/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.brailleblaster.BBIniImpl;
import org.brailleblaster.util.FileUtils;
import org.brailleblaster.utils.PropertyFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001a\n\u0002\u0010\u0011\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\b\u0010 \u001a\u00020!H\u0007J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u0018H\u0007J\u001f\u0010:\u001a\u00020\u00132\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110<\"\u00020\u0011\u00a2\u0006\u0002\u0010=J!\u0010L\u001a\u00020\u00132\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110<\"\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010=J!\u0010M\u001a\u0004\u0018\u00010\u00132\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110<\"\u00020\u0011\u00a2\u0006\u0002\u0010=J\u0006\u0010P\u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0017\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0018@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\"\u001a\u0004\u0018\u00010\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u0003\u001a\u0004\b$\u0010\u001bR\u001c\u0010%\u001a\u0004\u0018\u00010\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0003\u001a\u0004\b'\u0010\u001bR\u0011\u0010*\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\rR\u0011\u0010+\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001bR\u0011\u0010-\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001bR\u001a\u0010/\u001a\u00020\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b0\u0010\u0003\u001a\u0004\b1\u0010\u001bR\u0011\u00102\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001bR\u0011\u00104\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b8\u0010\u0003\u001a\u0004\b9\u0010\u001bR\u0011\u0010>\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u001bR\u001a\u0010@\u001a\u00020\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bA\u0010\u0003\u001a\u0004\bB\u0010\u001bR\u001a\u0010C\u001a\u00020\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010\u0003\u001a\u0004\bE\u0010\u001bR\u0011\u0010F\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bG\u00106R\u001a\u0010H\u001a\u00020\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bI\u0010\u0003\u001a\u0004\bJ\u0010KR\u0011\u0010N\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u001b\u00a8\u0006Q"}, d2={"Lorg/brailleblaster/BBIni;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "impl", "Lorg/brailleblaster/BBIniImpl;", "value", "", "debugging", "getDebugging$annotations", "getDebugging", "()Z", "initialize", "argsToParse", "", "", "bbPath", "Ljava/io/File;", "userbbPath", "propManager", "Lorg/brailleblaster/utils/PropertyFileManager;", "bootDialogsEnabled", "Ljava/nio/file/Path;", "recentDocs", "getRecentDocs", "()Ljava/nio/file/Path;", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "setDebuggingEnabled", "", "debugFilePath", "getDebugFilePath$annotations", "getDebugFilePath", "debugSavePath", "getDebugSavePath$annotations", "getDebugSavePath", "setTestData", "recentDocumentsPath", "isReleaseBuild", "nativeBinPath", "getNativeBinPath", "nativeLibraryPath", "getNativeLibraryPath", "programDataPath", "getProgramDataPath$annotations", "getProgramDataPath", "helpDocsPath", "getHelpDocsPath", "nativeLibrarySuffix", "getNativeLibrarySuffix", "()Ljava/lang/String;", "userProgramDataPath", "getUserProgramDataPath$annotations", "getUserProgramDataPath", "getUserProgramDataFile", "pathSuffixParts", "", "([Ljava/lang/String;)Ljava/io/File;", "logFilesPath", "getLogFilesPath", "recentSaves", "getRecentSaves$annotations", "getRecentSaves", "autoSavePath", "getAutoSavePath$annotations", "getAutoSavePath", "autoSaveCrashPath", "getAutoSaveCrashPath", "propertyFileManager", "getPropertyFileManager$annotations", "getPropertyFileManager", "()Lorg/brailleblaster/utils/PropertyFileManager;", "loadAutoProgramDataFile", "loadAutoProgramDataFileOrNull", "bbDistPath", "getBbDistPath", "createAutoSaveCrashFile", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBBIni.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBIni.kt\norg/brailleblaster/BBIni\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,209:1\n742#2,9:210\n37#3,2:219\n*S KotlinDebug\n*F\n+ 1 BBIni.kt\norg/brailleblaster/BBIni\n*L\n69#1:210,9\n69#1:219,2\n*E\n"})
public final class BBIni {
    @NotNull
    public static final BBIni INSTANCE = new BBIni();
    @NotNull
    private static final Logger log;
    private static BBIniImpl impl;
    private static boolean debugging;
    @JvmField
    public static boolean bootDialogsEnabled;
    private static Path recentDocs;
    @NotNull
    private static final Charset charset;

    private BBIni() {
    }

    public static final boolean getDebugging() {
        return debugging;
    }

    @JvmStatic
    public static /* synthetic */ void getDebugging$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final boolean initialize(@NotNull List<String> argsToParse, @NotNull File bbPath, @NotNull File userbbPath, @Nullable PropertyFileManager propManager) {
        Intrinsics.checkNotNullParameter(argsToParse, (String)"argsToParse");
        Intrinsics.checkNotNullParameter((Object)bbPath, (String)"bbPath");
        Intrinsics.checkNotNullParameter((Object)userbbPath, (String)"userbbPath");
        if (impl == null || debugging) {
            List debugArgs = CollectionsKt.emptyList();
            if (!((Collection)argsToParse).isEmpty()) {
                String option;
                debugging = true;
                for (int i = 0; i < argsToParse.size() && (option = argsToParse.get(0)).charAt(0) == '-'; ++i) {
                    argsToParse.remove(0);
                    if (Intrinsics.areEqual((Object)option, (Object)"-debug")) {
                        void $this$toTypedArray$iv;
                        List list;
                        Collection $this$dropLastWhile$iv;
                        Object object = argsToParse.remove(0);
                        Regex regex = new Regex(",");
                        int n = 0;
                        object = regex.split((CharSequence)object, n);
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                String it = (String)iterator$iv.previous();
                                boolean bl = false;
                                if (((CharSequence)it).length() == 0) continue;
                                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                        $this$dropLastWhile$iv = list;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] tokens = thisCollection$iv.toArray(new String[0]);
                        debugArgs = CollectionsKt.listOf((Object[])Arrays.copyOf(tokens, tokens.length));
                        continue;
                    }
                    System.out.println((Object)("Bad option '" + option + "'"));
                }
            }
            Path path = bbPath.toPath().toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            Path path2 = userbbPath.toPath().toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
            impl = new BBIniImpl(path, path2, propManager, debugArgs);
            BBIniImpl bBIniImpl = impl;
            if (bBIniImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                bBIniImpl = null;
            }
            recentDocs = bBIniImpl.getRecentDocsPath();
            BBIniImpl bBIniImpl2 = impl;
            if (bBIniImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
                bBIniImpl2 = null;
            }
            Path dictDir = bBIniImpl2.getUserProgramDataPath().resolve("dictionaries");
            Intrinsics.checkNotNull((Object)dictDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(dictDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                try {
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dictDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                }
                catch (IOException e) {
                    log.warn("Unable to create dictionary directory", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean initialize$default(BBIni bBIni, List list, File file, File file2, PropertyFileManager propertyFileManager, int n, Object object) {
        if ((n & 8) != 0) {
            propertyFileManager = null;
        }
        return bBIni.initialize(list, file, file2, propertyFileManager);
    }

    @NotNull
    public final Path getRecentDocs() {
        Path path = recentDocs;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recentDocs");
        return null;
    }

    @NotNull
    public final Charset getCharset() {
        return charset;
    }

    @JvmStatic
    public static final void setDebuggingEnabled() {
        debugging = true;
    }

    @Nullable
    public static final Path getDebugFilePath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getDebugFilePath();
    }

    @JvmStatic
    public static /* synthetic */ void getDebugFilePath$annotations() {
    }

    @Nullable
    public static final Path getDebugSavePath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getDebugSavePath();
    }

    @JvmStatic
    public static /* synthetic */ void getDebugSavePath$annotations() {
    }

    @JvmStatic
    public static final void setTestData(@NotNull Path recentDocumentsPath) {
        Intrinsics.checkNotNullParameter((Object)recentDocumentsPath, (String)"recentDocumentsPath");
        Path path = recentDocumentsPath.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        recentDocs = path;
    }

    public final boolean isReleaseBuild() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getReleaseBuild();
    }

    @NotNull
    public final Path getNativeBinPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getNativeBinPath();
    }

    @NotNull
    public final Path getNativeLibraryPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getNativeLibraryPath();
    }

    @NotNull
    public static final Path getProgramDataPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getProgramDataPath();
    }

    @JvmStatic
    public static /* synthetic */ void getProgramDataPath$annotations() {
    }

    @NotNull
    public final Path getHelpDocsPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getHelpDocsPath();
    }

    @NotNull
    public final String getNativeLibrarySuffix() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getNativeLibrarySuffix();
    }

    @NotNull
    public static final Path getUserProgramDataPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getUserProgramDataPath();
    }

    @JvmStatic
    public static /* synthetic */ void getUserProgramDataPath$annotations() {
    }

    @NotNull
    public final File getUserProgramDataFile(String ... pathSuffixParts) {
        Intrinsics.checkNotNullParameter((Object)pathSuffixParts, (String)"pathSuffixParts");
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        String string = ((Object)bBIniImpl.getUserProgramDataPath()).toString();
        String[] stringArray = Arrays.copyOf(pathSuffixParts, pathSuffixParts.length);
        Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final Path getLogFilesPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getLogFilesPath();
    }

    @NotNull
    public static final Path getRecentSaves() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getRecentSaves();
    }

    @JvmStatic
    public static /* synthetic */ void getRecentSaves$annotations() {
    }

    @NotNull
    public static final Path getAutoSavePath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getAutoSavePath();
    }

    @JvmStatic
    public static /* synthetic */ void getAutoSavePath$annotations() {
    }

    @NotNull
    public final String getAutoSaveCrashPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return ((Object)bBIniImpl.getAutoSaveCrashPath()).toString();
    }

    @NotNull
    public static final PropertyFileManager getPropertyFileManager() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getPropertyFileManager();
    }

    @JvmStatic
    public static /* synthetic */ void getPropertyFileManager$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final File loadAutoProgramDataFile(String ... pathSuffixParts) {
        File result;
        Intrinsics.checkNotNullParameter((Object)pathSuffixParts, (String)"pathSuffixParts");
        File file = result = INSTANCE.loadAutoProgramDataFileOrNull(Arrays.copyOf(pathSuffixParts, pathSuffixParts.length));
        if (file != null) {
            return file;
        }
        String[] stringArray = Arrays.copyOf(pathSuffixParts, pathSuffixParts.length);
        Path path = Paths.get("", Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        throw new RuntimeException("Cannot find file " + path + " in " + BBIni.getUserProgramDataPath() + " or " + BBIni.getProgramDataPath());
    }

    @Nullable
    public final File loadAutoProgramDataFileOrNull(String ... pathSuffixParts) {
        Intrinsics.checkNotNullParameter((Object)pathSuffixParts, (String)"pathSuffixParts");
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        String string = ((Object)bBIniImpl.getUserProgramDataPath()).toString();
        String[] stringArray = Arrays.copyOf(pathSuffixParts, pathSuffixParts.length);
        Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path file = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return file.toFile();
        }
        BBIniImpl bBIniImpl2 = impl;
        if (bBIniImpl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl2 = null;
        }
        string = ((Object)bBIniImpl2.getProgramDataPath()).toString();
        stringArray = Arrays.copyOf(pathSuffixParts, pathSuffixParts.length);
        Path path2 = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        file = path2;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return file.toFile();
        }
        return null;
    }

    @NotNull
    public final Path getBbDistPath() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        return bBIniImpl.getBbDistPath();
    }

    public final void createAutoSaveCrashFile() {
        BBIniImpl bBIniImpl = impl;
        if (bBIniImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"impl");
            bBIniImpl = null;
        }
        FileUtils.INSTANCE.create(((Object)bBIniImpl.getAutoSaveCrashPath()).toString());
    }

    @JvmOverloads
    public final boolean initialize(@NotNull List<String> argsToParse, @NotNull File bbPath, @NotNull File userbbPath) {
        Intrinsics.checkNotNullParameter(argsToParse, (String)"argsToParse");
        Intrinsics.checkNotNullParameter((Object)bbPath, (String)"bbPath");
        Intrinsics.checkNotNullParameter((Object)userbbPath, (String)"userbbPath");
        return BBIni.initialize$default(this, argsToParse, bbPath, userbbPath, null, 8, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(BBIni.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        bootDialogsEnabled = true;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        BBIni.charset = charset;
    }
}

