/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Document;
import nu.xom.Node;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.BBXArchiverLoader;
import org.brailleblaster.archiver2.BBZArchiver;
import org.brailleblaster.archiver2.BaseArchiver;
import org.brailleblaster.archiver2.SaveOptions;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.exceptions.NodeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(message="")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J.\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lorg/brailleblaster/archiver2/BBXArchiver;", "Lorg/brailleblaster/archiver2/BaseArchiver;", "Lorg/brailleblaster/archiver2/Archiver2;", "origPath", "Ljava/nio/file/Path;", "bbxDocument", "Lnu/xom/Document;", "loader", "Ljava/lang/Class;", "<init>", "(Ljava/nio/file/Path;Lnu/xom/Document;Ljava/lang/Class;)V", "getBbxDocument", "()Lnu/xom/Document;", "resolveSibling", "descendant", "path", "getPath", "()Ljava/nio/file/Path;", "save", "", "destPath", "doc", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "options", "", "Lorg/brailleblaster/archiver2/SaveOptions;", "saveAs", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "close", "Companion", "brailleblaster-core"})
public final class BBXArchiver
extends BaseArchiver
implements Archiver2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Path origPath;
    @NotNull
    private final Document bbxDocument;
    @NotNull
    private static final Logger log;

    public BBXArchiver(@NotNull Path origPath, @NotNull Document bbxDocument, @Nullable Class<?> loader) {
        Intrinsics.checkNotNullParameter((Object)origPath, (String)"origPath");
        Intrinsics.checkNotNullParameter((Object)bbxDocument, (String)"bbxDocument");
        super(null, null);
        this.origPath = origPath;
        this.bbxDocument = bbxDocument;
        if (BBX.getFormatVersion(this.getBbxDocument()) < 1) {
            throw new NodeException("Failed to find format version", (Node)this.getBbxDocument(), null, 4, null);
        }
        BookToBBXConverter.Companion.upgradeFormat(this.getBbxDocument());
    }

    @Override
    @NotNull
    public Document getBbxDocument() {
        return this.bbxDocument;
    }

    @Override
    @NotNull
    public Path resolveSibling(@NotNull Path descendant) {
        Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
        Path path = this.origPath.resolveSibling(descendant);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.origPath;
    }

    @Override
    public void save(@NotNull Path destPath, @NotNull Document doc, @NotNull UTDTranslationEngine engine, @NotNull Set<? extends SaveOptions> options) {
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        try {
            BBZArchiver.Companion.saveBBX(destPath, doc);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to save to existing " + destPath, e);
        }
    }

    @Override
    public void saveAs(@NotNull Path destPath, @NotNull Document doc, @NotNull UTDTranslationEngine engine, @NotNull Set<? extends SaveOptions> options) {
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.save(destPath, doc, engine, options);
        this.origPath = destPath;
    }

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return BBXArchiverLoader.INSTANCE.getExtensionsAndDescription();
    }

    @Override
    public void close() throws IOException {
    }

    static {
        Logger logger = LoggerFactory.getLogger(BBXArchiver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/archiver2/BBXArchiver$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

