/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Document;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.BBZArchiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/archiver2/BBXArchiverLoader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "<init>", "()V", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "Companion", "brailleblaster-core"})
public final class BBXArchiverLoader
implements ArchiverFactory.FileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> extensionsAndDescription = MapsKt.mapOf((Pair)TuplesKt.to((Object)"*.bbx", (Object)"BB XML (*.bbx)"));
    private static final Logger log = LoggerFactory.getLogger(BBXArchiverLoader.class);
    @JvmField
    @NotNull
    public static final BBXArchiverLoader INSTANCE = new BBXArchiverLoader();

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return this.extensionsAndDescription;
    }

    @Override
    @Nullable
    public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
        Archiver2 archiver2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Document document = fileData.getDoc();
        Intrinsics.checkNotNull((Object)document);
        String rootName = document.getRootElement().getLocalName();
        if (Intrinsics.areEqual((Object)rootName, (Object)"bbdoc")) {
            log.debug("Detected BBX");
            Archiver2 arch = BBZArchiver.Companion.createImportedBBZ(file, fileData.getDoc());
            Object fileStr = ((Object)file.getFileName()).toString();
            String string = fileStr;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string2, (String)".bbx", (boolean)false, (int)2, null)) {
                fileStr = StringsKt.dropLast((String)fileStr, (int)4) + ".bbz";
            }
            arch.setNewPath(Paths.get((String)fileStr, new String[0]));
            archiver2 = arch;
        } else {
            log.error("File " + file.toUri() + " has root element '" + rootName + "', not bbx bbdoc");
            archiver2 = null;
        }
        return archiver2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/archiver2/BBXArchiverLoader$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "INSTANCE", "Lorg/brailleblaster/archiver2/BBXArchiverLoader;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

