/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import nu.xom.Document;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.BaseArchiver;
import org.brailleblaster.archiver2.SaveOptions;
import org.brailleblaster.archiver2.ZipHandles;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.utd.BRFWriter;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.utils.BBX2PEFConverterKt;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Notify;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0003*+,B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J.\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J8\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0002J0\u0010!\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0002J\u0012\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010)\u001a\u00020\u0015H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006-"}, d2={"Lorg/brailleblaster/archiver2/BBZArchiver;", "Lorg/brailleblaster/archiver2/BaseArchiver;", "Lorg/brailleblaster/archiver2/Archiver2;", "path", "Ljava/nio/file/Path;", "zipFS", "Ljava/nio/file/FileSystem;", "bbxPath", "bbxDocument", "Lnu/xom/Document;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/FileSystem;Ljava/nio/file/Path;Lnu/xom/Document;)V", "getPath", "()Ljava/nio/file/Path;", "setPath", "(Ljava/nio/file/Path;)V", "getBbxDocument", "()Lnu/xom/Document;", "resolveSibling", "descendant", "save", "", "destPath", "doc", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "options", "", "Lorg/brailleblaster/archiver2/SaveOptions;", "saveAs", "saveExisting", "destZipFS", "destZipPath", "saveNew", "isZipValid", "zip", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "close", "BBZSaveOptions", "Loader", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBBZArchiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBZArchiver.kt\norg/brailleblaster/archiver2/BBZArchiver\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n37#2,2:345\n1#3:347\n*S KotlinDebug\n*F\n+ 1 BBZArchiver.kt\norg/brailleblaster/archiver2/BBZArchiver\n*L\n59#1:345,2\n*E\n"})
public final class BBZArchiver
extends BaseArchiver
implements Archiver2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Path path;
    @NotNull
    private FileSystem zipFS;
    @NotNull
    private Path bbxPath;
    @NotNull
    private final Document bbxDocument;
    private static final Logger log = LoggerFactory.getLogger(BBZArchiver.class);
    @NotNull
    public static final String LOCATION_FILE = "/bbx_location";

    public BBZArchiver(@NotNull Path path, @NotNull FileSystem zipFS, @NotNull Path bbxPath, @NotNull Document bbxDocument) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)zipFS, (String)"zipFS");
        Intrinsics.checkNotNullParameter((Object)bbxPath, (String)"bbxPath");
        Intrinsics.checkNotNullParameter((Object)bbxDocument, (String)"bbxDocument");
        super(null, null);
        this.path = path;
        this.zipFS = zipFS;
        this.bbxPath = bbxPath;
        this.bbxDocument = bbxDocument;
        this.isZipValid(this.zipFS);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    public void setPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.path = path;
    }

    @Override
    @NotNull
    public Document getBbxDocument() {
        return this.bbxDocument;
    }

    @Override
    @NotNull
    public Path resolveSibling(@NotNull Path descendant) {
        Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
        Iterator<Path> iterator = descendant.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Path> itr = iterator;
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence(itr), BBZArchiver::resolveSibling$lambda$0));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new String[0]);
        Path zipDescendant = this.zipFS.getPath(((Object)itr.next()).toString(), Arrays.copyOf(object, ((String[])object).length));
        try {
            object = this.bbxPath.resolveSibling(zipDescendant);
            Intrinsics.checkNotNull((Object)object);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve '" + zipDescendant + "' as sibling of " + this.bbxPath, e);
        }
        return object;
    }

    @Override
    public void save(@NotNull Path destPath, @NotNull Document doc, @NotNull UTDTranslationEngine engine, @NotNull Set<? extends SaveOptions> options) {
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (Intrinsics.areEqual((Object)destPath, (Object)this.getPath())) {
            this.saveExisting(doc, this.zipFS, this.getPath(), engine, options);
        } else {
            this.saveNew(doc, destPath, engine, options);
        }
        try {
            ZipHandles.close(this.getPath());
            this.zipFS = ZipHandles.open(this.getPath(), false);
            this.isZipValid(this.zipFS);
        }
        catch (Exception e) {
            Notify.showException("Failed to save to existing file at " + destPath + ".\nThe file location may not be available, or the file may have been opened by another program. Try closing the file and opening it again.", e);
        }
    }

    @Override
    public void saveAs(@NotNull Path destPath, @NotNull Document doc, @NotNull UTDTranslationEngine engine, @NotNull Set<? extends SaveOptions> options) {
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (Intrinsics.areEqual((Object)destPath, (Object)this.getPath())) {
            this.saveExisting(doc, this.zipFS, this.getPath(), engine, options);
        } else {
            this.saveNew(doc, destPath, engine, options);
        }
        ZipHandles.close(this.getPath());
        this.setPath(destPath);
        this.zipFS = ZipHandles.open(this.getPath(), false);
        Path path = this.zipFS.getPath(((Object)this.bbxPath).toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        this.bbxPath = path;
        this.isZipValid(this.zipFS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveExisting(Document doc, FileSystem destZipFS, Path destZipPath, UTDTranslationEngine engine, Set<? extends SaveOptions> options) {
        Object e2;
        Object object;
        String relativeBBXPath = ((Object)this.bbxPath).toString();
        try {
            log.debug("Saving to existing zip {}", (Object)this.bbxPath);
            Path newBBXPath = destZipFS.getPath(relativeBBXPath, new String[0]);
            Intrinsics.checkNotNull((Object)newBBXPath);
            Companion.saveBBX(newBBXPath, doc);
            Path docPath = destZipFS.getPath(LOCATION_FILE, new String[0]);
            log.debug("Writing {} to {}", (Object)relativeBBXPath, (Object)docPath.toUri());
            object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            Files.write(docPath, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)relativeBBXPath), object);
        }
        catch (Exception e2) {
            Notify.showException("Failed to save to existing ZIP at " + destZipPath, e2);
        }
        if (options.contains(BBZSaveOptions.IncludePEF)) {
            Path pefPath = destZipFS.getPath("/document.pef", new String[0]);
            try {
                e2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
                e2 = new BufferedOutputStream(Files.newOutputStream(pefPath, e2));
                object = null;
                try {
                    BufferedOutputStream pefOut = (BufferedOutputStream)e2;
                    boolean bl = false;
                    BBX2PEFConverterKt.convertBBX2PEF((Document)doc, (String)relativeBBXPath, (ITranslationEngine)((ITranslationEngine)engine), (IntPredicate)BBX2PEFConverterKt.ALL_VOLUMES, (OutputStream)pefOut);
                    pefOut = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    object = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)e2, (Throwable)object);
                }
            }
            catch (IOException e3) {
                throw new RuntimeException("Failed to create and insert the PEF into the BBZ.", e3);
            }
        }
        if (options.contains(BBZSaveOptions.IncludeBRF)) {
            Path brfPath = destZipFS.getPath("/document.brf", new String[0]);
            try {
                e2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
                e2 = Files.newBufferedWriter(brfPath, e2);
                object = null;
                try {
                    BufferedWriter writer = (BufferedWriter)e2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)writer);
                    Writer writer2 = writer;
                    BRFWriter.PageListener pageListener = BRFWriter.EMPTY_PAGE_LISTENER;
                    Intrinsics.checkNotNullExpressionValue((Object)pageListener, (String)"EMPTY_PAGE_LISTENER");
                    UTDTranslationEngine.toBRF$default((UTDTranslationEngine)engine, (Document)doc, (Writer)writer2, (int)0, (BRFWriter.PageListener)pageListener, (boolean)false, (boolean)false, (int)48, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)e2, (Throwable)object);
                }
            }
            catch (IOException e4) {
                throw new RuntimeException("Failed to create and insert the BRF into the BBZ.", e4);
            }
        }
        this.isZipValid(this.zipFS);
    }

    private final void saveNew(Document doc, Path destZipPath, UTDTranslationEngine engine, Set<? extends SaveOptions> options) {
        try {
            log.debug("Saving to new zip {}", (Object)destZipPath);
            if (ZipHandles.has(destZipPath)) {
                throw new BBNotifyException("Cannot save over other open file " + destZipPath);
            }
            if (Files.exists(destZipPath, new LinkOption[0])) {
                try {
                    Files.delete(destZipPath);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Failed to delete existing file at " + destZipPath, e);
                }
            }
            this.isZipValid(this.zipFS);
            FileSystem newZipFS = ZipHandles.open(destZipPath, true);
            Files.walkFileTree(this.zipFS.getPath("/", new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(newZipFS){
                final /* synthetic */ FileSystem $newZipFS;
                {
                    this.$newZipFS = $newZipFS;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    if (Intrinsics.areEqual((Object)((Object)dir).toString(), (Object)"/")) {
                        return FileVisitResult.CONTINUE;
                    }
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                    Files.copy(dir, this.$newZipFS.getPath(((Object)dir).toString(), new String[0]), copyOptionArray);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                    Files.copy(file, this.$newZipFS.getPath(((Object)file).toString(), new String[0]), copyOptionArray);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                    throw new UnsupportedOperationException("Not supported yet.", exc);
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    if (exc != null) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            this.saveExisting(doc, newZipFS, destZipPath, engine, options);
            ZipHandles.close(destZipPath);
        }
        catch (BBNotifyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to save to " + destZipPath, e);
        }
    }

    private final void isZipValid(FileSystem zip) {
        FileSystem fileSystem = zip;
        Intrinsics.checkNotNull((Object)fileSystem);
        if (!fileSystem.isOpen()) {
            boolean bl = false;
            String string = "zipFS at " + this.getPath() + " is not open: " + zip;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return Loader.Companion.getINSTANCE().getExtensionsAndDescription();
    }

    @Override
    public void close() throws IOException {
        ZipHandles.close(this.getPath());
    }

    private static final String resolveSibling$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)it).toString();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/archiver2/BBZArchiver$BBZSaveOptions;", "Lorg/brailleblaster/archiver2/SaveOptions;", "", "<init>", "(Ljava/lang/String;I)V", "IncludeBRF", "IncludePEF", "brailleblaster-core"})
    public static final class BBZSaveOptions
    extends Enum<BBZSaveOptions>
    implements SaveOptions {
        public static final /* enum */ BBZSaveOptions IncludeBRF = new BBZSaveOptions();
        public static final /* enum */ BBZSaveOptions IncludePEF = new BBZSaveOptions();
        private static final /* synthetic */ BBZSaveOptions[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BBZSaveOptions[] values() {
            return (BBZSaveOptions[])$VALUES.clone();
        }

        public static BBZSaveOptions valueOf(String value) {
            return Enum.valueOf(BBZSaveOptions.class, value);
        }

        @NotNull
        public static EnumEntries<BBZSaveOptions> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = bBZSaveOptionsArray = new BBZSaveOptions[]{BBZSaveOptions.IncludeBRF, BBZSaveOptions.IncludePEF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0012J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0012R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/archiver2/BBZArchiver$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOCATION_FILE", "", "loadLocationFile", "Ljava/nio/file/Path;", "zipPath", "zipFS", "Ljava/nio/file/FileSystem;", "saveBBX", "", "destPath", "doc", "Lnu/xom/Document;", "createImportedBBZ", "Lorg/brailleblaster/archiver2/BBZArchiver;", "importedFrom", "bbxDocument", "bbzPath", "createNewBBZ", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path loadLocationFile(@Nullable Path zipPath, @NotNull FileSystem zipFS) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)zipFS, (String)"zipFS");
            Path locationPath = zipFS.getPath(BBZArchiver.LOCATION_FILE, new String[0]);
            if (!Files.exists(locationPath, new LinkOption[0])) {
                path = null;
            } else {
                Path path2;
                try {
                    List<String> locationDataRaw = Files.readAllLines(locationPath, StandardCharsets.UTF_8);
                    if (locationDataRaw.size() != 1) {
                        throw new RuntimeException("Location data is in unexpected format");
                    }
                    String locationData = locationDataRaw.get(0);
                    path2 = zipFS.getPath(locationData, new String[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load /bbx_location in ZIP", e);
                }
                path = path2;
            }
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void saveBBX(@NotNull Path destPath, @NotNull Document doc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            log.debug("Writing BBX to {}", (Object)destPath.toUri());
            Document newDoc = doc.copy();
            Intrinsics.checkNotNull((Object)newDoc);
            UTDHelper.stripUTDRecursive((Document)newDoc);
            Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            object = Files.newOutputStream(destPath, object);
            Throwable throwable = null;
            try {
                OutputStream out = (OutputStream)object;
                boolean bl = false;
                XMLHandler xMLHandler = new XMLHandler();
                Intrinsics.checkNotNull((Object)out);
                xMLHandler.save(newDoc, out);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        @NotNull
        public final BBZArchiver createImportedBBZ(@NotNull Path importedFrom, @NotNull Document bbxDocument) throws IOException {
            Intrinsics.checkNotNullParameter((Object)importedFrom, (String)"importedFrom");
            Intrinsics.checkNotNullParameter((Object)bbxDocument, (String)"bbxDocument");
            String docBaseName = PathsKt.getNameWithoutExtension((Path)importedFrom);
            File bbzFile = File.createTempFile(docBaseName + "-", ".bbz");
            bbzFile.deleteOnExit();
            Path path = bbzFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            return this.createImportedBBZ(importedFrom, path, bbxDocument);
        }

        @NotNull
        public final BBZArchiver createImportedBBZ(@Nullable Path importedFrom, @NotNull Path bbzPath, @NotNull Document bbxDocument) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bbzPath, (String)"bbzPath");
            Intrinsics.checkNotNullParameter((Object)bbxDocument, (String)"bbxDocument");
            BBZArchiver archiver = this.createNewBBZ(bbzPath, bbxDocument);
            archiver.setImportedFrom(importedFrom);
            return archiver;
        }

        @NotNull
        public final BBZArchiver createNewBBZ(@NotNull Path bbzPath, @NotNull Document bbxDocument) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bbzPath, (String)"bbzPath");
            Intrinsics.checkNotNullParameter((Object)bbxDocument, (String)"bbxDocument");
            FileSystem zipFS = ZipHandles.open(bbzPath, true);
            Path locationPath = zipFS.getPath(BBZArchiver.LOCATION_FILE, new String[0]);
            String bbxPathStr = "/document.bbx";
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Files.write(locationPath, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)bbxPathStr), Charsets.UTF_8, openOptionArray);
            Path bbxPath = zipFS.getPath(bbxPathStr, new String[0]);
            Intrinsics.checkNotNull((Object)bbxPath);
            return new BBZArchiver(bbzPath, zipFS, bbxPath, bbxDocument);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/archiver2/BBZArchiver$Loader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "<init>", "()V", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "Companion", "brailleblaster-core"})
    public static final class Loader
    implements ArchiverFactory.FileLoader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, String> extensionsAndDescription = MapsKt.mapOf((Pair)TuplesKt.to((Object)"*.bbz", (Object)"BB Archive (*.bbz)"));
        private static final Logger log = LoggerFactory.getLogger(Loader.class);
        @NotNull
        private static final Loader INSTANCE = new Loader();

        @Override
        @Nullable
        public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
            Archiver2 archiver2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
            FileSystem zipFS = ZipHandles.open(file, false);
            Path locationFile = Companion.loadLocationFile(file, zipFS);
            if (locationFile == null) {
                log.info("No BBX location file found");
                archiver2 = null;
            } else {
                log.debug("Loading " + locationFile.toUri());
                archiver2 = new BBZArchiver(file, zipFS, locationFile, new XMLHandler().load(locationFile, ""));
            }
            return archiver2;
        }

        @Override
        @NotNull
        public Map<String, String> getExtensionsAndDescription() {
            return this.extensionsAndDescription;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/archiver2/BBZArchiver$Loader$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "INSTANCE", "Lorg/brailleblaster/archiver2/BBZArchiver$Loader;", "getINSTANCE", "()Lorg/brailleblaster/archiver2/BBZArchiver$Loader;", "brailleblaster-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Loader getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

