/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalCharacterDataException;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.BBZArchiver;
import org.brailleblaster.bbx.BBX;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/archiver2/TextArchiveLoader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "<init>", "()V", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "createBlock", "Lnu/xom/Element;", "usableText", "Lnu/xom/Text;", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTextArchiveLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextArchiveLoader.kt\norg/brailleblaster/archiver2/TextArchiveLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1391#2:98\n1480#2,5:99\n777#2:104\n873#2,2:105\n1642#2,10:107\n1915#2:117\n1916#2:119\n1652#2:120\n1849#2,3:121\n1#3:118\n*S KotlinDebug\n*F\n+ 1 TextArchiveLoader.kt\norg/brailleblaster/archiver2/TextArchiveLoader\n*L\n35#1:98\n35#1:99,5\n35#1:104\n35#1:105,2\n35#1:107,10\n35#1:117\n35#1:119\n35#1:120\n35#1:121,3\n35#1:118\n*E\n"})
public class TextArchiveLoader
implements ArchiverFactory.FileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> extensionsAndDescription = MapsKt.mapOf((Pair)TuplesKt.to((Object)"*.txt", (Object)"Text (*.txt)"));
    private static final Logger log = LoggerFactory.getLogger(TextArchiveLoader.class);
    @NotNull
    private static final TextArchiveLoader INSTANCE = new TextArchiveLoader();
    public static final char FORM_FEED = '\f';

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
        void $this$fold$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Document bbxDoc = BBX.newDocument();
        Element root = BBX.SECTION.ROOT.create();
        bbxDoc.getRootElement().appendChild((Node)root);
        List<String> list = Files.readAllLines(file, BBIni.INSTANCE.getCharset());
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        Iterable iterable = list;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            object = new char[]{'\f'};
            Iterable list$iv$iv = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])object, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Text it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            if (Companion.getUsableText(it2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Element initial$iv = root;
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void v;
            Text $i$f$forEach2 = (Text)element$iv;
            Element r = accumulator$iv;
            boolean bl = false;
            Object it3 = object = (Object)r;
            boolean bl5 = false;
            it3.appendChild((Node)this.createBlock((Text)v));
            accumulator$iv = object;
        }
        Intrinsics.checkNotNull((Object)bbxDoc);
        Archiver2 archiver = BBZArchiver.Companion.createImportedBBZ(file, bbxDoc);
        Object fileStr = ((Object)file).toString();
        String string = fileStr;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        fileStr = (String)(StringsKt.endsWith$default((String)string2, (String)".txt", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)fileStr, (int)4) : fileStr) + ".bbz";
        archiver.setNewPath(Paths.get((String)fileStr, new String[0]));
        return archiver;
    }

    @NotNull
    protected Element createBlock(@Nullable Text usableText) {
        Element block = BBX.BLOCK.DEFAULT.create();
        block.appendChild((Node)usableText);
        Intrinsics.checkNotNull((Object)block);
        return block;
    }

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return this.extensionsAndDescription;
    }

    @JvmStatic
    @Nullable
    public static final Text getUsableText(@NotNull String line) {
        return Companion.getUsableText(line);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/archiver2/TextArchiveLoader$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "INSTANCE", "Lorg/brailleblaster/archiver2/TextArchiveLoader;", "getINSTANCE", "()Lorg/brailleblaster/archiver2/TextArchiveLoader;", "FORM_FEED", "", "getUsableText", "Lnu/xom/Text;", "line", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextArchiveLoader getINSTANCE() {
            return INSTANCE;
        }

        @JvmStatic
        @Nullable
        public final Text getUsableText(@NotNull String line) {
            Text text;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            try {
                text = new Text(line);
            }
            catch (IllegalCharacterDataException illegalCharacterDataException) {
                Text text2 = null;
                StringBuilder lineBuilder = new StringBuilder();
                char[] cArray = line.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                for (char c : cArray) {
                    try {
                        text2 = new Text(lineBuilder.toString() + c);
                        lineBuilder.append(c);
                    }
                    catch (IllegalCharacterDataException ex) {
                        log.error("Character 0x" + Integer.toHexString(c) + " " + Character.getName(c) + " is not valid in XML, skipping", (Throwable)ex);
                    }
                }
                text = text2;
            }
            return text;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

