/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ&\u0010\u0016\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/bbx/BBXValidator;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "validElementType", "", "type", "Lorg/brailleblaster/bbx/BBX$CoreType;", "node", "Lnu/xom/Node;", "validateDocument", "doc", "Lnu/xom/Document;", "styleDefs", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "assertEquals", "obj1", "obj2", "context", "assertNotEquals", "ValidateException", "brailleblaster-core"})
public final class BBXValidator {
    @NotNull
    public static final BBXValidator INSTANCE = new BBXValidator();
    private static final Logger log = LoggerFactory.getLogger(BBXValidator.class);

    private BBXValidator() {
    }

    public final void validElementType(@Nullable BBX.CoreType type, @Nullable Node node) throws ValidateException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (node == null) {
            throw new NullPointerException("node");
        }
        String validateResult = type.validate(node);
        if (validateResult != null) {
            Object[] objectArray = new Object[]{type, validateResult};
            throw new ValidateException(node, "Input node is not expected type {}: {}", objectArray);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void validateDocument(@NotNull Document doc, @NotNull StyleDefinitions styleDefs2) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)styleDefs2, (String)"styleDefs");
        if (!BBIni.getDebugging()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.assertEquals(BBX.getFormatVersion(doc), 6, (Node)doc);
        this.assertEquals(BBX.getHead(doc), doc.getRootElement().getChildElements().get(0), (Node)doc);
        Element element = BBX.getRoot(doc);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
        Element bookRoot = element;
        this.assertEquals(bookRoot, doc.getRootElement().getChildElements().get(1), (Node)doc);
        Deque itrStack = new ArrayDeque();
        itrStack.push(bookRoot);
        block11: while (!itrStack.isEmpty()) {
            Element curElem = (Element)itrStack.pop();
            String string = curElem.getNamespaceURI();
            if (string == null) throw new ValidateException((Node)curElem, "Unexpected namespace " + curElem.getNamespaceURI());
            int n = -1;
            switch (string.hashCode()) {
                case 1725132794: {
                    if (string.equals("http://www.w3.org/1998/Math/MathML")) {
                        n = 1;
                    }
                    break;
                }
                case -665739990: {
                    if (string.equals("http://brailleblaster.org/ns/utd")) {
                        n = 1;
                    }
                    break;
                }
                case 809807899: {
                    if (string.equals("http://brailleblaster.org/ns/bb")) {
                        n = 2;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    continue block11;
                }
                default: {
                    throw new ValidateException((Node)curElem, "Unexpected namespace " + curElem.getNamespaceURI());
                }
                case 2: 
            }
            BBX.CoreType curType = BBX.getType(curElem);
            BBX.SubType curSubType = curType.getSubType((Node)curElem);
            Object[] objectArray = new Object[3];
            objectArray[0] = curType;
            objectArray[1] = curSubType;
            Intrinsics.checkNotNull((Object)curElem);
            objectArray[2] = XMLHandler.Companion.toXMLSimple((Node)curElem);
            String elemDebug = Utils.formatMessage("{} subtype {} for element {}", objectArray);
            log.trace("Found type " + elemDebug);
            try {
                curSubType.assertComplete(curElem, styleDefs2);
                if (curElem != bookRoot) {
                    ParentNode parentNode = curElem.getParent();
                    Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                    BBX.CoreType parentType = BBX.getType((Element)parentNode);
                    if (!parentType.isValidChild(curType)) {
                        Object[] objectArray2 = new Object[]{curType, parentType};
                        throw new ValidateException((Node)curElem, "Child type {} cannot descend from {} for node", objectArray2);
                    }
                }
                if (BBX._ATTRIB_OVERRIDE_STYLE.has((Node)curElem)) {
                    this.assertNotEquals(styleDefs2.getStyleByName((String)BBX._ATTRIB_OVERRIDE_STYLE.get(curElem)), null, (Node)curElem);
                }
                if (curSubType == BBX.INLINE.MATHML) continue;
                for (Node curChildNode : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)curElem))) {
                    if (curChildNode instanceof Comment) continue;
                    if (curChildNode instanceof Text) {
                        if (curType.textChildrenValid) continue;
                        Object[] objectArray3 = new Object[]{curType};
                        throw new ValidateException(curChildNode, "Unexpected text node under {}", objectArray3);
                    }
                    if (!(curChildNode instanceof Element)) throw new NodeException("Unhandled node", curChildNode, null, 4, null);
                    itrStack.push(curChildNode);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed when processing " + elemDebug, e);
            }
        }
        log.info("Validated BBX document in " + Utils.runtimeToString(startTime));
    }

    public final void assertEquals(@Nullable Object obj1, @Nullable Object obj2, @Nullable Node context) {
        if (!Intrinsics.areEqual((Object)obj1, (Object)obj2)) {
            Object[] objectArray = new Object[]{obj1, obj2};
            throw new ValidateException(context, "Objects not equal: {} != {}", objectArray);
        }
    }

    private final void assertNotEquals(Object obj1, Object obj2, Node context) {
        if (Intrinsics.areEqual((Object)obj1, (Object)obj2)) {
            Object[] objectArray = new Object[]{obj1, obj2};
            throw new ValidateException(context, "Objects equal: {} == {}", objectArray);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B5\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t\"\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/bbx/BBXValidator$ValidateException;", "Lorg/brailleblaster/utd/exceptions/NodeException;", "node", "Lnu/xom/Node;", "message", "", "<init>", "(Lnu/xom/Node;Ljava/lang/String;)V", "args", "", "", "(Lnu/xom/Node;Ljava/lang/String;[Ljava/lang/Object;)V", "brailleblaster-core"})
    public static final class ValidateException
    extends NodeException {
        public ValidateException(@Nullable Node node, @Nullable String message) {
            String string = message;
            Intrinsics.checkNotNull((Object)string);
            super(string, node, null, 4, null);
        }

        public ValidateException(@Nullable Node node, @Nullable String message, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this(node, Utils.formatMessage(message, Arrays.copyOf(args, args.length)));
        }
    }
}

