/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Serializer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.BBIni;
import org.brailleblaster.Main;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXValidator;
import org.brailleblaster.bbx.BookToBBXConverter$fix$;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.bbx.fixers.ImportFixer;
import org.brailleblaster.bbx.fixers.ImportFixerMap;
import org.brailleblaster.bbx.fixers2.BBXTo4Upgrader;
import org.brailleblaster.bbx.fixers2.BBXTo5Upgrader;
import org.brailleblaster.bbx.fixers2.BBXTo6Upgrader;
import org.brailleblaster.bbx.fixers2.LiveFixer;
import org.brailleblaster.bbx.parsers.ImportParser;
import org.brailleblaster.bbx.parsers.ImportParserMap;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.config.DocumentUTDConfig;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/bbx/BookToBBXConverter;", "", "parserMap", "Lorg/brailleblaster/bbx/parsers/ImportParserMap;", "fixerMap", "Lorg/brailleblaster/bbx/fixers/ImportFixerMap;", "styleDefs", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "<init>", "(Lorg/brailleblaster/bbx/parsers/ImportParserMap;Lorg/brailleblaster/bbx/fixers/ImportFixerMap;Lorg/brailleblaster/utd/config/StyleDefinitions;)V", "convert", "Lnu/xom/Document;", "oldDoc", "debug", "", "doUpgrade", "", "bbxDoc", "newVersion", "", "toBBX", "toBBXRecursive", "oldCursor", "Lnu/xom/Element;", "bbxCursor", "fix", "bbxDocument", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBookToBBXConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookToBBXConverter.kt\norg/brailleblaster/bbx/BookToBBXConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,398:1\n1#2:399\n479#3:400\n1342#3,2:401\n*S KotlinDebug\n*F\n+ 1 BookToBBXConverter.kt\norg/brailleblaster/bbx/BookToBBXConverter\n*L\n216#1:400\n218#1:401,2\n*E\n"})
public final class BookToBBXConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ImportParserMap parserMap;
    @NotNull
    private final ImportFixerMap fixerMap;
    @NotNull
    private final StyleDefinitions styleDefs;
    private static final boolean DEBUG_ASK_SWT_DIALOG;
    @JvmField
    public static final boolean STRICT_MODE;
    private static final Logger log;
    @Nullable
    private static String TEST_CONFIG;
    private static BookToBBXConverter TEST_CONVERTER;

    public BookToBBXConverter(@Nullable ImportParserMap parserMap, @NotNull ImportFixerMap fixerMap, @NotNull StyleDefinitions styleDefs2) {
        Intrinsics.checkNotNullParameter((Object)((Object)fixerMap), (String)"fixerMap");
        Intrinsics.checkNotNullParameter((Object)styleDefs2, (String)"styleDefs");
        this.parserMap = parserMap;
        this.fixerMap = fixerMap;
        this.styleDefs = styleDefs2;
    }

    @JvmOverloads
    @NotNull
    public final Document convert(@NotNull Document oldDoc, @Nullable String debug) {
        Intrinsics.checkNotNullParameter((Object)oldDoc, (String)"oldDoc");
        long startTime = System.currentTimeMillis();
        Document bbxDoc = this.toBBX(oldDoc);
        log.info("toBBX checkpoint {} {}", (Object)Utils.runtimeToString(startTime), (Object)debug);
        this.fix(bbxDoc);
        log.info("fix checkpoint {} {}", (Object)Utils.runtimeToString(startTime), (Object)debug);
        BBXValidator.INSTANCE.validateDocument(bbxDoc, this.styleDefs);
        log.info("validate checkpoint {}", (Object)Utils.runtimeToString(startTime));
        return bbxDoc;
    }

    public static /* synthetic */ Document convert$default(BookToBBXConverter bookToBBXConverter, Document document, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return bookToBBXConverter.convert(document, string);
    }

    public final void doUpgrade(@NotNull Document bbxDoc, @Nullable String debug, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)bbxDoc, (String)"bbxDoc");
        long startTime = System.currentTimeMillis();
        this.fix(bbxDoc);
        log.info("fix checkpoint {} {}", (Object)Utils.runtimeToString(startTime), (Object)debug);
        BBX.setFormatVersion(bbxDoc, newVersion);
    }

    private final Document toBBX(Document oldDoc) {
        UTDHelper.stripUTDRecursive((Document)oldDoc);
        Document bbxDoc = BBX.newDocument();
        Element element = oldDoc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        Element element2 = bbxDoc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"getRootElement(...)");
        this.toBBXRecursive(element, element2);
        Intrinsics.checkNotNull((Object)bbxDoc);
        return bbxDoc;
    }

    private final void toBBXRecursive(Element oldCursor, Element bbxCursor) {
        for (Node curOldChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)oldCursor))) {
            ImportParser.OldDocumentAction oldDocumentAction;
            ImportParser parser;
            ImportParserMap importParserMap = this.parserMap;
            Intrinsics.checkNotNull((Object)((Object)importParserMap));
            if ((ImportParser)importParserMap.findValueOrDefault(curOldChild) == null) {
                throw new NodeException("Unhandled element", curOldChild, null, 4, null);
            }
            try {
                oldDocumentAction = parser.parseToBBX(curOldChild, bbxCursor);
            }
            catch (Exception e) {
                log.error("Exception has been thrown!", (Throwable)e);
                if (ExceptionUtils.indexOfType((Throwable)e, NodeException.class) == -1) {
                    throw new NodeException("Builder at", (Node)bbxCursor, (Throwable)e);
                }
                throw new RuntimeException("Failed in parser " + parser, e);
            }
            ImportParser.OldDocumentAction oldAction = oldDocumentAction;
            if (oldAction != ImportParser.OldDocumentAction.DESCEND) continue;
            Intrinsics.checkNotNull((Object)curOldChild, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element element = (Element)curOldChild;
            Node node = bbxCursor.getChild(bbxCursor.getChildCount() - 1);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.toBBXRecursive(element, (Element)node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fix(Document bbxDocument) {
        Element element = BBX.getRoot(bbxDocument);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
        Element documentRoot = element;
        block0: for (Map.Entry entry : ((Map)((Object)this.fixerMap)).entrySet()) {
            INodeMatcher curMatcher = (INodeMatcher)entry.getKey();
            ImportFixer curFixer = (ImportFixer)entry.getValue();
            if (curFixer == null) continue;
            Node lastMatchedNode = null;
            List lastMatchedAncestors = new ArrayList();
            Node cursor = (Node)documentRoot;
            while (true) {
                Node node;
                String string;
                Node rootToSearch = cursor;
                Logger logger = log;
                String string2 = "fixer {}{} matcher {} searching from cursor {}";
                Object[] objectArray = new Object[4];
                objectArray[0] = curFixer;
                objectArray[1] = curFixer instanceof AbstractFixer ? " (" + ((AbstractFixer)curFixer).getComment() + ")" : "";
                objectArray[2] = curMatcher;
                Object[] objectArray2 = objectArray;
                int n = 3;
                if (rootToSearch != null) {
                    void it;
                    int n2 = n;
                    Object[] objectArray3 = objectArray2;
                    String string3 = string2;
                    Logger logger2 = logger;
                    boolean bl = false;
                    String string4 = XMLHandler.Companion.toXMLSimple((Node)it);
                    logger = logger2;
                    string2 = string3;
                    objectArray2 = objectArray3;
                    n = n2;
                    string = string4;
                } else {
                    string = null;
                }
                objectArray2[n] = string;
                logger.debug(string2, objectArray);
                log.trace("import fix.1");
                if (cursor != null && curMatcher.isMatch(cursor, this.fixerMap.getNamespaces())) {
                    node = rootToSearch;
                } else {
                    Intrinsics.checkNotNull((Object)rootToSearch, (String)"null cannot be cast to non-null type nu.xom.Element");
                    node = BookToBBXConverter.Companion.matchDescendantRecursive((Element)rootToSearch, curMatcher, this.fixerMap.getNamespaces());
                }
                Node matchedNode = node;
                log.trace("Import fix.3");
                if (matchedNode == null) {
                    log.trace("Import fix.4 == null");
                    for (Node curNode : FastXPath.following((Node)rootToSearch)) {
                        if (curNode == rootToSearch || !curMatcher.isMatch(curNode, this.fixerMap.getNamespaces())) continue;
                        matchedNode = curNode;
                        if (!log.isTraceEnabled()) break;
                        log.trace("Import fix.5 {}", (Object)matchedNode);
                        break;
                    }
                }
                if (matchedNode == null) continue block0;
                if (lastMatchedNode != null) {
                    if (matchedNode == lastMatchedNode && CollectionsKt.contains((Iterable)XMLHandler.Companion.ancestorOrSelf(XMLHandler.Companion.nodeToElementOrParentOrDocRoot(matchedNode)), (Object)matchedNode)) {
                        String debugFixer = curFixer instanceof AbstractFixer ? "\"" + ((AbstractFixer)curFixer).getComment() + "\" " : "";
                        throw new NodeException("Detected infinite loop, just fixed element is matched again on " + debugFixer + curFixer + " matcher " + curMatcher, matchedNode, null, 4, null);
                    }
                    lastMatchedNode = matchedNode;
                    lastMatchedAncestors.clear();
                    lastMatchedAncestors.addAll(XMLHandler.Companion.ancestorOrSelf(XMLHandler.Companion.nodeToElementOrParentOrDocRoot(matchedNode)));
                }
                log.trace("fixing matched node {}", (Object)XMLHandler.Companion.toXMLSimple(matchedNode));
                Element cursorSection = XMLHandler.Companion.ancestorVisitorElement(matchedNode, BookToBBXConverter::fix$lambda$1);
                curFixer.fix(matchedNode);
                cursor = (Node)cursorSection;
            }
        }
        Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)documentRoot));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)fix$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)sequence, BookToBBXConverter::fix$lambda$2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element curNode = (Element)element$iv;
            boolean bl = false;
            BBX.FixerMarker.ATTRIB_FIXER_MARKER.detach(curNode);
        }
    }

    @JvmOverloads
    @NotNull
    public final Document convert(@NotNull Document oldDoc) {
        Intrinsics.checkNotNullParameter((Object)oldDoc, (String)"oldDoc");
        return BookToBBXConverter.convert$default(this, oldDoc, null, 2, null);
    }

    private static final boolean fix$lambda$1(Element node) {
        return BBX.SECTION.isA((Node)node);
    }

    private static final boolean fix$lambda$2(Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return BBX.FixerMarker.ATTRIB_FIXER_MARKER.has((Node)node);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BookToBBXConverter fromConfig(@NotNull String bookType) {
        return Companion.fromConfig(bookType);
    }

    @JvmStatic
    public static final void upgradeFormat(@NotNull Document doc) {
        Companion.upgradeFormat(doc);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @JvmStatic
    @NotNull
    public static final String[] devSetup(@NotNull String[] args) {
        return Companion.devSetup(args);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BookToBBXConverter fromConfig() {
        return Companion.fromConfig();
    }

    public static final /* synthetic */ String access$getTEST_CONFIG$cp() {
        return TEST_CONFIG;
    }

    public static final /* synthetic */ BookToBBXConverter access$getTEST_CONVERTER$cp() {
        return TEST_CONVERTER;
    }

    public static final /* synthetic */ void access$setTEST_CONFIG$cp(String string) {
        TEST_CONFIG = string;
    }

    public static final /* synthetic */ void access$setTEST_CONVERTER$cp(BookToBBXConverter bookToBBXConverter) {
        TEST_CONVERTER = bookToBBXConverter;
    }

    static {
        STRICT_MODE = Intrinsics.areEqual((Object)System.getProperty("bbx.strict", "false"), (Object)"true");
        log = LoggerFactory.getLogger(BookToBBXConverter.class);
        String unitTest = System.getProperty("test");
        CharSequence charSequence = unitTest;
        DEBUG_ASK_SWT_DIALOG = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && StringsKt.startsWith$default((String)unitTest, (String)"org.brailleblaster", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001b\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J!\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/brailleblaster/bbx/BookToBBXConverter$Companion;", "", "<init>", "()V", "DEBUG_ASK_SWT_DIALOG", "", "STRICT_MODE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TEST_CONFIG", "", "TEST_CONVERTER", "Lorg/brailleblaster/bbx/BookToBBXConverter;", "fromConfig", "bookType", "upgradeFormat", "", "doc", "Lnu/xom/Document;", "matchDescendantRecursive", "Lnu/xom/Node;", "root", "Lnu/xom/Element;", "matcher", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "namespaceMap", "Lorg/brailleblaster/utd/NamespaceMap;", "main", "args", "", "([Ljava/lang/String;)V", "saveDocumentFormatted", "out", "Ljava/io/File;", "devSetup", "([Ljava/lang/String;)[Ljava/lang/String;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BookToBBXConverter fromConfig(@NotNull String bookType) {
            Intrinsics.checkNotNullParameter((Object)bookType, (String)"bookType");
            String[] stringArray = new String[]{"utd", bookType + ".parserMap.xml"};
            ImportParserMap importParserMap = ImportParserMap.Companion.load(BBIni.loadAutoProgramDataFile(stringArray));
            stringArray = new String[]{"utd", "bbx.fixerMap.xml"};
            BookToBBXConverter converter = new BookToBBXConverter(importParserMap, ImportFixerMap.Companion.load(BBIni.loadAutoProgramDataFile(stringArray)), UTDManager.Companion.loadStyleDefinitions(UTDManager.Companion.getPreferredFormatStandard()));
            return converter;
        }

        public static /* synthetic */ BookToBBXConverter fromConfig$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "nimas";
            }
            return companion.fromConfig(string);
        }

        @JvmStatic
        public final void upgradeFormat(@NotNull Document doc) {
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            int formatVersion = BBX.getFormatVersion(doc);
            if (formatVersion >= 6) {
                log.info("BBX version {} is up to date", (Object)formatVersion);
            }
            StyleDefinitions styleDefs2 = UTDManager.Companion.loadStyleDefinitions(UTDManager.Companion.getPreferredFormatStandard());
            switch (formatVersion) {
                case 0: 
                case 1: 
                case 2: {
                    log.info("Upgrading BBX format from 2 to 3");
                    String[] stringArray = new String[]{"utd", "bbx2to3.fixerMap.xml"};
                    new BookToBBXConverter(null, ImportFixerMap.Companion.load(BBIni.loadAutoProgramDataFile(stringArray)), styleDefs2).doUpgrade(doc, "Upgrade from 2 to 3", 3);
                    log.info("Upgrading BBX format from 3 to 4");
                    BBXTo4Upgrader.upgrade(doc);
                    log.info("Upgrading BBX format from 4 to 5");
                    BBXTo5Upgrader.upgrade(doc);
                    log.info("Upgrading BBX format from 5 to 6");
                    BBXTo6Upgrader.upgrade(doc);
                    log.info("Running LiveFixer, final upgrade");
                    Element element = BBX.getRoot(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
                    LiveFixer.fix(element);
                    break;
                }
                case 3: {
                    log.info("Upgrading BBX format from 3 to 4");
                    BBXTo4Upgrader.upgrade(doc);
                    log.info("Upgrading BBX format from 4 to 5");
                    BBXTo5Upgrader.upgrade(doc);
                    log.info("Upgrading BBX format from 5 to 6");
                    BBXTo6Upgrader.upgrade(doc);
                    log.info("Running LiveFixer, final upgrade");
                    Element element = BBX.getRoot(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
                    LiveFixer.fix(element);
                    break;
                }
                case 4: {
                    log.info("Upgrading BBX format from 4 to 5");
                    BBXTo5Upgrader.upgrade(doc);
                    log.info("Upgrading BBX format from 5 to 6");
                    BBXTo6Upgrader.upgrade(doc);
                    log.info("Running LiveFixer, final upgrade");
                    Element element = BBX.getRoot(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
                    LiveFixer.fix(element);
                    break;
                }
                case 5: {
                    log.info("Upgrading BBX format from 5 to 6");
                    BBXTo6Upgrader.upgrade(doc);
                    log.info("Running LiveFixer, final upgrade");
                    Element element = BBX.getRoot(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
                    LiveFixer.fix(element);
                    break;
                }
                default: {
                    log.info("Running LiveFixer, final upgrade");
                    Element element = BBX.getRoot(doc);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRoot(...)");
                    LiveFixer.fix(element);
                }
            }
            BBXValidator.INSTANCE.validateDocument(doc, styleDefs2);
        }

        private final Node matchDescendantRecursive(Element root, INodeMatcher matcher, NamespaceMap namespaceMap) {
            log.trace("matchDescendantRecursive.1");
            for (Node curChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)root))) {
                if (log.isTraceEnabled()) {
                    log.trace("matchDescendantRecursive.2 {}", (Object)curChild.toString());
                }
                if (matcher.isMatch(curChild, namespaceMap)) {
                    log.trace("matchDescendantRecursive.3");
                    return curChild;
                }
                if (!(curChild instanceof Element)) continue;
                log.trace("matchDescendantRecursive.4");
                Node result = this.matchDescendantRecursive((Element)curChild, matcher, namespaceMap);
                if (result == null) continue;
                log.trace("matchDescendantRecursive.5");
                return result;
            }
            log.trace("matchDescendantRecursive.6");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            String[] devSetupArgs = this.devSetup(args);
            if (devSetupArgs.length != 2) {
                System.err.println(BookToBBXConverter.class.getName() + " <input nimas book> <output bbx file>");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            Document doc = new XMLHandler().load(new File(devSetupArgs[0]));
            Main.initBB$default(Main.INSTANCE, CollectionsKt.emptyList(), false, 2, null);
            Thread.setDefaultUncaughtExceptionHandler(null);
            BookToBBXConverter converter = org.brailleblaster.bbx.BookToBBXConverter$Companion.fromConfig$default(this, null, 1, null);
            long startTime = System.currentTimeMillis();
            try {
                Document newDoc = BookToBBXConverter.convert$default(converter, doc, null, 2, null);
                this.saveDocumentFormatted(newDoc, new File(devSetupArgs[1]));
            }
            finally {
                log.error("Converted in {}", (Object)Utils.runtimeToString(startTime));
            }
        }

        private final void saveDocumentFormatted(Document doc, File out) {
            log.debug("Writing to " + out.getAbsolutePath());
            try {
                Element configElement;
                Element element = configElement = DocumentUTDConfig.NIMAS.getConfigElement(doc, "isNormalised");
                if (element != null) {
                    element.detach();
                }
                Serializer serializer2 = new Serializer((OutputStream)new FileOutputStream(out), "UTF-8");
                serializer2.setLineSeparator(ConstantsKt.getLINE_BREAK());
                serializer2.setIndent(2);
                serializer2.write(doc);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to save", e);
            }
        }

        @JvmStatic
        @NotNull
        public final String[] devSetup(@NotNull String[] args) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (new File("/home/leon/").exists()) {
                System.setProperty("nodeexception.folder", "exception.xml");
                try {
                    new File("exception.xml").createNewFile();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create exception.xml file", e);
                }
                String[] stringArray2 = new String[]{"../linuxdev/9780133268195NIMAS_revised.xml", "out-final.xml"};
                stringArray = stringArray2;
            } else {
                stringArray = args;
            }
            return stringArray;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final BookToBBXConverter fromConfig() {
            return org.brailleblaster.bbx.BookToBBXConverter$Companion.fromConfig$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

