/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/DefinitionTermImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "HasFollowingListItemMatcher", "Companion", "brailleblaster-core"})
public final class DefinitionTermImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.SPAN.DEFINITION_TERM.assertIsA(matchedNode);
        Element element = Companion.nextUsableListItem(matchedNode);
        if (element == null) {
            throw new NodeException("matched but no definition to move term inside of", matchedNode, null, 4, null);
        }
        Element definitionDescNode = element;
        BBX.BLOCK.LIST_ITEM.assertIsA((Node)definitionDescNode);
        matchedNode.detach();
        definitionDescNode.insertChild(matchedNode, 0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/bbx/fixers/DefinitionTermImportFixer$Companion;", "", "<init>", "()V", "nextUsableListItem", "Lnu/xom/Element;", "node", "Lnu/xom/Node;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Element nextUsableListItem(@NotNull Node node) {
            Element element;
            block3: {
                Node curNode;
                block2: {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    curNode = node;
                    do {
                        if (XMLHandler.Companion.nextSiblingNode(curNode) == null) {
                            return null;
                        }
                        if (!(curNode instanceof Text)) break block2;
                        string = ((Text)curNode).getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    } while (!(!StringsKt.isBlank((CharSequence)string)));
                    element = null;
                    break block3;
                }
                element = BBX.BLOCK.LIST_ITEM.isA(curNode) ? (Element)curNode : null;
            }
            return element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/DefinitionTermImportFixer$HasFollowingListItemMatcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "brailleblaster-core"})
    public static final class HasFollowingListItemMatcher
    implements INodeMatcher {
        public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
            return Companion.nextUsableListItem(node) != null;
        }
    }
}

