/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/ImageGroupImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nImageGroupImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageGroupImportFixer.kt\norg/brailleblaster/bbx/fixers/ImageGroupImportFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n2792#2,3:87\n*S KotlinDebug\n*F\n+ 1 ImageGroupImportFixer.kt\norg/brailleblaster/bbx/fixers/ImageGroupImportFixer\n*L\n35#1:87,3\n*E\n"})
public final class ImageGroupImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(ImageGroupImportFixer.class);
    @JvmField
    public static int imageIdCounter;

    @Override
    public void fix(@NotNull Node matchedNode) {
        boolean bl;
        int groupId;
        Element origGroup;
        block9: {
            Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
            BBX.CONTAINER.IMAGE.assertIsA(matchedNode);
            origGroup = (Element)matchedNode;
            BBX._ATTRIB_FIXER_TODO.assertAndDetach((BBX.FixerTodo)((Enum)BBX.FixerTodo.CONVERT_IMAGE_GROUP), origGroup);
            int n = imageIdCounter;
            imageIdCounter = n + 1;
            groupId = n;
            Iterable $this$none$iv = NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)matchedNode));
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Node node = (Node)element$iv;
                    boolean bl2 = false;
                    if (!BBX.SPAN.IMAGE.isA(node)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            log.warn("prodnote without image tag, skipping");
            return;
        }
        List groups = new ArrayList();
        boolean addedImage = false;
        Element curGroup = origGroup;
        groups.add(curGroup);
        BBX.CONTAINER.IMAGE.ATTRIB_GROUP_ID.set(curGroup, groupId);
        Iterator childIter = NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)matchedNode)).iterator();
        while (childIter.hasNext()) {
            Node curChild = (Node)childIter.next();
            if (BBX.SPAN.IMAGE.isA(curChild)) {
                if (!addedImage) {
                    addedImage = true;
                } else {
                    Element newGroup = BBX.CONTAINER.IMAGE.create();
                    BBX.CONTAINER.IMAGE.ATTRIB_GROUP_ID.set(newGroup, groupId);
                    curGroup.getParent().insertChild((Node)newGroup, curGroup.getParent().indexOf((Node)curGroup) + 1);
                    Intrinsics.checkNotNull((Object)newGroup);
                    groups.add(newGroup);
                    curGroup = newGroup;
                }
                Intrinsics.checkNotNull((Object)curChild, (String)"null cannot be cast to non-null type nu.xom.Element");
                for (Attribute curOldAttribute : NodeUtilsKt.getAttributes((Element)((Element)curChild))) {
                    Attribute newAttribute = new Attribute(curOldAttribute);
                    curGroup.addAttribute(newAttribute);
                }
                childIter.remove();
                continue;
            }
            if (NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)curGroup)).contains(curChild)) continue;
            childIter.remove();
            curGroup.appendChild(curChild);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/ImageGroupImportFixer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "imageIdCounter", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

