/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.bbx.fixers2.ImportFixerCommon;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.exceptions.UTDInterruption;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/TableImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "Companion", "brailleblaster-core"})
public final class TableImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(TableImportFixer.class);

    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.CONTAINER.TABLE.assertIsA(matchedNode);
        Element table = (Element)matchedNode;
        BBX._ATTRIB_FIXER_TODO.assertAndDetach((BBX.FixerTodo)((Enum)BBX.FixerTodo.TABLE_SIZE), table);
        XMLHandler.Companion.childrenRecursiveNodeVisitor((Node)table, TableImportFixer::fix$lambda$0);
        if (Companion.detectTableTypeUntranslated(table) == TableUtils.TableTypes.NONTABLE) {
            log.trace("Table is too big, stripping table elements");
            try {
                List<Element> list = Companion.stripTable(table);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot strip non-table table element", e);
            }
        }
        try {
            Companion.stripUnusedCellElements(table);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't cleanup table cell contents", e);
        }
    }

    private static final boolean fix$lambda$0(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof Text) {
            String string = ((Text)it).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (StringsKt.isBlank((CharSequence)string) && !MathModuleUtils.isMath(it)) {
                ((Text)it).setValue("");
            }
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final TableUtils.TableTypes detectTableTypeUntranslated(@NotNull Element table) {
        return Companion.detectTableTypeUntranslated(table);
    }

    @JvmStatic
    @NotNull
    public static final List<Element> stripTable(@NotNull Element bbxTable) {
        return Companion.stripTable(bbxTable);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\r\u001a\u00020\nH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/bbx/fixers/TableImportFixer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "detectTableTypeUntranslated", "Lorg/brailleblaster/utd/utils/TableUtils$TableTypes;", "table", "Lnu/xom/Element;", "stripUnusedCellElements", "", "bbxTable", "doUnwrap", "curElement", "stripTable", "", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nTableImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableImportFixer.kt\norg/brailleblaster/bbx/fixers/TableImportFixer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n777#2:191\n873#2,2:192\n*S KotlinDebug\n*F\n+ 1 TableImportFixer.kt\norg/brailleblaster/bbx/fixers/TableImportFixer$Companion\n*L\n119#1:191\n119#1:192,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TableUtils.TableTypes detectTableTypeUntranslated(@NotNull Element table) {
            Document document;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            BBX.CONTAINER.TABLE.assertIsA((Node)table);
            UTDManager utdMan = ImportFixerCommon.INSTANCE.getUTD_MANAGER();
            Document doc = null;
            int retries = 10;
            while (true) {
                Element root;
                Intrinsics.checkNotNullExpressionValue((Object)BBX.newDocument(), (String)"newDocument(...)");
                doc.getRootElement().appendChild((Node)BBX.SECTION.ROOT.create());
                Intrinsics.checkNotNullExpressionValue((Object)BBX.getRoot(doc), (String)"getRoot(...)");
                Element element = table.copy();
                Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type nu.xom.Element");
                root.appendChild((Node)element);
                try {
                    document = utdMan.getEngine().translateAndFormatDocument(doc);
                }
                catch (UTDInterruption e) {
                    if (--retries > 0) continue;
                    throw new RuntimeException("Something is preventing translation and formatting, please try again.", e);
                }
                break;
            }
            doc = document;
            Element tableForDetection = BBX.getRoot(doc).getChildElements().get(0);
            BBX.CONTAINER.TABLE.assertIsA((Node)tableForDetection);
            Intrinsics.checkNotNull((Object)tableForDetection);
            return TableUtils.INSTANCE.detectType(tableForDetection, utdMan.getEngine().getStyleMap(), utdMan.getEngine().getBrailleSettings(), utdMan.getEngine().getPageSettings());
        }

        /*
         * WARNING - void declaration
         */
        public final void stripUnusedCellElements(@NotNull Element bbxTable) {
            Intrinsics.checkNotNullParameter((Object)bbxTable, (String)"bbxTable");
            Iterator iterator = bbxTable.getChildElements().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                void $this$filterTo$iv$iv;
                Element curRow = (Element)iterator2.next();
                if (!BBX.CONTAINER.TABLE_ROW.isA((Node)curRow)) continue;
                Elements elements = curRow.getChildElements();
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getChildElements(...)");
                Iterable $this$filter$iv = (Iterable)elements;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Element it = (Element)element$iv$iv;
                    boolean bl = false;
                    if (!(BBX._ATTRIB_FIXER_TODO.has((Node)it) && BBX._ATTRIB_FIXER_TODO.get(it) == BBX.FixerTodo.TABLE_CELL_REAL)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Element curCell : (List)destination$iv$iv) {
                    Iterator iterator3;
                    BBX.transform(curCell, BBX.BLOCK.TABLE_CELL);
                    BBX._ATTRIB_FIXER_TODO.assertAndDetach((BBX.FixerTodo)((Enum)BBX.FixerTodo.TABLE_CELL_REAL), curCell);
                    Intrinsics.checkNotNullExpressionValue((Object)curCell.getChildElements().iterator(), (String)"iterator(...)");
                    while (iterator3.hasNext()) {
                        Element curCellChild = (Element)iterator3.next();
                        Intrinsics.checkNotNull((Object)curCellChild);
                        this.doUnwrap(curCellChild);
                    }
                }
            }
        }

        private final void doUnwrap(Element curElement) {
            if (BBX.INLINE.isA((Node)curElement)) {
                return;
            }
            if (BBX._ATTRIB_FIXER_TODO.has((Node)curElement) && BBX._ATTRIB_FIXER_TODO.get(curElement) == BBX.FixerTodo.LINE_BREAK) {
                curElement.getParent().replaceChild((Node)curElement, (Node)new Text(" "));
                return;
            }
            if (curElement.getChildCount() == 0) {
                curElement.detach();
                return;
            }
            Node nextNode = XMLHandler.Companion.nextSiblingNode((Node)curElement);
            boolean needsSpace = !(!BBX.BLOCK.isA((Node)curElement) && !BBX.CONTAINER.isA((Node)curElement) || nextNode == null || !BBX.BLOCK.isA(nextNode) && !BBX.CONTAINER.isA(nextNode));
            Iterator iterator = curElement.getChildElements().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Element childElement = (Element)iterator2.next();
                Intrinsics.checkNotNull((Object)childElement);
                this.doUnwrap(childElement);
            }
            ParentNode parent = curElement.getParent();
            Node lastChild = (Node)CollectionsKt.lastOrNull((List)NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)curElement)));
            XMLHandler.Companion.unwrapElement(curElement);
            if (needsSpace) {
                Node node = lastChild;
                parent.insertChild((Node)new Text(" "), node != null ? parent.indexOf(node) + 1 : 0);
            }
        }

        @JvmStatic
        @NotNull
        public final List<Element> stripTable(@NotNull Element bbxTable) {
            Intrinsics.checkNotNullParameter((Object)bbxTable, (String)"bbxTable");
            BBX.CONTAINER.TABLE.assertIsA((Node)bbxTable);
            List cells = new ArrayList();
            Iterator iterator = bbxTable.getChildElements().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Element curRow = (Element)iterator2.next();
                if (!BBX.CONTAINER.TABLE_ROW.isA((Node)curRow)) continue;
                Collection collection = cells;
                Elements elements = curRow.getChildElements();
                Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getChildElements(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)elements));
                Intrinsics.checkNotNull((Object)curRow);
                XMLHandler.Companion.unwrapElement(curRow);
            }
            XMLHandler.Companion.unwrapElement(bbxTable);
            for (Element cell : cells) {
                if (!BBX.BLOCK.isA((Node)cell)) continue;
                BBX.transform(cell, BBX.BLOCK.DEFAULT);
            }
            return cells;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

