/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers.to3;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/MarginImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "Matcher", "brailleblaster-core"})
public final class MarginImportFixer
extends AbstractFixer {
    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.BLOCK.assertIsA(matchedNode);
        Element element = (Element)matchedNode;
        Object t = BBX._ATTRIB_OVERRIDE_STYLE.get(element);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        BBXUtils.ListStyleData listStyleData = BBXUtils.INSTANCE.parseListStyle((String)t);
        if (listStyleData == null) {
            throw new NodeException("Node matches but styleData is null?", matchedNode, null, 4, null);
        }
        BBXUtils.ListStyleData styleData = listStyleData;
        BBXUtils.INSTANCE.stripStyleExceptOverrideStyle(element);
        BBX._ATTRIB_OVERRIDE_STYLE.detach(element);
        if (styleData.getListType() != null) {
            BBXUtils.INSTANCE.stripStyleExceptOverrideStyle(element);
            BBX.transform(element, BBX.BLOCK.LIST_ITEM);
            BBX.BLOCK.LIST_ITEM.ATTRIB_ITEM_LEVEL.set(element, styleData.getIndentLevel());
        } else if (styleData.getMarginType() != null) {
            BBX.transform(element, BBX.BLOCK.MARGIN);
            BBX.BLOCK.MARGIN.ATTRIB_MARGIN_TYPE.set(element, styleData.getMarginType());
            BBX.BLOCK.MARGIN.ATTRIB_INDENT.set(element, styleData.getIndentLevel());
            BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.set(element, styleData.getRunoverLevel());
        } else {
            throw new NodeException("styleData with no marginType or listType? " + styleData, matchedNode, null, 4, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/MarginImportFixer$Matcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "brailleblaster-core"})
    public static final class Matcher
    implements INodeMatcher {
        public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
            if (!BBX.BLOCK.isA(node)) {
                return false;
            }
            Element element = (Element)node;
            if (!BBX._ATTRIB_OVERRIDE_STYLE.has((Node)element)) {
                return false;
            }
            Object t = BBX._ATTRIB_OVERRIDE_STYLE.get(element);
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            BBXUtils.ListStyleData styleData = BBXUtils.INSTANCE.parseListStyle((String)t);
            if (styleData == null) {
                return false;
            }
            if (styleData.getListType() != null) {
                Integer origListLevel;
                Element element2 = XMLHandler.Companion.ancestorVisitorElement((Node)element, Matcher::isMatch$lambda$0);
                if (element2 == null) {
                    return false;
                }
                Element parentWithListLevel = element2;
                BBX.ListType listType = (BBX.ListType)BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get(parentWithListLevel);
                if (listType != styleData.getListType() && (listType != BBX.ListType.POEM && listType != BBX.ListType.POEM_LINE_GROUP || styleData.getListType() != BBX.ListType.POEM && styleData.getListType() != BBX.ListType.POEM_LINE_GROUP)) {
                    return false;
                }
                Integer n = origListLevel = (Integer)BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(parentWithListLevel);
                int n2 = styleData.getRunoverLevel();
                if (n == null || n != n2) {
                    return false;
                }
            } else if (styleData.getMarginType() == null) {
                throw new NodeException("styleData with no marginType or listType? " + styleData, (Node)element, null, 4, null);
            }
            return true;
        }

        private static final boolean isMatch$lambda$0(Element it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.has((Node)it);
        }
    }
}

