/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.document;

import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;
import nu.xom.XPathContext;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.Controller;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.BRFWriter;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0004J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0011J&\u0010/\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001eJ\u0016\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u00020$J\u0016\u00109\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u00020$J \u0010:\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0018\u0010;\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\u0018\u001a\u00020\u0011J\u0010\u0010>\u001a\u00020?2\b\u0010>\u001a\u0004\u0018\u00010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0019\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R\u0011\u0010@\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\rR\u0011\u0010B\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010 R\u0011\u0010D\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006I"}, d2={"Lorg/brailleblaster/document/BBDocument;", "", "controller", "Lorg/brailleblaster/perspectives/Controller;", "doc", "Lnu/xom/Document;", "<init>", "(Lorg/brailleblaster/perspectives/Controller;Lnu/xom/Document;)V", "getController", "()Lorg/brailleblaster/perspectives/Controller;", "utdManager", "Lorg/brailleblaster/settings/UTDManager;", "getUtdManager", "()Lorg/brailleblaster/settings/UTDManager;", "translateDocument", "", "makeElement", "Lnu/xom/Element;", "subType", "Lorg/brailleblaster/bbx/BBX$SubType;", "attribute", "", "value", "addNamespace", "e", "rootElement", "getRootElement", "()Lnu/xom/Element;", "removeAllBraille", "currentStart", "", "getCurrentStart", "()I", "setCurrentStart", "(I)V", "print", "", "getPrint", "()Z", "setPrint", "(Z)V", "nlflag", "getNlflag", "setNlflag", "psFlag", "getPsFlag", "setPsFlag", "createBrlFile", "filePath", "Ljava/nio/file/Path;", "start", "end", "scope", "setMarginTopLines", "Ljava/io/FileOutputStream;", "output", "addMargin", "setMarginLeftCells", "checkAttributeValue", "attributeExists", "findPrintPageNode", "Lnu/xom/Node;", "query", "Lnu/xom/Nodes;", "settingsManager", "getSettingsManager", "linesPerPage", "getLinesPerPage", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "getEngine", "()Lorg/brailleblaster/utd/UTDTranslationEngine;", "Companion", "brailleblaster-core"})
public class BBDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Controller controller;
    @JvmField
    @NotNull
    public final Document doc;
    @NotNull
    private final UTDManager utdManager;
    private int currentStart;
    private boolean print;
    private boolean nlflag;
    private boolean psFlag;
    public static final boolean TEST_MODE = false;
    @Nullable
    private static UTDManager TEST_UTD;
    @NotNull
    private static final Logger log;

    public BBDocument(@NotNull Controller controller, @NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.controller = controller;
        this.doc = doc;
        try {
            UTDManager uTDManager;
            UTDManager uTDManager2 = TEST_UTD;
            BBDocument bBDocument = this;
            boolean bl = false;
            UTDManager it = uTDManager = new UTDManager(null, 1, null);
            boolean bl2 = false;
            it.loadEngineFromDoc(this.doc, "bbx");
            bBDocument.utdManager = uTDManager;
            TEST_UTD = this.utdManager;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize UTD engine", e);
        }
    }

    @NotNull
    protected final Controller getController() {
        return this.controller;
    }

    @NotNull
    protected final UTDManager getUtdManager() {
        return this.utdManager;
    }

    public final void translateDocument() {
        this.getSettingsManager().getEngine().expectedTranslate = true;
        Document translatedDoc = this.getEngine().translateAndFormatDocument(this.doc);
        this.getSettingsManager().getEngine().expectedTranslate = false;
        Element translatedRoot = translatedDoc.getRootElement();
        translatedDoc.replaceChild((Node)translatedRoot, (Node)new Element("empty"));
        this.doc.replaceChild((Node)this.doc.getRootElement(), (Node)translatedRoot);
    }

    @NotNull
    public final Element makeElement(@NotNull BBX.SubType subType, @Nullable String attribute, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Element e = this.makeElement(subType);
        if (attribute != null) {
            e.addAttribute(new Attribute(attribute, value));
        }
        return e;
    }

    @NotNull
    public final Element makeElement(@NotNull BBX.SubType subType) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Element element = subType.create();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        return element;
    }

    protected final void addNamespace(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.setNamespaceURI(this.doc.getRootElement().getNamespaceURI());
        Elements els = e.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            this.addNamespace(element);
        }
    }

    @NotNull
    public final Element getRootElement() {
        Element element = this.doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        return element;
    }

    public final void removeAllBraille(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (UTDElements.META.isA((Node)e)) {
            if (this.attributeExists(e, "name") && Intrinsics.areEqual((Object)e.getAttributeValue("name"), (Object)"utd")) {
                e.getParent().removeChild((Node)e);
            } else if (this.attributeExists(e, "semantics")) {
                attr = e.getAttribute("semantics");
                e.removeAttribute(attr);
            }
        } else if (e.getAttribute("semantics") != null) {
            attr = e.getAttribute("semantics");
            e.removeAttribute(attr);
        }
        Iterator iterator = e.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Node node;
            Element curElement = (Element)iterator2.next();
            if (UTDElements.BRL.isA((Node)curElement)) {
                node = e.removeChild((Node)curElement);
                continue;
            }
            if (BBX.CONTAINER.TABLE.isA((Node)curElement) && curElement.getAttribute("class") != null) {
                String string = curElement.getAttributeValue("class");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"utd:table", (boolean)false, (int)2, null)) {
                    node = e.removeChild((Node)curElement);
                    continue;
                }
            }
            Intrinsics.checkNotNull((Object)curElement);
            this.removeAllBraille(curElement);
            node = Unit.INSTANCE;
        }
    }

    public final int getCurrentStart() {
        return this.currentStart;
    }

    public final void setCurrentStart(int n) {
        this.currentStart = n;
    }

    public final boolean getPrint() {
        return this.print;
    }

    public final void setPrint(boolean bl) {
        this.print = bl;
    }

    public final boolean getNlflag() {
        return this.nlflag;
    }

    public final void setNlflag(boolean bl) {
        this.nlflag = bl;
    }

    public final boolean getPsFlag() {
        return this.psFlag;
    }

    public final void setPsFlag(boolean bl) {
        this.psFlag = bl;
    }

    public final boolean createBrlFile(@NotNull Path filePath, int start, int end, int scope) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        boolean addMargin = false;
        try {
            if (start == end && start == 1 && scope == 0) {
                this.print = true;
                FileOutputStream output = new FileOutputStream(filePath.toFile());
                this.setMarginTopLines(output, addMargin);
                this.setMarginLeftCells(output, addMargin);
                ITranslationEngine iTranslationEngine = (ITranslationEngine)this.getEngine();
                BRFWriter.OutputCharStream outputCharStream = arg_0 -> BBDocument.createBrlFile$lambda$0(this, output, addMargin, arg_0);
                BRFWriter.PageListener pageListener = BRFWriter.EMPTY_PAGE_LISTENER;
                Intrinsics.checkNotNullExpressionValue((Object)pageListener, (String)"EMPTY_PAGE_LISTENER");
                ITranslationEngine.toBRF$default((ITranslationEngine)iTranslationEngine, (Document)this.doc, (BRFWriter.OutputCharStream)outputCharStream, (int)0, (BRFWriter.PageListener)pageListener, (boolean)false, (int)16, null);
            } else {
                FileOutputStream output = new FileOutputStream(filePath.toFile());
                if (start == 1) {
                    this.print = true;
                    this.setMarginTopLines(output, addMargin);
                    this.setMarginLeftCells(output, addMargin);
                }
                ITranslationEngine iTranslationEngine = (ITranslationEngine)this.getEngine();
                BRFWriter.OutputCharStream outputCharStream = arg_0 -> BBDocument.createBrlFile$lambda$1(this, output, addMargin, start, end, arg_0);
                BRFWriter.PageListener pageListener = BRFWriter.EMPTY_PAGE_LISTENER;
                Intrinsics.checkNotNullExpressionValue((Object)pageListener, (String)"EMPTY_PAGE_LISTENER");
                ITranslationEngine.toBRF$default((ITranslationEngine)iTranslationEngine, (Document)this.doc, (BRFWriter.OutputCharStream)outputCharStream, (int)0, (BRFWriter.PageListener)pageListener, (boolean)false, (int)16, null);
            }
            this.print = false;
            this.currentStart = 0;
            this.nlflag = false;
            this.psFlag = false;
            return true;
        }
        catch (IOException e) {
            log.debug("Attempting to save BRF", (Throwable)e);
            return false;
        }
    }

    @NotNull
    public final FileOutputStream setMarginTopLines(@NotNull FileOutputStream output, boolean addMargin) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (addMargin) {
            PageSettings pageSettings = this.getEngine().getPageSettings();
            int marginTopLines = this.getEngine().getBrailleSettings().getCellType().getLinesForHeight(BigDecimal.valueOf(pageSettings.getTopMargin()));
            for (int i = 0; i < marginTopLines; ++i) {
                try {
                    output.write(10);
                    continue;
                }
                catch (IOException e) {
                    log.debug("Attempting to add top margin", (Throwable)e);
                }
            }
        }
        return output;
    }

    @NotNull
    public final FileOutputStream setMarginLeftCells(@NotNull FileOutputStream output, boolean addMargin) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (addMargin) {
            PageSettings pageSettings = this.getEngine().getPageSettings();
            int marginLeftCells = this.getEngine().getBrailleSettings().getCellType().getCellsForWidth(BigDecimal.valueOf(pageSettings.getLeftMargin()));
            for (int i = 0; i < marginLeftCells; ++i) {
                try {
                    output.write(32);
                    continue;
                }
                catch (IOException e) {
                    log.debug("Attempting to add left margin", (Throwable)e);
                }
            }
        }
        return output;
    }

    public final boolean checkAttributeValue(@NotNull Element e, @Nullable String attribute, @NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            bl = Intrinsics.areEqual((Object)e.getAttributeValue(attribute), (Object)value);
        }
        catch (Exception ex) {
            bl = false;
        }
        return bl;
    }

    public final boolean attributeExists(@NotNull Element e, @Nullable String attribute) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getAttribute(attribute) != null;
    }

    @Nullable
    public final Node findPrintPageNode(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int count = e.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (!(e.getChild(i) instanceof Text)) continue;
            return e.getChild(i);
        }
        return null;
    }

    @NotNull
    public final Nodes query(@Nullable String query) {
        XPathContext context = XPathContext.makeNamespaceContext((Element)this.doc.getRootElement());
        Nodes nodes = this.doc.query(query, context);
        Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"query(...)");
        return nodes;
    }

    @NotNull
    public final UTDManager getSettingsManager() {
        return this.utdManager;
    }

    public final int getLinesPerPage() {
        double heightMM = this.getEngine().getPageSettings().getDrawableHeight();
        return this.getEngine().getBrailleSettings().getCellType().getLinesForHeight(BigDecimal.valueOf(heightMM));
    }

    @NotNull
    public final UTDTranslationEngine getEngine() {
        return this.utdManager.getEngine();
    }

    private static final void createBrlFile$lambda$0$0(FileOutputStream $output, char b) {
        $output.write(b);
    }

    private static final void createBrlFile$lambda$1$0(FileOutputStream $output, char b) {
        $output.write(b);
    }

    private static final void createBrlFile$lambda$0(BBDocument this$0, FileOutputStream $output, boolean $addMargin, char onChar) {
        if (this$0.nlflag) {
            this$0.setMarginLeftCells($output, $addMargin);
            this$0.nlflag = false;
        }
        if (this$0.psFlag) {
            this$0.setMarginTopLines($output, $addMargin);
            this$0.setMarginLeftCells($output, $addMargin);
            this$0.psFlag = false;
        }
        if (onChar == '\n') {
            this$0.nlflag = true;
        }
        if (onChar == '\f') {
            this$0.psFlag = true;
        }
        if (this$0.print) {
            BRFWriter.lineEndingRewriter(arg_0 -> BBDocument.createBrlFile$lambda$0$0($output, arg_0)).accept(onChar);
        }
    }

    private static final void createBrlFile$lambda$1(BBDocument this$0, FileOutputStream $output, boolean $addMargin, int $start, int $end, char onChar) {
        if (this$0.nlflag && this$0.print) {
            this$0.setMarginLeftCells($output, $addMargin);
            this$0.nlflag = false;
        }
        if (this$0.psFlag) {
            this$0.psFlag = false;
            this$0.print = true;
            this$0.setMarginTopLines($output, $addMargin);
            this$0.setMarginLeftCells($output, $addMargin);
        }
        if (onChar == '\f') {
            int n = this$0.currentStart;
            this$0.currentStart = n + 1;
            if ((n = this$0.currentStart) == $start - 1) {
                this$0.psFlag = true;
            } else {
                boolean bl = $start <= n ? n < $end : false;
                if (bl) {
                    this$0.psFlag = true;
                } else if (n == $end) {
                    $output.write(onChar);
                    this$0.print = false;
                    $output.close();
                }
            }
        } else if (onChar == '\n' && this$0.print) {
            this$0.nlflag = true;
        }
        if (this$0.print) {
            BRFWriter.lineEndingRewriter(arg_0 -> BBDocument.createBrlFile$lambda$1$0($output, arg_0)).accept(onChar);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(BBDocument.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/document/BBDocument$Companion;", "", "<init>", "()V", "TEST_MODE", "", "TEST_UTD", "Lorg/brailleblaster/settings/UTDManager;", "getTEST_UTD", "()Lorg/brailleblaster/settings/UTDManager;", "setTEST_UTD", "(Lorg/brailleblaster/settings/UTDManager;)V", "log", "Lorg/slf4j/Logger;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final UTDManager getTEST_UTD() {
            return TEST_UTD;
        }

        public final void setTEST_UTD(@Nullable UTDManager uTDManager) {
            TEST_UTD = uTDManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

