/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.easierxml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.easierxml.ImageUtils$matchingImages$;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.ui.BBStyleableText;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0019H\u0007J \u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\u000eH\u0007J\u0014\u0010)\u001a\u0004\u0018\u00010\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0007H\u0002J \u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020&H\u0007J\u0012\u00101\u001a\u00020\u00132\b\u00102\u001a\u0004\u0018\u000103H\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00064"}, d2={"Lorg/brailleblaster/easierxml/ImageUtils;", "", "<init>", "()V", "getImage", "Lorg/eclipse/swt/graphics/Image;", "imgElem", "Lnu/xom/Element;", "archiver", "Lorg/brailleblaster/archiver2/Archiver2;", "imageSize", "", "findAllImages", "Ljava/util/ArrayList;", "Lnu/xom/Node;", "Lkotlin/collections/ArrayList;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "gatherImages", "", "node", "array", "getArchiver", "()Lorg/brailleblaster/archiver2/Archiver2;", "isImage", "", "getElementFromInputDescription", "text", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText;", "setImageDescription", "imgElement", "descriptionElementRoot", "captionEnabled", "matchingImages", "", "doc", "Lnu/xom/Document;", "imgSrc", "", "getImageNavigateBlock", "imageNode", "getPreviousNavigateBlock", "caret", "imageNotFound", "l", "Lorg/eclipse/swt/widgets/Label;", "imgDir", "Ljava/nio/file/Path;", "imgPath", "willReplaceWarning", "shell", "Lorg/eclipse/swt/widgets/Shell;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageUtils.kt\norg/brailleblaster/easierxml/ImageUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n479#2:232\n2296#2,2:233\n812#3,12:235\n296#3,2:247\n*S KotlinDebug\n*F\n+ 1 ImageUtils.kt\norg/brailleblaster/easierxml/ImageUtils\n*L\n180#1:232\n210#1:233,2\n215#1:235,12\n215#1:247,2\n*E\n"})
public final class ImageUtils {
    @NotNull
    public static final ImageUtils INSTANCE = new ImageUtils();

    private ImageUtils() {
    }

    @JvmStatic
    @Nullable
    public static final Image getImage(@Nullable Element imgElem, @NotNull Archiver2 archiver, int imageSize) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)archiver, (String)"archiver");
        String string = (String)BBX.SPAN.IMAGE.ATTRIB_SOURCE.get(imgElem);
        if (string == null) {
            throw new NodeException("Image doesn't have src attribute ", (Node)imgElem, null, 4, null);
        }
        String imgSrc = string;
        Path path = Paths.get(imgSrc, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path imgFile = archiver.resolveSibling(path);
        if (!Files.exists(imgFile, new LinkOption[0])) {
            return null;
        }
        try {
            image = new Image((Device)Display.getCurrent(), Files.newInputStream(imgFile, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to render image at " + imgFile, e);
        }
        Image img = image;
        ImageData imgData = img.getImageData();
        int originalWidth = imgData.width;
        int originalHeight = imgData.height;
        int scaledHeight = 0;
        int scaledWidth = 0;
        if (originalWidth > originalHeight) {
            int extraPixels = imageSize - originalWidth;
            if (extraPixels > 0) {
                scaledWidth = originalWidth + extraPixels;
                double scaleFactor = (double)scaledWidth / (double)originalWidth;
                scaledHeight = (int)((double)originalHeight * scaleFactor);
            } else {
                scaledWidth = imageSize;
                double scaleFactor = (double)scaledWidth / (double)originalWidth;
                scaledHeight = (int)((double)originalHeight * scaleFactor);
            }
        } else if (originalHeight > originalWidth) {
            int extraPixels = imageSize - originalHeight;
            if (extraPixels > 0) {
                scaledHeight = originalHeight + extraPixels;
                double scaleFactor = (double)scaledHeight / (double)originalHeight;
                scaledWidth = (int)((double)originalWidth * scaleFactor);
            } else {
                scaledHeight = imageSize;
                double scaleFactor = (double)scaledHeight / (double)originalHeight;
                scaledWidth = (int)((double)originalWidth * scaleFactor);
            }
        } else {
            scaledHeight = imageSize;
            scaledWidth = imageSize;
        }
        imgData = imgData.scaledTo(scaledWidth, scaledHeight);
        img = new Image((Device)Display.getCurrent(), imgData);
        return img;
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<Node> findAllImages(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Document document = m.getDoc();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
        Document doc = document;
        ArrayList<Node> array = new ArrayList<Node>();
        Element element = doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        INSTANCE.gatherImages((Node)element, array);
        return array;
    }

    private final void gatherImages(Node node, ArrayList<Node> array) {
        if (BBX.SPAN.IMAGE.isA(node) || BBX.CONTAINER.IMAGE.isA(node)) {
            array.add(node);
        } else {
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                Node node2 = node.getChild(i);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
                this.gatherImages(node2, array);
            }
        }
    }

    @NotNull
    public final Archiver2 getArchiver() {
        Archiver2 archiver2 = WPManager.Companion.getInstance().getController().getArchiver();
        Intrinsics.checkNotNullExpressionValue((Object)archiver2, (String)"<get-archiver>(...)");
        return archiver2;
    }

    public final boolean isImage(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return (BBX.SPAN.IMAGE.isA(node) || BBX.CONTAINER.IMAGE.isA(node)) && XMLHandler.Companion.ancestorElementNot(node, ImageUtils::isImage$lambda$0);
    }

    @JvmStatic
    @NotNull
    public static final Element getElementFromInputDescription(@NotNull BBStyleableText text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return text.getXML(new Element("output"));
    }

    @JvmStatic
    @NotNull
    public static final Element setImageDescription(@NotNull Element imgElement, @NotNull Element descriptionElementRoot, boolean captionEnabled) {
        Intrinsics.checkNotNullParameter((Object)imgElement, (String)"imgElement");
        Intrinsics.checkNotNullParameter((Object)descriptionElementRoot, (String)"descriptionElementRoot");
        if (!INSTANCE.isImage((Node)imgElement)) {
            throw new NodeException("Expected img element, got", (Node)imgElement, null, 4, null);
        }
        imgElement.removeChildren();
        Object newDescRoot = null;
        if (BBX.SPAN.IMAGE.isA((Node)imgElement)) {
            newDescRoot = imgElement;
        } else {
            Object object;
            if (captionEnabled) {
                var4_4 = BBX.BLOCK.STYLE.create("Caption");
                Intrinsics.checkNotNull((Object)var4_4);
                object = var4_4;
            } else {
                var4_4 = BBX.BLOCK.DEFAULT.create();
                Intrinsics.checkNotNull((Object)var4_4);
                object = var4_4;
            }
            newDescRoot = object;
            imgElement.appendChild((Node)newDescRoot);
        }
        for (Node curDescChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)descriptionElementRoot))) {
            newDescRoot.appendChild(curDescChild.copy());
        }
        return imgElement;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> matchingImages(@Nullable Document doc, @NotNull String imgSrc) {
        Intrinsics.checkNotNullParameter((Object)imgSrc, (String)"imgSrc");
        Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)doc));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)matchingImages$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> ImageUtils.matchingImages$lambda$0(imgSrc, arg_0)), ImageUtils::matchingImages$lambda$1));
    }

    @JvmStatic
    @Nullable
    public static final Element getImageNavigateBlock(@NotNull Node imageNode) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)imageNode, (String)"imageNode");
        if (BBX.SPAN.IMAGE.isA(imageNode)) {
            Element block = (Element)XMLHandler.Companion.ancestorVisitor(imageNode, ImageUtils::getImageNavigateBlock$lambda$0);
            if (block == null) {
                block = (Element)imageNode;
            }
            element = INSTANCE.getPreviousNavigateBlock(block);
        } else {
            element = BBX.CONTAINER.IMAGE.isA(imageNode) ? INSTANCE.getPreviousNavigateBlock((Element)imageNode) : null;
        }
        return element;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Element getPreviousNavigateBlock(Element caret) {
        block = caret;
        while (block != null) {
            block7: {
                block6: {
                    $this$none$iv = FastXPath.descendant((Node)((Node)block));
                    $i$f$none = false;
                    for (E element$iv : $this$none$iv) {
                        node = (Node)element$iv /* !! */ ;
                        $i$a$-none-ImageUtils$getPreviousNavigateBlock$1 = false;
                        if (!(node instanceof Text)) ** GOTO lbl-1000
                        v0 = ((Text)node).getParent();
                        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type nu.xom.Element");
                        if (!Intrinsics.areEqual((Object)((Element)v0).getNamespaceURI(), (Object)"http://brailleblaster.org/ns/utd")) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        if (!v1) continue;
                        v2 = false;
                        break block6;
                    }
                    v2 = true;
                }
                if (!v2) break;
                $this$filterIsInstance$iv = FastXPath.INSTANCE.preceding((Node)block);
                $i$f$filterIsInstance = false;
                var5_5 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Element)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$firstOrNull$iv = (List)destination$iv$iv;
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    node = (Element)element$iv /* !! */ ;
                    $i$a$-firstOrNull-ImageUtils$getPreviousNavigateBlock$2 = false;
                    if (!BBX.BLOCK.isA((Node)node)) continue;
                    v3 = element$iv /* !! */ ;
                    break block7;
                }
                v3 = null;
            }
            block = v3;
        }
        return block;
    }

    @JvmStatic
    public static final void imageNotFound(@NotNull Label l, @NotNull Path imgDir, @NotNull String imgPath) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)imgDir, (String)"imgDir");
        Intrinsics.checkNotNullParameter((Object)imgPath, (String)"imgPath");
        l.setText("File " + imgPath + " not found in:" + ConstantsKt.getLINE_BREAK() + imgDir);
    }

    @JvmStatic
    public static final void willReplaceWarning(@Nullable Shell shell) {
        Label descWarning = new Label((Composite)shell, 0);
        descWarning.setText("Warning: This will replace the existing image description");
        descWarning.setForeground(Display.getCurrent().getSystemColor(3));
    }

    private static final boolean isImage$lambda$0(Element curAncestor) {
        Intrinsics.checkNotNullParameter((Object)curAncestor, (String)"curAncestor");
        return curAncestor.getAttribute("tableCopy", "http://brailleblaster.org/ns/utd") != null;
    }

    private static final boolean matchingImages$lambda$1$0(Element curAncestor) {
        Intrinsics.checkNotNullParameter((Object)curAncestor, (String)"curAncestor");
        return curAncestor.getAttribute("tableCopy", "http://brailleblaster.org/ns/utd") != null;
    }

    private static final boolean matchingImages$lambda$0(String $imgSrc, Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return INSTANCE.isImage((Node)node) && Intrinsics.areEqual(BBX.SPAN.IMAGE.ATTRIB_SOURCE.get(node), (Object)$imgSrc);
    }

    private static final boolean matchingImages$lambda$1(Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XMLHandler.Companion.ancestorElementNot((Node)node, ImageUtils::matchingImages$lambda$1$0);
    }

    private static final boolean getImageNavigateBlock$lambda$0(Node node) {
        return BBX.BLOCK.isA(node);
    }
}

