/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.easierxml;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.easierxml.ImageUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.stylers.StyleHandler;
import org.brailleblaster.perspectives.braille.ui.BBStyleableText;
import org.brailleblaster.perspectives.braille.views.wp.SixKeyHandler;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.Utils;
import org.brailleblaster.util.YesNoChoice;
import org.brailleblaster.util.ui.SixKeyUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.SizeAndLocation;
import org.brailleblaster.wordprocessor.FontManager;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 =2\u00020\u0001:\u0001=B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0002J(\u0010,\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0007H\u0002J\b\u00100\u001a\u00020\u001bH\u0002J\u0010\u00101\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0018\u00103\u001a\u00020\u001b2\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\nH\u0002J\u0018\u00105\u001a\u00020\u001b2\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\nH\u0002J \u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0016\u00109\u001a\u00020\u001b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0016\u0010;\u001a\u00020\u001b2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/brailleblaster/easierxml/SimpleImageDescriberDialog;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "swtParent", "Lorg/eclipse/swt/widgets/Shell;", "cursorImage", "Lnu/xom/Element;", "onFinishedImgGroup", "Ljava/util/function/Consumer;", "", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/eclipse/swt/widgets/Shell;Lnu/xom/Element;Ljava/util/function/Consumer;)V", "array", "", "Lnu/xom/Node;", "matchingImages", "index", "", "descTextEditor", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText;", "shell", "brailleWidget", "Lorg/eclipse/swt/custom/StyledText;", "wantsCaptionStyle", "", "open", "", "saveLocation", "addSizeMenu", "dialog", "menuBar", "Lorg/eclipse/swt/widgets/Menu;", "addPreferencesMenu", "clickPrevious", "clickNext", "getSrc", "", "element", "removeBraille", "image", "addBraillePane", "inputPane", "Lorg/eclipse/swt/widgets/Group;", "addStyledTextPane", "imgSrc", "Ljava/nio/file/Path;", "imgElem", "close", "clickApplySingleInline", "clickApplySingleBlock", "clickApplyAllInline", "imgElements", "clickApplyAllBlock", "insertIntoImageTag", "ele", "inline", "clickDeleteAll", "clickDeleteSingle", "postClick", "modifiedElements", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSimpleImageDescriberDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleImageDescriberDialog.kt\norg/brailleblaster/easierxml/SimpleImageDescriberDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,653:1\n1807#2,3:654\n1807#2,3:657\n1807#2,3:660\n*S KotlinDebug\n*F\n+ 1 SimpleImageDescriberDialog.kt\norg/brailleblaster/easierxml/SimpleImageDescriberDialog\n*L\n88#1:654,3\n367#1:657,3\n380#1:660,3\n*E\n"})
public final class SimpleImageDescriberDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @NotNull
    private final Consumer<List<Element>> onFinishedImgGroup;
    @NotNull
    private final List<Node> array;
    @NotNull
    private List<? extends Element> matchingImages;
    private int index;
    @Nullable
    private BBStyleableText descTextEditor;
    private Shell shell;
    @Nullable
    private StyledText brailleWidget;
    private boolean wantsCaptionStyle;
    private static final Logger log = LoggerFactory.getLogger(SimpleImageDescriberDialog.class);
    @NotNull
    public static final String SWTBOT_APPLY_ALL_INLINE = "simpleImageDescriber.applyAllInline";
    @NotNull
    public static final String SWTBOT_APPLY_ALL_BLOCK = "simpleImageDescriber.applyAllBlock";
    @NotNull
    public static final String SWTBOT_INFO_COMPOSITE = "simpleImageDescriber.applyAll";
    @NotNull
    public static final String INLINE_ONE = "Apply to this Image Inline";
    @NotNull
    public static final String BLOCK_ONE = "Apply to this Image Block";
    @NotNull
    public static final String INLINE_ALL_P1 = "Apply to All ";
    @NotNull
    public static final String BLOCK_ALL_P1 = "Apply to All ";
    @NotNull
    public static final String INLINE_ALL_P2 = " Instances Inline";
    @NotNull
    public static final String BLOCK_ALL_P2 = " Instances Block";
    @NotNull
    public static final String CAPTION_STYLE_BOX = "Wrap Text in Caption Style";
    private static int defaultSize = 200;
    private static boolean captionEnabled;
    private static boolean braille;
    @Nullable
    private static SizeAndLocation previousLocation;

    public SimpleImageDescriberDialog(@NotNull Manager m, @Nullable Shell swtParent, @Nullable Element cursorImage, @NotNull Consumer<List<Element>> onFinishedImgGroup) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter(onFinishedImgGroup, (String)"onFinishedImgGroup");
        this.m = m;
        this.onFinishedImgGroup = onFinishedImgGroup;
        this.array = ImageUtils.findAllImages(this.m);
        this.matchingImages = new ArrayList();
        if (!((Collection)this.array).isEmpty()) {
            boolean bl;
            block7: {
                if (cursorImage != null) {
                    log.debug("Cursor in image");
                    this.index = this.array.indexOf(cursorImage);
                    this.matchingImages = ImageUtils.matchingImages(this.m.getDoc(), this.getSrc(cursorImage));
                } else {
                    this.index = 0;
                    Document document = this.m.getDoc();
                    Node node = this.array.get(this.index);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                    this.matchingImages = ImageUtils.matchingImages(document, this.getSrc((Element)node));
                }
                Iterable $this$any$iv = this.matchingImages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Element node = (Element)element$iv;
                        boolean bl2 = false;
                        if (!BBX.CONTAINER.IMAGE.isA((Node)node)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            captionEnabled = bl;
            this.open();
        } else {
            Notify.notify$default(Notify.INSTANCE, "There are no images in your file", "No Images", false, 4, null);
        }
    }

    private final void open() {
        Shell shell;
        Shell shell2;
        Node node = this.array.get(this.index);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element selectedImage = (Element)node;
        if (Manager.getTableParent((Node)selectedImage) == null) {
            BBSimpleManager bBSimpleManager = this.m.getSimpleManager();
            Element element = ImageUtils.getImageNavigateBlock((Node)selectedImage);
            Intrinsics.checkNotNull((Object)element);
            bBSimpleManager.dispatchEvent(new XMLCaretEvent(Sender.IMAGE_DESCRIBER, new XMLNodeCaret((Node)element, null, 2, null), null, 4, null));
        }
        if ((shell2 = (this.shell = new Shell(this.m.getWpManager().getShell(), 67696))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell2 = null;
        }
        shell2.setText("Image Describer");
        GridLayout grid = new GridLayout(1, false);
        Shell shell3 = this.shell;
        if (shell3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell3 = null;
        }
        shell3.setLayout((Layout)grid);
        Shell shell4 = this.shell;
        if (shell4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell4 = null;
        }
        Menu menuBar = new Menu((Decorations)shell4, 2);
        Shell shell5 = this.shell;
        if (shell5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell5 = null;
        }
        this.addSizeMenu(shell5, menuBar);
        Shell shell6 = this.shell;
        if (shell6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell6 = null;
        }
        this.addPreferencesMenu(shell6, menuBar);
        Shell shell7 = this.shell;
        if (shell7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell7 = null;
        }
        Composite outerContainer = new Composite((Composite)shell7, 0);
        outerContainer.setLayout((Layout)new GridLayout(1, false));
        outerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc = new ScrolledComposite(outerContainer, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        Composite innerContainer = new Composite((Composite)sc, 0);
        innerContainer.setLayout((Layout)new GridLayout(1, false));
        innerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Group dualPane = new Group(innerContainer, 0);
        dualPane.setLayout((Layout)new GridLayout(2, true));
        dualPane.setLayoutData((Object)new GridData(4, 4, true, true));
        dualPane.setText(this.index + 1 + " of " + this.array.size() + " Images");
        EasySWT.INSTANCE.addSwtBotKey((Control)dualPane, SWTBOT_INFO_COMPOSITE);
        Group imagePane = new Group((Composite)dualPane, 0);
        imagePane.setLayout((Layout)new GridLayout(1, false));
        imagePane.setLayoutData((Object)new GridData(4, 4, true, true));
        Archiver2 archiver2 = this.m.getArchiver();
        Intrinsics.checkNotNullExpressionValue((Object)archiver2, (String)"<get-archiver>(...)");
        Archiver2 archiver = archiver2;
        Node node2 = this.array.get(this.index);
        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
        Image image = ImageUtils.getImage((Element)node2, archiver, defaultSize);
        Label imageLabel = new Label((Composite)imagePane, 0);
        imageLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        if (image != null) {
            imageLabel.setImage(image);
        } else {
            Path path = archiver.getPath();
            Node node3 = this.array.get(this.index);
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type nu.xom.Element");
            ImageUtils.imageNotFound(imageLabel, path, this.getSrc((Element)node3));
        }
        Group inputPane = new Group((Composite)dualPane, 0);
        inputPane.setLayout((Layout)new GridLayout(1, false));
        inputPane.setLayoutData((Object)new GridData(4, 4, true, true));
        if (braille) {
            this.addBraillePane(inputPane);
        } else {
            Shell shell8 = this.shell;
            if (shell8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
                shell8 = null;
            }
            Path path = archiver.getPath();
            Node node4 = this.array.get(this.index);
            Intrinsics.checkNotNull((Object)node4, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.addStyledTextPane(shell8, inputPane, path, (Element)node4);
        }
        Group nav1 = new Group(innerContainer, 0);
        nav1.setLayout((Layout)new GridLayout(4, false));
        nav1.setLayoutData((Object)new GridData(4, 4, true, false));
        Group nav2 = new Group(innerContainer, 0);
        nav2.setLayout((Layout)new GridLayout(5, false));
        nav2.setLayoutData((Object)new GridData(4, 4, true, false));
        Button applySingleInlineButton = new Button((Composite)nav1, 0);
        applySingleInlineButton.setText(INLINE_ONE);
        applySingleInlineButton.setLayoutData((Object)new GridData(4, 4, true, false));
        EasySWT.addSelectionListener((Button)applySingleInlineButton, arg_0 -> SimpleImageDescriberDialog.open$lambda$0(this, selectedImage, arg_0));
        Button applySingleBlockButton = new Button((Composite)nav1, 0);
        applySingleBlockButton.setText(BLOCK_ONE);
        applySingleBlockButton.setLayoutData((Object)new GridData(4, 4, true, false));
        EasySWT.addSelectionListener((Button)applySingleBlockButton, arg_0 -> SimpleImageDescriberDialog.open$lambda$1(this, selectedImage, arg_0));
        Button applyAllInlineButton = new Button((Composite)nav1, 8);
        EasySWT.INSTANCE.addSwtBotKey((Control)applyAllInlineButton, SWTBOT_APPLY_ALL_INLINE);
        applyAllInlineButton.setLayoutData((Object)new GridData(4, 4, true, false));
        applyAllInlineButton.setText("Apply to All " + this.matchingImages.size() + INLINE_ALL_P2);
        EasySWT.addSelectionListener((Button)applyAllInlineButton, arg_0 -> SimpleImageDescriberDialog.open$lambda$2(this, arg_0));
        Button applyAllBlockButton = new Button((Composite)nav1, 8);
        EasySWT.INSTANCE.addSwtBotKey((Control)applyAllBlockButton, SWTBOT_APPLY_ALL_BLOCK);
        applyAllBlockButton.setLayoutData((Object)new GridData(4, 4, true, false));
        applyAllBlockButton.setText("Apply to All " + this.matchingImages.size() + BLOCK_ALL_P2);
        EasySWT.addSelectionListener((Button)applyAllBlockButton, arg_0 -> SimpleImageDescriberDialog.open$lambda$3(this, arg_0));
        Button deleteSingleButton = new Button((Composite)nav2, 8);
        deleteSingleButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteSingleButton.setText("Delete  description");
        EasySWT.addSelectionListener((Button)deleteSingleButton, arg_0 -> SimpleImageDescriberDialog.open$lambda$4(this, selectedImage, arg_0));
        Button deleteAllButton = new Button((Composite)nav2, 8);
        deleteAllButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteAllButton.setText("Delete all " + this.matchingImages.size() + " descriptions");
        EasySWT.addSelectionListener((Button)deleteAllButton, arg_0 -> SimpleImageDescriberDialog.open$lambda$5(this, arg_0));
        Button previous = new Button((Composite)nav2, 8);
        previous.setText("Previous Image");
        previous.setLayoutData((Object)new GridData(4, 4, true, false));
        EasySWT.addSelectionListener((Button)previous, arg_0 -> SimpleImageDescriberDialog.open$lambda$6(this, arg_0));
        Button next = new Button((Composite)nav2, 8);
        next.setText("Next Image");
        next.setLayoutData((Object)new GridData(4, 4, true, false));
        EasySWT.addSelectionListener((Button)next, arg_0 -> SimpleImageDescriberDialog.open$lambda$7(this, arg_0));
        Button cancel = new Button((Composite)nav2, 8);
        cancel.setText("Close");
        cancel.setLayoutData((Object)new GridData(4, 4, true, false));
        EasySWT.addSelectionListener((Button)cancel, arg_0 -> SimpleImageDescriberDialog.open$lambda$8(this, arg_0));
        sc.setContent((Control)innerContainer);
        Shell shell9 = this.shell;
        if (shell9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell9 = null;
        }
        EasySWT.INSTANCE.addEscapeCloseListener(shell9);
        Shell shell10 = this.shell;
        if (shell10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell10 = null;
        }
        shell10.addShellListener(new ShellListener(this){
            final /* synthetic */ SimpleImageDescriberDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void shellActivated(ShellEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void shellClosed(ShellEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.doit = false;
                SimpleImageDescriberDialog.access$saveLocation(this.this$0);
                e.doit = true;
            }

            public void shellDeactivated(ShellEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void shellDeiconified(ShellEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void shellIconified(ShellEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        Shell shell11 = this.shell;
        if (shell11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell11 = null;
        }
        EasySWT.INSTANCE.addKeyListener(shell11, 262144, 110, arg_0 -> SimpleImageDescriberDialog.open$lambda$9(this, arg_0));
        Shell shell12 = this.shell;
        if (shell12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell12 = null;
        }
        EasySWT.INSTANCE.addKeyListener(shell12, 262144, 112, arg_0 -> SimpleImageDescriberDialog.open$lambda$10(this, arg_0));
        SizeAndLocation pl = previousLocation;
        if (pl == null) {
            Shell shell13 = this.shell;
            if (shell13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
                shell13 = null;
            }
            EasySWT.INSTANCE.setSizeAndLocationWideScreen(shell13);
        } else {
            Shell shell14 = this.shell;
            if (shell14 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
                shell14 = null;
            }
            EasySWT.INSTANCE.setSizeAndLocation(shell14, pl);
        }
        if ((shell = this.shell) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        shell.layout();
        Shell shell15 = this.shell;
        if (shell15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell15 = null;
        }
        shell15.open();
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            Utils.INSTANCE.adjustFontToDialog(this.m, styledText);
            Shell shell16 = this.shell;
            if (shell16 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
                shell16 = null;
            }
            Control control = (Control)shell16;
            StyledText styledText2 = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText2);
            EasySWT.INSTANCE.addResizeListener(control, styledText2, SimpleImageDescriberDialog::open$lambda$11);
        } else {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            Utils.INSTANCE.adjustFontToDialog(this.m, bBStyleableText.text);
            Shell shell17 = this.shell;
            if (shell17 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
                shell17 = null;
            }
            Control control = (Control)shell17;
            BBStyleableText bBStyleableText2 = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText2);
            EasySWT.INSTANCE.addResizeListener(control, bBStyleableText2.text, SimpleImageDescriberDialog::open$lambda$12);
        }
    }

    private final void saveLocation() {
        Shell shell = this.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        int n = shell.getSize().x;
        Shell shell2 = this.shell;
        if (shell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell2 = null;
        }
        int n2 = shell2.getSize().y;
        Shell shell3 = this.shell;
        if (shell3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell3 = null;
        }
        int n3 = shell3.getLocation().x;
        Shell shell4 = this.shell;
        if (shell4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell4 = null;
        }
        previousLocation = new SizeAndLocation(n, n2, n3, shell4.getLocation().y);
    }

    private final void addSizeMenu(Shell dialog, Menu menuBar) {
        MenuItem cascadeFileMenu = new MenuItem(menuBar, 64);
        cascadeFileMenu.setText("Image Size");
        Menu fileMenu = new Menu((Decorations)dialog, 4);
        cascadeFileMenu.setMenu(fileMenu);
        int currentSelection = defaultSize;
        MenuItem two = new MenuItem(fileMenu, 32);
        two.setText("200");
        String string = two.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        two.setSelection(currentSelection == Integer.parseInt(string));
        dialog.setMenuBar(menuBar);
        two.addListener(13, arg_0 -> SimpleImageDescriberDialog.addSizeMenu$lambda$0(two, dialog, this, arg_0));
        MenuItem three = new MenuItem(fileMenu, 32);
        three.setText("300");
        String string2 = three.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        three.setSelection(currentSelection == Integer.parseInt(string2));
        dialog.setMenuBar(menuBar);
        three.addListener(13, arg_0 -> SimpleImageDescriberDialog.addSizeMenu$lambda$1(three, dialog, this, arg_0));
        MenuItem four = new MenuItem(fileMenu, 32);
        four.setText("400");
        String string3 = four.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        four.setSelection(currentSelection == Integer.parseInt(string3));
        dialog.setMenuBar(menuBar);
        four.addListener(13, arg_0 -> SimpleImageDescriberDialog.addSizeMenu$lambda$2(four, dialog, this, arg_0));
        MenuItem five = new MenuItem(fileMenu, 32);
        five.setText("500");
        String string4 = five.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        five.setSelection(currentSelection == Integer.parseInt(string4));
        dialog.setMenuBar(menuBar);
        five.addListener(13, arg_0 -> SimpleImageDescriberDialog.addSizeMenu$lambda$3(five, dialog, this, arg_0));
    }

    private final void addPreferencesMenu(Shell dialog, Menu menuBar) {
        MenuItem cascadeFileMenu = new MenuItem(menuBar, 64);
        cascadeFileMenu.setText("Input Preference");
        Menu fileMenu = new Menu((Decorations)dialog, 4);
        cascadeFileMenu.setMenu(fileMenu);
        MenuItem sixKey = new MenuItem(fileMenu, 16);
        sixKey.setText("Six Key");
        sixKey.setSelection(braille);
        dialog.setMenuBar(menuBar);
        MenuItem styledText = new MenuItem(fileMenu, 16);
        styledText.setText("Styled Text");
        styledText.setSelection(!braille);
        dialog.setMenuBar(menuBar);
        sixKey.addListener(13, arg_0 -> SimpleImageDescriberDialog.addPreferencesMenu$lambda$0(this, styledText, sixKey, dialog, arg_0));
        styledText.addListener(13, arg_0 -> SimpleImageDescriberDialog.addPreferencesMenu$lambda$1(this, styledText, sixKey, dialog, arg_0));
    }

    private final void clickPrevious(Shell shell) {
        if (this.index > 0) {
            boolean bl;
            block5: {
                int n = this.index;
                this.index = n + -1;
                Document document = this.m.getDoc();
                Node node = this.array.get(this.index);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                this.matchingImages = ImageUtils.matchingImages(document, this.getSrc((Element)node));
                Iterable $this$any$iv = this.matchingImages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Element node2 = (Element)element$iv;
                        boolean bl2 = false;
                        if (!BBX.CONTAINER.IMAGE.isA((Node)node2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            captionEnabled = bl;
            this.saveLocation();
            shell.close();
            this.open();
        } else {
            Notify.notify$default(Notify.INSTANCE, "You have reached the beginning of the images", "No more images", false, 4, null);
        }
    }

    private final void clickNext(Shell shell) {
        if (this.index < this.array.size() - 1) {
            boolean bl;
            block5: {
                int n = this.index;
                this.index = n + 1;
                Document document = this.m.getDoc();
                Node node = this.array.get(this.index);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                this.matchingImages = ImageUtils.matchingImages(document, this.getSrc((Element)node));
                Iterable $this$any$iv = this.matchingImages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Element node2 = (Element)element$iv;
                        boolean bl2 = false;
                        if (!BBX.CONTAINER.IMAGE.isA((Node)node2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            captionEnabled = bl;
            this.saveLocation();
            shell.close();
            this.open();
        } else {
            Notify.notify$default(Notify.INSTANCE, "You have reached the end of the images", "No more images", false, 4, null);
        }
    }

    private final String getSrc(Element element) {
        Object t = BBX.SPAN.IMAGE.ATTRIB_SOURCE.get(element);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (String)t;
    }

    private final Element removeBraille(Element image) {
        block0: {
            Node oldText;
            Node node = oldText = Companion.alreadyHasBrailleElement(image);
            if (node == null) break block0;
            node.detach();
        }
        return image;
    }

    private final void addBraillePane(Group inputPane) {
        StyledText styledText = this.brailleWidget = new StyledText((Composite)inputPane, 320);
        Intrinsics.checkNotNull((Object)styledText);
        styledText.setLayoutData((Object)new GridData(4, 4, true, true));
        Node node = this.array.get(this.index);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Node brailleString = Companion.alreadyHasBrailleElement((Element)node);
        if (brailleString != null) {
            StyledText styledText2 = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText2);
            styledText2.setText(SixKeyUtils.INSTANCE.formatPreviousImageDescription(brailleString));
        }
        SixKeyHandler skh = new SixKeyHandler(null, null, true);
        StyledText styledText3 = this.brailleWidget;
        Intrinsics.checkNotNull((Object)styledText3);
        styledText3.addKeyListener((KeyListener)skh);
        StyledText styledText4 = this.brailleWidget;
        Intrinsics.checkNotNull((Object)styledText4);
        styledText4.addVerifyKeyListener((VerifyKeyListener)skh);
        StyledText styledText5 = this.brailleWidget;
        Intrinsics.checkNotNull((Object)styledText5);
        styledText5.setFont(FontManager.LoadedFont.newFont$default(FontManager.Companion.getBRAILLE_FONTS().get(0), 0, 1, null));
    }

    private final void addStyledTextPane(Shell shell, Group inputPane, Path imgSrc, Element imgElem) {
        inputPane.setLayout((Layout)new GridLayout(1, false));
        EasySWT.INSTANCE.setGridData((Control)inputPane);
        Group actions = new Group((Composite)inputPane, 0);
        actions.setLayout((Layout)new GridLayout(3, false));
        actions.setLayoutData((Object)new GridData(4, 4, true, false));
        this.descTextEditor = new BBStyleableText((Composite)inputPane, (Composite)actions, 33934, 2562);
        int n = actions.getChildren().length;
        for (int i = 0; i < n; ++i) {
            actions.getChildren()[i].setData((Object)new GridData(4, 4, true, false));
        }
        BBStyleableText bBStyleableText = this.descTextEditor;
        Intrinsics.checkNotNull((Object)bBStyleableText);
        EasySWT.INSTANCE.setGridDataVertical((Control)bBStyleableText.text);
        Button captionStyle = new Button((Composite)inputPane, 32);
        captionStyle.setText(CAPTION_STYLE_BOX);
        if (!captionEnabled) {
            captionStyle.setEnabled(false);
        }
        EasySWT.addSelectionListener((Button)captionStyle, arg_0 -> SimpleImageDescriberDialog.addStyledTextPane$lambda$0(this, arg_0));
        Element parentImgGroup = XMLHandler.Companion.ancestorVisitorElement((Node)imgElem, SimpleImageDescriberDialog::addStyledTextPane$lambda$1);
        if (parentImgGroup != null) {
            ImageUtils.willReplaceWarning(shell);
        }
        if (imgElem.getChildCount() > 0) {
            BBStyleableText bBStyleableText2 = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText2);
            bBStyleableText2.setXML(imgElem);
        }
    }

    private final void close() {
        this.saveLocation();
        Shell shell = this.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        shell.close();
    }

    private final void clickApplySingleInline(Element imgElem) {
        Element element;
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (!braille) {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (braille) {
            Node node = this.array.get(this.index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.removeBraille((Element)node);
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Element element2 = SixKeyUtils.INSTANCE.saveBraille(true, this.m, string, true);
            Node node2 = this.array.get(this.index);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = this.insertIntoImageTag(element2, true, (Element)node2);
        } else {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                Notify.showMessage("Description is empty", new Object[0]);
                return;
            }
            BBStyleableText bBStyleableText2 = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText2);
            Element newDescElement = ImageUtils.getElementFromInputDescription(bBStyleableText2);
            element = ImageUtils.setImageDescription(imgElem, newDescElement, this.wantsCaptionStyle);
        }
        Element imgWrapper = element;
        this.postClick(CollectionsKt.listOf((Object)imgWrapper));
        this.open();
    }

    private final void clickApplySingleBlock(Element imgElem) {
        Element element;
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (!braille) {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (braille) {
            Node node = this.array.get(this.index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            this.removeBraille((Element)node);
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Element element2 = SixKeyUtils.INSTANCE.saveBraille(false, this.m, string, true);
            Node node2 = this.array.get(this.index);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = this.insertIntoImageTag(element2, false, (Element)node2);
        } else {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                Notify.showMessage("Description is empty", new Object[0]);
                return;
            }
            BBStyleableText bBStyleableText2 = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText2);
            Element newDescElement = ImageUtils.getElementFromInputDescription(bBStyleableText2);
            element = ImageUtils.setImageDescription(imgElem, newDescElement, this.wantsCaptionStyle);
        }
        Element imgWrapper = element;
        this.postClick(CollectionsKt.listOf((Object)imgWrapper));
        this.open();
    }

    private final void clickApplyAllInline(List<? extends Element> imgElements) {
        List changedImgGroups = new ArrayList();
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (!braille) {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (braille) {
            for (Element element : this.matchingImages) {
                this.removeBraille(element);
                StyledText styledText = this.brailleWidget;
                Intrinsics.checkNotNull((Object)styledText);
                String string = styledText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                changedImgGroups.add(this.insertIntoImageTag(SixKeyUtils.INSTANCE.saveBraille(true, this.m, string, true), true, element));
            }
        } else {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                Notify.showMessage("Description is empty", new Object[0]);
                return;
            }
            BBStyleableText bBStyleableText2 = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText2);
            Element newDescElement = ImageUtils.getElementFromInputDescription(bBStyleableText2);
            if (!BBIni.getDebugging() && !YesNoChoice.Companion.ask("Replace description on " + imgElements.size() + " images?")) {
                return;
            }
            Iterator<? extends Element> iterator = imgElements.iterator();
            while (iterator.hasNext()) {
                Element curElem;
                Element element = curElem = iterator.next();
                Intrinsics.checkNotNull((Object)element);
                Element newImgGroup = ImageUtils.setImageDescription(element, newDescElement, this.wantsCaptionStyle);
                changedImgGroups.add(newImgGroup);
            }
        }
        this.postClick(changedImgGroups);
        this.open();
    }

    private final void clickApplyAllBlock(List<? extends Element> imgElements) {
        List changedImgGroups = new ArrayList();
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (!braille) {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (braille) {
            for (Element element : this.matchingImages) {
                this.removeBraille(element);
                StyledText styledText = this.brailleWidget;
                Intrinsics.checkNotNull((Object)styledText);
                String string = styledText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                changedImgGroups.add(this.insertIntoImageTag(SixKeyUtils.INSTANCE.saveBraille(false, this.m, string, true), false, element));
            }
        } else {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                Notify.showMessage("Description is empty", new Object[0]);
                return;
            }
            BBStyleableText bBStyleableText2 = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText2);
            Element newDescElement = ImageUtils.getElementFromInputDescription(bBStyleableText2);
            if (!BBIni.getDebugging() && !YesNoChoice.Companion.ask("Replace description on " + imgElements.size() + " images?")) {
                return;
            }
            Iterator<? extends Element> iterator = imgElements.iterator();
            while (iterator.hasNext()) {
                Element curElem;
                Element element = curElem = iterator.next();
                Intrinsics.checkNotNull((Object)element);
                Element newImgGroup = ImageUtils.setImageDescription(element, newDescElement, this.wantsCaptionStyle);
                changedImgGroups.add(newImgGroup);
            }
        }
        this.postClick(changedImgGroups);
        this.open();
    }

    private final Element insertIntoImageTag(Element ele, boolean inline, Element image) {
        if (inline && !BBX.CONTAINER.IMAGE.isA((Node)image)) {
            Utils.insertChildCountSafe((ParentNode)image, (Node)ele, 0);
        } else {
            Element bodyText = BBX.BLOCK.DEFAULT.create();
            Utils.insertChildCountSafe((ParentNode)image, (Node)bodyText, 0);
            bodyText.appendChild((Node)ele);
            Intrinsics.checkNotNull((Object)bodyText);
            StyleHandler.Companion.addStyle(bodyText, "1-1", this.m);
        }
        return image;
    }

    private final void clickDeleteAll(List<? extends Element> imgElements) {
        List changedImgGroups = new ArrayList();
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (!braille) {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        for (Element element : this.matchingImages) {
            changedImgGroups.add(this.removeBraille(element));
        }
        this.postClick(changedImgGroups);
        this.open();
    }

    private final void clickDeleteSingle(Element imgElem) {
        if (braille) {
            StyledText styledText = this.brailleWidget;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        if (!braille) {
            BBStyleableText bBStyleableText = this.descTextEditor;
            Intrinsics.checkNotNull((Object)bBStyleableText);
            String string = bBStyleableText.text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        Node node = this.array.get(this.index);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element imgWrapper = this.removeBraille((Element)node);
        this.postClick(CollectionsKt.listOf((Object)imgWrapper));
        this.open();
    }

    private final void postClick(List<? extends Element> modifiedElements) {
        this.onFinishedImgGroup.accept(modifiedElements);
        this.saveLocation();
        Shell shell = this.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        shell.close();
    }

    private static final void open$lambda$0(SimpleImageDescriberDialog this$0, Element $selectedImage, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickApplySingleInline($selectedImage);
    }

    private static final void open$lambda$1(SimpleImageDescriberDialog this$0, Element $selectedImage, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickApplySingleBlock($selectedImage);
    }

    private static final void open$lambda$2(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickApplyAllInline(this$0.matchingImages);
    }

    private static final void open$lambda$3(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickApplyAllBlock(this$0.matchingImages);
    }

    private static final void open$lambda$4(SimpleImageDescriberDialog this$0, Element $selectedImage, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickDeleteSingle($selectedImage);
    }

    private static final void open$lambda$5(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickDeleteAll(this$0.matchingImages);
    }

    private static final void open$lambda$6(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Shell shell = this$0.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        this$0.clickPrevious(shell);
    }

    private static final void open$lambda$7(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Shell shell = this$0.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        this$0.clickNext(shell);
    }

    private static final void open$lambda$8(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.close();
    }

    private static final void open$lambda$9(SimpleImageDescriberDialog this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Shell shell = this$0.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        this$0.clickNext(shell);
    }

    private static final void open$lambda$10(SimpleImageDescriberDialog this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Shell shell = this$0.shell;
        if (shell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
            shell = null;
        }
        this$0.clickPrevious(shell);
    }

    private static final void open$lambda$11(StyledText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Utils.INSTANCE.adjustFontToDialog(WPManager.Companion.getInstance().getController(), it);
    }

    private static final void open$lambda$12(StyledText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Utils.INSTANCE.adjustFontToDialog(WPManager.Companion.getInstance().getController(), it);
    }

    private static final void addSizeMenu$lambda$0(MenuItem $two, Shell $dialog, SimpleImageDescriberDialog this$0, Event it) {
        String string = $two.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        defaultSize = Integer.parseInt(string);
        previousLocation = null;
        $dialog.close();
        this$0.open();
    }

    private static final void addSizeMenu$lambda$1(MenuItem $three, Shell $dialog, SimpleImageDescriberDialog this$0, Event it) {
        String string = $three.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        defaultSize = Integer.parseInt(string);
        previousLocation = null;
        $dialog.close();
        this$0.open();
    }

    private static final void addSizeMenu$lambda$2(MenuItem $four, Shell $dialog, SimpleImageDescriberDialog this$0, Event it) {
        String string = $four.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        defaultSize = Integer.parseInt(string);
        previousLocation = null;
        $dialog.close();
        this$0.open();
    }

    private static final void addSizeMenu$lambda$3(MenuItem $five, Shell $dialog, SimpleImageDescriberDialog this$0, Event it) {
        String string = $five.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        defaultSize = Integer.parseInt(string);
        previousLocation = null;
        $dialog.close();
        this$0.open();
    }

    private static final void addPreferencesMenu$lambda$0(SimpleImageDescriberDialog this$0, MenuItem $styledText, MenuItem $sixKey, Shell $dialog, Event event) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (braille) break block2;
                if (BBIni.getDebugging()) break block3;
                BBStyleableText bBStyleableText = this$0.descTextEditor;
                Intrinsics.checkNotNull((Object)bBStyleableText);
                String string = bBStyleableText.text.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!(((CharSequence)string).length() > 0) || YesNoChoice.Companion.ask("Delete entered text and switch to Six Key?")) break block3;
            }
            event.doit = false;
            $styledText.setSelection(false);
            $sixKey.setSelection(true);
            return;
        }
        braille = true;
        this$0.saveLocation();
        $dialog.close();
        this$0.open();
    }

    private static final void addPreferencesMenu$lambda$1(SimpleImageDescriberDialog this$0, MenuItem $styledText, MenuItem $sixKey, Shell $dialog, Event event) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!braille) break block2;
                if (BBIni.getDebugging()) break block3;
                StyledText styledText = this$0.brailleWidget;
                Intrinsics.checkNotNull((Object)styledText);
                String string = styledText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!(((CharSequence)string).length() > 0) || YesNoChoice.Companion.ask("Delete entered text and switch to Styled Text?")) break block3;
            }
            event.doit = false;
            $styledText.setSelection(true);
            $sixKey.setSelection(false);
            return;
        }
        braille = false;
        this$0.saveLocation();
        $dialog.close();
        this$0.open();
    }

    private static final void addStyledTextPane$lambda$0(SimpleImageDescriberDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.wantsCaptionStyle = !this$0.wantsCaptionStyle;
    }

    private static final boolean addStyledTextPane$lambda$1(Element node) {
        return BBX.CONTAINER.IMAGE.isA((Node)node);
    }

    @JvmStatic
    @NotNull
    public static final String makeAllString(boolean block, @NotNull String number) {
        return Companion.makeAllString(block, number);
    }

    public static final /* synthetic */ void access$saveLocation(SimpleImageDescriberDialog $this) {
        $this.saveLocation();
    }

    static {
        braille = true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\bH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/brailleblaster/easierxml/SimpleImageDescriberDialog$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SWTBOT_APPLY_ALL_INLINE", "", "SWTBOT_APPLY_ALL_BLOCK", "SWTBOT_INFO_COMPOSITE", "INLINE_ONE", "BLOCK_ONE", "INLINE_ALL_P1", "BLOCK_ALL_P1", "INLINE_ALL_P2", "BLOCK_ALL_P2", "CAPTION_STYLE_BOX", "defaultSize", "", "getDefaultSize", "()I", "setDefaultSize", "(I)V", "captionEnabled", "", "braille", "previousLocation", "Lorg/brailleblaster/utils/swt/SizeAndLocation;", "alreadyHasBrailleElement", "Lnu/xom/Node;", "image", "Lnu/xom/Element;", "makeAllString", "block", "number", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDefaultSize() {
            return defaultSize;
        }

        public final void setDefaultSize(int n) {
            defaultSize = n;
        }

        @Nullable
        public final Node alreadyHasBrailleElement(@NotNull Element image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return (Node)XMLHandler.Companion.childrenRecursiveVisitor(image, Companion::alreadyHasBrailleElement$lambda$0);
        }

        @JvmStatic
        @NotNull
        public final String makeAllString(boolean block, @NotNull String number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return block ? "Apply to All " + number + SimpleImageDescriberDialog.BLOCK_ALL_P2 : "Apply to All " + number + SimpleImageDescriberDialog.INLINE_ALL_P2;
        }

        private static final boolean alreadyHasBrailleElement$lambda$0(Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.INLINE.EMPHASIS.isA((Node)e) && ((EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get(e)).contains(EmphasisType.NO_TRANSLATE) && XMLHandler.Companion.findFirstText(e) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

