/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.embossers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.brailleblaster.embossers.EmbosserConfig;
import org.brailleblaster.embossers.EmbosserConfigList;
import org.brailleblaster.embossers.EmbosserEditDialog;
import org.brailleblaster.embossers.EmbossingUtils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.ButtonBuilder;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.TextBuilder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 22\u00020\u0001:\u00012B'\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u0003H\u0014J\b\u0010/\u001a\u00020'H\u0016J\b\u00100\u001a\u00020'H\u0014J\u0010\u00101\u001a\u00020\"2\b\u0010*\u001a\u0004\u0018\u00010\u0003R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0015R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010#\"\u0004\b$\u0010%\u00a8\u00063"}, d2={"Lorg/brailleblaster/embossers/EmbossDialog;", "Lorg/eclipse/jface/dialogs/Dialog;", "parentShell", "Lorg/eclipse/swt/widgets/Shell;", "openSettings", "Ljava/util/function/Consumer;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Ljava/util/function/Consumer;)V", "embosserList", "Lorg/brailleblaster/embossers/EmbosserConfigList;", "embosser", "Lorg/brailleblaster/embossers/EmbosserConfig;", "getEmbosser", "()Lorg/brailleblaster/embossers/EmbosserConfig;", "setEmbosser", "(Lorg/brailleblaster/embossers/EmbosserConfig;)V", "cbPrinter", "Lorg/eclipse/swt/widgets/Combo;", "copies", "", "getCopies", "()I", "setCopies", "(I)V", "startPage", "getStartPage", "setStartPage", "endPage", "getEndPage", "setEndPage", "value", "scope", "getScope", "isCreateDebugFile", "", "()Z", "setCreateDebugFile", "(Z)V", "loadEmbosserList", "", "createDialogArea", "Lorg/eclipse/swt/widgets/Control;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "updateEmbosserCombo", "configureShell", "newShell", "create", "okPressed", "ensureEmbossersAvailable", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nEmbossDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbossDialog.kt\norg/brailleblaster/embossers/EmbossDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n777#2:234\n873#2,2:235\n1915#2,2:237\n296#2,2:239\n1#3:241\n*S KotlinDebug\n*F\n+ 1 EmbossDialog.kt\norg/brailleblaster/embossers/EmbossDialog\n*L\n162#1:234\n162#1:235,2\n162#1:237,2\n64#1:239,2\n*E\n"})
public final class EmbossDialog
extends Dialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Consumer<Shell> openSettings;
    @Nullable
    private EmbosserConfigList embosserList;
    @Nullable
    private EmbosserConfig embosser;
    @Nullable
    private Combo cbPrinter;
    private int copies;
    private int startPage;
    private int endPage;
    private int scope;
    private boolean isCreateDebugFile;
    private static final Logger logger = LoggerFactory.getLogger(EmbossDialog.class);

    @JvmOverloads
    public EmbossDialog(@Nullable Shell parentShell, @Nullable Consumer<Shell> openSettings) {
        super(parentShell);
        this.openSettings = openSettings;
        this.copies = 1;
        this.startPage = 1;
        this.endPage = 1;
        this.loadEmbosserList();
    }

    public /* synthetic */ EmbossDialog(Shell shell, Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            shell = Display.getCurrent().getActiveShell();
        }
        if ((n & 2) != 0) {
            consumer = null;
        }
        this(shell, consumer);
    }

    @Nullable
    public final EmbosserConfig getEmbosser() {
        return this.embosser;
    }

    public final void setEmbosser(@Nullable EmbosserConfig embosserConfig) {
        this.embosser = embosserConfig;
    }

    public final int getCopies() {
        return this.copies;
    }

    public final void setCopies(int n) {
        this.copies = n;
    }

    public final int getStartPage() {
        return this.startPage;
    }

    public final void setStartPage(int n) {
        this.startPage = n;
    }

    public final int getEndPage() {
        return this.endPage;
    }

    public final void setEndPage(int n) {
        this.endPage = n;
    }

    public final int getScope() {
        return this.scope;
    }

    public final boolean isCreateDebugFile() {
        return this.isCreateDebugFile;
    }

    public final void setCreateDebugFile(boolean bl) {
        this.isCreateDebugFile = bl;
    }

    private final void loadEmbosserList() {
        EmbosserConfigList embosserConfigList = this.embosserList = EmbosserConfigList.Companion.loadEmbossers$default(EmbosserConfigList.Companion, EmbossingUtils.INSTANCE.getEmbossersFile(), null, 2, null);
        Intrinsics.checkNotNull((Object)embosserConfigList);
        if (!embosserConfigList.isEmpty()) {
            EmbosserConfigList embosserConfigList2 = this.embosserList;
            Intrinsics.checkNotNull((Object)embosserConfigList2);
            this.embosser = embosserConfigList2.getPreferredEmbosser();
        }
    }

    @NotNull
    protected Control createDialogArea(@NotNull Composite parent) {
        Combo cbPrinter;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Control control = super.createDialogArea(parent);
        Intrinsics.checkNotNull((Object)control, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.Composite");
        Composite area = (Composite)control;
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        EasySWT.INSTANCE.addLabel(container, LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.embosser"));
        this.cbPrinter = cbPrinter = (Combo)EasySWT.makeComboDropdown((Composite)container).get();
        this.updateEmbosserCombo();
        EasySWT.INSTANCE.addSelectionListener(cbPrinter, arg_0 -> EmbossDialog.createDialogArea$lambda$0(cbPrinter, this, arg_0));
        EasySWT.INSTANCE.addLabel(container, "");
        ShellAdapter activationListener2 = new ShellAdapter(cbPrinter, this){
            final /* synthetic */ Combo $cbPrinter;
            final /* synthetic */ EmbossDialog this$0;
            {
                this.$cbPrinter = $cbPrinter;
                this.this$0 = $receiver;
            }

            public void shellActivated(ShellEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$cbPrinter.removeAll();
                EmbossDialog.access$loadEmbosserList(this.this$0);
                EmbossDialog.access$updateEmbosserCombo(this.this$0);
                this.this$0.getShell().removeShellListener((ShellListener)this);
            }
        };
        Button btnManageEmbossers = new Button(container, 8);
        btnManageEmbossers.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.manageEmbossers"));
        if (this.openSettings == null) {
            btnManageEmbossers.setEnabled(false);
        } else {
            btnManageEmbossers.addSelectionListener((SelectionListener)new SelectionAdapter(this, activationListener2){
                final /* synthetic */ EmbossDialog this$0;
                final /* synthetic */ ShellAdapter $activationListener;
                {
                    this.this$0 = $receiver;
                    this.$activationListener = $activationListener;
                }

                public void widgetSelected(SelectionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.getShell().addShellListener((ShellListener)this.$activationListener);
                    EmbossDialog.access$getOpenSettings$p(this.this$0).accept(this.this$0.getShell());
                }
            });
        }
        Button chkEmbossFile = (Button)((ButtonBuilder)EasySWT.INSTANCE.makeCheckbox(container).gridDataHorizontalSpan(2)).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.createDebugFile")).selected(false).get();
        EasySWT.addSelectionListener((Button)chkEmbossFile, arg_0 -> EmbossDialog.createDialogArea$lambda$1(this, chkEmbossFile, arg_0));
        Group grpPageRange = new Group(container, 0);
        grpPageRange.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.pageRange"));
        grpPageRange.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        grpPageRange.setLayout((Layout)new GridLayout(2, false));
        Button rbAllPages = new Button((Composite)grpPageRange, 16);
        rbAllPages.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.allPages"));
        EasySWT.INSTANCE.makeLabel((Composite)grpPageRange);
        Button rbPageRange = new Button((Composite)grpPageRange, 16);
        rbPageRange.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.pages"));
        Composite cmpPages = new Composite((Composite)grpPageRange, 0);
        cmpPages.setLayout((Layout)new RowLayout());
        EasySWT.INSTANCE.makeLabel(cmpPages).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.pagesFrom"));
        Text txtPagesFrom = (Text)((TextBuilder)EasySWT.makeTextBuilder$default((EasySWT)EasySWT.INSTANCE, (Composite)cmpPages, (int)0, (int)2, null).text(String.valueOf(this.startPage)).onModify(arg_0 -> EmbossDialog.createDialogArea$lambda$2(this, arg_0)).rowDataWidth(this.convertWidthInCharsToPixels(5))).get();
        EasySWT.INSTANCE.addIntegerFilter(txtPagesFrom);
        EasySWT.INSTANCE.makeLabel(cmpPages).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.pagesTo"));
        Text txtPagesTo = (Text)((TextBuilder)EasySWT.makeTextBuilder$default((EasySWT)EasySWT.INSTANCE, (Composite)cmpPages, (int)0, (int)2, null).text(String.valueOf(this.endPage)).onModify(arg_0 -> EmbossDialog.createDialogArea$lambda$3(this, arg_0)).rowDataWidth(this.convertWidthInCharsToPixels(5))).get();
        EasySWT.INSTANCE.addIntegerFilter(txtPagesTo);
        EasySWT.addSelectionListener((Button)rbAllPages, arg_0 -> EmbossDialog.createDialogArea$lambda$4(this, txtPagesFrom, txtPagesTo, arg_0));
        EasySWT.addSelectionListener((Button)rbPageRange, arg_0 -> EmbossDialog.createDialogArea$lambda$5(this, txtPagesFrom, txtPagesTo, arg_0));
        rbAllPages.setSelection(true);
        Group grpCopies = new Group(container, 0);
        grpCopies.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.copies"));
        grpCopies.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        grpCopies.setLayout((Layout)new GridLayout(2, false));
        Label lblCopies = EasySWT.INSTANCE.addLabel((Composite)grpCopies, LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.numOfCopies"));
        Spinner spCopies = new Spinner((Composite)grpCopies, 0);
        spCopies.setMinimum(1);
        spCopies.setMaximum(99);
        EasySWT.INSTANCE.addSelectionListener(spCopies, arg_0 -> EmbossDialog.createDialogArea$lambda$6(this, arg_0));
        spCopies.setSelection(this.copies);
        Accessible accLabel = lblCopies.getAccessible();
        Accessible accCtrl = spCopies.getAccessible();
        accLabel.addRelation(8, accCtrl);
        accCtrl.addRelation(9, accLabel);
        return (Control)area;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEmbosserCombo() {
        void $this$filterTo$iv$iv;
        EmbosserConfigList embosserConfigList = this.embosserList;
        Intrinsics.checkNotNull((Object)embosserConfigList);
        Iterable $this$filter$iv = embosserConfigList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EmbosserConfig p0 = (EmbosserConfig)element$iv$iv;
            boolean bl = false;
            if (!p0.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EmbosserConfig e = (EmbosserConfig)element$iv;
            boolean bl = false;
            Combo combo = this.cbPrinter;
            Intrinsics.checkNotNull((Object)combo);
            combo.add(e.getName());
        }
        int defaultIndex = 0;
        if (this.embosser != null) {
            Combo combo = this.cbPrinter;
            Intrinsics.checkNotNull((Object)combo);
            EmbosserConfig embosserConfig = this.embosser;
            Intrinsics.checkNotNull((Object)embosserConfig);
            defaultIndex = combo.indexOf(embosserConfig.getName());
            defaultIndex = RangesKt.coerceAtLeast((int)defaultIndex, (int)0);
        }
        Combo combo = this.cbPrinter;
        Intrinsics.checkNotNull((Object)combo);
        combo.select(defaultIndex);
    }

    protected void configureShell(@NotNull Shell newShell) {
        Intrinsics.checkNotNullParameter((Object)newShell, (String)"newShell");
        super.configureShell(newShell);
        newShell.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossDialog.title"));
    }

    public void create() {
        super.create();
        EmbosserConfigList embosserConfigList = this.embosserList;
        Intrinsics.checkNotNull((Object)embosserConfigList);
        if (embosserConfigList.isEmpty()) {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        EmbosserConfigList embosserConfigList = this.embosserList;
        Intrinsics.checkNotNull((Object)embosserConfigList);
        EmbosserConfig embosserConfig = this.embosser;
        Intrinsics.checkNotNull((Object)embosserConfig);
        embosserConfigList.setLastUsedEmbosser(embosserConfig);
        try {
            EmbosserConfigList embosserConfigList2 = this.embosserList;
            Intrinsics.checkNotNull((Object)embosserConfigList2);
            embosserConfigList2.saveEmbossers(EmbossingUtils.INSTANCE.getEmbossersFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    public final boolean ensureEmbossersAvailable(@Nullable Shell parent) {
        EmbosserConfigList embosserList;
        EmbosserConfigList embosserConfigList = embosserList = this.embosserList;
        Intrinsics.checkNotNull((Object)embosserConfigList);
        if (embosserConfigList.isEmpty()) {
            boolean result = MessageDialog.openQuestion((Shell)parent, (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.noEmbosserTitle"), (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.noEmbosserMsg"));
            if (!result) {
                return false;
            }
            EmbosserEditDialog d = new EmbosserEditDialog(parent, SetsKt.emptySet());
            int res = d.open();
            if (res != 0) {
                return false;
            }
            EmbosserConfig de = d.getEmbosser();
            embosserList.add(de);
            this.embosser = de;
            try {
                embosserList.saveEmbossers();
            }
            catch (IOException iOException) {
                logger.error("Unable to save embossers file");
            }
        }
        return true;
    }

    @JvmOverloads
    public EmbossDialog(@Nullable Shell parentShell) {
        this(parentShell, null, 2, null);
    }

    @JvmOverloads
    public EmbossDialog() {
        this(null, null, 3, null);
    }

    private static final void createDialogArea$lambda$0(Combo $cbPrinter, EmbossDialog this$0, SelectionEvent it) {
        block2: {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String selEmbosser = $cbPrinter.getText();
                EmbosserConfigList embosserConfigList = this$0.embosserList;
                Intrinsics.checkNotNull((Object)embosserConfigList);
                Iterable $this$firstOrNull$iv = embosserConfigList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EmbosserConfig p = (EmbosserConfig)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)p.getName(), (Object)selEmbosser)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            EmbosserConfig embosserConfig = v1;
            if (embosserConfig == null) break block2;
            EmbosserConfig emb = embosserConfig;
            boolean bl = false;
            this$0.embosser = emb;
        }
    }

    private static final void createDialogArea$lambda$1(EmbossDialog this$0, Button $chkEmbossFile, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.isCreateDebugFile = $chkEmbossFile.getSelection();
    }

    private static final void createDialogArea$lambda$2(EmbossDialog this$0, ModifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Widget widget = e.widget;
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.Text");
        String string = ((Text)widget).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.startPage = Integer.parseInt(string);
    }

    private static final void createDialogArea$lambda$3(EmbossDialog this$0, ModifyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Widget widget = e.widget;
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.Text");
        String string = ((Text)widget).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.endPage = Integer.parseInt(string);
    }

    private static final void createDialogArea$lambda$4(EmbossDialog this$0, Text $txtPagesFrom, Text $txtPagesTo, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scope = 0;
        $txtPagesFrom.setEditable(false);
        $txtPagesTo.setEditable(false);
    }

    private static final void createDialogArea$lambda$5(EmbossDialog this$0, Text $txtPagesFrom, Text $txtPagesTo, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scope = 1;
        $txtPagesFrom.setEditable(true);
        $txtPagesTo.setEditable(true);
    }

    private static final void createDialogArea$lambda$6(EmbossDialog this$0, SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Widget widget = e.widget;
        Intrinsics.checkNotNull((Object)widget, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.Spinner");
        this$0.copies = ((Spinner)widget).getSelection();
    }

    public static final /* synthetic */ void access$loadEmbosserList(EmbossDialog $this) {
        $this.loadEmbosserList();
    }

    public static final /* synthetic */ void access$updateEmbosserCombo(EmbossDialog $this) {
        $this.updateEmbosserCombo();
    }

    public static final /* synthetic */ Consumer access$getOpenSettings$p(EmbossDialog $this) {
        return $this.openSettings;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/embossers/EmbossDialog$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

