/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.embossers;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.embossers.EmbosserConfig;
import org.brailleblaster.embossers.EmbosserOptionsView;
import org.brailleblaster.libembosser.EmbosserService;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.OptionIdentifier;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.ComboBuilder;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0014J\b\u0010#\u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020!H\u0002J\b\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020!H\u0002J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020!H\u0014J\b\u00102\u001a\u00020!H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/brailleblaster/embossers/EmbosserEditDialog;", "Lorg/eclipse/jface/dialogs/TitleAreaDialog;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "existingNames", "", "", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Ljava/util/Set;)V", "txtName", "Lorg/eclipse/swt/widgets/Text;", "cbEmbosserDevice", "Lorg/eclipse/swt/widgets/Combo;", "cbEmbosserManufacturer", "printerList", "", "Ljavax/print/PrintService;", "[Ljavax/print/PrintService;", "embosser", "Lorg/brailleblaster/embossers/EmbosserConfig;", "getEmbosser", "()Lorg/brailleblaster/embossers/EmbosserConfig;", "setEmbosser", "(Lorg/brailleblaster/embossers/EmbosserConfig;)V", "embosserMap", "", "", "Lorg/brailleblaster/libembosser/spi/Embosser;", "embosserDriver", "cbEmbosserModel", "embosserOptionsView", "Lorg/brailleblaster/embossers/EmbosserOptionsView;", "configureShell", "", "newShell", "create", "createDialogArea", "Lorg/eclipse/swt/widgets/Control;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "createGeneralSettingsComposite", "selectEmbossermanufacturer", "index", "", "updateEmbosserDriver", "updateFromEmbosser", "embosserManufacturerChanged", "validate", "", "okPressed", "saveInput", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nEmbosserEditDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbosserEditDialog.kt\norg/brailleblaster/embossers/EmbosserEditDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n296#2,2:239\n*S KotlinDebug\n*F\n+ 1 EmbosserEditDialog.kt\norg/brailleblaster/embossers/EmbosserEditDialog\n*L\n133#1:239,2\n*E\n"})
public final class EmbosserEditDialog
extends TitleAreaDialog {
    @NotNull
    private final Set<String> existingNames;
    private Text txtName;
    private Combo cbEmbosserDevice;
    private Combo cbEmbosserManufacturer;
    @NotNull
    private final PrintService[] printerList;
    @NotNull
    private EmbosserConfig embosser;
    @Nullable
    private Map<String, ? extends List<? extends Embosser>> embosserMap;
    @Nullable
    private Embosser embosserDriver;
    private Combo cbEmbosserModel;
    private EmbosserOptionsView embosserOptionsView;

    public EmbosserEditDialog(@Nullable Shell shell, @NotNull Set<String> existingNames) {
        Intrinsics.checkNotNullParameter(existingNames, (String)"existingNames");
        super(shell);
        this.existingNames = existingNames;
        this.embosser = new EmbosserConfig(null, null, 3, null);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
        Intrinsics.checkNotNullExpressionValue((Object)printServiceArray, (String)"lookupPrintServices(...)");
        this.printerList = printServiceArray;
    }

    @NotNull
    public final EmbosserConfig getEmbosser() {
        return this.embosser;
    }

    public final void setEmbosser(@NotNull EmbosserConfig embosserConfig) {
        Intrinsics.checkNotNullParameter((Object)embosserConfig, (String)"<set-?>");
        this.embosser = embosserConfig;
    }

    protected void configureShell(@NotNull Shell newShell) {
        Intrinsics.checkNotNullParameter((Object)newShell, (String)"newShell");
        super.configureShell(newShell);
        newShell.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.shellText"));
    }

    public void create() {
        super.create();
        this.setTitle(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.title"));
        this.setMessage(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.msg"), 1);
        this.validate();
    }

    @NotNull
    protected Control createDialogArea(@NotNull Composite parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Control control = super.createDialogArea(parent);
        Intrinsics.checkNotNull((Object)control, (String)"null cannot be cast to non-null type org.eclipse.swt.widgets.Composite");
        Composite area = (Composite)control;
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        TabFolder folder = new TabFolder(area, 2048);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.generalTabTitle"));
        generalTab.setControl(this.createGeneralSettingsComposite((Composite)folder));
        TabItem advancedTab = new TabItem(folder, 0);
        advancedTab.setText(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.advancedTabTitle"));
        this.embosserOptionsView = new EmbosserOptionsView((Composite)folder, 2816, MapsKt.emptyMap());
        EmbosserOptionsView embosserOptionsView = this.embosserOptionsView;
        if (embosserOptionsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"embosserOptionsView");
            embosserOptionsView = null;
        }
        embosserOptionsView.addValidateListener((Function1<? super Set<? extends OptionIdentifier>, Unit>)((Function1)arg_0 -> EmbosserEditDialog.createDialogArea$lambda$0(this, arg_0)));
        EmbosserOptionsView embosserOptionsView2 = this.embosserOptionsView;
        if (embosserOptionsView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"embosserOptionsView");
            embosserOptionsView2 = null;
        }
        advancedTab.setControl(embosserOptionsView2.getControl());
        this.updateFromEmbosser();
        return (Control)area;
    }

    private final Control createGeneralSettingsComposite(Composite parent) {
        Text txtName;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        EasySWT.INSTANCE.makeLabel(container).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.name"));
        this.txtName = txtName = (Text)EasySWT.makeTextBuilder$default((EasySWT)EasySWT.INSTANCE, (Composite)container, (int)0, (int)2, null).get();
        EasySWT.INSTANCE.makeLabel(container).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.device")).get();
        ComboBuilder cb = EasySWT.makeComboDropdown((Composite)container).add(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.selectPrinter"));
        for (PrintService pd : this.printerList) {
            cb = cb.add(pd.getName());
        }
        this.cbEmbosserDevice = (Combo)cb.get();
        EasySWT.INSTANCE.makeLabel(container).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.embosserManufacturer")).get();
        cb = EasySWT.makeComboDropdown((Composite)container).add(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.selectEmbosserManufacturer"));
        Map<String, List<Object>> embosserMap = EmbosserService.getInstance().getEmbosserStream().collect(Collectors.groupingBy(arg_0 -> EmbosserEditDialog.createGeneralSettingsComposite$lambda$1(EmbosserEditDialog::createGeneralSettingsComposite$lambda$0, arg_0)));
        this.embosserMap = embosserMap;
        for (String m : embosserMap.keySet()) {
            cb.add(m);
        }
        this.cbEmbosserManufacturer = (Combo)cb.get();
        EasySWT.INSTANCE.makeLabel(container).text(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.embosserModel"));
        this.cbEmbosserModel = (Combo)EasySWT.makeComboDropdown((Composite)container).get();
        txtName.addModifyListener(arg_0 -> EmbosserEditDialog.createGeneralSettingsComposite$lambda$2(this, arg_0));
        Combo combo = this.cbEmbosserDevice;
        if (combo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserDevice");
            combo = null;
        }
        EasySWT.INSTANCE.addSelectionListener(combo, arg_0 -> EmbosserEditDialog.createGeneralSettingsComposite$lambda$3(this, arg_0));
        Combo combo2 = this.cbEmbosserManufacturer;
        if (combo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
            combo2 = null;
        }
        EasySWT.INSTANCE.addSelectionListener(combo2, arg_0 -> EmbosserEditDialog.createGeneralSettingsComposite$lambda$4(this, arg_0));
        Combo combo3 = this.cbEmbosserModel;
        if (combo3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
            combo3 = null;
        }
        EasySWT.INSTANCE.addSelectionListener(combo3, arg_0 -> EmbosserEditDialog.createGeneralSettingsComposite$lambda$5(this, arg_0));
        return (Control)container;
    }

    private final void selectEmbossermanufacturer(int index) {
        Combo combo = this.cbEmbosserManufacturer;
        if (combo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
            combo = null;
        }
        combo.select(index);
        this.embosserManufacturerChanged();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEmbosserDriver() {
        int selIndex;
        Combo combo = this.cbEmbosserManufacturer;
        if (combo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
            combo = null;
        }
        if ((selIndex = combo.getSelectionIndex()) < 1) {
            this.embosser.setEmbosserDriver(null);
        } else {
            Object v7;
            block9: {
                void $this$firstOrNull$iv;
                Combo combo2 = this.cbEmbosserManufacturer;
                if (combo2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
                    combo2 = null;
                }
                String manufacturer = combo2.getItem(selIndex);
                Combo combo3 = this.cbEmbosserModel;
                if (combo3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                    combo3 = null;
                }
                selIndex = combo3.getSelectionIndex();
                Combo combo4 = this.cbEmbosserModel;
                if (combo4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                    combo4 = null;
                }
                String model = combo4.getItem(selIndex);
                Map<String, ? extends List<? extends Embosser>> map = this.embosserMap;
                Intrinsics.checkNotNull(map);
                List<? extends Embosser> list = map.get(manufacturer);
                Intrinsics.checkNotNull(list);
                Iterable iterable = list;
                EmbosserEditDialog embosserEditDialog = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Embosser e = (Embosser)element$iv;
                    boolean bl = false;
                    Embosser embosser = e;
                    Intrinsics.checkNotNull((Object)embosser);
                    if (!Intrinsics.areEqual((Object)embosser.getModel(), (Object)model)) continue;
                    v7 = element$iv;
                    break block9;
                }
                v7 = null;
            }
            embosserEditDialog.embosserDriver = v7;
            if (this.embosserDriver != null) {
                EmbosserOptionsView embosserOptionsView = this.embosserOptionsView;
                if (embosserOptionsView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"embosserOptionsView");
                    embosserOptionsView = null;
                }
                Embosser embosser = this.embosserDriver;
                Intrinsics.checkNotNull((Object)embosser);
                Map map = embosser.getOptions();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getOptions(...)");
                embosserOptionsView.setEmbosserOptions(map);
            }
        }
    }

    private final void updateFromEmbosser() {
        Combo combo;
        Text text = this.txtName;
        if (text == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"txtName");
            text = null;
        }
        text.setText(this.embosser.getName());
        int defaultIndex = 0;
        int n = this.printerList.length;
        for (int i = 0; i < n; ++i) {
            PrintService ps = this.printerList[i];
            if (!Intrinsics.areEqual((Object)ps.getName(), (Object)this.embosser.getPrinterName())) continue;
            defaultIndex = i + 1;
            break;
        }
        if ((combo = this.cbEmbosserDevice) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserDevice");
            combo = null;
        }
        combo.select(defaultIndex);
        defaultIndex = 0;
        Embosser ed = this.embosser.getEmbosserDriver();
        if (ed != null) {
            int i = 1;
            Combo combo2 = this.cbEmbosserManufacturer;
            if (combo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
                combo2 = null;
            }
            int n2 = combo2.getItemCount();
            while (i < n2) {
                Combo combo3 = this.cbEmbosserManufacturer;
                if (combo3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
                    combo3 = null;
                }
                if (Intrinsics.areEqual((Object)combo3.getItem(i), (Object)ed.getManufacturer())) {
                    defaultIndex = i;
                    break;
                }
                ++i;
            }
        }
        this.selectEmbossermanufacturer(defaultIndex);
        if (ed != null) {
            Combo combo4;
            Combo combo5 = this.cbEmbosserModel;
            if (combo5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                combo5 = null;
            }
            if ((combo4 = this.cbEmbosserModel) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                combo4 = null;
            }
            combo5.select(combo4.indexOf(ed.getModel()));
            EmbosserOptionsView embosserOptionsView = this.embosserOptionsView;
            if (embosserOptionsView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"embosserOptionsView");
                embosserOptionsView = null;
            }
            Map map = ed.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getOptions(...)");
            embosserOptionsView.setEmbosserOptions(map);
        }
        this.embosserDriver = ed;
    }

    private final void embosserManufacturerChanged() {
        int selIndex;
        Combo combo = this.cbEmbosserModel;
        if (combo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
            combo = null;
        }
        combo.removeAll();
        Combo combo2 = this.cbEmbosserManufacturer;
        if (combo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
            combo2 = null;
        }
        if ((selIndex = combo2.getSelectionIndex()) < 1) {
            Combo combo3 = this.cbEmbosserModel;
            if (combo3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                combo3 = null;
            }
            combo3.setEnabled(false);
        } else {
            Combo combo4 = this.cbEmbosserModel;
            if (combo4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                combo4 = null;
            }
            combo4.setEnabled(true);
            Map<String, ? extends List<? extends Embosser>> map = this.embosserMap;
            Intrinsics.checkNotNull(map);
            Combo combo5 = this.cbEmbosserManufacturer;
            if (combo5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
                combo5 = null;
            }
            List<? extends Embosser> list = map.get(combo5.getItem(selIndex));
            Intrinsics.checkNotNull(list);
            List<? extends Embosser> el = list;
            for (Embosser embosser : el) {
                Combo combo6 = this.cbEmbosserModel;
                if (combo6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                    combo6 = null;
                }
                Embosser embosser2 = embosser;
                Intrinsics.checkNotNull((Object)embosser2);
                combo6.add(embosser2.getModel());
            }
            Combo combo7 = this.cbEmbosserModel;
            if (combo7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserModel");
                combo7 = null;
            }
            combo7.select(0);
        }
        this.updateEmbosserDriver();
    }

    private final boolean validate() {
        Text text;
        Combo combo;
        Combo combo2;
        OptionIdentifier invalidOption;
        String errorMsg = null;
        EmbosserOptionsView embosserOptionsView = this.embosserOptionsView;
        if (embosserOptionsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"embosserOptionsView");
            embosserOptionsView = null;
        }
        if ((invalidOption = (OptionIdentifier)CollectionsKt.lastOrNull((Iterable)embosserOptionsView.getOptionErrors())) != null) {
            LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
            Object[] objectArray = new Object[1];
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            objectArray[0] = invalidOption.getDisplayName(locale);
            errorMsg = localeHandler.format("EmbosserEditDialog.optionsView.errorInvalidOptionValue", objectArray);
        }
        if ((combo2 = this.cbEmbosserManufacturer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserManufacturer");
            combo2 = null;
        }
        if (combo2.getSelectionIndex() < 1) {
            errorMsg = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.errSelectEmbosserManufacturer");
        }
        if ((combo = this.cbEmbosserDevice) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserDevice");
            combo = null;
        }
        if (combo.getSelectionIndex() < 1) {
            errorMsg = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.errSelectDevice");
        }
        if ((text = this.txtName) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"txtName");
            text = null;
        }
        if (this.existingNames.contains(text.getText())) {
            errorMsg = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.errExistingName");
        } else {
            Text text2 = this.txtName;
            if (text2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"txtName");
                text2 = null;
            }
            if (Intrinsics.areEqual((Object)"", (Object)text2.getText())) {
                errorMsg = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbosserEditDialog.errBlankName");
            }
        }
        this.setErrorMessage(errorMsg);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(errorMsg == null);
        }
        return errorMsg == null;
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    private final void saveInput() {
        Combo combo = this.cbEmbosserDevice;
        if (combo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cbEmbosserDevice");
            combo = null;
        }
        String printerName = combo.getText();
        Text text = this.txtName;
        if (text == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"txtName");
            text = null;
        }
        String string = text.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.embosser = new EmbosserConfig(string, printerName);
        Embosser driver2 = this.embosserDriver;
        if (driver2 != null) {
            EmbosserOptionsView embosserOptionsView = this.embosserOptionsView;
            if (embosserOptionsView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"embosserOptionsView");
                embosserOptionsView = null;
            }
            driver2 = driver2.customize(embosserOptionsView.getEmbosserOptions());
        }
        this.embosser.setEmbosserDriver(driver2);
    }

    private static final Unit createDialogArea$lambda$0(EmbosserEditDialog this$0, Set it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.validate();
        return Unit.INSTANCE;
    }

    private static final String createGeneralSettingsComposite$lambda$0(Embosser obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getManufacturer();
    }

    private static final String createGeneralSettingsComposite$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void createGeneralSettingsComposite$lambda$2(EmbosserEditDialog this$0, ModifyEvent it) {
        this$0.validate();
    }

    private static final void createGeneralSettingsComposite$lambda$3(EmbosserEditDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.validate();
    }

    private static final void createGeneralSettingsComposite$lambda$4(EmbosserEditDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.embosserManufacturerChanged();
        this$0.validate();
    }

    private static final void createGeneralSettingsComposite$lambda$5(EmbosserEditDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateEmbosserDriver();
        this$0.validate();
    }
}

