/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.frontmatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.apache.commons.lang3.StringUtils;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.frontmatter.SpecialSymbols;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u000245B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bH\u0002JJ\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u001f\u001a\u00020\u0017H\u0002JX\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0!0\b2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u001f\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002JL\u0010#\u001a\u00020\n2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010)\u001a\u00020*H\u0002J$\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u00152\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bH\u0002J \u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u000203H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R)\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00066"}, d2={"Lorg/brailleblaster/frontmatter/AutoFillSpecialSymbols;", "", "doc", "Lnu/xom/Document;", "m", "Lorg/brailleblaster/settings/UTDManager;", "callback", "Lkotlin/Function1;", "", "Lorg/brailleblaster/frontmatter/SpecialSymbols$Symbol;", "", "<init>", "(Lnu/xom/Document;Lorg/brailleblaster/settings/UTDManager;Lkotlin/jvm/functions/Function1;)V", "getDoc", "()Lnu/xom/Document;", "getM", "()Lorg/brailleblaster/settings/UTDManager;", "getCallback", "()Lkotlin/jvm/functions/Function1;", "openDialog", "parent", "Lorg/eclipse/swt/widgets/Shell;", "curVolume", "", "verifyResults", "results", "beginAutoFill", "onFind", "Lkotlin/Function2;", "", "onMessage", "volume", "searchSymbols", "", "symbols", "iterateThruXML", "onBrl", "Lnu/xom/Element;", "onVolume", "Lkotlin/Function0;", "listOfSymbols", "node", "Lnu/xom/Node;", "finish", "dialog", "data", "createFontRange", "Lorg/eclipse/swt/custom/StyleRange;", "start", "length", "font", "Lorg/eclipse/swt/graphics/Font;", "VolumeTracker", "Companion", "brailleblaster-core"})
public final class AutoFillSpecialSymbols {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document doc;
    @NotNull
    private final UTDManager m;
    @NotNull
    private final Function1<List<? extends List<? extends SpecialSymbols.Symbol>>, Unit> callback;
    public static final int BUTTON_WIDTH = 100;
    public static final int TEXT_WIDTH = 400;
    public static final int TEXT_HEIGHT = 300;
    public static final int TABLE_WIDTH = 500;
    public static final int TABLE_HEIGHT = 500;
    @NotNull
    private static final String FOUND_SYMBOL_MESSAGE_1 = "Found symbol: ";
    @NotNull
    private static final String FOUND_SYMBOL_MESSAGE_2 = " in ";

    public AutoFillSpecialSymbols(@NotNull Document doc, @NotNull UTDManager m, @NotNull Function1<? super List<? extends List<? extends SpecialSymbols.Symbol>>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.doc = doc;
        this.m = m;
        this.callback = callback;
    }

    @NotNull
    public final Document getDoc() {
        return this.doc;
    }

    @NotNull
    public final UTDManager getM() {
        return this.m;
    }

    @NotNull
    public final Function1<List<? extends List<? extends SpecialSymbols.Symbol>>, Unit> getCallback() {
        return this.callback;
    }

    public final void openDialog(@NotNull Shell parent, int curVolume) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Shell dialog = new Shell(parent, 67680);
        dialog.setLayout((Layout)new GridLayout(1, false));
        Composite container = new Composite((Composite)dialog, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        dialog.setText("Special Symbol Locator");
        Label warningLabel = EasySWT.makeLabel((Composite)container, (String)"Warning: Any symbols manually added to T-Pages before running this process will be overwritten when this process is ran.", (int)1);
        EasySWT.setLabelSizeToFit((Label)warningLabel, (int)400);
        Composite radioContainer = new Composite(container, 0);
        radioContainer.setLayout((Layout)new GridLayout(1, false));
        Button radio1 = new Button(radioContainer, 16);
        radio1.setText("Volume " + (curVolume + 1) + " only");
        radio1.setSelection(false);
        Button radio2 = new Button(radioContainer, 16);
        radio2.setText("All volumes");
        radio2.setSelection(true);
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new GridLayout(2, false));
        Button beginButton = EasySWT.makePushButton((Composite)buttonPanel, (String)"Begin", (int)100, (int)1, null);
        Button cancelButton = EasySWT.makePushButton((Composite)buttonPanel, (String)"Cancel", (int)100, (int)1, arg_0 -> AutoFillSpecialSymbols.openDialog$lambda$0(dialog, arg_0));
        StyledText statusText = new StyledText(container, 2560);
        statusText.setEditable(false);
        EasySWT.buildGridData().setHint(Integer.valueOf(400), Integer.valueOf(300)).setGrabSpace(true, true).applyTo((Control)statusText);
        Font simBraille = new Font((Device)Display.getCurrent(), "SimBraille", statusText.getFont().getFontData()[0].getHeight(), 0);
        Function2 onFind = (arg_0, arg_1) -> AutoFillSpecialSymbols.openDialog$lambda$1(statusText, this, simBraille, arg_0, arg_1);
        Function1 onMessage = arg_0 -> AutoFillSpecialSymbols.openDialog$lambda$2(statusText, arg_0);
        beginButton.addSelectionListener((SelectionListener)new SelectionAdapter(beginButton, cancelButton, this, (Function2<? super String, ? super String, Unit>)onFind, (Function1<? super String, Unit>)onMessage, radio1, curVolume, parent, dialog){
            final /* synthetic */ Button $beginButton;
            final /* synthetic */ Button $cancelButton;
            final /* synthetic */ AutoFillSpecialSymbols this$0;
            final /* synthetic */ Function2<String, String, Unit> $onFind;
            final /* synthetic */ Function1<String, Unit> $onMessage;
            final /* synthetic */ Button $radio1;
            final /* synthetic */ int $curVolume;
            final /* synthetic */ Shell $parent;
            final /* synthetic */ Shell $dialog;
            {
                this.$beginButton = $beginButton;
                this.$cancelButton = $cancelButton;
                this.this$0 = $receiver;
                this.$onFind = $onFind;
                this.$onMessage = $onMessage;
                this.$radio1 = $radio1;
                this.$curVolume = $curVolume;
                this.$parent = $parent;
                this.$dialog = $dialog;
            }

            public void widgetSelected(SelectionEvent e) {
                List data;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = this.$beginButton.getData();
                List list = data = object instanceof List ? (List)object : null;
                if (data == null) {
                    this.$cancelButton.setEnabled(false);
                    this.$beginButton.setEnabled(false);
                    this.$beginButton.setData((Object)AutoFillSpecialSymbols.access$beginAutoFill(this.this$0, this.$onFind, this.$onMessage, this.$radio1.getSelection() ? this.$curVolume : -1));
                    this.$beginButton.setEnabled(true);
                    this.$cancelButton.setEnabled(true);
                    this.$beginButton.setText("Continue");
                } else {
                    AutoFillSpecialSymbols.access$verifyResults(this.this$0, this.$parent, data);
                    this.$dialog.close();
                }
            }
        });
        dialog.open();
        dialog.pack();
    }

    private final void verifyResults(Shell parent, List<? extends List<? extends SpecialSymbols.Symbol>> results) {
        Shell dialog = new Shell(parent, 67680);
        dialog.setLayout((Layout)new GridLayout(1, false));
        Composite container = EasySWT.makeComposite((Composite)((Composite)dialog), (int)1);
        Label description = new Label(container, 0);
        Composite tableCont = EasySWT.makeComposite((Composite)((Composite)dialog), (int)1);
        Table resultsTable = new Table(tableCont, 68096);
        resultsTable.setLinesVisible(true);
        resultsTable.setHeaderVisible(true);
        EasySWT.buildGridData().setHint(Integer.valueOf(500), Integer.valueOf(500)).applyTo((Control)resultsTable);
        Composite buttonPanel = EasySWT.makeComposite((Composite)tableCont, (int)1);
        EasySWT.buildGridData().setGrabSpace(true, false).applyTo((Control)buttonPanel);
        description.setText("The following special symbols were found:");
        if (results.isEmpty()) {
            TableColumn emptyColumn = new TableColumn(resultsTable, 0);
            emptyColumn.setText("No results found");
            emptyColumn.setWidth(500);
        } else {
            TableColumn symbolColumn = new TableColumn(resultsTable, 0);
            symbolColumn.setText("Symbol");
            symbolColumn.setWidth(150);
            TableColumn descColumn = new TableColumn(resultsTable, 0);
            descColumn.setText("Description");
            descColumn.setWidth(350);
            int vol = 1;
            List<SpecialSymbols.Symbol> symbolDatabase = SpecialSymbols.getSymbols();
            for (List<? extends SpecialSymbols.Symbol> list : results) {
                if (!((Collection)list).isEmpty()) {
                    TableItem headingItem = new TableItem(resultsTable, 0);
                    String[] stringArray = new String[]{"Volume " + vol, ""};
                    headingItem.setText(stringArray);
                    for (SpecialSymbols.Symbol symbol : list) {
                        SpecialSymbols.Symbol storedSymbol = symbolDatabase.get(symbolDatabase.indexOf(symbol));
                        TableItem newItem = new TableItem(resultsTable, 0);
                        String symbolName = storedSymbol.getSymbol();
                        String string = storedSymbol.getDesc();
                        if (string == null) {
                            string = "";
                        }
                        String symbolDesc = string;
                        String[] stringArray2 = new String[]{symbolName, symbolDesc, SpecialSymbols.rulesToString(storedSymbol.getRules())};
                        newItem.setText(stringArray2);
                    }
                }
                ++vol;
            }
        }
        Composite okCancelPanel = EasySWT.buildComposite((Composite)buttonPanel).addButton("Finish", 100, 1, arg_0 -> AutoFillSpecialSymbols.verifyResults$lambda$0(this, dialog, results, arg_0)).addButton("Cancel", 100, 1, arg_0 -> AutoFillSpecialSymbols.verifyResults$lambda$1(dialog, arg_0)).build();
        EasySWT.buildGridData().setAlign(Integer.valueOf(131072), null).setGrabSpace(true, false).applyTo((Control)okCancelPanel);
        dialog.open();
        dialog.pack(true);
    }

    private final List<List<SpecialSymbols.Symbol>> beginAutoFill(Function2<? super String, ? super String, Unit> onFind, Function1<? super String, Unit> onMessage, int volume) {
        onMessage.invoke((Object)"Loading local symbol definitions");
        List<SpecialSymbols.Symbol> symbols = SpecialSymbols.getSymbols();
        onMessage.invoke((Object)"Begin special symbol search");
        Intrinsics.checkNotNull(symbols);
        List<List<SpecialSymbols.Symbol>> found = this.searchSymbols(onFind, onMessage, volume, symbols);
        for (List<SpecialSymbols.Symbol> symbolList : found) {
            CollectionsKt.sortWith(symbolList, (Comparator)new SpecialSymbols.SymbolComparator());
        }
        return found;
    }

    private final List<List<SpecialSymbols.Symbol>> searchSymbols(Function2<? super String, ? super String, Unit> onFind, Function1<? super String, Unit> onMessage, int volume, List<? extends SpecialSymbols.Symbol> symbols) {
        List volumes = new ArrayList();
        List foundSymbols = new ArrayList();
        List localSymbols = new ArrayList(symbols);
        VolumeTracker vt = new VolumeTracker();
        vt.setAllVolumes(volume == -1);
        Function1 onBrl = arg_0 -> AutoFillSpecialSymbols.searchSymbols$lambda$0(vt, volume, localSymbols, this, onFind, foundSymbols, arg_0);
        Function0 onVolume = () -> AutoFillSpecialSymbols.searchSymbols$lambda$1(vt, volumes, foundSymbols, onMessage, localSymbols, symbols);
        this.iterateThruXML((Function1<? super Element, ? extends List<? extends SpecialSymbols.Symbol>>)onBrl, (Function0<? extends List<? extends SpecialSymbols.Symbol>>)onVolume, localSymbols, (Node)this.doc);
        if (volumes.isEmpty()) {
            onVolume.invoke();
        }
        onMessage.invoke((Object)"Completed special symbol search");
        return volumes;
    }

    private final void iterateThruXML(Function1<? super Element, ? extends List<? extends SpecialSymbols.Symbol>> onBrl, Function0<? extends List<? extends SpecialSymbols.Symbol>> onVolume, List<? extends SpecialSymbols.Symbol> listOfSymbols, Node node) {
        List symbols = listOfSymbols;
        boolean inVolumeEndBlock = false;
        if (node instanceof Element) {
            if (UTDElements.BRL.isA(node)) {
                symbols = (List)onBrl.invoke((Object)node);
            } else if (BBX.BLOCK.VOLUME_END.isA(node)) {
                inVolumeEndBlock = true;
            }
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node2 = node.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            this.iterateThruXML(onBrl, onVolume, symbols, node2);
        }
        if (inVolumeEndBlock) {
            onVolume.invoke();
        }
    }

    private final void finish(Shell dialog, List<? extends List<? extends SpecialSymbols.Symbol>> data) {
        this.callback.invoke(data);
        dialog.close();
    }

    private final StyleRange createFontRange(int start, int length, Font font) {
        StyleRange newSR = new StyleRange();
        newSR.font = font;
        newSR.start = start;
        newSR.length = length;
        return newSR;
    }

    private static final void openDialog$lambda$0(Shell $dialog, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $dialog.close();
    }

    private static final Unit openDialog$lambda$1(StyledText $statusText, AutoFillSpecialSymbols this$0, Font $simBraille, String symbol, String location) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int curLength = $statusText.getText().length();
        $statusText.append(FOUND_SYMBOL_MESSAGE_1 + symbol + FOUND_SYMBOL_MESSAGE_2 + location + "\n");
        $statusText.setStyleRange(this$0.createFontRange(curLength += 14, symbol.length(), $simBraille));
        $statusText.setStyleRange(this$0.createFontRange(curLength += symbol.length() + 4, location.length(), $simBraille));
        $statusText.setSelection($statusText.getText().length() - 1);
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
            display.sleep();
        }
        return Unit.INSTANCE;
    }

    private static final Unit openDialog$lambda$2(StyledText $statusText, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $statusText.append(s + "\n");
        $statusText.setSelection($statusText.getText().length() - 1);
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
            display.sleep();
        }
        return Unit.INSTANCE;
    }

    private static final void verifyResults$lambda$0(AutoFillSpecialSymbols this$0, Shell $dialog, List $results, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.finish($dialog, $results);
    }

    private static final void verifyResults$lambda$1(Shell $dialog, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $dialog.close();
    }

    private static final List searchSymbols$lambda$0(VolumeTracker $vt, int $volume, List $localSymbols, AutoFillSpecialSymbols this$0, Function2 $onFind, List $foundSymbols, Element brlElement) {
        Intrinsics.checkNotNullParameter((Object)brlElement, (String)"brlElement");
        int n = brlElement.getChildCount();
        for (int i = 0; i < n && ($vt.getAllVolumes() || $vt.getVolume() == $volume); ++i) {
            if (!(brlElement.getChild(i) instanceof Text)) continue;
            String brl = brlElement.getChild(i).getValue();
            Iterator iter = $localSymbols.iterator();
            block1: while (iter.hasNext()) {
                SpecialSymbols.Symbol symbol = (SpecialSymbols.Symbol)iter.next();
                List<String> symbolPermutations = SpecialSymbols.getSymbolPermutations(symbol.getSymbol());
                symbolPermutations.add(symbol.getSymbol());
                int symbolIter = 0;
                block2: for (String symbolPerm : symbolPermutations) {
                    int iteration = 0;
                    block3: while (symbolIter < brl.length()) {
                        Intrinsics.checkNotNull((Object)brl);
                        CharSequence charSequence = brl;
                        Intrinsics.checkNotNull((Object)symbolPerm);
                        if (StringsKt.indexOf$default((CharSequence)charSequence, (String)symbolPerm, (int)symbolIter, (boolean)false, (int)4, null) == -1) continue block2;
                        int optionalTests = 0;
                        int optionalTestsPassed = 0;
                        for (SpecialSymbols.DetectionRule rule : symbol.getRules()) {
                            boolean result;
                            if (!rule.getAlways()) {
                                ++optionalTests;
                            }
                            if (!(result = rule.test(brlElement, i, symbol.getSymbol(), iteration, this$0.m)) && rule.getAlways()) {
                                symbolIter = StringsKt.indexOf$default((CharSequence)brl, (String)symbolPerm, (int)symbolIter, (boolean)false, (int)4, null) + 1;
                                ++iteration;
                                continue block3;
                            }
                            if (!result || rule.getAlways()) continue;
                            ++optionalTestsPassed;
                        }
                        if (optionalTests > 0 && optionalTestsPassed == 0) {
                            symbolIter = StringsKt.indexOf$default((CharSequence)brl, (String)symbolPerm, (int)symbolIter, (boolean)false, (int)4, null) + 1;
                            ++iteration;
                            continue;
                        }
                        String string = StringUtils.abbreviate((String)brl, (int)StringsKt.indexOf$default((CharSequence)brl, (String)symbolPerm, (int)0, (boolean)false, (int)6, null), (int)30);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abbreviate(...)");
                        $onFind.invoke((Object)symbolPerm, (Object)string);
                        $foundSymbols.add(symbol);
                        iter.remove();
                        continue block1;
                    }
                }
            }
        }
        return $localSymbols;
    }

    private static final List searchSymbols$lambda$1(VolumeTracker $vt, List $volumes, List $foundSymbols, Function1 $onMessage, List $localSymbols, List $symbols) {
        $vt.increaseVolume();
        $volumes.add(new ArrayList($foundSymbols));
        if ($vt.getAllVolumes()) {
            $onMessage.invoke((Object)("Finished volume " + $volumes.size()));
        }
        $foundSymbols.clear();
        $localSymbols.clear();
        $localSymbols.addAll($symbols);
        return $localSymbols;
    }

    public static final /* synthetic */ List access$beginAutoFill(AutoFillSpecialSymbols $this, Function2 onFind, Function1 onMessage, int volume) {
        return $this.beginAutoFill((Function2<? super String, ? super String, Unit>)onFind, (Function1<? super String, Unit>)onMessage, volume);
    }

    public static final /* synthetic */ void access$verifyResults(AutoFillSpecialSymbols $this, Shell parent, List results) {
        $this.verifyResults(parent, results);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/frontmatter/AutoFillSpecialSymbols$Companion;", "", "<init>", "()V", "BUTTON_WIDTH", "", "TEXT_WIDTH", "TEXT_HEIGHT", "TABLE_WIDTH", "TABLE_HEIGHT", "FOUND_SYMBOL_MESSAGE_1", "", "FOUND_SYMBOL_MESSAGE_2", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/frontmatter/AutoFillSpecialSymbols$VolumeTracker;", "", "<init>", "()V", "volume", "", "getVolume", "()I", "setVolume", "(I)V", "allVolumes", "", "getAllVolumes", "()Z", "setAllVolumes", "(Z)V", "increaseVolume", "", "brailleblaster-core"})
    private static final class VolumeTracker {
        private int volume;
        private boolean allVolumes = true;

        public final int getVolume() {
            return this.volume;
        }

        public final void setVolume(int n) {
            this.volume = n;
        }

        public final boolean getAllVolumes() {
            return this.allVolumes;
        }

        public final void setAllVolumes(boolean bl) {
            this.allVolumes = bl;
        }

        public final void increaseVolume() {
            int n = this.volume;
            this.volume = n + 1;
        }
    }
}

