/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.frontmatter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import org.brailleblaster.BBIni;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.util.Notify;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialSymbols {
    private static final String DEFAULT_SYMBOL_PATH = BBIni.getProgramDataPath().resolve(Paths.get("settings", "symbols.xml")).toString();
    private static final String CUSTOM_SYMBOL_PATH = BBIni.getUserProgramDataPath().resolve(Paths.get("settings", "symbols.xml")).toString();
    private static final Logger log = LoggerFactory.getLogger(SpecialSymbols.class);
    private static final String RULE_NAME_WHOLE_WORD = "Whole Word";
    private static final String RULE_NAME_BEGINNING_OF_WORD = "Beginning of Word";
    private static final String RULE_NAME_END_OF_WORD = "End of Word";
    private static final String RULE_NAME_DIRECT_TRANSLATED = "Direct Translated";
    private static final String RULE_NAME_FOLLOWED_BY = "Followed By";
    private static final String RULE_NAME_PRECEDED_BY = "Preceded By";
    private static final String RULE_NAME_NONE = "None";
    private static final String RULE_MODIFIER_NOT = "Not ";
    private static final String RULE_MODIFIER_ALWAYS = " [Always]";
    public static final String[] RULES = new String[]{"None", "Whole Word", "Not Whole Word", "Beginning of Word", "Not Beginning of Word", "End of Word", "Not End of Word", "Direct Translated", "Not Direct Translated", "Followed By", "Not Followed By", "Preceded By", "Not Preceded By"};
    static final String[][] sharedSymbols = new String[][]{{"~", "^"}, {"`", "@"}, {"{", "["}, {"}", "]"}, {"|", "\\"}};

    public static DetectionRule getEquivalentRule(String string, boolean always) {
        return switch (string) {
            case RULE_NAME_WHOLE_WORD, "WHOLE_WORD" -> new WholeWordRule(false, always);
            case "Not Whole Word", "NOT_WHOLE_WORD" -> new WholeWordRule(true, always);
            case RULE_NAME_DIRECT_TRANSLATED, "DIRECT_TRANSLATED" -> new DirectTranslatedRule(false, always);
            case "Not Direct Translated", "NOT_DIRECT_TRANSLATED" -> new DirectTranslatedRule(true, always);
            case RULE_NAME_BEGINNING_OF_WORD, "BEGINNING_OF_WORD" -> new BeginningOfWordRule(false, always);
            case "Not Beginning of Word", "NOT_BEGINNING_OF_WORD" -> new BeginningOfWordRule(true, always);
            case RULE_NAME_END_OF_WORD, "END_OF_WORD" -> new EndOfWordRule(false, always);
            case "Not End of Word", "NOT_END_OF_WORD" -> new EndOfWordRule(true, always);
            case RULE_NAME_PRECEDED_BY, "PRECEDED_BY" -> new PrecededByRule(false, always);
            case "Not Preceded By", "NOT_PRECEDED_BY" -> new PrecededByRule(true, always);
            case RULE_NAME_FOLLOWED_BY, "FOLLOWED_BY" -> new FollowedByRule(false, always);
            case "Not Followed By", "NOT_FOLLOWED_BY" -> new FollowedByRule(true, always);
            default -> throw new IllegalArgumentException("Rule not found: " + string);
        };
    }

    private static boolean wholeWordTest(Element e, int childIndex, String s, int iteration, UTDManager m) {
        return SpecialSymbols.beginningOfWordTest(e, childIndex, s, iteration, m) && SpecialSymbols.endOfWordTest(e, childIndex, s, iteration, m);
    }

    private static boolean directTranslatedTest(Element e, String s) {
        return "DIRECT".equals(((Element)e.getParent()).getAttributeValue("table"));
    }

    private static boolean beginningOfWordTest(Element e, int childIndex, String s, int iteration, UTDManager m) {
        Element block = (Element)m.getEngine().findTranslationBlock((Node)e.getParent());
        boolean isBlock = block == e.getParent();
        Node textNode = e.getChild(childIndex);
        if (iteration == 0 && textNode.getValue().startsWith(s)) {
            if (childIndex > 0 && UTDElements.MOVE_TO.isA(e.getChild(childIndex - 1))) {
                return true;
            }
            if (!isBlock) {
                List<Element> allBrl = SpecialSymbols.getDescendantBrl(block);
                int thisBrlIndex = allBrl.indexOf(e);
                if (thisBrlIndex == 0) {
                    return false;
                }
                Element prevBrl = allBrl.get(thisBrlIndex - 1);
                return prevBrl.getValue().endsWith(" ");
            }
            return false;
        }
        int symbolLocation = SpecialSymbols.findSymbolIndex(textNode, s, iteration);
        String textNodeValue = textNode.getValue();
        int charIndex = textNodeValue.indexOf(s, symbolLocation);
        return charIndex > 0 && textNodeValue.charAt(charIndex - 1) == ' ';
    }

    private static boolean endOfWordTest(Element e, int childIndex, String s, int iteration, UTDManager m) {
        int symbolLocation;
        boolean finalIteration;
        Element block = (Element)m.getEngine().findTranslationBlock((Node)e.getParent());
        boolean isBlock = block == e.getParent();
        Node textNode = e.getChild(childIndex);
        boolean bl = finalIteration = SpecialSymbols.findMaxIterations(textNode, s) == iteration + 1;
        if (finalIteration && textNode.getValue().endsWith(s)) {
            if (isBlock && childIndex == e.getChildCount() - 1 || childIndex + 1 < e.getChildCount() && UTDElements.MOVE_TO.isA(e.getChild(childIndex + 1))) {
                return true;
            }
            if (!isBlock) {
                List<Element> allBrl = SpecialSymbols.getDescendantBrl(block);
                int thisBrlIndex = allBrl.indexOf(e);
                if (thisBrlIndex == allBrl.size() - 1) {
                    return false;
                }
                Element nextBrl = allBrl.get(thisBrlIndex + 1);
                if (nextBrl.getValue().startsWith(" ")) {
                    return true;
                }
                return UTDElements.MOVE_TO.isA(nextBrl.getChild(0)) || UTDElements.NEW_PAGE.isA(nextBrl.getChild(0));
            }
            return false;
        }
        String textNodeValue = textNode.getValue();
        int charIndex = textNodeValue.indexOf(s, symbolLocation = SpecialSymbols.findSymbolIndex(textNode, s, iteration));
        return charIndex + s.length() + 1 < textNodeValue.length() && textNodeValue.substring(charIndex + s.length(), charIndex + s.length() + 1).equals(" ");
    }

    private static boolean precededByTest(Element e, int childIndex, String s, String option, int iteration, UTDManager m) {
        Element block = (Element)m.getEngine().findTranslationBlock((Node)e.getParent());
        boolean isBlock = block == e.getParent();
        Node textNode = e.getChild(childIndex);
        if (iteration == 0 && textNode.getValue().startsWith(s)) {
            if (childIndex > 0 && (UTDElements.MOVE_TO.isA(e.getChild(childIndex - 1)) || UTDElements.NEW_PAGE.isA(e.getChild(childIndex - 1)))) {
                return false;
            }
            if (!isBlock) {
                List<Element> allBrl = SpecialSymbols.getDescendantBrl(block);
                int thisBrl = allBrl.indexOf(e);
                if (thisBrl == 0) {
                    return false;
                }
                Element prevBrl = allBrl.get(thisBrl - 1);
                if (prevBrl.getValue().endsWith(option)) {
                    return true;
                }
            }
        }
        String textNodeValue = textNode.getValue();
        int symbolLocation = SpecialSymbols.findSymbolIndex(textNode, s, iteration);
        return textNodeValue.substring(0, textNodeValue.indexOf(s, symbolLocation)).endsWith(option);
    }

    private static boolean followedByTest(Element e, int childIndex, String s, String option, int iteration, UTDManager m) {
        String textNodeValue;
        int i;
        boolean finalIteration;
        int symbolLocation = 0;
        Element block = (Element)m.getEngine().findTranslationBlock((Node)e.getParent());
        boolean isBlock = block == e.getParent();
        Node textNode = e.getChild(childIndex);
        boolean bl = finalIteration = SpecialSymbols.findMaxIterations(textNode, s) == iteration + 1;
        if (finalIteration && textNode.getValue().endsWith(s)) {
            if (childIndex + 1 < e.getChildCount() && (UTDElements.MOVE_TO.isA(e.getChild(childIndex + 1)) || UTDElements.NEW_PAGE.isA(e.getChild(childIndex + 1)))) {
                return false;
            }
            if (!isBlock) {
                List<Element> allBrl = SpecialSymbols.getDescendantBrl(block);
                int thisBrl = allBrl.indexOf(e);
                if (thisBrl == allBrl.size() - 1) {
                    return false;
                }
                Element nextBrl = allBrl.get(thisBrl + 1);
                if (nextBrl.getValue().startsWith(option)) {
                    return true;
                }
            }
        }
        return (i = (textNodeValue = textNode.getValue()).indexOf(s, symbolLocation) + s.length()) < textNodeValue.length() && textNodeValue.substring(i).startsWith(option);
    }

    private static int findSymbolIndex(Node textNode, String symbol, int iteration) {
        int symbolLocation = 0;
        int startIter = 0;
        String text = textNode.getValue();
        while (symbolLocation < text.length() && text.indexOf(symbol, symbolLocation) != -1) {
            if (startIter == iteration) {
                return symbolLocation;
            }
            ++startIter;
            symbolLocation = text.indexOf(symbol, symbolLocation) + 1;
        }
        throw new IllegalArgumentException("The " + iteration + " copy of symbol " + symbol + " was not found in text node " + textNode.getValue());
    }

    private static int findMaxIterations(Node textNode, String symbol) {
        int symbolLocation = 0;
        int totalIterations = 0;
        String text = textNode.getValue();
        while (symbolLocation < text.length() && text.indexOf(symbol, symbolLocation) != -1) {
            ++totalIterations;
            symbolLocation = text.indexOf(symbol, symbolLocation) + 1;
        }
        return totalIterations;
    }

    private static List<Element> getDescendantBrl(Element parent) {
        ArrayList<Element> returnList = new ArrayList<Element>();
        Nodes query = parent.query("descendant::*[local-name()='brl']");
        for (int i = 0; i < query.size(); ++i) {
            returnList.add((Element)query.get(i));
        }
        return returnList;
    }

    public static List<Symbol> getSymbols() {
        List<Symbol> defaultList = SpecialSymbols.readSymbolsFromFile(DEFAULT_SYMBOL_PATH);
        List<Symbol> customList = SpecialSymbols.readSymbolsFromFile(CUSTOM_SYMBOL_PATH);
        log.debug("Found {} items in custom list and {} items in the default list", (Object)customList.size(), (Object)defaultList.size());
        ArrayList<Symbol> returnList = new ArrayList<Symbol>(customList);
        for (Symbol symbol : defaultList) {
            if (customList.contains(symbol)) continue;
            returnList.add(symbol);
        }
        return returnList;
    }

    private static List<Symbol> readSymbolsFromFile(String path) {
        log.debug("Loading symbol map from path {} ", (Object)path);
        ArrayList<Symbol> returnList = new ArrayList<Symbol>();
        if (new File(path).exists()) {
            Document newDoc = SpecialSymbols.readDocFromPath(path);
            if (newDoc == null) {
                return returnList;
            }
            List entries = XMLHandler.queryElements((Node)newDoc, (String)"descendant::entry", (Object[])new Object[0]);
            for (Element entry : entries) {
                if (entry.getChildElements().size() <= 0) continue;
                String name = entry.getChildElements().get(0).getValue();
                String desc = null;
                if (entry.getChildElements().size() > 1) {
                    desc = entry.getChildElements().get(1).getValue();
                }
                ArrayList<DetectionRule> rules = new ArrayList<DetectionRule>();
                if (entry.getChildElements().size() > 2) {
                    for (int child = 2; child < entry.getChildElements().size(); ++child) {
                        try {
                            String option = entry.getChildElements().get(child).getAttributeValue("option");
                            boolean always = "true".equals(entry.getChildElements().get(child).getAttributeValue("always"));
                            DetectionRule rule = SpecialSymbols.getEquivalentRule(entry.getChildElements().get(child).getValue(), always);
                            if (option != null) {
                                ((AdvancedDetectionRule)rule).setOption(option);
                            }
                            rules.add(rule);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            Notify.showMessage("An error occurred while parsing rules for symbol: " + name + ": " + desc + ". The rule was not loaded", new Object[0]);
                            log.debug(e.toString());
                        }
                    }
                }
                returnList.add(new Symbol(name, desc, rules));
            }
        } else {
            log.debug("Symbol map not found at {}", (Object)path);
        }
        return returnList;
    }

    public static void saveChanges(List<Symbol> list) {
        log.debug("Saving list: {}", (Object)list.size());
        ArrayList<Symbol> changes = new ArrayList<Symbol>();
        List<Symbol> defaultList = SpecialSymbols.readSymbolsFromFile(DEFAULT_SYMBOL_PATH);
        for (Symbol symbol : defaultList) {
            if (list.contains(symbol)) continue;
            symbol.setDesc(null);
            symbol.setRules(null);
        }
        for (Symbol symbol : list) {
            boolean changed;
            if (defaultList.contains(symbol)) {
                Symbol customSymbol;
                Symbol defaultSymbol = defaultList.get(defaultList.indexOf(symbol));
                changed = !SpecialSymbols.compareSymbol(defaultSymbol, customSymbol = list.get(list.indexOf(symbol)));
            } else {
                log.debug("Default list does not contain {}", (Object)symbol.getSymbol());
                changed = true;
            }
            if (!changed) continue;
            changes.add(symbol);
        }
        SpecialSymbols.saveListToXML(changes, CUSTOM_SYMBOL_PATH);
    }

    public static String[] getPrefixDefault() {
        String[] prefix;
        if (new File(CUSTOM_SYMBOL_PATH).exists() && (prefix = SpecialSymbols.loadPrefix(CUSTOM_SYMBOL_PATH)) != null) {
            log.debug("Found custom symbol prefix: {}: {}", (Object)prefix[0], (Object)prefix[1]);
            return prefix;
        }
        if (new File(DEFAULT_SYMBOL_PATH).exists() && (prefix = SpecialSymbols.loadPrefix(DEFAULT_SYMBOL_PATH)) != null) {
            log.debug("Found default symbol prefix: {}: {}", (Object)prefix[0], (Object)prefix[1]);
            return prefix;
        }
        return null;
    }

    private static String[] loadPrefix(String path) {
        Element prefix;
        Nodes query;
        Document doc = SpecialSymbols.readDocFromPath(path);
        if (doc != null && (query = doc.query("descendant::prefix")).size() > 0 && (prefix = (Element)query.get(0)).getChildElements().size() > 0) {
            String symbol = prefix.getChildElements().get(0).getValue();
            String desc = "";
            if (prefix.getChildElements().size() > 1) {
                desc = prefix.getChildElements().get(1).getValue();
            }
            return new String[]{symbol, desc};
        }
        return null;
    }

    public static void setPrefixDefault(String symbol, String desc) {
        String[] defaultPrefix;
        Document custom;
        if (!new File(CUSTOM_SYMBOL_PATH).exists()) {
            SpecialSymbols.saveListToXML(new ArrayList<Symbol>(), CUSTOM_SYMBOL_PATH);
        }
        if ((custom = SpecialSymbols.readDocFromPath(CUSTOM_SYMBOL_PATH)) == null) {
            return;
        }
        Nodes existingPrefix = custom.query("descendant::prefix");
        if (existingPrefix.size() > 0) {
            existingPrefix.get(0).detach();
        }
        if (!((defaultPrefix = SpecialSymbols.loadPrefix(DEFAULT_SYMBOL_PATH)) == null || symbol.equals(defaultPrefix[0]) && desc.equals(defaultPrefix[1]))) {
            Element root = custom.getRootElement();
            Element newPrefix = new Element("prefix");
            Element newSymbol = new Element("symbol");
            newSymbol.appendChild(symbol);
            Element newDesc = new Element("desc");
            newDesc.appendChild(desc);
            newPrefix.appendChild((Node)newSymbol);
            newPrefix.appendChild((Node)newDesc);
            root.appendChild((Node)newPrefix);
        }
        new XMLHandler().save(custom, new File(CUSTOM_SYMBOL_PATH));
    }

    public static List<String> getSymbolPermutations(String symbol) {
        return SpecialSymbols.symbolPermutationHelper(symbol, 0);
    }

    private static List<String> symbolPermutationHelper(String symbol, int startIndex) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int curCharNum = startIndex; curCharNum < symbol.length(); ++curCharNum) {
            String curChar = String.valueOf(symbol.charAt(curCharNum));
            for (String[] sharedSymbol : sharedSymbols) {
                StringBuilder sb;
                if (curChar.equals(sharedSymbol[0])) {
                    sb = new StringBuilder();
                    sb.append(symbol, 0, curCharNum);
                    sb.append(sharedSymbol[1]);
                    if (curCharNum + 1 < symbol.length()) {
                        sb.append(symbol.substring(curCharNum + 1));
                    }
                    returnList.add(sb.toString());
                    returnList.addAll(SpecialSymbols.symbolPermutationHelper(sb.toString(), curCharNum + 1));
                    continue;
                }
                if (!curChar.equals(sharedSymbol[1])) continue;
                sb = new StringBuilder();
                sb.append(symbol, 0, curCharNum);
                sb.append(sharedSymbol[0]);
                if (curCharNum + 1 < symbol.length()) {
                    sb.append(symbol.substring(curCharNum + 1));
                }
                returnList.add(sb.toString());
                returnList.addAll(SpecialSymbols.symbolPermutationHelper(sb.toString(), curCharNum + 1));
            }
        }
        return returnList;
    }

    private static void saveListToXML(List<Symbol> symbols, String path) {
        log.debug("Saving map to path {}", (Object)path);
        Element root = new Element("symbols");
        Document doc = new Document(root);
        for (Symbol symbol : symbols) {
            String symbolName = symbol.getSymbol();
            String desc = symbol.getDesc();
            List<DetectionRule> rules = symbol.getRules();
            Element newEntry = new Element("entry");
            Element newSymbol = new Element("symbol");
            newEntry.appendChild((Node)newSymbol);
            newSymbol.appendChild(symbolName);
            if (desc != null && !desc.isEmpty()) {
                Element newDesc = new Element("desc");
                newDesc.appendChild(desc);
                newEntry.appendChild((Node)newDesc);
            }
            if (rules != null && !rules.isEmpty()) {
                for (DetectionRule rule : rules) {
                    Element newRule = new Element("rule");
                    newRule.appendChild(rule.getRuleName());
                    if (rule.getAlways()) {
                        newRule.addAttribute(new Attribute("always", "true"));
                    }
                    if (rule instanceof AdvancedDetectionRule) {
                        newRule.addAttribute(new Attribute("option", ((AdvancedDetectionRule)rule).getOption()));
                    }
                    newEntry.appendChild((Node)newRule);
                }
            }
            root.appendChild((Node)newEntry);
        }
        new XMLHandler().save(doc, new File(path));
    }

    @Nullable
    private static Document readDocFromPath(String path) {
        Builder builder2 = new Builder();
        File file = new File(path);
        try {
            return builder2.build(file);
        }
        catch (IOException | ParsingException e) {
            log.warn("Problem parsing XML", e);
            return null;
        }
    }

    public static void restoreDefault() {
        new File(CUSTOM_SYMBOL_PATH).delete();
    }

    public static String singleRuleToString(DetectionRule rule) {
        if (rule instanceof AdvancedDetectionRule) {
            return rule.getRuleName() + " (" + ((AdvancedDetectionRule)rule).getOption() + ")" + (rule.getAlways() ? RULE_MODIFIER_ALWAYS : "");
        }
        return rule.getRuleName() + (rule.getAlways() ? RULE_MODIFIER_ALWAYS : "");
    }

    public static String rulesToString(List<DetectionRule> rules) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rules.size(); ++i) {
            sb.append(SpecialSymbols.singleRuleToString(rules.get(i)));
            if (i == rules.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static List<DetectionRule> stringToRules(String input) {
        if (input.isEmpty()) {
            return new ArrayList<DetectionRule>();
        }
        String[] split = SpecialSymbols.splitSafely(input);
        ArrayList<DetectionRule> rules = new ArrayList<DetectionRule>();
        for (String rule : split) {
            String option;
            rule = rule.trim();
            boolean always = rule.contains("[Always]");
            String actualRule = rule.replace(RULE_MODIFIER_ALWAYS, "");
            Pattern pattern = Pattern.compile(" \\(.+\\)");
            Matcher matcher = pattern.matcher(actualRule);
            String string = option = matcher.find() ? actualRule.substring(matcher.start(), matcher.end()) : null;
            if (option != null) {
                actualRule = actualRule.replace(option, "");
            }
            DetectionRule newRule = SpecialSymbols.getEquivalentRule(actualRule, always);
            if (option != null) {
                ((AdvancedDetectionRule)newRule).setOption(option.replace(" (", "").replace(")", ""));
            }
            rules.add(newRule);
        }
        return rules;
    }

    private static String[] splitSafely(String string) {
        Pattern p = Pattern.compile("\\(.?,.?\\)");
        Matcher m = p.matcher(string);
        ArrayList<String> array = new ArrayList<String>();
        if (m.find()) {
            char[] charArray = string.toCharArray();
            StringBuilder s = new StringBuilder();
            boolean inParenthesis = false;
            for (char c : charArray) {
                if (c == ',' && !inParenthesis) {
                    array.add(s.toString());
                    s = new StringBuilder();
                    continue;
                }
                if (c == '(') {
                    inParenthesis = true;
                } else if (c == ')') {
                    inParenthesis = false;
                }
                s.append(c);
            }
            if (!s.isEmpty()) {
                array.add(s.toString());
            }
            String[] sArray = new String[array.size()];
            return array.toArray(sArray);
        }
        return string.split(",");
    }

    private static boolean compareSymbol(Symbol symbol1, Symbol symbol2) {
        if (symbol1.getSymbol() != null && symbol2.getSymbol() != null ? !symbol1.getSymbol().equals(symbol2.getSymbol()) : symbol1.getSymbol() == null && symbol2.getSymbol() != null || symbol1.getSymbol() != null && symbol2.getSymbol() == null) {
            return false;
        }
        if (symbol1.getDesc() != null && symbol2.getDesc() != null ? !symbol1.getDesc().equals(symbol2.getDesc()) : symbol1.getDesc() == null && symbol2.getDesc() != null || symbol1.getDesc() != null && symbol2.getDesc() == null) {
            return false;
        }
        List<DetectionRule> list1 = symbol1.getRules();
        List<DetectionRule> list2 = symbol2.getRules();
        if (list1 == null || list2 == null) {
            return list1 == list2;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            DetectionRule rule2;
            DetectionRule rule1 = list1.get(i);
            if (rule1.compare(rule2 = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class WholeWordRule
    implements DetectionRule {
        final boolean not;
        final boolean always;

        public WholeWordRule(boolean not, boolean always) {
            this.not = not;
            this.always = always;
        }

        @Override
        public boolean test(Element symbolContainer, int childIndex, String symbol, int iteration, UTDManager m) {
            return this.not != SpecialSymbols.wholeWordTest(symbolContainer, childIndex, symbol, iteration, m);
        }

        @Override
        public String getRuleName() {
            return (this.not ? SpecialSymbols.RULE_MODIFIER_NOT : "") + SpecialSymbols.RULE_NAME_WHOLE_WORD;
        }

        @Override
        public boolean getAlways() {
            return this.always;
        }
    }

    public static class DirectTranslatedRule
    implements DetectionRule {
        final boolean not;
        final boolean always;

        public DirectTranslatedRule(boolean not, boolean always) {
            this.not = not;
            this.always = always;
        }

        @Override
        public boolean test(Element symbolContainer, int childIndex, String symbol, int iteration, UTDManager m) {
            return this.not != SpecialSymbols.directTranslatedTest(symbolContainer, symbol);
        }

        @Override
        public String getRuleName() {
            return (this.not ? SpecialSymbols.RULE_MODIFIER_NOT : "") + SpecialSymbols.RULE_NAME_DIRECT_TRANSLATED;
        }

        @Override
        public boolean getAlways() {
            return this.always;
        }
    }

    public static class BeginningOfWordRule
    implements DetectionRule {
        final boolean not;
        final boolean always;

        public BeginningOfWordRule(boolean not, boolean always) {
            this.not = not;
            this.always = always;
        }

        @Override
        public boolean test(Element symbolContainer, int childIndex, String symbol, int iteration, UTDManager m) {
            return this.not ? !SpecialSymbols.beginningOfWordTest(symbolContainer, childIndex, symbol, iteration, m) || SpecialSymbols.wholeWordTest(symbolContainer, childIndex, symbol, iteration, m) : SpecialSymbols.beginningOfWordTest(symbolContainer, childIndex, symbol, iteration, m) && !SpecialSymbols.wholeWordTest(symbolContainer, childIndex, symbol, iteration, m);
        }

        @Override
        public String getRuleName() {
            return (this.not ? SpecialSymbols.RULE_MODIFIER_NOT : "") + SpecialSymbols.RULE_NAME_BEGINNING_OF_WORD;
        }

        @Override
        public boolean getAlways() {
            return this.always;
        }
    }

    public static class EndOfWordRule
    implements DetectionRule {
        final boolean not;
        final boolean always;

        public EndOfWordRule(boolean not, boolean always) {
            this.not = not;
            this.always = always;
        }

        @Override
        public boolean test(Element symbolContainer, int childIndex, String symbol, int iteration, UTDManager m) {
            return this.not ? !SpecialSymbols.endOfWordTest(symbolContainer, childIndex, symbol, iteration, m) || SpecialSymbols.wholeWordTest(symbolContainer, childIndex, symbol, iteration, m) : SpecialSymbols.endOfWordTest(symbolContainer, childIndex, symbol, iteration, m) && !SpecialSymbols.wholeWordTest(symbolContainer, childIndex, symbol, iteration, m);
        }

        @Override
        public String getRuleName() {
            return (this.not ? SpecialSymbols.RULE_MODIFIER_NOT : "") + SpecialSymbols.RULE_NAME_END_OF_WORD;
        }

        @Override
        public boolean getAlways() {
            return this.always;
        }
    }

    public static class PrecededByRule
    implements AdvancedDetectionRule {
        final boolean not;
        final boolean always;
        String option;

        public PrecededByRule(boolean not, boolean always) {
            this.not = not;
            this.always = always;
        }

        @Override
        public boolean test(Element symbolContainer, int childIndex, String symbol, int iteration, UTDManager m) {
            return this.not != SpecialSymbols.precededByTest(symbolContainer, childIndex, symbol, this.option, iteration, m);
        }

        @Override
        public String getRuleName() {
            return (this.not ? SpecialSymbols.RULE_MODIFIER_NOT : "") + SpecialSymbols.RULE_NAME_PRECEDED_BY;
        }

        @Override
        public void setOption(String option) {
            this.option = option;
        }

        @Override
        public String getOption() {
            return this.option;
        }

        @Override
        public boolean getAlways() {
            return this.always;
        }
    }

    public static class FollowedByRule
    implements AdvancedDetectionRule {
        final boolean not;
        final boolean always;
        String option;

        public FollowedByRule(boolean not, boolean always) {
            this.not = not;
            this.always = always;
        }

        @Override
        public boolean test(Element symbolContainer, int childIndex, String symbol, int iteration, UTDManager m) {
            return this.not != SpecialSymbols.followedByTest(symbolContainer, childIndex, symbol, this.option, iteration, m);
        }

        @Override
        public String getRuleName() {
            return (this.not ? SpecialSymbols.RULE_MODIFIER_NOT : "") + SpecialSymbols.RULE_NAME_FOLLOWED_BY;
        }

        @Override
        public void setOption(String option) {
            this.option = option;
        }

        @Override
        public String getOption() {
            return this.option;
        }

        @Override
        public boolean getAlways() {
            return this.always;
        }
    }

    public static class Symbol {
        private String symbol;
        private String desc;
        private List<DetectionRule> rules;

        public Symbol(String name, String desc, List<DetectionRule> rules) {
            this.symbol = name;
            this.desc = desc;
            this.rules = rules;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public List<DetectionRule> getRules() {
            return this.rules;
        }

        public void setRules(List<DetectionRule> rules) {
            this.rules = rules;
        }

        public boolean equals(Object o) {
            if (o instanceof Symbol) {
                return this.symbol.equals(((Symbol)o).getSymbol());
            }
            if (o instanceof String) {
                return this.symbol.equals(o);
            }
            return false;
        }
    }

    public static interface DetectionRule {
        public boolean test(Element var1, int var2, String var3, int var4, UTDManager var5);

        public String getRuleName();

        public boolean getAlways();

        default public boolean compare(DetectionRule rule2) {
            return this.getRuleName().equals(rule2.getRuleName()) && this.getAlways() == rule2.getAlways();
        }
    }

    public static interface AdvancedDetectionRule
    extends DetectionRule {
        public void setOption(String var1);

        public String getOption();

        @Override
        default public boolean compare(DetectionRule rule2) {
            if (!(rule2 instanceof AdvancedDetectionRule)) {
                return false;
            }
            return this.getRuleName().equals(rule2.getRuleName()) && this.getAlways() == rule2.getAlways() && this.getOption().equals(((AdvancedDetectionRule)rule2).getOption());
        }
    }

    public static class SymbolComparator
    implements Comparator<Symbol> {
        final String complexityOrder = "abcdefghijklmnopqrstuvxyz&=(!)*<%?:$]\\[w1234567890/+#>'-@^_\".;,";

        @Override
        public int compare(Symbol sym1, Symbol sym2) {
            String o1 = sym1.getSymbol();
            String o2 = sym2.getSymbol();
            int prevChar = o1.toLowerCase().charAt(0);
            int thisChar = o2.toLowerCase().charAt(0);
            if (o1.length() > 1 && o2.length() > 1) {
                int iterator = 0;
                while (prevChar == thisChar) {
                    if (++iterator >= o1.length()) {
                        prevChar = 124;
                        break;
                    }
                    if (iterator >= o2.length()) {
                        thisChar = 124;
                        break;
                    }
                    prevChar = o1.toLowerCase().charAt(iterator);
                    thisChar = o2.toLowerCase().charAt(iterator);
                }
            }
            return Integer.compare("abcdefghijklmnopqrstuvxyz&=(!)*<%?:$]\\[w1234567890/+#>'-@^_\".;,".indexOf(prevChar), "abcdefghijklmnopqrstuvxyz&=(!)*<%?:$]\\[w1234567890/+#>'-@^_\".;,".indexOf(thisChar));
        }
    }
}

