/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.frontmatter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.IntPredicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.frontmatter.VolumeUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.BRFWriter;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.BBX2PEFConverterKt;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.BBFileDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0003'()B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J#\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020!H\u0002J#\u0010\"\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e\u0018\u00010&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/brailleblaster/frontmatter/VolumeSaveDialog;", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "arch", "Lorg/brailleblaster/archiver2/Archiver2;", "utdManager", "Lorg/brailleblaster/settings/UTDManager;", "doc", "Lnu/xom/Document;", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;Lorg/brailleblaster/archiver2/Archiver2;Lorg/brailleblaster/settings/UTDManager;Lnu/xom/Document;Lorg/brailleblaster/perspectives/braille/Manager;)V", "saveExec", "", "shell", "volumesTable", "Lorg/eclipse/swt/widgets/Table;", "selectedFormat", "Lorg/brailleblaster/frontmatter/VolumeSaveDialog$Format;", "clickSaveSingle", "", "clickSaveFolder", "all", "doSaveFolder", "selectedItems", "", "Lorg/eclipse/swt/widgets/TableItem;", "path", "", "([Lorg/eclipse/swt/widgets/TableItem;Ljava/lang/String;)V", "identifierFromFileName", "Ljava/io/File;", "checkDoSaveFolder", "", "([Lorg/eclipse/swt/widgets/TableItem;Ljava/lang/String;)I", "generateSaveDialog", "Lkotlin/Pair;", "State", "Format", "Companion", "brailleblaster-core"})
public final class VolumeSaveDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Archiver2 arch;
    @NotNull
    private final UTDManager utdManager;
    @NotNull
    private final Document doc;
    @NotNull
    private final Manager m;
    private boolean saveExec;
    @NotNull
    private final Shell shell;
    @Nullable
    private final Table volumesTable;
    @NotNull
    private Format selectedFormat;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String SETTINGS_FORMAT = "volumeSaveDialog.format";
    @NotNull
    public static final String SWTBOT_SAVE_SINGLE = "volumeSaveDialog.saveAll";
    @NotNull
    public static final String SWTBOT_SAVE_FOLDER = "volumeSaveDialog.saveFolder";
    @NotNull
    public static final String SWTBOT_SAVE_FOLDER_ALL = "volumeSaveDialog.saveFolderAll";
    @NotNull
    private static final String KEY_VOLUME_DATA = "volumeSaveDialog.volumeData";

    public VolumeSaveDialog(@NotNull Shell parent, @NotNull Archiver2 arch, @NotNull UTDManager utdManager, @NotNull Document doc, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter((Object)utdManager, (String)"utdManager");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.arch = arch;
        this.utdManager = utdManager;
        this.doc = doc;
        this.m = m;
        this.selectedFormat = Format.valueOf(BBIni.getPropertyFileManager().getProperty(SETTINGS_FORMAT, Format.BRF.toString()));
        List<Element> volumes = VolumeUtils.getVolumeElements(this.doc);
        this.shell = EasySWT.INSTANCE.makeDialog(parent);
        this.shell.setText(localeHandler.get("&SaveVolumeBRFPEF"));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        if (volumes.isEmpty()) {
            this.clickSaveSingle();
            this.volumesTable = null;
        } else {
            Composite tableWrapper = EasySWT.makeComposite((Composite)((Composite)this.shell), (int)1);
            EasySWT.buildGridData().setGrabSpace(true, true).setAlign(Integer.valueOf(4), Integer.valueOf(4)).verticalSpan(3).applyTo((Control)tableWrapper);
            this.volumesTable = new Table(tableWrapper, 268503042);
            EasySWT.buildGridData().setGrabSpace(true, true).setAlign(Integer.valueOf(4), Integer.valueOf(4)).applyTo((Control)this.volumesTable);
            TableColumn name = new TableColumn(this.volumesTable, 0);
            name.setText("Volume");
            name.setWidth(100);
            Button saveSingle = new Button((Composite)this.shell, 0);
            EasySWT.INSTANCE.addSwtBotKey((Control)saveSingle, SWTBOT_SAVE_SINGLE);
            saveSingle.setText("Save All to Single File");
            EasySWT.INSTANCE.setGridData((Control)saveSingle);
            Button saveFolder = new Button((Composite)this.shell, 0);
            EasySWT.INSTANCE.addSwtBotKey((Control)saveFolder, SWTBOT_SAVE_FOLDER);
            saveFolder.setText("Save Selected to Folder");
            EasySWT.INSTANCE.setGridData((Control)saveFolder);
            Button saveFolderAll = new Button((Composite)this.shell, 0);
            EasySWT.INSTANCE.addSwtBotKey((Control)saveFolderAll, SWTBOT_SAVE_FOLDER_ALL);
            saveFolderAll.setText("Save All to Folder");
            EasySWT.INSTANCE.setGridData((Control)saveFolderAll);
            EasySWT.addSelectionListener((Button)saveSingle, arg_0 -> VolumeSaveDialog._init_$lambda$0(this, arg_0));
            EasySWT.addSelectionListener((Button)saveFolder, arg_0 -> VolumeSaveDialog._init_$lambda$1(this, arg_0));
            EasySWT.addSelectionListener((Button)saveFolderAll, arg_0 -> VolumeSaveDialog._init_$lambda$2(this, arg_0));
            for (VolumeUtils.VolumeData curVolume : VolumeUtils.INSTANCE.getVolumeNames(volumes)) {
                TableItem entry = new TableItem(this.volumesTable, 0);
                String[] stringArray = new String[]{curVolume.nameLong};
                entry.setText(stringArray);
                entry.setData(KEY_VOLUME_DATA, (Object)curVolume);
            }
            EasySWT.INSTANCE.setLargeDialogSize(this.shell);
            this.shell.open();
        }
    }

    private final void clickSaveSingle() {
        log.trace("saving volumneless brf");
        Pair<Format, String> save = this.generateSaveDialog();
        if (save == null) {
            log.debug("canceled save");
            return;
        }
        Format format = (Format)((Object)save.getFirst());
        String path = (String)save.getSecond();
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    UTDTranslationEngine.toBRF$default((UTDTranslationEngine)this.utdManager.getEngine(), (Document)this.doc, (File)new File(path), (int)0, null, (boolean)false, (int)28, null);
                    break;
                }
                case 2: {
                    OutputStream os = new FileOutputStream(path);
                    String defaultIdentifier = this.identifierFromFileName(new File(path));
                    BBX2PEFConverterKt.convertBBX2PEF((Document)this.doc, (String)defaultIdentifier, (ITranslationEngine)((ITranslationEngine)this.utdManager.getEngine()), (IntPredicate)BBX2PEFConverterKt.ALL_VOLUMES, (OutputStream)os);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write BRF to " + path, e);
        }
    }

    private final void clickSaveFolder(boolean all) {
        TableItem[] selectedItems;
        log.trace("saving BRF to folder");
        if (all) {
            Table table = this.volumesTable;
            Intrinsics.checkNotNull((Object)table);
            v1 = table.getItems();
        } else {
            Table table = this.volumesTable;
            Intrinsics.checkNotNull((Object)table);
            v1 = selectedItems = table.getSelection();
        }
        if (selectedItems.length == 0) {
            Notify.showMessage("Must select volume", new Object[0]);
            return;
        }
        String path = null;
        if (selectedItems.length == 1) {
            Pair<Format, String> save = this.generateSaveDialog();
            if (save == null) {
                log.debug("canceled save");
                return;
            }
            Format format = (Format)((Object)save.getFirst());
            path = (String)save.getSecond();
            TableItem[] tableItemArray = this.volumesTable.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)tableItemArray, (String)"getItems(...)");
            int volumeIndex = ArraysKt.indexOf((Object[])tableItemArray, (Object)selectedItems[0]);
            try {
                switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                    case 1: {
                        String volumeBRF = Companion.volumeToBRF(this.utdManager.getEngine(), this.doc, volumeIndex, true);
                        FilesKt.writeText((File)new File(path), (String)volumeBRF, (Charset)Charsets.UTF_8);
                        log.info("Wrote {} characters to {}", (Object)volumeBRF.length(), (Object)path);
                        break;
                    }
                    case 2: {
                        String defaultIdentifier = this.identifierFromFileName(new File(path));
                        BBX2PEFConverterKt.convertBBX2PEF((Document)this.doc, (String)defaultIdentifier, (ITranslationEngine)((ITranslationEngine)this.utdManager.getEngine()), arg_0 -> VolumeSaveDialog.clickSaveFolder$lambda$0(volumeIndex, arg_0), (OutputStream)new FileOutputStream(path));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to save ordinal volume " + volumeIndex, e);
            }
            this.shell.close();
        } else {
            Path debugSavePath = BBIni.getDebugSavePath();
            if (BBIni.getDebugging() && debugSavePath != null) {
                path = ((Object)debugSavePath.getParent().toAbsolutePath()).toString();
            } else {
                DirectoryDialog dialog = new DirectoryDialog(this.shell, 8192);
                path = dialog.open();
            }
            if (path == null) {
                log.debug("canceled save");
                return;
            }
            Shell formatSelector = new Shell(this.shell, 67680);
            formatSelector.setLayout((Layout)new GridLayout(1, false));
            formatSelector.setText("Format selector");
            Button formatBrf = new Button((Composite)formatSelector, 16);
            formatBrf.setText("Braille Ready File (BRF)");
            Button formatPef = new Button((Composite)formatSelector, 16);
            formatPef.setText("Portable Embosser Format (PEF)");
            Button submit = new Button((Composite)formatSelector, 0);
            submit.setText("Submit");
            formatSelector.open();
            formatSelector.pack();
            submit.addListener(13, arg_0 -> VolumeSaveDialog.clickSaveFolder$lambda$1(this, formatBrf, formatPef, selectedItems, path, formatSelector, arg_0));
            switch (WhenMappings.$EnumSwitchMapping$0[this.selectedFormat.ordinal()]) {
                case 1: {
                    formatBrf.setSelection(true);
                    break;
                }
                case 2: {
                    formatPef.setSelection(true);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void doSaveFolder(TableItem[] selectedItems, String path) {
        int checkvalue = this.checkDoSaveFolder(selectedItems, path);
        if (checkvalue == 0) {
            this.saveExec = true;
            block6: for (TableItem selectedItem : selectedItems) {
                Object object = selectedItem.getData(KEY_VOLUME_DATA);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.frontmatter.VolumeUtils.VolumeData");
                VolumeUtils.VolumeData volumeData = (VolumeUtils.VolumeData)object;
                Table table = this.volumesTable;
                Intrinsics.checkNotNull((Object)table);
                TableItem[] tableItemArray = table.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)tableItemArray, (String)"getItems(...)");
                int volumeIndex = ArraysKt.indexOf((Object[])tableItemArray, (Object)selectedItem);
                try {
                    Path path2 = Paths.get(path, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    File outputPath = Companion.getBRFPath(path2, this.arch.getPath(), volumeData.type, volumeData.volumeTypeIndex, this.selectedFormat);
                    switch (WhenMappings.$EnumSwitchMapping$0[this.selectedFormat.ordinal()]) {
                        case 1: {
                            String volumeBRF = Companion.volumeToBRF(this.utdManager.getEngine(), this.doc, volumeIndex, true);
                            FilesKt.writeText((File)outputPath, (String)volumeBRF, (Charset)Charsets.UTF_8);
                            log.info("Wrote {} characters to {}", (Object)volumeBRF.length(), (Object)outputPath);
                            continue block6;
                        }
                        case 2: {
                            String defaultIdentifier = this.identifierFromFileName(outputPath);
                            BBX2PEFConverterKt.convertBBX2PEF((Document)this.doc, (String)defaultIdentifier, (ITranslationEngine)((ITranslationEngine)this.utdManager.getEngine()), arg_0 -> VolumeSaveDialog.doSaveFolder$lambda$0(volumeIndex, arg_0), (OutputStream)new FileOutputStream(outputPath));
                            log.info("Wrote volume {} to PEF", (Object)volumeIndex);
                            continue block6;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to save ordinal volume " + volumeIndex, e);
                }
            }
        }
    }

    private final String identifierFromFileName(File path) {
        String string = path.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }

    private final int checkDoSaveFolder(TableItem[] selectedItems, String path) {
        boolean existsFile = false;
        for (TableItem selectedItem : selectedItems) {
            Object object = selectedItem.getData(KEY_VOLUME_DATA);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.frontmatter.VolumeUtils.VolumeData");
            VolumeUtils.VolumeData volumeData = (VolumeUtils.VolumeData)object;
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            File outputPath = Companion.getBRFPath(path2, this.arch.getPath(), volumeData.type, volumeData.volumeTypeIndex, this.selectedFormat);
            if (!Files.exists(outputPath.toPath(), new LinkOption[0])) continue;
            existsFile = true;
            break;
        }
        if (existsFile) {
            String[] stringArray = new String[]{"Yes", "No"};
            MessageDialog dialog = new MessageDialog(this.shell, "Confirm Save", null, "This operation will overwrite one or more files in this directory. Are you sure you want to continue?", 4, stringArray, 0);
            return dialog.open();
        }
        return 0;
    }

    private final Pair<Format, String> generateSaveDialog() {
        Pair pair;
        Path debugSavePath = BBIni.getDebugSavePath();
        if (BBIni.getDebugging() && debugSavePath != null) {
            return TuplesKt.to((Object)((Object)Format.BRF), (Object)((Object)debugSavePath).toString());
        }
        Path path = this.m.getArchiver().getPath().getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFileName(...)");
        String fileName = PathsKt.getNameWithoutExtension((Path)path);
        BBFileDialog dialog = new BBFileDialog(this.m.getWpManager().getShell(), 8192, fileName, Format.Companion.fileDialogNames(), Format.Companion.fileDialogExtensions(), Format.getEntries().indexOf((Object)this.selectedFormat), null, 64, null);
        String string = dialog.open();
        if (string != null) {
            String filename = string;
            boolean bl = false;
            Format format = Format.Companion.matchExtension(filename, dialog.getWidget().getFilterIndex());
            pair = TuplesKt.to((Object)((Object)format), (Object)filename);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final void _init_$lambda$0(VolumeSaveDialog this$0, SelectionEvent selectionEvent) {
        this$0.clickSaveSingle();
    }

    private static final void _init_$lambda$1(VolumeSaveDialog this$0, SelectionEvent selectionEvent) {
        this$0.clickSaveFolder(false);
    }

    private static final void _init_$lambda$2(VolumeSaveDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickSaveFolder(true);
    }

    private static final boolean clickSaveFolder$lambda$0(int $volumeIndex, int x) {
        return x == $volumeIndex;
    }

    private static final void clickSaveFolder$lambda$1(VolumeSaveDialog this$0, Button $formatBrf, Button $formatPef, TableItem[] $selectedItems, String $path, Shell $formatSelector, Event it) {
        Format format;
        if ($formatBrf.getSelection()) {
            format = Format.BRF;
        } else if ($formatPef.getSelection()) {
            format = Format.PEF;
        } else {
            throw new UnsupportedOperationException("missing selection");
        }
        this$0.selectedFormat = format;
        Intrinsics.checkNotNull((Object)$selectedItems);
        this$0.doSaveFolder($selectedItems, $path);
        $formatSelector.close();
        if (this$0.saveExec) {
            this$0.shell.close();
        }
    }

    private static final boolean doSaveFolder$lambda$0(int $volumeIndex, int x) {
        return x == $volumeIndex;
    }

    @JvmStatic
    @NotNull
    public static final File getBRFPath(@NotNull Path documentPath, @NotNull BBX.VolumeType volumeType, int volumeTypeIndex, @Nullable Format selectedFormat) {
        return Companion.getBRFPath(documentPath, volumeType, volumeTypeIndex, selectedFormat);
    }

    static {
        Logger logger = LoggerFactory.getLogger(VolumeSaveDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J&\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/brailleblaster/frontmatter/VolumeSaveDialog$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "log", "Lorg/slf4j/Logger;", "SETTINGS_FORMAT", "", "SWTBOT_SAVE_SINGLE", "SWTBOT_SAVE_FOLDER", "SWTBOT_SAVE_FOLDER_ALL", "KEY_VOLUME_DATA", "getBRFPath", "Ljava/io/File;", "documentPath", "Ljava/nio/file/Path;", "volumeType", "Lorg/brailleblaster/bbx/BBX$VolumeType;", "volumeTypeIndex", "", "selectedFormat", "Lorg/brailleblaster/frontmatter/VolumeSaveDialog$Format;", "parentFile", "volumeToBRF", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "doc", "Lnu/xom/Document;", "volume", "convertLineEndings", "", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nVolumeSaveDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolumeSaveDialog.kt\norg/brailleblaster/frontmatter/VolumeSaveDialog$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,553:1\n1#2:554\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final File getBRFPath(@NotNull Path documentPath, @NotNull BBX.VolumeType volumeType, int volumeTypeIndex, @Nullable Format selectedFormat) {
            Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
            Intrinsics.checkNotNullParameter((Object)((Object)volumeType), (String)"volumeType");
            Path path = documentPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            return this.getBRFPath(path, documentPath, volumeType, volumeTypeIndex, selectedFormat);
        }

        @NotNull
        public final File getBRFPath(@NotNull Path parentFile, @NotNull Path documentPath, @NotNull BBX.VolumeType volumeType, int volumeTypeIndex, @Nullable Format selectedFormat) {
            Intrinsics.checkNotNullParameter((Object)parentFile, (String)"parentFile");
            Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
            Intrinsics.checkNotNullParameter((Object)((Object)volumeType), (String)"volumeType");
            Object name = StringsKt.substringBeforeLast$default((String)((Object)documentPath.getFileName()).toString(), (char)'.', null, (int)2, null);
            String format = ".brf";
            if (selectedFormat == Format.PEF) {
                format = ".pef";
            }
            String string = volumeType.volumeNameShort;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"volumeNameShort");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            name = (String)name + "_" + string3 + volumeTypeIndex + format;
            File file = parentFile.resolve((String)name).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final String volumeToBRF(@NotNull UTDTranslationEngine engine, @NotNull Document doc, int volume, boolean convertLineEndings) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            log.trace("Saving volume {}", (Object)volume);
            List volumeEndBrls = FastXPath.INSTANCE.descendantFindList((Node)doc, Companion::volumeToBRF$lambda$0);
            StringBuilder brfBuilder = new StringBuilder();
            Ref.ObjectRef finalBrfMut = new Ref.ObjectRef();
            BRFWriter.OutputCharStream stream = convertLineEndings ? BRFWriter.lineEndingRewriter(arg_0 -> Companion.volumeToBRF$lambda$1(brfBuilder, arg_0)) : arg_0 -> Companion.volumeToBRF$lambda$2(brfBuilder, arg_0);
            Intrinsics.checkNotNull((Object)stream);
            engine.toBRF(doc, stream, 0, new BRFWriter.PageListener(volume, (Ref.ObjectRef<String>)finalBrfMut, volumeEndBrls, brfBuilder){
                private State saveState;
                final /* synthetic */ int $volume;
                final /* synthetic */ Ref.ObjectRef<String> $finalBrfMut;
                final /* synthetic */ List<Element> $volumeEndBrls;
                final /* synthetic */ StringBuilder $brfBuilder;
                {
                    this.$volume = $volume;
                    this.$finalBrfMut = $finalBrfMut;
                    this.$volumeEndBrls = $volumeEndBrls;
                    this.$brfBuilder = $brfBuilder;
                    this.saveState = State.NOT_RUNNING;
                    if ($volume == 0) {
                        this.saveState = State.STARTED;
                    }
                }

                public final State getSaveState() {
                    return this.saveState;
                }

                public final void setSaveState(State state) {
                    Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
                    this.saveState = state;
                }

                public void onBeforeBrl(BRFWriter grid, Element brl) {
                    Intrinsics.checkNotNullParameter((Object)brl, (String)"brl");
                    if (this.saveState == State.FINISHED) {
                        return;
                    }
                    if (this.$volume == 0) {
                        if (this.$finalBrfMut.element == null && brl == CollectionsKt.first(this.$volumeEndBrls)) {
                            this.saveState = State.END_TRIGGER;
                        }
                    } else if (this.saveState == State.NOT_RUNNING && brl == this.$volumeEndBrls.get(this.$volume - 1)) {
                        this.saveState = State.START_TRIGGER;
                    } else if (this.saveState == State.STARTED && this.$volume != this.$volumeEndBrls.size() && brl == this.$volumeEndBrls.get(this.$volume)) {
                        this.saveState = State.END_TRIGGER;
                    }
                    VolumeSaveDialog.access$getLog$cp().debug("State {} element {}", (Object)((Object)this.saveState), (Object)brl.toXML());
                }

                public void onAfterFlush(BRFWriter brfWriter) {
                    if (this.saveState == State.FINISHED) {
                        return;
                    }
                    if (this.saveState == State.START_TRIGGER) {
                        VolumeSaveDialog.access$getLog$cp().debug("Start triggered");
                        this.$brfBuilder.setLength(0);
                        this.saveState = State.STARTED;
                    } else if (this.saveState == State.END_TRIGGER) {
                        this.$finalBrfMut.element = this.$brfBuilder.toString();
                        this.saveState = State.FINISHED;
                    }
                }
            }, true);
            if (volume == volumeEndBrls.size()) {
                if (!(finalBrfMut.element == null)) {
                    boolean $i$a$-check-VolumeSaveDialog$Companion$volumeToBRF$42 = false;
                    String $i$a$-check-VolumeSaveDialog$Companion$volumeToBRF$42 = "Wut " + finalBrfMut.element;
                    throw new IllegalStateException($i$a$-check-VolumeSaveDialog$Companion$volumeToBRF$42.toString());
                }
                finalBrfMut.element = brfBuilder.toString();
            }
            Object object = finalBrfMut.element;
            Intrinsics.checkNotNull((Object)object);
            String finalBrf = (String)object;
            if (!(!StringsKt.isBlank((CharSequence)finalBrf))) {
                boolean bl = false;
                String string2 = "No finalBrf?! " + ConstantsKt.getLINE_BREAK() + finalBrf + ConstantsKt.getLINE_BREAK() + "=------=";
                throw new IllegalStateException(string2.toString());
            }
            int linesPerPage = engine.getBrailleSettings().getCellType().getLinesForHeight(BigDecimal.valueOf(engine.getPageSettings().getDrawableHeight()));
            if (StringsKt.startsWith$default((String)finalBrf, (String)(StringsKt.repeat((CharSequence)"\n", (int)linesPerPage) + "\f"), (boolean)false, (int)2, null)) {
                String string3 = finalBrf.substring(linesPerPage + 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = finalBrf;
            }
            return string;
        }

        private static final boolean volumeToBRF$lambda$0$0(List list, Node curEndBlockChild) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)curEndBlockChild, (String)"curEndBlockChild");
            return UTDElements.BRL.isA(curEndBlockChild);
        }

        private static final boolean volumeToBRF$lambda$0(List results, Node curNode) {
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            Intrinsics.checkNotNullParameter((Object)curNode, (String)"curNode");
            if (BBX.BLOCK.VOLUME_END.isA(curNode)) {
                List blockBrls = FastXPath.INSTANCE.descendantFindList(curNode, Companion::volumeToBRF$lambda$0$0);
                results.add(CollectionsKt.last((List)blockBrls));
            }
            return false;
        }

        private static final void volumeToBRF$lambda$1(StringBuilder $brfBuilder, char c) {
            $brfBuilder.append(c);
        }

        private static final void volumeToBRF$lambda$2(StringBuilder $brfBuilder, char c) {
            $brfBuilder.append(c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/frontmatter/VolumeSaveDialog$Format;", "", "extension", "", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "BRF", "PEF", "Companion", "brailleblaster-core"})
    public static final class Format
    extends Enum<Format> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String extension;
        @NotNull
        private final String displayName;
        public static final /* enum */ Format BRF;
        public static final /* enum */ Format PEF;
        private static final /* synthetic */ Format[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Format(String extension, String displayName) {
            this.extension = extension;
            this.displayName = displayName;
        }

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String value) {
            return Enum.valueOf(Format.class, value);
        }

        @NotNull
        public static EnumEntries<Format> getEntries() {
            return $ENTRIES;
        }

        static {
            BRF = new Format("brf", "Braille Ready File");
            PEF = new Format("pef", "Portable Embosser Format");
            $VALUES = formatArray = new Format[]{Format.BRF, Format.PEF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/frontmatter/VolumeSaveDialog$Format$Companion;", "", "<init>", "()V", "fileDialogExtensions", "", "", "()[Ljava/lang/String;", "fileDialogNames", "matchExtension", "Lorg/brailleblaster/frontmatter/VolumeSaveDialog$Format;", "filename", "fallbackEnumIndex", "", "brailleblaster-core"})
        @SourceDebugExtension(value={"SMAP\nVolumeSaveDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolumeSaveDialog.kt\norg/brailleblaster/frontmatter/VolumeSaveDialog$Format$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,553:1\n1586#2:554\n1661#2,3:555\n1586#2:560\n1661#2,3:561\n37#3,2:558\n37#3,2:564\n*S KotlinDebug\n*F\n+ 1 VolumeSaveDialog.kt\norg/brailleblaster/frontmatter/VolumeSaveDialog$Format$Companion\n*L\n390#1:554\n390#1:555,3\n393#1:560\n393#1:561,3\n390#1:558,2\n393#1:564,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String[] fileDialogExtensions() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)Format.getEntries();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void value;
                    Format format = (Format)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add("*." + ((Format)value).extension);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new String[0]);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String[] fileDialogNames() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)Format.getEntries();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void value;
                    Format format = (Format)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Format)value).displayName + " (*." + ((Format)value).extension + ")");
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new String[0]);
            }

            @NotNull
            public final Format matchExtension(@NotNull String filename, int fallbackEnumIndex) {
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                Format result = (Format)((Object)Format.getEntries().get(fallbackEnumIndex));
                int periodIndex = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (periodIndex == -1) {
                    log.warn("missing extension {}", (Object)filename);
                    log.warn("falling back to value {}", (Object)result);
                } else {
                    String string = filename.substring(periodIndex + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String fileExtension = string;
                    for (Format value : Format.getEntries()) {
                        if (!Intrinsics.areEqual((Object)value.extension, (Object)fileExtension)) continue;
                        return value;
                    }
                    log.warn("invalid extension on {}", (Object)filename);
                }
                return result;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/frontmatter/VolumeSaveDialog$State;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_RUNNING", "START_TRIGGER", "STARTED", "END_TRIGGER", "FINISHED", "brailleblaster-core"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_RUNNING = new State();
        public static final /* enum */ State START_TRIGGER = new State();
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State END_TRIGGER = new State();
        public static final /* enum */ State FINISHED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_RUNNING, State.START_TRIGGER, State.STARTED, State.END_TRIGGER, State.FINISHED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Format.values().length];
            try {
                nArray[Format.BRF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.PEF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

