/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.ascii;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.BBIni;
import org.brailleblaster.math.ascii.ASCIICategory;
import org.brailleblaster.math.ascii.ASCIIEntries;
import org.brailleblaster.math.ascii.ASCIIEntry;
import org.brailleblaster.utd.config.UTDConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/math/ascii/ASCIILoadJAXB;", "", "<init>", "()V", "content", "Lorg/brailleblaster/math/ascii/ASCIIEntries;", "getContent", "()Lorg/brailleblaster/math/ascii/ASCIIEntries;", "setContent", "(Lorg/brailleblaster/math/ascii/ASCIIEntries;)V", "categories", "Ljava/util/ArrayList;", "", "getCategories", "()Ljava/util/ArrayList;", "setCategories", "(Ljava/util/ArrayList;)V", "getEntries", "Lorg/brailleblaster/math/ascii/ASCIIEntry;", "name", "Comparators", "Companion", "brailleblaster-core"})
public final class ASCIILoadJAXB {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ASCIIEntries content = new ASCIIEntries();
    @NotNull
    private ArrayList<String> categories = new ArrayList();
    @NotNull
    private static final File ASCIISETTINGS;

    /*
     * WARNING - void declaration
     */
    public ASCIILoadJAXB() {
        try {
            void it;
            Class[] classArray = new Class[]{ASCIIEntries.class};
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray);
            ASCIILoadJAXB aSCIILoadJAXB = this;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            aSCIILoadJAXB.content = (ASCIIEntries)UTDConfig.INSTANCE.loadJAXB(ASCIISETTINGS, ASCIIEntries.class, (JAXBContext)it);
            this.getCategories();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final ASCIIEntries getContent() {
        return this.content;
    }

    public final void setContent(@NotNull ASCIIEntries aSCIIEntries) {
        Intrinsics.checkNotNullParameter((Object)aSCIIEntries, (String)"<set-?>");
        this.content = aSCIIEntries;
    }

    @NotNull
    public final ArrayList<String> getCategories() {
        int n = ((Collection)this.content.getEntries()).size();
        for (int i = 0; i < n; ++i) {
            String category = this.content.getEntries().get(i).getCategory();
            if (this.categories.contains(category)) continue;
            this.categories.add(category);
        }
        CollectionsKt.sort((List)this.categories);
        return this.categories;
    }

    public final void setCategories(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.categories = arrayList;
    }

    @NotNull
    public final ArrayList<ASCIIEntry> getEntries(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ArrayList<ASCIIEntry> array = new ArrayList<ASCIIEntry>();
        int n = ((Collection)this.content.getEntries()).size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)this.content.getEntries().get(i).getCategory(), (Object)name)) continue;
            array.add(this.content.getEntries().get(i));
        }
        CollectionsKt.sortWith((List)array, Comparators.INSTANCE.getENTRY());
        return array;
    }

    static {
        String[] stringArray = new String[]{"asciicheat.xml"};
        File file = BBIni.getProgramDataPath().resolve(Paths.get("settings", stringArray)).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ASCIISETTINGS = file;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/math/ascii/ASCIILoadJAXB$Companion;", "", "<init>", "()V", "ASCIISETTINGS", "Ljava/io/File;", "getASCIISETTINGS", "()Ljava/io/File;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getASCIISETTINGS() {
            return ASCIISETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/math/ascii/ASCIILoadJAXB$Comparators;", "", "<init>", "()V", "ENTRY", "Ljava/util/Comparator;", "Lorg/brailleblaster/math/ascii/ASCIIEntry;", "kotlin.jvm.PlatformType", "getENTRY", "()Ljava/util/Comparator;", "CATEGORY", "Lorg/brailleblaster/math/ascii/ASCIICategory;", "getCATEGORY", "brailleblaster-core"})
    public static final class Comparators {
        @NotNull
        public static final Comparators INSTANCE = new Comparators();
        @NotNull
        private static final Comparator<ASCIIEntry> ENTRY = Comparators::ENTRY$lambda$0;
        @NotNull
        private static final Comparator<ASCIICategory> CATEGORY = Comparators::CATEGORY$lambda$0;

        private Comparators() {
        }

        @NotNull
        public final Comparator<ASCIIEntry> getENTRY() {
            return ENTRY;
        }

        @NotNull
        public final Comparator<ASCIICategory> getCATEGORY() {
            return CATEGORY;
        }

        private static final int ENTRY$lambda$0(ASCIIEntry o1, ASCIIEntry o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return o1.getName().compareTo(o2.getName());
        }

        private static final int CATEGORY$lambda$0(ASCIICategory o1, ASCIICategory o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return o2.getPrettyName().compareTo(o1.getPrettyName());
        }
    }
}

