/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.ascii;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Node;
import org.brailleblaster.math.ascii.ASCIICategory;
import org.brailleblaster.math.ascii.ASCIIEntry;
import org.brailleblaster.math.ascii.ASCIILoadJAXB;
import org.brailleblaster.math.ascii.MathDialogSettings;
import org.brailleblaster.math.mathml.ImageCreator;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.mathml.MathSubject;
import org.brailleblaster.math.mathml.MathUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.SectionElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.MathEditHandler;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.AccessibilityUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.SizeAndLocation;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 J2\u00020\u0001:\u0001JB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020\u001dH\u0002J\b\u0010/\u001a\u00020\u001dH\u0002J\b\u00100\u001a\u00020\u001dH\u0002J\t\u00101\u001a\u00020\u001dH\u0082\u0002J\u001a\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u0002042\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u00105\u001a\u00020\u001dH\u0002J\b\u00106\u001a\u00020\u001dH\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\"H\u0002J\u0012\u00109\u001a\u00020\u001d2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0010\u0010:\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\"H\u0002J\"\u0010;\u001a\u00020\u001d2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020*0D2\u0006\u0010E\u001a\u00020&H\u0002J\u0010\u0010F\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020&H\u0002J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020&H\u0002J\b\u0010I\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/brailleblaster/math/ascii/ASCIIMathEditorDialog;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "buttonImageWidth", "", "buttonImageHeight", "buttonTextWidth", "buttonTextHeight", "fontScaleMax", "fontScaleMin", "fontScale", "panelWidth", "panelHeight", "textBox", "Lorg/eclipse/swt/custom/StyledText;", "browser", "Lorg/eclipse/swt/browser/Browser;", "settings", "Lorg/brailleblaster/math/ascii/MathDialogSettings;", "getSettings", "()Lorg/brailleblaster/math/ascii/MathDialogSettings;", "setSettings", "(Lorg/brailleblaster/math/ascii/MathDialogSettings;)V", "searchTextBox", "Lorg/eclipse/swt/widgets/Text;", "open", "", "clear", "setSearchBox", "makeSearchBox", "leftPanel", "Lorg/eclipse/swt/widgets/Group;", "determineDialogProportions", "makeButtons", "addButtonTextPadding", "", "see", "addHoverText", "entry", "Lorg/brailleblaster/math/ascii/ASCIIEntry;", "button", "Lorg/eclipse/swt/widgets/Button;", "addAltText", "insert", "replace", "previous", "next", "updateTextView", "startNode", "Lnu/xom/Node;", "updateTextAndBrowser", "updateBrowser", "makeBrowserView", "rightPanel", "putAttributeInTextBox", "makeTextBox", "addSettingsDropDown", "shell", "Lorg/eclipse/swt/widgets/Shell;", "settingsFileMenu", "Lorg/eclipse/swt/widgets/MenuItem;", "menuBar", "Lorg/eclipse/swt/widgets/Menu;", "makeCombo", "getSearchResults", "Ljava/util/ArrayList;", "text", "search", "insertIntoTextBox", "txt", "extractText", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nASCIIMathEditorDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASCIIMathEditorDialog.kt\norg/brailleblaster/math/ascii/ASCIIMathEditorDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,538:1\n1300#2,2:539\n1315#2,4:541\n*S KotlinDebug\n*F\n+ 1 ASCIIMathEditorDialog.kt\norg/brailleblaster/math/ascii/ASCIIMathEditorDialog\n*L\n251#1:539,2\n251#1:541,4\n*E\n"})
public final class ASCIIMathEditorDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int buttonImageWidth;
    private final int buttonImageHeight;
    private final int buttonTextWidth;
    private final int buttonTextHeight;
    private final int fontScaleMax;
    private final int fontScaleMin;
    private int fontScale;
    private int panelWidth;
    private int panelHeight;
    @Nullable
    private StyledText textBox;
    @Nullable
    private Browser browser;
    @NotNull
    private MathDialogSettings settings;
    @Nullable
    private Text searchTextBox;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    private static final String SETTINGS = localeHandler.get("settings");
    @NotNull
    private static final String BEGINNING_OF_MATH_WARNING = localeHandler.get("beginningOfMathWarning");
    @NotNull
    private static final String END_OF_MATH_WARNING = localeHandler.get("endOfMathWarning");
    @NotNull
    private static final String FULL_SCREEN = localeHandler.get("fullScreen");
    @NotNull
    private static final String NEXT_MATH = localeHandler.get("nextMath");
    @NotNull
    private static final String PREVIOUS_MATH = localeHandler.get("previousMath");
    @JvmField
    @NotNull
    public static final String REPLACE_CURRENT_MATH = localeHandler.get("replaceCurrentMath");
    @JvmField
    @NotNull
    public static final String INSERT_MATH = localeHandler.get("insertMath");
    @NotNull
    private static final String PLACEHOLDER = localeHandler.get("mathJaxPlaceHolder");
    @Nullable
    private static Shell shell;
    @Nullable
    private static SizeAndLocation sizeLocation;
    @NotNull
    private static final String SEARCH;
    @NotNull
    private static final String OK;
    @NotNull
    private static final String CATEGORY_LABEL;
    @NotNull
    private static final String CLEAR_MATH;
    private static final int SEARCH_BOX_LENGTH = 20;
    @NotNull
    private static final String NO_SEARCH_RESULTS;

    public ASCIIMathEditorDialog(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.buttonImageWidth = 270;
        this.buttonImageHeight = 90;
        this.buttonTextWidth = 90;
        this.buttonTextHeight = 45;
        this.fontScaleMax = 30;
        this.fontScale = this.fontScaleMin = 9;
        this.settings = new MathDialogSettings();
        this.settings.loadSettings();
        this.open();
        this.putAttributeInTextBox(m.getSimpleManager().getCurrentCaret().getNode());
    }

    @NotNull
    public final MathDialogSettings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull MathDialogSettings mathDialogSettings) {
        Intrinsics.checkNotNullParameter((Object)mathDialogSettings, (String)"<set-?>");
        this.settings = mathDialogSettings;
    }

    /*
     * Unable to fully structure code
     */
    public final void open() {
        m = WPManager.Companion.getInstance().getController();
        if (ASCIIMathEditorDialog.shell == null) ** GOTO lbl-1000
        v0 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.isDisposed()) lbl-1000:
        // 2 sources

        {
            ASCIIMathEditorDialog.shell = new Shell(m.getDisplay().getActiveShell(), 2144);
        } else {
            v1 = ASCIIMathEditorDialog.shell;
            Intrinsics.checkNotNull((Object)v1);
            ASCIIMathEditorDialog.sizeLocation = EasySWT.INSTANCE.saveLocation(v1);
            v2 = ASCIIMathEditorDialog.shell;
            Intrinsics.checkNotNull((Object)v2);
            length = v2.getChildren().length;
            for (i = 0; i < length; ++i) {
                v3 = ASCIIMathEditorDialog.shell;
                Intrinsics.checkNotNull((Object)v3);
                v3.getChildren()[0].dispose();
            }
        }
        v4 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v4);
        v4.setText(MathModuleUtils.ASCII_EDITOR);
        v5 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v5);
        v5.setLayout((Layout)new GridLayout(2, false));
        if (this.settings.isFullScreen()) {
            v6 = ASCIIMathEditorDialog.shell;
            Intrinsics.checkNotNull((Object)v6);
            EasySWT.INSTANCE.setFullScreen(v6);
        } else if (ASCIIMathEditorDialog.sizeLocation != null) {
            v7 = ASCIIMathEditorDialog.shell;
            Intrinsics.checkNotNull((Object)v7);
            v8 = ASCIIMathEditorDialog.sizeLocation;
            Intrinsics.checkNotNull((Object)v8);
            EasySWT.INSTANCE.setSizeAndLocation(v7, v8);
        } else {
            v9 = ASCIIMathEditorDialog.shell;
            Intrinsics.checkNotNull((Object)v9);
            EasySWT.INSTANCE.setSizeAndLocationHalfScreen(v9);
        }
        this.determineDialogProportions();
        menuBar = new Menu((Decorations)ASCIIMathEditorDialog.shell, 2);
        settingsFileMenu = new MenuItem(menuBar, 64);
        settingsFileMenu.setText(ASCIIMathEditorDialog.SETTINGS);
        this.addSettingsDropDown(ASCIIMathEditorDialog.shell, settingsFileMenu, menuBar);
        leftPanel = EasySWT.makeGroup((Composite)((Composite)ASCIIMathEditorDialog.shell), (int)0, (int)1, (boolean)true);
        rightPanel = EasySWT.makeGroup((Composite)((Composite)ASCIIMathEditorDialog.shell), (int)0, (int)1, (boolean)true);
        this.makeCombo(leftPanel);
        this.makeButtons(leftPanel);
        this.makeBrowserView(rightPanel);
        this.makeTextBox(rightPanel);
        options = new Group((Composite)rightPanel, 0);
        optionsGrid = new GridData(4, 4, true, true);
        options.setData((Object)optionsGrid);
        options.setLayout((Layout)new GridLayout(5, false));
        apply = new Button((Composite)options, 8);
        apply.setText(ASCIIMathEditorDialog.INSERT_MATH);
        grid = new GridData(4, 4, true, true);
        apply.setData((Object)grid);
        EasySWT.addSelectionListener((Button)apply, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$0(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        replace = new Button((Composite)options, 8);
        replace.setText(ASCIIMathEditorDialog.REPLACE_CURRENT_MATH);
        replace.setData((Object)grid);
        EasySWT.addSelectionListener((Button)replace, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$1(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        previous = new Button((Composite)options, 8);
        previous.setText(ASCIIMathEditorDialog.PREVIOUS_MATH);
        previous.setData((Object)grid);
        EasySWT.addSelectionListener((Button)previous, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$2(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        next = new Button((Composite)options, 8);
        next.setText(ASCIIMathEditorDialog.NEXT_MATH);
        next.setData((Object)grid);
        EasySWT.addSelectionListener((Button)next, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$3(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        clear = new Button((Composite)options, 8);
        clear.setText(ASCIIMathEditorDialog.CLEAR_MATH);
        clear.setData((Object)grid);
        EasySWT.addSelectionListener((Button)clear, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$4(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        v10 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v10);
        EasySWT.INSTANCE.addEscapeCloseListener(v10);
        fontControls = new Group((Composite)rightPanel, 0);
        fontControlsGrid = new GridData(3, 1, false, false);
        fontControls.setData((Object)fontControlsGrid);
        fontControls.setLayout((Layout)new GridLayout(3, false));
        fontSizeLabel = new Label((Composite)fontControls, 0);
        fontSizeLabel.setText("Font Size: ");
        fontPlus = new Button((Composite)fontControls, 8);
        fontPlus.setText(" + ");
        EasySWT.addSelectionListener((Button)fontPlus, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$5(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        fontMinus = new Button((Composite)fontControls, 8);
        fontMinus.setText(" - ");
        EasySWT.addSelectionListener((Button)fontMinus, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$6(org.brailleblaster.math.ascii.ASCIIMathEditorDialog org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((ASCIIMathEditorDialog)this));
        v11 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v11);
        EasySWT.INSTANCE.addEscapeCloseListener(v11);
        v12 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v12);
        v12.pack();
        v13 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v13);
        v13.layout(true);
        v14 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v14);
        v14.setSize(this.panelWidth * 3, this.panelHeight * 3);
        v15 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)v15);
        v15.open();
        v16 = this.textBox;
        Intrinsics.checkNotNull((Object)v16);
        v16.setFocus();
        if (this.settings.getCurrentName() == MathDialogSettings.CATEGORIES.SEARCH) {
            this.setSearchBox();
        }
    }

    private final void clear() {
        this.settings.setCurrentAscii("");
        StyledText styledText = this.textBox;
        Intrinsics.checkNotNull((Object)styledText);
        styledText.setText("");
    }

    private final void setSearchBox() {
        if (this.searchTextBox != null) {
            Text text = this.searchTextBox;
            Intrinsics.checkNotNull((Object)text);
            if (!text.isDisposed()) {
                Text text2 = this.searchTextBox;
                Intrinsics.checkNotNull((Object)text2);
                text2.setText(this.settings.getLastSearch());
            }
        }
    }

    private final void makeSearchBox(Group leftPanel) {
        Group g = new Group((Composite)leftPanel, 0);
        GridLayout gl = new GridLayout(3, true);
        g.setLayout((Layout)gl);
        g.setLayoutData((Object)new GridData(4, 0, false, false));
        EasySWT.makeLabel((Composite)((Composite)g), (String)SEARCH, (int)1);
        this.searchTextBox = new Text((Composite)g, 2112);
        EasySWT.makePushButton((Composite)((Composite)g), (String)OK, (int)1, arg_0 -> ASCIIMathEditorDialog.makeSearchBox$lambda$0(this, arg_0));
        String searchBox = StringsKt.repeat((CharSequence)" ", (int)40);
        Text text = this.searchTextBox;
        Intrinsics.checkNotNull((Object)text);
        text.setText(StringsKt.trimIndent((String)searchBox));
        Text text2 = this.searchTextBox;
        Intrinsics.checkNotNull((Object)text2);
        text2.addKeyListener(new KeyListener(this){
            final /* synthetic */ ASCIIMathEditorDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.keyCode == 13) {
                    Text text = ASCIIMathEditorDialog.access$getSearchTextBox$p(this.this$0);
                    Intrinsics.checkNotNull((Object)text);
                    String searchText = text.getText();
                    this.this$0.getSettings().setCurrentAscii("");
                    this.this$0.getSettings().setLastSearch("");
                    ASCIICategory aSCIICategory = this.this$0.getSettings().getCurrentCategory();
                    Intrinsics.checkNotNull((Object)aSCIICategory);
                    aSCIICategory.getArray().clear();
                    Intrinsics.checkNotNull((Object)searchText);
                    ASCIIMathEditorDialog.access$search(this.this$0, searchText);
                    Text text2 = ASCIIMathEditorDialog.access$getSearchTextBox$p(this.this$0);
                    Intrinsics.checkNotNull((Object)text2);
                    text2.setText("");
                }
            }

            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    private final void determineDialogProportions() {
        Shell shell = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)shell);
        int width = shell.getBounds().width;
        Shell shell2 = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)shell2);
        int height = shell2.getBounds().height;
        this.panelWidth = width / 4;
        this.panelHeight = height / 4;
    }

    /*
     * WARNING - void declaration
     */
    private final void makeButtons(Group leftPanel) {
        if (this.settings.getCurrentName() == MathDialogSettings.CATEGORIES.SEARCH) {
            this.makeSearchBox(leftPanel);
        }
        Composite outerContainer = new Composite((Composite)leftPanel, 2048);
        outerContainer.setLayout((Layout)new GridLayout(1, false));
        outerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc = new ScrolledComposite(outerContainer, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setAlwaysShowScrollBars(true);
        Composite innerContainer = new Composite((Composite)sc, 2048);
        innerContainer.setLayout((Layout)new GridLayout(6, false));
        innerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ASCIICategory aSCIICategory = this.settings.getCurrentCategory();
        Intrinsics.checkNotNull((Object)aSCIICategory);
        int entrySize = aSCIICategory.getArray().size();
        if (entrySize == 0) {
            Text t = EasySWT.makeText((Composite)innerContainer, (int)1);
            t.setText(NO_SEARCH_RESULTS);
            t.setEditable(false);
        } else {
            Image image;
            ASCIIEntry entry;
            void $this$associateWithTo$iv$iv;
            ASCIICategory aSCIICategory2 = this.settings.getCurrentCategory();
            Intrinsics.checkNotNull((Object)aSCIICategory2);
            Iterable $this$associateWith$iv = aSCIICategory2.getArray();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                ASCIIEntry aSCIIEntry = (ASCIIEntry)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Image image2 = MathUtils.INSTANCE.getImageFromMMLDoc(it.getName());
                map.put(t, image2);
            }
            Map imagesMap = destination$iv$iv;
            for (Map.Entry entry2 : imagesMap.entrySet()) {
                entry = (ASCIIEntry)entry2.getKey();
                image = (Image)entry2.getValue();
                if (image == null) continue;
                Image im = new Image((Device)Display.getCurrent(), this.buttonImageWidth, this.buttonImageHeight);
                GC g = new GC((Drawable)im);
                int xSpace = (this.buttonImageWidth - image.getBounds().width) / 2;
                int ySpace = (this.buttonImageHeight - image.getBounds().height) / 2;
                g.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, xSpace, ySpace, image.getBounds().width, image.getBounds().height);
                g.dispose();
                Button button = new Button(innerContainer, 0);
                GridData data = new GridData();
                data.horizontalSpan = 2;
                button.setLayoutData((Object)data);
                EasySWT.addSelectionListener((Button)button, arg_0 -> ASCIIMathEditorDialog.makeButtons$lambda$1(this, entry, arg_0));
                button.setImage(im);
                this.addAltText(entry, button);
                this.addHoverText(entry, button);
            }
            for (Map.Entry entry3 : imagesMap.entrySet()) {
                entry = (ASCIIEntry)entry3.getKey();
                image = (Image)entry3.getValue();
                if (image != null) continue;
                Button button = new Button(innerContainer, 0x1000000);
                GridData data = new GridData();
                data.horizontalAlignment = 4;
                button.setLayoutData((Object)data);
                EasySWT.addSelectionListener((Button)button, arg_0 -> ASCIIMathEditorDialog.makeButtons$lambda$2(this, entry, arg_0));
                FontData[] fontdata = button.getFont().getFontData();
                fontdata[0].setHeight(this.fontScale * 2);
                Font font = new Font((Device)Display.getCurrent(), fontdata);
                button.setFont(font);
                button.setText(this.addButtonTextPadding(entry.getSee()));
                button.setSize(this.buttonTextWidth, this.buttonTextHeight);
                this.addAltText(entry, button);
                this.addHoverText(entry, button);
            }
        }
        sc.setContent((Control)innerContainer);
        sc.setMinSize(innerContainer.computeSize(-1, -1));
    }

    private final String addButtonTextPadding(String see) {
        int width = 8;
        if (see.length() > width) {
            return see;
        }
        int padding = width - see.length();
        int leftPadding = padding / 2;
        int rightPadding = padding - leftPadding;
        return StringsKt.repeat((CharSequence)" ", (int)leftPadding) + see + StringsKt.repeat((CharSequence)" ", (int)rightPadding);
    }

    private final void addHoverText(ASCIIEntry entry, Button button) {
        button.setToolTipText(entry.getName());
    }

    private final void addAltText(ASCIIEntry entry, Button button) {
        AccessibilityUtils.setName((Control)((Control)button), (String)entry.getName());
    }

    private final void insert() {
        MathEditHandler.INSTANCE.insertNew(new MathSubject(this.settings.getCurrentAscii()));
    }

    private final void replace() {
        StyledText styledText = this.textBox;
        Intrinsics.checkNotNull((Object)styledText);
        String string = styledText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        MathEditHandler.INSTANCE.replaceMathAtCursor(new MathSubject(string));
    }

    private final void previous() {
        Manager m = WPManager.Companion.getInstance().getController();
        Node startNode = m.getSimpleManager().getCurrentSelection().start.getNode();
        Node node = MathUtils.INSTANCE.previous(startNode, m);
        if (node != null) {
            this.putAttributeInTextBox(node);
            this.updateBrowser();
            this.updateTextView(node, m);
        } else {
            Notify.notify$default(Notify.INSTANCE, BEGINNING_OF_MATH_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
        }
    }

    private final void next() {
        Manager m = WPManager.Companion.getInstance().getController();
        Node startNode = m.getSimpleManager().getCurrentSelection().end.getNode();
        Node node = MathUtils.INSTANCE.next(startNode, m);
        if (node != null) {
            this.putAttributeInTextBox(node);
            this.updateBrowser();
            this.updateTextView(node, m);
        } else {
            Notify.notify$default(Notify.INSTANCE, END_OF_MATH_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
        }
    }

    private final void updateTextView(Node startNode, Manager m) {
        int startSection;
        Manager manager = m;
        Intrinsics.checkNotNull((Object)manager);
        int n = manager.getSectionList().size();
        for (int i = startSection = 0; i < n; ++i) {
            SectionElement section = m.getSectionList().get(i);
            MapList list = section.list;
            int listSize = list.size();
            for (int j = 0; j < listSize; ++j) {
                Object e = list.get(j);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                TextMapElement mapElement = (TextMapElement)e;
                if (mapElement.getNode() == null || !Intrinsics.areEqual((Object)mapElement.getNode(), (Object)startNode)) continue;
                if (!section.isVisible()) {
                    m.useResetSectionMethod(i);
                    m.getMapList().setCurrent(0);
                    m.waitForFormatting(true);
                }
                m.getTextView().setTopIndex(m.getTextView().getLineAtOffset(mapElement.getStart(m.getMapList())));
                int index = m.getMapList().indexOf(mapElement);
                if (index != -1) {
                    m.getMapList().setCurrent(index);
                }
                m.getText().highlight(mapElement.getStart(m.getMapList()), mapElement.getEnd(m.getMapList()));
                return;
            }
        }
    }

    private final void updateTextAndBrowser() {
        this.updateBrowser();
        this.insertIntoTextBox(this.settings.getCurrentAscii());
    }

    private final void updateBrowser() {
        ImageCreator.INSTANCE.updateBrowser(this.browser, this.settings.getCurrentAscii());
    }

    private final void makeBrowserView(Group rightPanel) {
        this.browser = ImageCreator.INSTANCE.makeBrowserView(rightPanel, this.settings.getCurrentAscii(), this.panelWidth, this.panelHeight);
    }

    private final void putAttributeInTextBox(Node startNode) {
        StyledText styledText = this.textBox;
        Intrinsics.checkNotNull((Object)styledText);
        styledText.setText(startNode != null && MathModuleUtils.isMath(startNode) ? MathModuleUtils.getMathText(startNode) : "");
    }

    /*
     * WARNING - void declaration
     */
    private final void makeTextBox(Group rightPanel) {
        void $this$makeTextBox_u24lambda_u240;
        StyledText styledText;
        ScrolledComposite outer = new ScrolledComposite((Composite)rightPanel, 768);
        outer.setData((Object)new GridData(4, 4, true, true));
        outer.setLayout((Layout)new GridLayout(1, true));
        outer.setMinSize(this.panelWidth, this.panelHeight);
        outer.setExpandHorizontal(true);
        outer.setExpandVertical(true);
        StyledText styledText2 = styledText = new StyledText((Composite)outer, 2816);
        ASCIIMathEditorDialog aSCIIMathEditorDialog = this;
        boolean bl = false;
        $this$makeTextBox_u24lambda_u240.setData((Object)new GridData(4, 4, true, true));
        $this$makeTextBox_u24lambda_u240.setSize(this.panelWidth, this.panelHeight);
        aSCIIMathEditorDialog.textBox = styledText;
        outer.setContent((Control)this.textBox);
        StyledText styledText3 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText3);
        FontData[] fontdata = styledText3.getFont().getFontData();
        fontdata[0].setHeight(this.fontScale * 2);
        Font font = new Font((Device)Display.getCurrent(), fontdata);
        StyledText styledText4 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText4);
        styledText4.setFont(font);
        StyledText styledText5 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText5);
        styledText5.addVerifyKeyListener(arg_0 -> ASCIIMathEditorDialog.makeTextBox$lambda$1(this, arg_0));
        StyledText styledText6 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText6);
        styledText6.addModifyListener(arg_0 -> ASCIIMathEditorDialog.makeTextBox$lambda$2(this, arg_0));
        StyledText styledText7 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText7);
        styledText7.addKeyListener(new KeyListener(this){
            final /* synthetic */ ASCIIMathEditorDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    StyledText styledText = ASCIIMathEditorDialog.access$getTextBox$p(this.this$0);
                    Intrinsics.checkNotNull((Object)styledText);
                    styledText.selectAll();
                }
            }

            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        this.insertIntoTextBox(this.settings.getCurrentAscii());
    }

    private final void addSettingsDropDown(Shell shell, MenuItem settingsFileMenu, Menu menuBar) {
        Menu fileMenu = new Menu((Decorations)shell, 4);
        settingsFileMenu.setMenu(fileMenu);
        MenuItem full = new MenuItem(fileMenu, 32);
        full.setText(FULL_SCREEN);
        Shell shell2 = shell;
        Intrinsics.checkNotNull((Object)shell2);
        shell2.setMenuBar(menuBar);
        full.setSelection(this.settings.isFullScreen());
        full.addListener(13, arg_0 -> ASCIIMathEditorDialog.addSettingsDropDown$lambda$0(this, full, shell, arg_0));
    }

    private final void makeCombo(Group leftPanel) {
        Group g = new Group((Composite)leftPanel, 0);
        g.setLayout((Layout)new GridLayout(2, false));
        g.setLayoutData((Object)new GridData(0, 0, false, false));
        EasySWT.makeLabel((Composite)((Composite)g), (String)CATEGORY_LABEL, (int)1);
        ArrayList<ASCIICategory> categories = this.settings.getCategories();
        CollectionsKt.sortWith((List)categories, ASCIILoadJAXB.Comparators.INSTANCE.getCATEGORY());
        Combo combo = new Combo((Composite)g, 12);
        combo.setData((Object)new GridData(4, 0, true, true));
        String[] stringArray = this.settings.getCategoriesEnumStringArray();
        combo.setItems(Arrays.copyOf(stringArray, stringArray.length));
        EasySWT.INSTANCE.addSelectionListener(combo, arg_0 -> ASCIIMathEditorDialog.makeCombo$lambda$0(this, combo, arg_0));
        combo.select(combo.indexOf(this.settings.getCurrentName().getPrettyName()));
    }

    private final ArrayList<ASCIIEntry> getSearchResults(String text) {
        ArrayList<ASCIIEntry> results = new ArrayList<ASCIIEntry>();
        ArrayList<ASCIICategory> categories = this.settings.getCategories();
        int n = ((Collection)categories).size();
        for (int i = 0; i < n; ++i) {
            ArrayList<ASCIIEntry> array = categories.get(i).getArray();
            int n2 = ((Collection)array).size();
            for (int j = 0; j < n2; ++j) {
                String string = array.get(j).getName();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                CharSequence charSequence = string2;
                string = text;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string3 = string.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) {
                    string = array.get(j).getEntry();
                    Locale locale3 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                    String string4 = string.toLowerCase(locale3);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    CharSequence charSequence2 = string4;
                    string = text;
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                    String string5 = string.toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    if (!StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string5, (boolean)false, (int)2, null)) continue;
                }
                results.add(array.get(j));
            }
        }
        return results;
    }

    private final void search(String text) {
        this.extractText();
        Text text2 = this.searchTextBox;
        Intrinsics.checkNotNull((Object)text2);
        String string = text2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.settings.setLastSearch(string);
        ArrayList<ASCIIEntry> results = this.getSearchResults(text);
        this.settings.setCurrentName(MathDialogSettings.CATEGORIES.SEARCH);
        ASCIICategory aSCIICategory = this.settings.getCurrentCategory();
        Intrinsics.checkNotNull((Object)aSCIICategory);
        aSCIICategory.setArray(results);
        this.open();
    }

    private final void insertIntoTextBox(String txt) {
        String text = txt;
        CharSequence charSequence = text;
        Regex regex = new Regex("\n");
        String string = "";
        text = regex.replace(charSequence, string);
        StyledText styledText = this.textBox;
        Intrinsics.checkNotNull((Object)styledText);
        int offset = styledText.getCaretOffset();
        StyledText styledText2 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText2);
        styledText2.insert(text);
        StyledText styledText3 = this.textBox;
        Intrinsics.checkNotNull((Object)styledText3);
        styledText3.setCaretOffset(offset + text.length());
    }

    private final void extractText() {
        StyledText styledText = this.textBox;
        Intrinsics.checkNotNull((Object)styledText);
        String string = styledText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.settings.setCurrentAscii(string);
    }

    private static final void open$lambda$0(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.insert();
    }

    private static final void open$lambda$1(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.replace();
    }

    private static final void open$lambda$2(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.previous();
    }

    private static final void open$lambda$3(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.next();
    }

    private static final void open$lambda$4(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clear();
    }

    private static final void open$lambda$5(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.fontScale < this$0.fontScaleMax) {
            int n = this$0.fontScale;
            this$0.fontScale = n + 1;
        }
        Shell shell = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)shell);
        shell.close();
        this$0.open();
    }

    private static final void open$lambda$6(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.fontScale > this$0.fontScaleMin) {
            int n = this$0.fontScale;
            this$0.fontScale = n + -1;
        }
        Shell shell = ASCIIMathEditorDialog.shell;
        Intrinsics.checkNotNull((Object)shell);
        shell.close();
        this$0.open();
    }

    private static final void makeSearchBox$lambda$0(ASCIIMathEditorDialog this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Text text = this$0.searchTextBox;
        Intrinsics.checkNotNull((Object)text);
        String searchText = text.getText();
        this$0.settings.setCurrentAscii("");
        this$0.settings.setLastSearch("");
        ASCIICategory aSCIICategory = this$0.settings.getCurrentCategory();
        Intrinsics.checkNotNull((Object)aSCIICategory);
        aSCIICategory.getArray().clear();
        Intrinsics.checkNotNull((Object)searchText);
        this$0.search(searchText);
        Text text2 = this$0.searchTextBox;
        Intrinsics.checkNotNull((Object)text2);
        text2.setText("");
    }

    private static final void makeButtons$lambda$1(ASCIIMathEditorDialog this$0, ASCIIEntry $entry, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.settings.setCurrentAscii($entry.getEntry());
        this$0.updateTextAndBrowser();
    }

    private static final void makeButtons$lambda$2(ASCIIMathEditorDialog this$0, ASCIIEntry $entry, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.settings.setCurrentAscii($entry.getEntry());
        this$0.updateTextAndBrowser();
    }

    private static final void makeTextBox$lambda$1(ASCIIMathEditorDialog this$0, VerifyEvent event) {
        block3: {
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.keyCode != 13 && event.keyCode != 9) break block2;
                    event.doit = false;
                    break block3;
                }
                if (event.keyCode == 127) break block4;
                if (event.keyCode != 8 || this$0.textBox == null) break block3;
                StyledText styledText = this$0.textBox;
                Intrinsics.checkNotNull((Object)styledText);
                if (styledText.isDisposed()) break block3;
                StyledText styledText2 = this$0.textBox;
                Intrinsics.checkNotNull((Object)styledText2);
                if (styledText2.getText().length() != 1) break block3;
            }
            this$0.extractText();
            this$0.updateBrowser();
        }
    }

    private static final void makeTextBox$lambda$2(ASCIIMathEditorDialog this$0, ModifyEvent it) {
        this$0.extractText();
        this$0.updateBrowser();
    }

    private static final void addSettingsDropDown$lambda$0(ASCIIMathEditorDialog this$0, MenuItem $full, Shell $shell, Event it) {
        this$0.settings.setFullScreen(!this$0.settings.isFullScreen());
        $full.setSelection(this$0.settings.isFullScreen());
        this$0.settings.saveSettings();
        $shell.close();
        this$0.open();
    }

    private static final void makeCombo$lambda$0(ASCIIMathEditorDialog this$0, Combo $combo, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.extractText();
        MathDialogSettings mathDialogSettings = this$0.settings;
        MathDialogSettings mathDialogSettings2 = this$0.settings;
        String string = $combo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        MathDialogSettings.CATEGORIES cATEGORIES = mathDialogSettings2.getCategoryPrettyName(string);
        Intrinsics.checkNotNull((Object)((Object)cATEGORIES));
        mathDialogSettings.setCurrentName(cATEGORIES);
        this$0.settings.saveSettings();
        this$0.open();
    }

    public static final /* synthetic */ Text access$getSearchTextBox$p(ASCIIMathEditorDialog $this) {
        return $this.searchTextBox;
    }

    public static final /* synthetic */ void access$search(ASCIIMathEditorDialog $this, String text) {
        $this.search(text);
    }

    public static final /* synthetic */ StyledText access$getTextBox$p(ASCIIMathEditorDialog $this) {
        return $this.textBox;
    }

    static {
        SEARCH = localeHandler.get("search");
        OK = localeHandler.get("lblOk");
        CATEGORY_LABEL = localeHandler.get("categoryLabel");
        CLEAR_MATH = localeHandler.get("clear");
        NO_SEARCH_RESULTS = localeHandler.get("noSearchResults");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/brailleblaster/math/ascii/ASCIIMathEditorDialog$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "SETTINGS", "", "BEGINNING_OF_MATH_WARNING", "END_OF_MATH_WARNING", "FULL_SCREEN", "NEXT_MATH", "PREVIOUS_MATH", "REPLACE_CURRENT_MATH", "INSERT_MATH", "PLACEHOLDER", "getPLACEHOLDER", "()Ljava/lang/String;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "sizeLocation", "Lorg/brailleblaster/utils/swt/SizeAndLocation;", "SEARCH", "OK", "CATEGORY_LABEL", "getCATEGORY_LABEL", "CLEAR_MATH", "SEARCH_BOX_LENGTH", "", "NO_SEARCH_RESULTS", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPLACEHOLDER() {
            return PLACEHOLDER;
        }

        @NotNull
        public final String getCATEGORY_LABEL() {
            return CATEGORY_LABEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

