/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.mathml;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;
import org.apache.commons.text.StringEscapeUtils;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.ascii.ASCII2MathML;
import org.brailleblaster.math.mathml.MathUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.spatial.ConnectingContainer;
import org.brailleblaster.math.spatial.Grid;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.views.wp.MathEditHandler;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.MathBraileCode;
import org.brailleblaster.utd.asciimath.AsciiMathConverter;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TextTranslator;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.SWT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VJ\u0012\u0010W\u001a\u00020\"2\b\u0010X\u001a\u0004\u0018\u00010YH\u0007J\u0010\u0010Z\u001a\u00020\"2\b\u0010X\u001a\u0004\u0018\u00010YJ\u0012\u0010[\u001a\u00020\u00072\b\u0010\\\u001a\u0004\u0018\u00010YH\u0007J\u0010\u0010]\u001a\u0004\u0018\u00010Y2\u0006\u0010\\\u001a\u00020YJ\u0010\u0010^\u001a\u00020\"2\u0006\u0010_\u001a\u00020YH\u0007J\u0010\u0010`\u001a\u00020\"2\u0006\u0010U\u001a\u00020VH\u0007J\u0010\u0010a\u001a\u00020Y2\b\u0010\\\u001a\u0004\u0018\u00010YJ\u0012\u0010b\u001a\u0004\u0018\u00010Y2\b\u0010\\\u001a\u0004\u0018\u00010YJ\u000e\u0010c\u001a\u00020T2\u0006\u0010\\\u001a\u00020dJ\u0012\u0010e\u001a\u0004\u0018\u00010Y2\u0006\u0010U\u001a\u00020VH\u0007J\u001a\u0010h\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020Y2\b\b\u0002\u0010i\u001a\u00020\u0007H\u0007J\u000e\u0010j\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u000e\u0010k\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u000e\u0010l\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u000e\u0010m\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u0007J\u0012\u0010n\u001a\u00020\"2\b\u0010\\\u001a\u0004\u0018\u00010YH\u0007J\u000e\u0010o\u001a\u00020d2\u0006\u0010\\\u001a\u00020YJ\u0010\u0010p\u001a\u00020T2\u0006\u0010q\u001a\u00020rH\u0007J\u0006\u0010s\u001a\u00020\"J\u0016\u0010t\u001a\u00020\"2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020xJ\u0016\u0010y\u001a\u00020\"2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020xR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001f\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001fR\u0011\u00100\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001fR\u0011\u00102\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001fR\u0011\u00104\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001fR\u0010\u00106\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001fR\u000e\u00109\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010:\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001fR\u0010\u0010<\u001a\u00020=8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010?\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001fR\u0010\u0010A\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010B\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001fR\u0011\u0010D\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u001fR\u000e\u0010F\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010f\u001a\u00020\"8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bg\u0010\u0003\u001a\u0004\bf\u0010$\u00a8\u0006z"}, d2={"Lorg/brailleblaster/math/mathml/MathModuleUtils;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "MATH_HELP_KEY", "", "ASCII_EDITOR_KEY", "MATH_TOGGLE_KEY", "NEMETH_BLOCK_KEY", "NEMETH_INLINE_KEY", "NEMETH_TOGGLE_KEY", "MATH_TABLE_KEY", "MATRIX_KEY", "NUMBER_LINE_KEY", "NUMERIC_PASSAGE_INLINE_KEY", "NUMERIC_PASSAGE_BLOCK_KEY", "NUMERIC_SERIES_KEY", "NOT_YET_IMPLEMENTED_KEY", "HELP_PREFIX_KEY", "SPATIAL_COMBO_KEY", "TEMPLATES_KEY", "MATH_HELP", "ASCII_EDITOR", "MATH_TOGGLE", "NEMETH_BLOCK", "NEMETH_INLINE", "NEMETH_TOGGLE", "TEMPLATES", "getTEMPLATES", "()Ljava/lang/String;", "SPATIAL_COMBO", "MATHDEBUG", "", "getMATHDEBUG", "()Z", "setMATHDEBUG", "(Z)V", "BASIC_MATH_XML", "getBASIC_MATH_XML", "setBASIC_MATH_XML", "(Ljava/lang/String;)V", "MATH_ATTRIBUTE", "MATHML_NAMESPACE", "MATH_TABLE", "MATRIX", "getMATRIX", "NUMBER_LINE", "getNUMBER_LINE", "NUMERIC_PASSAGE_INLINE", "getNUMERIC_PASSAGE_INLINE", "NUMERIC_PASSAGE_BLOCK", "getNUMERIC_PASSAGE_BLOCK", "NUMERIC_SERIES", "NOT_YET_IMPLEMENTED", "getNOT_YET_IMPLEMENTED", "IMAGE_DESCRIBER_KEY", "IMAGE_DESCRIBER", "getIMAGE_DESCRIBER", "MATH_ACCELERATOR", "", "SPATIAL_MATH_KEY", "SPATIAL_MATH", "getSPATIAL_MATH", "SPATIAL_MATH_WARNING", "END_NEMETH_INDICATOR", "getEND_NEMETH_INDICATOR", "BEGIN_NEMETH_INDICATOR", "getBEGIN_NEMETH_INDICATOR", "STYLE_DEF_SPATIAL_GRID", "STYLE_DEF_SPATIAL_BLOCK_BLANK_AFTER", "STYLE_DEF_OPTION_LINES_AFTER", "STYLE_DEF_TEMPLATE", "STYLE_DEF_NUMBER_LINE", "STYLE_DEF_MATRIX", "NBS", "GRADE_1_PASSAGE_START", "GRADE_1_PASSAGE_END", "LONG_LINE_WARNING", "NUMERIC_BLOCK", "NUMERIC_INLINE", "SPATIAL_MATH_BBX_VERSION", "toggleMath", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "isMath", "currentNode", "Lnu/xom/Node;", "isMathParent", "getMathText", "node", "getBrl", "blockContainsMath", "curBlock", "selectionContainsMath", "getMathParent", "getMathParentOrNull", "setASCIIText", "Lnu/xom/Element;", "makeMathFromSelection", "isNemeth", "isNemeth$annotations", "getBrailleText", "s", "translateMathPrint", "translateAsciiMath", "translateMainPrint", "translateUncontracted", "isSpatialMath", "getSpatialMathParent", "retranslateSpatial", "document", "Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "currentIsSpatialMath", "atBeginningSpatialMath", "curElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "atEndSpatialMath", "brailleblaster-core"})
public final class MathModuleUtils {
    @NotNull
    public static final MathModuleUtils INSTANCE = new MathModuleUtils();
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    public static final String MATH_HELP_KEY = "mathHelp";
    @NotNull
    public static final String ASCII_EDITOR_KEY = "asciiEditor";
    @NotNull
    public static final String MATH_TOGGLE_KEY = "math";
    @NotNull
    public static final String NEMETH_BLOCK_KEY = "nemethBlock";
    @NotNull
    public static final String NEMETH_INLINE_KEY = "nemethInline";
    @NotNull
    public static final String NEMETH_TOGGLE_KEY = "nemethIndicators";
    @NotNull
    public static final String MATH_TABLE_KEY = "mathTable";
    @NotNull
    public static final String MATRIX_KEY = "matrix";
    @NotNull
    public static final String NUMBER_LINE_KEY = "numberLine";
    @NotNull
    public static final String NUMERIC_PASSAGE_INLINE_KEY = "numericInline";
    @NotNull
    public static final String NUMERIC_PASSAGE_BLOCK_KEY = "numericBlock";
    @NotNull
    public static final String NUMERIC_SERIES_KEY = "numericSeries";
    @NotNull
    public static final String NOT_YET_IMPLEMENTED_KEY = "notYetImplemented";
    @NotNull
    public static final String HELP_PREFIX_KEY = "mhelp.";
    @NotNull
    public static final String SPATIAL_COMBO_KEY = "spatialMath";
    @NotNull
    public static final String TEMPLATES_KEY = "mathTemplate";
    @JvmField
    @NotNull
    public static final String MATH_HELP = localeHandler.get("mathHelp");
    @JvmField
    @NotNull
    public static final String ASCII_EDITOR = localeHandler.get("asciiEditor");
    @JvmField
    @NotNull
    public static final String MATH_TOGGLE = localeHandler.get("math");
    @JvmField
    @NotNull
    public static final String NEMETH_BLOCK = localeHandler.get("nemethBlock");
    @JvmField
    @NotNull
    public static final String NEMETH_INLINE = localeHandler.get("nemethInline");
    @JvmField
    @NotNull
    public static final String NEMETH_TOGGLE = localeHandler.get("nemethIndicators");
    @NotNull
    private static final String TEMPLATES = localeHandler.get("mathTemplate");
    @JvmField
    @NotNull
    public static final String SPATIAL_COMBO = localeHandler.get("spatialMath");
    private static boolean MATHDEBUG;
    @NotNull
    private static String BASIC_MATH_XML;
    @NotNull
    public static final String MATH_ATTRIBUTE = "alttext";
    @NotNull
    public static final String MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @JvmField
    @NotNull
    public static final String MATH_TABLE;
    @NotNull
    private static final String MATRIX;
    @NotNull
    private static final String NUMBER_LINE;
    @NotNull
    private static final String NUMERIC_PASSAGE_INLINE;
    @NotNull
    private static final String NUMERIC_PASSAGE_BLOCK;
    @JvmField
    @NotNull
    public static final String NUMERIC_SERIES;
    @NotNull
    private static final String NOT_YET_IMPLEMENTED;
    @NotNull
    public static final String IMAGE_DESCRIBER_KEY = "imageDescriber";
    @NotNull
    private static final String IMAGE_DESCRIBER;
    @JvmField
    public static final int MATH_ACCELERATOR;
    @NotNull
    public static final String SPATIAL_MATH_KEY = "spatialMath";
    @NotNull
    private static final String SPATIAL_MATH;
    @JvmField
    @NotNull
    public static final String SPATIAL_MATH_WARNING;
    @NotNull
    private static final String END_NEMETH_INDICATOR;
    @NotNull
    private static final String BEGIN_NEMETH_INDICATOR;
    @NotNull
    public static final String STYLE_DEF_SPATIAL_GRID = "Spatial Grid";
    @NotNull
    public static final String STYLE_DEF_SPATIAL_BLOCK_BLANK_AFTER = "Spatial Math Line Break";
    @NotNull
    public static final String STYLE_DEF_OPTION_LINES_AFTER = "linesAfter";
    @NotNull
    public static final String STYLE_DEF_TEMPLATE = "Template";
    @NotNull
    public static final String STYLE_DEF_NUMBER_LINE = "Number Line";
    @NotNull
    public static final String STYLE_DEF_MATRIX = "Matrix";
    @NotNull
    public static final String NBS = "\u00a0";
    @NotNull
    public static final String GRADE_1_PASSAGE_START = ";;;";
    @NotNull
    public static final String GRADE_1_PASSAGE_END = ";'";
    @JvmField
    @NotNull
    public static final String LONG_LINE_WARNING;
    @JvmField
    @NotNull
    public static final String NUMERIC_BLOCK;
    @JvmField
    @NotNull
    public static final String NUMERIC_INLINE;
    @NotNull
    public static final String SPATIAL_MATH_BBX_VERSION = "2";

    private MathModuleUtils() {
    }

    @NotNull
    public final String getTEMPLATES() {
        return TEMPLATES;
    }

    public final boolean getMATHDEBUG() {
        return MATHDEBUG;
    }

    public final void setMATHDEBUG(boolean bl) {
        MATHDEBUG = bl;
    }

    @NotNull
    public final String getBASIC_MATH_XML() {
        return BASIC_MATH_XML;
    }

    public final void setBASIC_MATH_XML(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        BASIC_MATH_XML = string;
    }

    @NotNull
    public final String getMATRIX() {
        return MATRIX;
    }

    @NotNull
    public final String getNUMBER_LINE() {
        return NUMBER_LINE;
    }

    @NotNull
    public final String getNUMERIC_PASSAGE_INLINE() {
        return NUMERIC_PASSAGE_INLINE;
    }

    @NotNull
    public final String getNUMERIC_PASSAGE_BLOCK() {
        return NUMERIC_PASSAGE_BLOCK;
    }

    @NotNull
    public final String getNOT_YET_IMPLEMENTED() {
        return NOT_YET_IMPLEMENTED;
    }

    @NotNull
    public final String getIMAGE_DESCRIBER() {
        return IMAGE_DESCRIBER;
    }

    @NotNull
    public final String getSPATIAL_MATH() {
        return SPATIAL_MATH;
    }

    @NotNull
    public final String getEND_NEMETH_INDICATOR() {
        return END_NEMETH_INDICATOR;
    }

    @NotNull
    public final String getBEGIN_NEMETH_INDICATOR() {
        return BEGIN_NEMETH_INDICATOR;
    }

    public final void toggleMath(@NotNull Manager m) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                if (m.getTextView().getSelectionCount() < 1) break block5;
                String string = m.getTextView().getSelectionText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSelectionText(...)");
                if (!StringsKt.isBlank((CharSequence)string)) break block6;
            }
            return;
        }
        if (MathModuleUtils.selectionContainsMath(m)) {
            MathUtils.removeMathInSelectedRange(m);
        } else {
            MathEditHandler.INSTANCE.makeMathFromTextViewSelection();
        }
    }

    @JvmStatic
    public static final boolean isMath(@Nullable Node currentNode) {
        return currentNode instanceof Element && Intrinsics.areEqual((Object)((Element)currentNode).getLocalName(), (Object)MATH_TOGGLE_KEY) || currentNode != null && XMLHandler.Companion.ancestorElementIs(currentNode, MathModuleUtils::isMath$lambda$0);
    }

    public final boolean isMathParent(@Nullable Node currentNode) {
        return currentNode instanceof Element && Intrinsics.areEqual((Object)((Element)currentNode).getLocalName(), (Object)MATH_TOGGLE_KEY);
    }

    @JvmStatic
    @NotNull
    public static final String getMathText(@Nullable Node node) {
        String string = node instanceof Element ? ((Element)node).getAttributeValue(MATH_ATTRIBUTE) : "";
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public final Node getBrl(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Node n = null;
        int n2 = node.getParent().getChildCount();
        for (int i = 0; i < n2; ++i) {
            if (!UTDElements.BRL.isA(node.getParent().getChild(i))) continue;
            n = node.getParent().getChild(i);
            break;
        }
        return n;
    }

    @JvmStatic
    public static final boolean blockContainsMath(@NotNull Node curBlock) {
        Intrinsics.checkNotNullParameter((Object)curBlock, (String)"curBlock");
        if (curBlock.getChildCount() > 0) {
            int n = curBlock.getChildCount();
            for (int i = 0; i < n; ++i) {
                Node node = curBlock.getChild(i);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getChild(...)");
                if (!MathModuleUtils.blockContainsMath(node)) continue;
                return true;
            }
            return false;
        }
        return MathModuleUtils.isMath(curBlock);
    }

    @JvmStatic
    public static final boolean selectionContainsMath(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Set<TextMapElement> tmes = m.getMapList().getElementsOneByOne(m.getTextView().getSelection().x, m.getTextView().getSelection().y);
        for (TextMapElement tme : tmes) {
            if (!MathModuleUtils.isMath(tme.getNode())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Node getMathParent(@Nullable Node node) {
        Node node2;
        Node node3 = node2 = this.getMathParentOrNull(node);
        if (node3 == null) {
            throw new NoSuchElementException();
        }
        return node3;
    }

    @Nullable
    public final Node getMathParentOrNull(@Nullable Node node) {
        Node node2;
        for (node2 = node; node2 != null && !this.isMathParent(node2); node2 = (Node)node2.getParent()) {
        }
        return node2;
    }

    public final void setASCIIText(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Attribute att = new Attribute(MATH_ATTRIBUTE, AsciiMathConverter.INSTANCE.toAsciiMath(new Nodes((Node)node), true));
        node.addAttribute(att);
    }

    @JvmStatic
    @Nullable
    public static final Node makeMathFromSelection(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        String selectedText = m.getTextView().getSelectionText();
        Intrinsics.checkNotNull((Object)selectedText);
        if (((CharSequence)selectedText).length() == 0) {
            return null;
        }
        Node n = ASCII2MathML.translate(selectedText);
        Element inline = BBX.INLINE.MATHML.create();
        inline.appendChild(n);
        return (Node)inline;
    }

    public static final boolean isNemeth() {
        return MathBraileCode.Nemeth == WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathBrailleCode();
    }

    @JvmStatic
    public static /* synthetic */ void isNemeth$annotations() {
    }

    @JvmOverloads
    @NotNull
    public final String getBrailleText(@NotNull Node node, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder sb = new StringBuilder(s);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (UTDElements.BRL.isA(node.getChild(i))) {
                Node brailleNode = node.getChild(i);
                int n2 = brailleNode.getChildCount();
                for (int j = 0; j < n2; ++j) {
                    Node brailleNodeChild = brailleNode.getChild(j);
                    if (!(brailleNodeChild instanceof Text)) continue;
                    sb.append(((Text)brailleNodeChild).getValue());
                }
            }
            Node node2 = node.getChild(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getChild(...)");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            sb = new StringBuilder(this.getBrailleText(node2, string));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getBrailleText$default(MathModuleUtils mathModuleUtils, Node node, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return mathModuleUtils.getBrailleText(node, string);
    }

    @NotNull
    public final String translateMathPrint(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String s2 = s;
        String translated = null;
        if (MathModuleUtils.isNemeth()) {
            if (Intrinsics.areEqual((Object)s2, (Object)"\u00d7")) {
                s2 = "\u00b7";
            }
            translated = TextTranslator.translateText((String)s2, (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, (BrailleTableType)BrailleTableType.MATH);
        } else {
            CharSequence charSequence = TextTranslator.translateText$default((String)s2, (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            Regex regex = new Regex("#");
            String string = "";
            translated = regex.replace(charSequence, string);
        }
        return translated;
    }

    @NotNull
    public final String translateAsciiMath(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Node mathNode = ASCII2MathML.translate(s);
        Element ele = BBX.INLINE.MATHML.create();
        ele.appendChild(mathNode);
        WPManager.Companion.getInstance().getController().getDocument().getSettingsManager().getEngine().expectedTranslate = true;
        UTDManager.BBUTDTranslationEngine bBUTDTranslationEngine = WPManager.Companion.getInstance().getController().getDocument().getSettingsManager().getEngine();
        Intrinsics.checkNotNull((Object)ele);
        Nodes nodes = bBUTDTranslationEngine.translate((Node)ele);
        WPManager.Companion.getInstance().getController().getDocument().getSettingsManager().getEngine().expectedTranslate = false;
        Node node = nodes.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"get(...)");
        return MathModuleUtils.getBrailleText$default(this, node, null, 2, null);
    }

    @NotNull
    public final String translateMainPrint(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return TextTranslator.translateText$default((String)s, (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
    }

    @NotNull
    public final String translateUncontracted(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return TextTranslator.translateText((String)s, (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, (BrailleTableType)BrailleTableType.UNCONTRACTED);
    }

    @JvmStatic
    public static final boolean isSpatialMath(@Nullable Node node) {
        return node != null && (XMLHandler.Companion.ancestorVisitorElement(node, MathModuleUtils::isSpatialMath$lambda$0) != null || XMLHandler.Companion.ancestorVisitorElement(node, MathModuleUtils::isSpatialMath$lambda$1) != null || XMLHandler.Companion.ancestorVisitorElement(node, MathModuleUtils::isSpatialMath$lambda$2) != null || XMLHandler.Companion.ancestorVisitorElement(node, MathModuleUtils::isSpatialMath$lambda$3) != null || XMLHandler.Companion.ancestorVisitorElement(node, MathModuleUtils::isSpatialMath$lambda$4) != null);
    }

    @NotNull
    public final Element getSpatialMathParent(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element element = XMLHandler.Companion.ancestorVisitorElement(node, MathModuleUtils::getSpatialMathParent$lambda$0);
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @JvmStatic
    public static final void retranslateSpatial(@NotNull BrailleDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List nodes = XMLHandler.Companion.queryElements((Node)document.doc, "//*[@bb:type='TEMPLATE']", new Object[0]);
        for (Object n : nodes) {
            Template.Companion.initialize((Node)n);
        }
        List nodes2 = XMLHandler.Companion.queryElements((Node)document.doc, "//*[@bb:type='MATRIX']", new Object[0]);
        for (Object n : nodes2) {
            Matrix.Companion.initialize((Node)n);
        }
        List nodes3 = XMLHandler.Companion.queryElements((Node)document.doc, "//*[@bb:type='NUMBER_LINE']", new Object[0]);
        for (Object n : nodes3) {
            NumberLine.Companion.initialize((Node)n);
        }
        List nodes4 = XMLHandler.Companion.queryElements((Node)document.doc, "//*[@bb:type='CONNECTING_CONTAINER']", new Object[0]);
        for (Element n : nodes4) {
            ConnectingContainer.Companion.initialize((Node)n);
        }
        List nodes6 = XMLHandler.Companion.queryElements((Node)document.doc, "//*[@bb:type='SPATIAL_GRID']", new Object[0]);
        for (Element n : nodes6) {
            Grid.Companion.initialize((Node)n);
        }
    }

    public final boolean currentIsSpatialMath() {
        return SpatialMathUtils.currentIsSpatialGrid() || Matrix.Companion.currentIsMatrix() || NumberLine.Companion.currentIsNumberLine();
    }

    public final boolean atBeginningSpatialMath(@NotNull TextMapElement curElement, @NotNull MapList list) {
        TextMapElement previous;
        Intrinsics.checkNotNullParameter((Object)curElement, (String)"curElement");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        if (!MathModuleUtils.isSpatialMath(curElement.getNode())) {
            return false;
        }
        int index = list.indexOf(curElement);
        if (index == 0) {
            return true;
        }
        if ((previous = list.findPreviousNonWhitespace(--index)) != null && MathModuleUtils.isSpatialMath(previous.getNode())) {
            Node node = previous.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element previousParent = this.getSpatialMathParent(node);
            Node node2 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
            Element thisParent = this.getSpatialMathParent(node2);
            return !Intrinsics.areEqual((Object)previousParent, (Object)thisParent);
        }
        return true;
    }

    public final boolean atEndSpatialMath(@NotNull TextMapElement curElement, @NotNull MapList list) {
        TextMapElement nextElement;
        Intrinsics.checkNotNullParameter((Object)curElement, (String)"curElement");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        if (!MathModuleUtils.isSpatialMath(curElement.getNode())) {
            return false;
        }
        int index = list.indexOf(curElement);
        if (index == list.size() - 1) {
            return true;
        }
        if (MathModuleUtils.isSpatialMath((nextElement = list.findNextNonWhitespace(++index)).getNode())) {
            Node node = nextElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element previousParent = this.getSpatialMathParent(node);
            Node node2 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
            Element thisParent = this.getSpatialMathParent(node2);
            return !Intrinsics.areEqual((Object)previousParent, (Object)thisParent);
        }
        return true;
    }

    @JvmOverloads
    @NotNull
    public final String getBrailleText(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return MathModuleUtils.getBrailleText$default(this, node, null, 2, null);
    }

    private static final boolean isMath$lambda$0(Element n) {
        return n != null && Intrinsics.areEqual((Object)n.getLocalName(), (Object)MATH_TOGGLE_KEY);
    }

    private static final boolean isSpatialMath$lambda$0(Element node) {
        return BBX.CONTAINER.MATRIX.isA((Node)node);
    }

    private static final boolean isSpatialMath$lambda$1(Element node) {
        return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
    }

    private static final boolean isSpatialMath$lambda$2(Element node) {
        return BBX.CONTAINER.CONNECTING_CONTAINER.isA((Node)node);
    }

    private static final boolean isSpatialMath$lambda$3(Element node) {
        return BBX.CONTAINER.TEMPLATE.isA((Node)node);
    }

    private static final boolean isSpatialMath$lambda$4(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    private static final boolean getSpatialMathParent$lambda$0(Element node) {
        return BBX.CONTAINER.isA((Node)node);
    }

    static {
        String string = StringEscapeUtils.escapeJava((String)"<math xmlns=\"http://www.w3.org/1998/Math/MathML\"><mn>0</mn></math>");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeJava(...)");
        BASIC_MATH_XML = string;
        MATH_TABLE = localeHandler.get(MATH_TABLE_KEY);
        MATRIX = localeHandler.get(MATRIX_KEY);
        NUMBER_LINE = localeHandler.get(NUMBER_LINE_KEY);
        NUMERIC_PASSAGE_INLINE = localeHandler.get(NUMERIC_PASSAGE_INLINE_KEY);
        NUMERIC_PASSAGE_BLOCK = localeHandler.get(NUMERIC_PASSAGE_BLOCK_KEY);
        NUMERIC_SERIES = localeHandler.get(NUMERIC_SERIES_KEY);
        NOT_YET_IMPLEMENTED = localeHandler.get(NOT_YET_IMPLEMENTED_KEY);
        IMAGE_DESCRIBER = localeHandler.get(IMAGE_DESCRIBER_KEY);
        MATH_ACCELERATOR = SWT.MOD1 + 77;
        SPATIAL_MATH = localeHandler.get("spatialMath");
        SPATIAL_MATH_WARNING = localeHandler.get("spatialMathWarningUseEditor");
        END_NEMETH_INDICATOR = localeHandler.get("endNemethIndicator");
        BEGIN_NEMETH_INDICATOR = localeHandler.get("beginNemethIndicator");
        LONG_LINE_WARNING = localeHandler.get("lineTooLongWarning");
        NUMERIC_BLOCK = localeHandler.get(NUMERIC_PASSAGE_BLOCK_KEY);
        NUMERIC_INLINE = localeHandler.get(NUMERIC_PASSAGE_INLINE_KEY);
    }
}

