/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.mathml;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.converter.Converter;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/math/mathml/MathRenderer;", "", "<init>", "()V", "COLOR_ENTRIES", "", "BITS_PER_PIXEL", "PALETTE_BGR", "Lorg/eclipse/swt/graphics/PaletteData;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "converter", "Lnet/sourceforge/jeuclid/converter/Converter;", "render", "Lorg/eclipse/swt/graphics/ImageData;", "document", "Lorg/w3c/dom/Node;", "layoutContext", "Lnet/sourceforge/jeuclid/LayoutContext;", "brailleblaster-core"})
public final class MathRenderer {
    @NotNull
    public static final MathRenderer INSTANCE = new MathRenderer();
    private static final int COLOR_ENTRIES = 3;
    private static final int BITS_PER_PIXEL = 24;
    @NotNull
    private static final PaletteData PALETTE_BGR = new PaletteData(255, 65280, 0xFF0000);
    private static final Logger logger = LoggerFactory.getLogger(MathRenderer.class);
    private static final Converter converter = Converter.getInstance();

    private MathRenderer() {
    }

    @Nullable
    public final ImageData render(@Nullable Node document, @NotNull LayoutContext layoutContext) {
        ImageData imageData;
        Intrinsics.checkNotNullParameter((Object)layoutContext, (String)"layoutContext");
        if (document != null) {
            ImageData imageData2;
            try {
                BufferedImage bi = converter.render(document, layoutContext, 5);
                WritableRaster r = bi.getRaster();
                DataBuffer dataBuffer = r.getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
                DataBufferByte b = (DataBufferByte)dataBuffer;
                byte[] data = b.getData();
                int w = bi.getWidth();
                imageData2 = new ImageData(w, bi.getHeight(), 24, PALETTE_BGR, 3 * w, data);
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                imageData2 = null;
            }
            imageData = imageData2;
        } else {
            imageData = null;
        }
        return imageData;
    }
}

