/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineFormatter;
import org.brailleblaster.math.numberLine.NumberLineLine;
import org.brailleblaster.math.numberLine.NumberLineMathUtils;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.mwhapples.jlouis.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/brailleblaster/math/numberLine/NemethNumberLineFormatter;", "", "<init>", "()V", "Companion", "brailleblaster-core"})
public class NemethNumberLineFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static Logger log;

    @JvmStatic
    protected static final void formatMultiplePoints(@NotNull NumberLine numberLine) {
        Companion.formatMultiplePoints(numberLine);
    }

    static {
        Logger logger = LoggerFactory.getLogger(NemethNumberLineFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0005J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/brailleblaster/math/numberLine/NemethNumberLineFormatter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "setLog", "(Lorg/slf4j/Logger;)V", "formatSegment", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "formatLine", "formatPoints", "cellsPerLine", "", "getStretchCells", "getBrailleFraction", "", "fraction", "Lorg/apache/commons/lang3/math/Fraction;", "makeImproperFractionString", "format", "", "formatMultiplePoints", "determineOverflow", "makeMixedFractionString", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nNemethNumberLineFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NemethNumberLineFormatter.kt\norg/brailleblaster/math/numberLine/NemethNumberLineFormatter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,454:1\n742#2,9:455\n37#3,2:464\n*S KotlinDebug\n*F\n+ 1 NemethNumberLineFormatter.kt\norg/brailleblaster/math/numberLine/NemethNumberLineFormatter$Companion\n*L\n229#1:455,9\n229#1:464,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public final void setLog(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
            log = logger;
        }

        public final void formatSegment(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int startInterval = numberLine.getSegment().getStartInterval();
            int endInterval = numberLine.getSegment().getEndInterval();
            int countOfIntervals = 0;
            Line line = new Line();
            ArrayList<NumberLinePoint> array = numberLine.getPoints();
            if (numberLine.getSettings().isStartOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(2));
            } else if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(1));
            }
            int n = ((Collection)array).size();
            for (int i = 0; i < n; ++i) {
                NumberLinePoint mathText;
                Intrinsics.checkNotNullExpressionValue((Object)array.get(i), (String)"get(...)");
                boolean bl = i != 0 ? line.getElements().add(line.getWhitespaceSegment(mathText.getLeftPadding() + mathText.getLeftDec().length())) : line.getElements().add(line.getWhitespaceSegment(1));
                int n2 = ++countOfIntervals;
                boolean bl2 = n2 == startInterval ? line.getElements().add(line.getTextSegment(NumberLineFormatter.Companion.getSegmentBeginning(numberLine))) : (n2 == endInterval ? line.getElements().add(line.getTextSegment(NumberLineFormatter.Companion.getSegmentEnding(numberLine))) : line.getElements().add(line.getWhitespaceSegment(1)));
                boolean bl3 = i != array.size() - 1 ? line.getElements().add(line.getWhitespaceSegment(mathText.getRightPadding() + mathText.getRightDec().length())) : line.getElements().add(line.getWhitespaceSegment(mathText.getRightDec().length()));
            }
            if (numberLine.getSettings().isEndOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(2));
            }
            if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(1));
            }
            ((ArrayList)numberLine.getLines()).add(line);
            if (!numberLine.getSegment().isPoint()) {
                boolean inSegment = numberLine.getSettings().isStartOverflow();
                countOfIntervals = 0;
                int n3 = ((Collection)numberLine.getLine()).size();
                for (int i = 0; i < n3; ++i) {
                    NumberLineLine lineSegment;
                    Intrinsics.checkNotNullExpressionValue((Object)numberLine.getLine().get(i), (String)"get(...)");
                    NumberLineLine.LineChar c = lineSegment.getType();
                    if (c == NumberLineLine.LineChar.INTERVAL) {
                        if (++countOfIntervals == startInterval) {
                            inSegment = true;
                            continue;
                        }
                        if (countOfIntervals != endInterval) continue;
                        inSegment = false;
                        continue;
                    }
                    if (NumberLineLine.LineChar.Companion.isArrow(c) || !inSegment) continue;
                    lineSegment.setType(NumberLineLine.LineChar.LINE_FILL);
                }
            }
        }

        public final void formatLine(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ArrayList<NumberLinePoint> array = numberLine.getPoints();
            ArrayList<NumberLineLine> lineChars = new ArrayList<NumberLineLine>();
            if (numberLine.getSettings().isStartOverflow()) {
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.DOUBLE_ARROW_START));
            } else if (numberLine.getSettings().isArrow()) {
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.ARROW_START));
            }
            int n = ((Collection)array).size();
            for (int i = 0; i < n; ++i) {
                NumberLinePoint mathText;
                Intrinsics.checkNotNullExpressionValue((Object)array.get(i), (String)"get(...)");
                boolean bl = i != 0 ? lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, mathText.getLeftPadding() + mathText.getLeftDec().length())) : lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY));
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.INTERVAL));
                boolean bl2 = i != array.size() - 1 ? lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, mathText.getRightPadding() + mathText.getRightDec().length())) : lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, numberLine.getLastIntervalLength()));
            }
            if (numberLine.getSettings().isEndOverflow()) {
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.DOUBLE_ARROW_END));
            } else if (numberLine.getSettings().isArrow()) {
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.ARROW_END));
            }
            numberLine.setLine(lineChars);
        }

        public final void formatPoints(@NotNull NumberLine numberLine, int cellsPerLine) throws MathFormattingException {
            int addedCells;
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ArrayList<NumberLinePoint> points = new ArrayList<NumberLinePoint>();
            Fraction interval = numberLine.getNumberLineText().getInterval().getFraction();
            Fraction lineStart = numberLine.getNumberLineText().getLineStart().getFraction();
            Fraction lineEnd = numberLine.getNumberLineText().getLineEnd().getFraction();
            int totalUnits = (int)lineEnd.subtract(lineStart).divideBy(interval).doubleValue() + 1;
            for (int i = 0; i < totalUnits; ++i) {
                Fraction fraction;
                if (i != 0) {
                    Fraction additionalUnits = interval.multiplyBy(Fraction.getFraction((double)i));
                    Fraction fraction2 = lineStart.add(additionalUnits);
                    Intrinsics.checkNotNull((Object)fraction2);
                    fraction = fraction2;
                } else {
                    fraction = lineStart;
                }
                Fraction fraction3 = fraction;
                String string = NumberLineMathUtils.INSTANCE.getFractionString(numberLine, fraction3);
                String braille = this.getBrailleFraction(numberLine, fraction3);
                MathText mathText = new MathText(string, braille, false, 4, null);
                boolean bl = fraction3.doubleValue() < 0.0;
                points.add(new NumberLinePoint(bl, fraction3, mathText, false, 8, null));
            }
            numberLine.setPoints(points);
            NumberLineFormatter.Companion.dealWithBlanks(numberLine);
            NumberLinePoint.Companion.makeColumnsEqualWidth(points);
            if (numberLine.getSettings().isStretch() && (addedCells = this.getStretchCells(numberLine, cellsPerLine)) > 0) {
                int n = ((Collection)numberLine.getPoints()).size();
                for (int i = 0; i < n; ++i) {
                    NumberLinePoint numberLinePoint = numberLine.getPoints().get(i);
                    numberLinePoint.setRightPadding(numberLinePoint.getRightPadding() + addedCells);
                }
            }
        }

        public final int getStretchCells(@NotNull NumberLine numberLine, int cellsPerLine) throws MathFormattingException {
            int addedCells;
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            this.formatLine(numberLine);
            int necessaryCells = NumberLineLine.Companion.getLineLength(numberLine.getLine());
            int leftoverCells = cellsPerLine - necessaryCells;
            int intervals = (int)Math.floor(numberLine.getNumberLineText().getLineEnd().getFraction().subtract(numberLine.getNumberLineText().getLineStart().getFraction()).doubleValue());
            if (leftoverCells > intervals && (addedCells = leftoverCells / intervals) > 0) {
                return addedCells;
            }
            return 0;
        }

        private final String getBrailleFraction(NumberLine numberLine, Fraction fraction) {
            Object string = null;
            String number = "";
            return switch (WhenMappings.$EnumSwitchMapping$0[numberLine.getSettings().getIntervalType().ordinal()]) {
                case 1 -> {
                    string = String.valueOf(fraction.intValue());
                    try {
                        String v0 = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), (String)string, 0);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"translateString(...)");
                        number = v0;
                    }
                    catch (TranslationException e) {
                        e.printStackTrace();
                    }
                    yield number;
                }
                case 2 -> {
                    if (numberLine.getSettings().isRemoveLeadingZeros()) {
                        void $this$toTypedArray$iv;
                        List v2;
                        Collection $this$dropLastWhile$iv;
                        string = String.valueOf(fraction.doubleValue());
                        Object var6_10 = (CharSequence)string;
                        Regex var7_11 = new Regex("\\.");
                        int var8_13 = 0;
                        var6_10 = var7_11.split((CharSequence)var6_10, var8_13);
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                String it = (String)iterator$iv.previous();
                                boolean $i$a$-dropLastWhile-NemethNumberLineFormatter$Companion$getBrailleFraction$array$1 = false;
                                if (((CharSequence)it).length() == 0) continue;
                                v2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            v2 = CollectionsKt.emptyList();
                        }
                        $this$dropLastWhile$iv = v2;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        String[] array = thisCollection$iv.toArray(new String[0]);
                        if (array.length > 1 && Integer.parseInt(array[0]) == 0) {
                            string = "." + array[1];
                        }
                    } else {
                        string = String.valueOf(fraction.doubleValue());
                    }
                    try {
                        this.getLog().error("Fraction string " + (String)string);
                        String v3 = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), (String)string, 0);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"translateString(...)");
                        number = v3;
                    }
                    catch (TranslationException e) {
                        e.printStackTrace();
                    }
                    yield number;
                }
                case 3 -> {
                    Fraction var5_8 = numberLine.getSettings().isReduceFraction() ? fraction.reduce() : NumberLineMathUtils.INSTANCE.unReduce(numberLine, fraction);
                    Intrinsics.checkNotNull((Object)var5_8);
                    yield this.makeMixedFractionString(numberLine, var5_8);
                }
                default -> {
                    Fraction var5_9 = numberLine.getSettings().isReduceFraction() ? fraction.reduce() : NumberLineMathUtils.INSTANCE.unReduce(numberLine, fraction);
                    Intrinsics.checkNotNull((Object)var5_9);
                    yield this.makeImproperFractionString(numberLine, var5_9);
                }
            };
        }

        private final String makeImproperFractionString(NumberLine numberLine, Fraction fraction) {
            Object string = "";
            boolean negative = fraction.doubleValue() < 0.0;
            try {
                Object object;
                String whole = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), String.valueOf(Math.abs(fraction.getProperWhole())), 0);
                String numerator = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), String.valueOf(Math.abs(fraction.getNumerator())), 0);
                String denominator = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), String.valueOf(Math.abs(fraction.getDenominator())), 0);
                String fractionString = numberLine.getSettings().isBeveledFraction() ? "_/" : "/";
                boolean canReduceToWhole = false;
                Fraction wholeFrac = Fraction.getFraction((double)fraction.getProperWhole());
                Fraction numDenFrac = Fraction.getFraction((String)(fraction.getNumerator() + "/" + fraction.getDenominator()));
                if (wholeFrac.compareTo(numDenFrac) == 0) {
                    canReduceToWhole = true;
                }
                if (canReduceToWhole && numberLine.getSettings().isReduceFraction()) {
                    String string2 = whole;
                    Intrinsics.checkNotNull((Object)string2);
                    object = string2;
                } else {
                    object = "?" + numerator + fractionString + denominator + "#";
                }
                string = object;
            }
            catch (TranslationException e) {
                e.printStackTrace();
            }
            return negative ? "\u2112" + (String)string : string;
        }

        public final boolean format(@NotNull NumberLine numberLine) throws MathFormattingException {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            this.determineOverflow(numberLine);
            int cellsPerLine = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
            this.formatPoints(numberLine, cellsPerLine);
            NumberLineFormatter.Companion.verticallyAlignLabelsAndPoints(numberLine);
            this.formatLine(numberLine);
            if (numberLine.getSettings().getSectionType() == SpatialMathEnum.NumberLineSection.POINTS) {
                NemethNumberLineFormatter.formatMultiplePoints(numberLine);
            } else if (numberLine.shouldFormatSegment()) {
                this.formatSegment(numberLine);
            }
            NumberLineFormatter.Companion.addLine(numberLine);
            if (!NumberLineFormatter.Companion.addPoints(numberLine)) {
                return false;
            }
            NumberLineFormatter.Companion.addLabels(numberLine);
            return true;
        }

        @JvmStatic
        protected final void formatMultiplePoints(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            Line line = new Line();
            ArrayList<NumberLinePoint> array = numberLine.getPoints();
            if (numberLine.getSettings().isStartOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(2));
            } else if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(1));
            }
            Iterator iterator = ((Iterable)array).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                NumberLinePoint mathText = (NumberLinePoint)iterator.next();
                int interval = i + 1;
                boolean bl = i != 0 ? line.getElements().add(line.getWhitespaceSegment(mathText.getLeftPadding() + mathText.getLeftDec().length())) : line.getElements().add(line.getWhitespaceSegment(1));
                if (NumberLineSegmentPoint.Companion.hasPoint(numberLine, interval)) {
                    ArrayList<Line.Segment> arrayList = line.getElements();
                    NumberLineSegmentPoint numberLineSegmentPoint = NumberLineSegmentPoint.Companion.getPointFromIndex(numberLine, interval);
                    Intrinsics.checkNotNull((Object)numberLineSegmentPoint);
                    v3 = arrayList.add(line.getTextSegment(NumberLineFormatter.Companion.getSegmentBeginning(numberLineSegmentPoint)));
                } else {
                    v3 = line.getElements().add(line.getWhitespaceSegment(1));
                }
                boolean bl2 = i != array.size() - 1 ? line.getElements().add(line.getWhitespaceSegment(mathText.getRightPadding() + mathText.getRightDec().length())) : line.getElements().add(line.getWhitespaceSegment(mathText.getRightDec().length()));
            }
            if (numberLine.getSettings().isEndOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(2));
            }
            if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(1));
            }
            ((ArrayList)numberLine.getLines()).add(line);
        }

        public final void determineOverflow(@NotNull NumberLine numberLine) throws MathFormattingException {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            if (numberLine.shouldFormatSegment()) {
                Fraction endLineFraction = numberLine.getNumberLineText().getLineEnd().getFraction();
                Fraction startSegmentFraction = numberLine.getNumberLineText().getSegment().getSegmentStart().getFraction();
                Fraction startLineFraction = numberLine.getNumberLineText().getLineStart().getFraction();
                Fraction endSegmentFraction = numberLine.getNumberLineText().getSegment().getSegmentEnd().getFraction();
                if (startSegmentFraction.subtract(startLineFraction).doubleValue() < 0.0) {
                    numberLine.getSettings().setStartOverflow(true);
                }
                if (endSegmentFraction.subtract(endLineFraction).doubleValue() > 0.0) {
                    numberLine.getSettings().setEndOverflow(true);
                }
            }
        }

        private final String makeMixedFractionString(NumberLine numberLine, Fraction fraction) {
            Object string = "";
            boolean negative = fraction.doubleValue() < 0.0;
            try {
                Object object;
                String whole = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), String.valueOf(Math.abs(fraction.getProperWhole())), 0);
                String numerator = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), String.valueOf(Math.abs(fraction.getProperNumerator())), 0);
                String denominator = WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleTranslator().translateString(WPManager.Companion.getInstance().getController().getDocument().getEngine().getBrailleSettings().getMathTextTable(), String.valueOf(Math.abs(fraction.getDenominator())), 0);
                String fractionString = numberLine.getSettings().isBeveledFraction() ? "_/" : "/";
                boolean canReduceToWhole = false;
                Fraction wholeFrac = Fraction.getFraction((double)fraction.getProperWhole());
                Fraction numDenFrac = Fraction.getFraction((String)(fraction.getNumerator() + "/" + fraction.getDenominator()));
                if (wholeFrac.compareTo(numDenFrac) == 0) {
                    canReduceToWhole = true;
                }
                if (canReduceToWhole && numberLine.getSettings().isReduceFraction()) {
                    String string2 = whole;
                    Intrinsics.checkNotNull((Object)string2);
                    object = string2;
                } else {
                    object = wholeFrac.getProperWhole() == 0 ? "?" + numerator + fractionString + denominator + "#" : whole + "_?" + numerator + fractionString + denominator + "_#";
                }
                string = object;
            }
            catch (TranslationException e) {
                e.printStackTrace();
            }
            return negative ? "\u2112" + (String)string : string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SpatialMathEnum.IntervalType.values().length];
                try {
                    nArray[SpatialMathEnum.IntervalType.WHOLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.IntervalType.DECIMAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.IntervalType.MIXED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

