/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.numberLine.NemethNumberLineFormatter;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineFormatter;
import org.brailleblaster.math.numberLine.NumberLineLine;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/math/numberLine/NemethUserDefinedFormatter;", "Lorg/brailleblaster/math/numberLine/NemethNumberLineFormatter;", "<init>", "()V", "formatPoints", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "cellsPerLine", "", "getStretchCells", "format", "", "brailleblaster-core"})
public final class NemethUserDefinedFormatter
extends NemethNumberLineFormatter {
    @NotNull
    public static final NemethUserDefinedFormatter INSTANCE = new NemethUserDefinedFormatter();

    private NemethUserDefinedFormatter() {
    }

    private final void formatPoints(NumberLine numberLine, int cellsPerLine) {
        int addedCells;
        ArrayList<NumberLinePoint> points = new ArrayList<NumberLinePoint>();
        int n = ((Collection)numberLine.getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            points.add(new NumberLinePoint(false, null, numberLine.getSettings().getUserDefinedArray().get(i).getUserText(), false, 11, null));
        }
        numberLine.setPoints(points);
        NumberLineFormatter.Companion.dealWithBlanks(numberLine);
        NumberLinePoint.Companion.makeColumnsEqualWidth(points);
        if (numberLine.getSettings().isStretch() && (addedCells = this.getStretchCells(numberLine, cellsPerLine)) > 0) {
            int n2 = ((Collection)numberLine.getPoints()).size();
            for (int i = 0; i < n2; ++i) {
                NumberLinePoint numberLinePoint = numberLine.getPoints().get(i);
                numberLinePoint.setRightPadding(numberLinePoint.getRightPadding() + addedCells);
            }
        }
    }

    private final int getStretchCells(NumberLine numberLine, int cellsPerLine) {
        int addedCells;
        NemethNumberLineFormatter.Companion.formatLine(numberLine);
        int necessaryCells = NumberLineLine.Companion.getLineLength(numberLine.getLine());
        int leftoverCells = cellsPerLine - necessaryCells;
        int intervals = numberLine.getSettings().getUserDefinedArray().size();
        if (leftoverCells > intervals && (addedCells = leftoverCells / intervals) > 0) {
            return addedCells;
        }
        return 0;
    }

    public final boolean format(@NotNull NumberLine numberLine) throws MathFormattingException {
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        NemethNumberLineFormatter.Companion.determineOverflow(numberLine);
        int cellsPerLine = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
        this.formatPoints(numberLine, cellsPerLine);
        NumberLineFormatter.Companion.verticallyAlignLabelsAndPoints(numberLine);
        NemethNumberLineFormatter.Companion.formatLine(numberLine);
        if (numberLine.getSettings().getSectionType() == SpatialMathEnum.NumberLineSection.POINTS) {
            NemethNumberLineFormatter.formatMultiplePoints(numberLine);
        } else if (numberLine.getSettings().getSectionType() == SpatialMathEnum.NumberLineSection.SEGMENT) {
            NemethNumberLineFormatter.Companion.formatSegment(numberLine);
        }
        NumberLineFormatter.Companion.addLine(numberLine);
        if (!NumberLineFormatter.Companion.addPoints(numberLine)) {
            return false;
        }
        NumberLineFormatter.Companion.addLabels(numberLine);
        return true;
    }
}

