/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineFormatter;
import org.brailleblaster.math.numberLine.NumberLineInterval;
import org.brailleblaster.math.numberLine.NumberLineJson;
import org.brailleblaster.math.numberLine.NumberLineLine;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.numberLine.NumberLineSegment;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.numberLine.NumberLineSettings;
import org.brailleblaster.math.numberLine.NumberLineText;
import org.brailleblaster.math.numberLine.NumberLineWidget;
import org.brailleblaster.math.numberLine.NumberLineWidgetAddBlanks;
import org.brailleblaster.math.numberLine.NumberLineWidgetAddLabels;
import org.brailleblaster.math.numberLine.NumberLineWidgetAutomaticMath;
import org.brailleblaster.math.numberLine.NumberLineWidgetUserDefined;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathBlock;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.math.spatial.VersionConverter;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Notify;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 g2\u00020\u0001:\u0001gB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010J\u001a\u00020\fJ\u000e\u0010K\u001a\u00020\f2\u0006\u0010I\u001a\u00020\fJ\b\u0010L\u001a\u00020\fH\u0002J\b\u0010M\u001a\u00020\fH\u0002J\u0006\u0010N\u001a\u00020\fJ\u0010\u0010O\u001a\u00020\f2\u0006\u0010P\u001a\u00020QH\u0002J\u0006\u0010R\u001a\u00020\fJ\u0006\u0010S\u001a\u00020\fJ\u0006\u0010T\u001a\u00020\fJ\u0006\u0010U\u001a\u00020\fJ\b\u0010V\u001a\u00020\u0007H\u0016J\b\u0010W\u001a\u00020\u0007H\u0016J\u0015\u0010\\\u001a\u00020,2\u0006\u0010]\u001a\u00020^H\u0000\u00a2\u0006\u0002\b_J\b\u0010d\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u0012\u0012\u0004\u0012\u00020302j\b\u0012\u0004\u0012\u000203`4X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R*\u00107\u001a\u0012\u0012\u0004\u0012\u00020802j\b\u0012\u0004\u0012\u000208`4X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00106\"\u0004\b:\u0010;R*\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020<02j\b\u0012\u0004\u0012\u00020<`4X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u00106\"\u0004\b>\u0010;R\u001a\u0010?\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u000e\u0010I\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010X\u001a\u00020YX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u0014\u0010`\u001a\u00020a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u0011\u0010e\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010A\u00a8\u0006h"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLine;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "<init>", "()V", "formatter", "Lorg/brailleblaster/math/numberLine/NumberLineFormatter;", "retranslateLabels", "", "retranslateUserText", "parse", "loadStringParser", "segmentNotEmpty", "", "shouldFormatSegment", "addBlankOption", "addLabelOption", "setSegmentIntervals", "format", "segment", "Lorg/brailleblaster/math/numberLine/NumberLineSegment;", "getSegment", "()Lorg/brailleblaster/math/numberLine/NumberLineSegment;", "segmentPoints", "", "Lorg/brailleblaster/math/numberLine/NumberLineSegmentPoint;", "getSegmentPoints", "()Ljava/util/List;", "rebuildPoints", "points", "", "initializePoints", "settings", "Lorg/brailleblaster/math/numberLine/NumberLineSettings;", "getSettings", "()Lorg/brailleblaster/math/numberLine/NumberLineSettings;", "setSettings", "(Lorg/brailleblaster/math/numberLine/NumberLineSettings;)V", "numberLineText", "Lorg/brailleblaster/math/numberLine/NumberLineText;", "getNumberLineText", "()Lorg/brailleblaster/math/numberLine/NumberLineText;", "setNumberLineText", "(Lorg/brailleblaster/math/numberLine/NumberLineText;)V", "widget", "Lorg/brailleblaster/math/numberLine/NumberLineWidget;", "getWidget", "()Lorg/brailleblaster/math/numberLine/NumberLineWidget;", "setWidget", "(Lorg/brailleblaster/math/numberLine/NumberLineWidget;)V", "lines", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/spatial/Line;", "Lkotlin/collections/ArrayList;", "getLines", "()Ljava/util/ArrayList;", "line", "Lorg/brailleblaster/math/numberLine/NumberLineLine;", "getLine", "setLine", "(Ljava/util/ArrayList;)V", "Lorg/brailleblaster/math/numberLine/NumberLinePoint;", "getPoints", "setPoints", "widestLine", "getWidestLine", "()I", "setWidestLine", "(I)V", "blank", "getBlank", "()Z", "setBlank", "(Z)V", "hush", "makeLine", "mathFormattingChecks", "intervalIsNegative", "notInOrder", "hasLineFilled", "notEmptyAndZero", "s", "", "denominatorIsZero", "intervalIsZero", "bothOrNoneSegments", "pointsDontMatchIntervals", "saveSettings", "loadSettingsFromFile", "typeEnum", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "getTypeEnum", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "createWidgetForType", "type", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$NumberLineViews;", "createWidgetForType$brailleblaster_core", "json", "Lorg/brailleblaster/math/numberLine/NumberLineJson;", "getJson", "()Lorg/brailleblaster/math/numberLine/NumberLineJson;", "preFormatChecks", "lastIntervalLength", "getLastIntervalLength", "Companion", "brailleblaster-core"})
public final class NumberLine
implements ISpatialMathContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NumberLineFormatter formatter;
    @NotNull
    private NumberLineSettings settings = new NumberLineSettings();
    @NotNull
    private NumberLineText numberLineText = new NumberLineText(null, null, null, null, null, 31, null);
    @NotNull
    private NumberLineWidget widget;
    @NotNull
    private final ArrayList<Line> lines = new ArrayList();
    @NotNull
    private ArrayList<NumberLineLine> line = new ArrayList();
    @NotNull
    private ArrayList<NumberLinePoint> points = new ArrayList();
    private int widestLine;
    private boolean blank;
    private boolean hush;
    @NotNull
    private final SpatialMathEnum.SpatialMathContainers typeEnum;
    @NotNull
    private static final String USER_SETTINGS_INTERVAL = "nle.interval";
    @NotNull
    private static final String USER_SETTINGS_START_SEGMENT = "nle.startSegment";
    @NotNull
    private static final String USER_SETTINGS_END_SEGMENT = "nle.endSegment";
    @NotNull
    private static final String USER_SETTINGS_REDUCE = "nle.reduce";
    @NotNull
    private static final String USER_SETTINGS_BEVELED = "nle.beveled";
    @NotNull
    private static final String USER_SETTINGS_ARROW = "nle.arrow";
    @NotNull
    private static final String USER_SETTINGS_STRETCH = "nle.stretch";
    @NotNull
    private static final String USER_SETTINGS_LEADING_ZEROS = "nle.leadingZeros";
    @NotNull
    private static final Logger log;
    private static final int DEFAULT_NUM_POINTS = 1;

    public NumberLine() {
        this.loadSettingsFromFile();
        this.formatter = new NumberLineFormatter(this);
        this.setWidget(this.createWidgetForType$brailleblaster_core(this.getSettings().getView()));
        this.typeEnum = SpatialMathEnum.SpatialMathContainers.NUMBER_LINE;
    }

    public final void retranslateLabels() {
        int n = ((Collection)this.getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            NumberLineInterval interval = this.getSettings().getUserDefinedArray().get(i);
            MathText mathText = new MathText(interval.getLabelText().getMathText().print, SpatialMathUtils.translate(this.getSettings().getTranslationLabel(), interval.getLabelText().getMathText().print), false, 4, null);
            interval.setLabelText(new NumberLinePoint(false, null, mathText, false, 3, null));
        }
    }

    public final void retranslateUserText() {
        int n = ((Collection)this.getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            NumberLineInterval interval = this.getSettings().getUserDefinedArray().get(i);
            interval.setUserText(new MathText(interval.getUserText().print, SpatialMathUtils.translate(this.getSettings().getTranslationUserDefined(), interval.getUserText().print), false, 4, null));
        }
    }

    public final void parse() throws MathFormattingException {
        NumberLineText newText;
        List<NumberLineSegmentPoint> oldPoints = this.numberLineText.getPoints();
        NumberLineSegment oldSegment = this.numberLineText.getSegment();
        this.numberLineText = newText = this.getSettings().getStringParser().parse();
        this.getSettings().setIntervalType(this.getSettings().getStringParser().getNumberLineType(this));
        this.numberLineText.setPoints(oldPoints);
        this.numberLineText.getSegment().setStartInterval(oldSegment.getStartInterval());
        this.numberLineText.getSegment().setEndInterval(oldSegment.getEndInterval());
        this.numberLineText.getSegment().setStartSegmentCircle(oldSegment.getStartSegmentCircle());
        this.numberLineText.getSegment().setEndSegmentCircle(oldSegment.getEndSegmentCircle());
    }

    public final void loadStringParser() {
        try {
            this.getSettings().getStringParser().unparse(this.getSettings().getIntervalType(), this.numberLineText);
        }
        catch (MathFormattingException e) {
            e.printStackTrace();
        }
    }

    public final boolean segmentNotEmpty() {
        return ((CharSequence)this.getSettings().getStringParser().getSegmentStart()).length() > 0;
    }

    public final boolean shouldFormatSegment() {
        boolean segmentSettings = this.getSettings().getSectionType() == SpatialMathEnum.NumberLineSection.SEGMENT;
        boolean segmentFilled = this.segmentNotEmpty();
        return segmentSettings && segmentFilled;
    }

    public final boolean addBlankOption() {
        boolean hasBlank = false;
        int n = ((Collection)this.getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            NumberLineInterval interval = this.getSettings().getUserDefinedArray().get(i);
            if (interval.getBlankType() == SpatialMathEnum.BlankOptions.NONE) continue;
            hasBlank = true;
        }
        if (hasBlank) {
            this.getSettings().getOptions().add(SpatialMathEnum.NumberLineOptions.BLANKS);
        }
        return hasBlank;
    }

    public final boolean addLabelOption() {
        boolean hasLabel = false;
        int n = ((Collection)this.getSettings().getUserDefinedArray()).size();
        for (int i = 0; i < n; ++i) {
            NumberLineInterval interval = this.getSettings().getUserDefinedArray().get(i);
            if (!(((CharSequence)interval.getLabelText().getMathText().braille).length() > 0)) continue;
            hasLabel = true;
        }
        if (hasLabel) {
            this.getSettings().getOptions().add(SpatialMathEnum.NumberLineOptions.LABELS);
        }
        return hasLabel;
    }

    public final void setSegmentIntervals() throws MathFormattingException {
        if (!this.segmentNotEmpty()) {
            return;
        }
        Fraction intervalFraction = this.numberLineText.getInterval().getFraction();
        Fraction startSegmentFraction = this.numberLineText.getSegment().getSegmentStart().getFraction();
        Fraction startLineFraction = this.numberLineText.getLineStart().getFraction();
        Fraction endSegmentFraction = this.numberLineText.getSegment().getSegmentEnd().getFraction();
        int startInterval = (int)startSegmentFraction.subtract(startLineFraction).divideBy(intervalFraction).doubleValue() + 1;
        int segmentLength = (int)endSegmentFraction.subtract(startSegmentFraction).divideBy(intervalFraction).doubleValue();
        this.getSegment().setStartInterval(startInterval);
        this.getSegment().setEndInterval(startInterval + segmentLength);
    }

    @Override
    public void format() {
        try {
            this.formatter.format();
        }
        catch (MathFormattingException mathFormattingException) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getNUMERAL_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
        }
    }

    @NotNull
    public final NumberLineSegment getSegment() {
        return this.numberLineText.getSegment();
    }

    @NotNull
    public final List<NumberLineSegmentPoint> getSegmentPoints() {
        return this.numberLineText.getPoints();
    }

    public final void rebuildPoints(int points) {
        block3: {
            block2: {
                if (this.numberLineText.getPoints().size() >= points) break block2;
                int difference = points - this.numberLineText.getPoints().size();
                for (int j = 0; j < difference; ++j) {
                    this.numberLineText.getPoints().add(new NumberLineSegmentPoint(null, null, 0, 7, null));
                }
                break block3;
            }
            if (this.numberLineText.getPoints().size() <= points) break block3;
            int difference = this.numberLineText.getPoints().size() - points;
            for (int j = 0; j < difference; ++j) {
                this.numberLineText.getPoints().remove(this.numberLineText.getPoints().size() - 1);
            }
        }
    }

    public final void initializePoints() {
        if (this.numberLineText.getPoints().isEmpty()) {
            for (int j = 0; j < 1; ++j) {
                this.numberLineText.getPoints().add(new NumberLineSegmentPoint(null, null, 0, 7, null));
            }
        }
    }

    @Override
    @NotNull
    public NumberLineSettings getSettings() {
        return this.settings;
    }

    public void setSettings(@NotNull NumberLineSettings numberLineSettings) {
        Intrinsics.checkNotNullParameter((Object)numberLineSettings, (String)"<set-?>");
        this.settings = numberLineSettings;
    }

    @NotNull
    public final NumberLineText getNumberLineText() {
        return this.numberLineText;
    }

    public final void setNumberLineText(@NotNull NumberLineText numberLineText) {
        Intrinsics.checkNotNullParameter((Object)numberLineText, (String)"<set-?>");
        this.numberLineText = numberLineText;
    }

    @Override
    @NotNull
    public NumberLineWidget getWidget() {
        return this.widget;
    }

    public void setWidget(@NotNull NumberLineWidget numberLineWidget) {
        Intrinsics.checkNotNullParameter((Object)numberLineWidget, (String)"<set-?>");
        this.widget = numberLineWidget;
    }

    @NotNull
    public ArrayList<Line> getLines() {
        return this.lines;
    }

    @NotNull
    public final ArrayList<NumberLineLine> getLine() {
        return this.line;
    }

    public final void setLine(@NotNull ArrayList<NumberLineLine> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.line = arrayList;
    }

    @NotNull
    public final ArrayList<NumberLinePoint> getPoints() {
        return this.points;
    }

    public final void setPoints(@NotNull ArrayList<NumberLinePoint> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.points = arrayList;
    }

    @Override
    public int getWidestLine() {
        return this.widestLine;
    }

    @Override
    public void setWidestLine(int n) {
        this.widestLine = n;
    }

    @Override
    public boolean getBlank() {
        return this.blank;
    }

    @Override
    public void setBlank(boolean bl) {
        this.blank = bl;
    }

    public final boolean makeLine() throws MathFormattingException {
        this.getWidget().extractText();
        try {
            this.parse();
        }
        catch (MathFormattingException mathFormattingException) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
            return false;
        }
        if (this.getSettings().getType() == SpatialMathEnum.NumberLineType.AUTOMATIC_MATH && !this.mathFormattingChecks(false)) {
            return false;
        }
        if (!this.formatter.format()) {
            if (!this.hush) {
                Notify.notify$default(Notify.INSTANCE, MathModuleUtils.LONG_LINE_WARNING, Notify.ALERT_SHELL_NAME, false, 4, null);
            }
            return false;
        }
        return true;
    }

    public final boolean mathFormattingChecks(boolean hush) {
        boolean bl;
        this.hush = hush;
        try {
            if (this.intervalIsZero()) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getINTERVAL_IS_ZERO_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getINTERVAL_IS_ZERO_WARNING());
                }
                return false;
            }
            if (this.intervalIsNegative()) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getINTERVAL_IS_NEGATIVE_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getINTERVAL_IS_NEGATIVE_WARNING());
                }
                return false;
            }
            if (this.denominatorIsZero()) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getDENOMINATOR_IS_ZERO_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getDENOMINATOR_IS_ZERO_WARNING());
                }
                return false;
            }
            if (!this.hasLineFilled()) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getEMPTY_FIELD_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getEMPTY_FIELD_WARNING());
                }
                return false;
            }
            if (!this.bothOrNoneSegments()) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getFILL_BOTH_SEGMENTS_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getFILL_BOTH_SEGMENTS_WARNING());
                }
                return false;
            }
            if (this.notInOrder()) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getOUT_OF_ORDER(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getOUT_OF_ORDER());
                }
                return false;
            }
            try {
                if (this.pointsDontMatchIntervals()) {
                    if (!hush) {
                        Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getINTERVAL_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                    } else {
                        log.error(NumberLineConstants.INSTANCE.getINTERVAL_WARNING());
                    }
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!hush) {
                    Notify.notify$default(Notify.INSTANCE, NumberLineConstants.INSTANCE.getNUMERAL_WARNING(), Notify.ALERT_SHELL_NAME, false, 4, null);
                } else {
                    log.error(NumberLineConstants.INSTANCE.getNUMERAL_WARNING());
                }
                return false;
            }
            bl = true;
        }
        catch (MathFormattingException mathFormattingException) {
            bl = false;
        }
        return bl;
    }

    private final boolean intervalIsNegative() {
        return this.numberLineText.getInterval().isMinus();
    }

    private final boolean notInOrder() throws MathFormattingException {
        if (this.numberLineText.getLineStart().compareTo(this.numberLineText.getLineEnd()) > 0) {
            return true;
        }
        return this.shouldFormatSegment() && this.numberLineText.getSegment().getSegmentStart().compareTo(this.numberLineText.getSegment().getSegmentEnd()) > 0;
    }

    public final boolean hasLineFilled() {
        return !StringsKt.isBlank((CharSequence)this.getSettings().getStringParser().getLineEndString()) && !StringsKt.isBlank((CharSequence)this.getSettings().getStringParser().getLineStartString());
    }

    private final boolean notEmptyAndZero(String s) {
        boolean bl;
        try {
            bl = !StringsKt.isBlank((CharSequence)s) && Integer.parseInt(s) == 0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public final boolean denominatorIsZero() {
        if (this.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER || this.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.MIXED) {
            if (this.notEmptyAndZero(this.numberLineText.getInterval().getDenominator()) || this.notEmptyAndZero(this.numberLineText.getLineStart().getDenominator()) || this.notEmptyAndZero(this.numberLineText.getLineEnd().getDenominator())) {
                return true;
            }
            if (this.notEmptyAndZero(this.numberLineText.getSegment().getSegmentStart().getDenominator()) || this.notEmptyAndZero(this.numberLineText.getSegment().getSegmentEnd().getDenominator())) {
                return true;
            }
        }
        return false;
    }

    public final boolean intervalIsZero() throws MathFormattingException {
        return this.numberLineText.getInterval().getFraction().compareTo(Fraction.ZERO) == 0;
    }

    public final boolean bothOrNoneSegments() {
        return this.numberLineText.getSegment().getSegmentStart().isEmpty() ? this.numberLineText.getSegment().getSegmentEnd().isEmpty() : !this.numberLineText.getSegment().getSegmentEnd().isEmpty();
    }

    public final boolean pointsDontMatchIntervals() throws MathFormattingException {
        boolean b;
        Fraction interval = this.numberLineText.getInterval().getFraction();
        Fraction lineStart = this.numberLineText.getLineStart().getFraction();
        Fraction lineEnd = this.numberLineText.getLineEnd().getFraction();
        Fraction adjustedLineEnd = lineEnd.subtract(lineStart);
        boolean bl = b = !(adjustedLineEnd.divideBy(interval).doubleValue() - Math.floor(adjustedLineEnd.divideBy(interval).doubleValue()) == 0.0);
        if (b) {
            return true;
        }
        if (this.shouldFormatSegment()) {
            boolean d;
            Fraction segmentStart = this.numberLineText.getSegment().getSegmentStart().getFraction();
            Fraction segmentEnd = this.numberLineText.getSegment().getSegmentEnd().getFraction();
            Fraction adjustedSegmentStart = segmentStart.subtract(lineStart);
            Fraction adjustedSegmentEnd = segmentEnd.subtract(lineStart);
            boolean c = !(adjustedSegmentStart.divideBy(interval).doubleValue() - Math.floor(adjustedSegmentStart.divideBy(interval).doubleValue()) == 0.0);
            boolean bl2 = d = !(adjustedSegmentEnd.divideBy(interval).doubleValue() - Math.floor(adjustedSegmentEnd.divideBy(interval).doubleValue()) == 0.0);
            if (c || d) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveSettings() {
        BBIni.getPropertyFileManager().save(USER_SETTINGS_INTERVAL, this.getSettings().getIntervalType().name());
        BBIni.getPropertyFileManager().save(USER_SETTINGS_START_SEGMENT, this.getSettings().getStartSegmentCircle().name());
        BBIni.getPropertyFileManager().save(USER_SETTINGS_END_SEGMENT, this.getSettings().getEndSegmentCircle().name());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_REDUCE, this.getSettings().isReduceFraction());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_BEVELED, this.getSettings().isBeveledFraction());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_ARROW, this.getSettings().isArrow());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_STRETCH, this.getSettings().isStretch());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_LEADING_ZEROS, this.getSettings().isRemoveLeadingZeros());
    }

    @Override
    public void loadSettingsFromFile() {
        String intervalString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_INTERVAL, this.getSettings().getIntervalType().name());
        SpatialMathEnum.IntervalType interval = SpatialMathEnum.IntervalType.valueOf(intervalString);
        this.getSettings().setIntervalType(interval);
        String startString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_START_SEGMENT, this.getSettings().getStartSegmentCircle().name());
        SpatialMathEnum.Fill start = SpatialMathEnum.Fill.valueOf(startString);
        this.getSettings().setStartSegmentCircle(start);
        String endString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_END_SEGMENT, this.getSettings().getEndSegmentCircle().name());
        SpatialMathEnum.Fill end = SpatialMathEnum.Fill.valueOf(endString);
        this.getSettings().setEndSegmentCircle(end);
        String reduce = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_REDUCE, "true");
        NumberLineSettings numberLineSettings = this.getSettings();
        Boolean bl = Boolean.valueOf(reduce);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"valueOf(...)");
        numberLineSettings.setReduceFraction(bl);
        String beveled = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_BEVELED, "false");
        NumberLineSettings numberLineSettings2 = this.getSettings();
        Boolean bl2 = Boolean.valueOf(beveled);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"valueOf(...)");
        numberLineSettings2.setBeveledFraction(bl2);
        String arrow = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_ARROW, "true");
        NumberLineSettings numberLineSettings3 = this.getSettings();
        Boolean bl3 = Boolean.valueOf(arrow);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"valueOf(...)");
        numberLineSettings3.setArrow(bl3);
        String stretch = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_STRETCH, "false");
        NumberLineSettings numberLineSettings4 = this.getSettings();
        Boolean bl4 = Boolean.valueOf(stretch);
        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"valueOf(...)");
        numberLineSettings4.setStretch(bl4);
        String zero = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_LEADING_ZEROS, "false");
        NumberLineSettings numberLineSettings5 = this.getSettings();
        Boolean bl5 = Boolean.valueOf(zero);
        Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"valueOf(...)");
        numberLineSettings5.setRemoveLeadingZeros(bl5);
    }

    @Override
    @NotNull
    public SpatialMathEnum.SpatialMathContainers getTypeEnum() {
        return this.typeEnum;
    }

    @NotNull
    public final NumberLineWidget createWidgetForType$brailleblaster_core(@NotNull SpatialMathEnum.NumberLineViews type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> new NumberLineWidgetAutomaticMath();
            case 2 -> new NumberLineWidgetAddBlanks();
            case 3 -> new NumberLineWidgetAddLabels();
            default -> new NumberLineWidgetUserDefined();
        };
    }

    @Override
    @NotNull
    public NumberLineJson getJson() {
        ISpatialMathContainerJson iSpatialMathContainerJson = new NumberLineJson().containerToJson(this);
        Intrinsics.checkNotNull((Object)iSpatialMathContainerJson, (String)"null cannot be cast to non-null type org.brailleblaster.math.numberLine.NumberLineJson");
        return (NumberLineJson)iSpatialMathContainerJson;
    }

    @Override
    public boolean preFormatChecks() {
        this.addBlankOption();
        this.addLabelOption();
        if (this.getSettings().getType() == SpatialMathEnum.NumberLineType.AUTOMATIC_MATH) {
            try {
                this.parse();
            }
            catch (MathFormattingException mathFormattingException) {
                Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
                return false;
            }
            if (!this.mathFormattingChecks(false)) {
                return false;
            }
        }
        return true;
    }

    public final int getLastIntervalLength() {
        NumberLineInterval interval;
        int lastInterval = this.points.get(this.points.size() - 1).getRightDec().length();
        if (this.getSettings().getOptions().contains((Object)SpatialMathEnum.NumberLineOptions.LABELS) && (interval = this.getSettings().getUserDefinedArray().get(this.getSettings().getUserDefinedArray().size() - 1)).getLabelText().getRightDec().length() > lastInterval) {
            lastInterval = interval.getLabelText().getRightDec().length() + 1;
        }
        return lastInterval;
    }

    @JvmStatic
    @NotNull
    public static final NumberLine getContainerFromElement(@NotNull Node node) {
        return Companion.getContainerFromElement(node);
    }

    @JvmStatic
    public static final boolean middleNumberLine(@NotNull TextMapElement currentElement) {
        return Companion.middleNumberLine(currentElement);
    }

    @JvmStatic
    public static final boolean isNumberLine(@Nullable Node node) {
        return Companion.isNumberLine(node);
    }

    @JvmStatic
    @Nullable
    public static final Element getNumberLineParent(@NotNull Node node) {
        return Companion.getNumberLineParent(node);
    }

    @JvmStatic
    @NotNull
    public static final Element initialize(@NotNull Node n) {
        return Companion.initialize(n);
    }

    @JvmStatic
    public static final boolean currentIsNumberLine() {
        return Companion.currentIsNumberLine();
    }

    static {
        Logger logger = LoggerFactory.getLogger(NumberLine.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0014H\u0007J\b\u0010\u001e\u001a\u00020\u0016H\u0007J\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010!\u001a\u00020\"X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLine$Companion;", "", "<init>", "()V", "USER_SETTINGS_INTERVAL", "", "USER_SETTINGS_START_SEGMENT", "USER_SETTINGS_END_SEGMENT", "USER_SETTINGS_REDUCE", "USER_SETTINGS_BEVELED", "USER_SETTINGS_ARROW", "USER_SETTINGS_STRETCH", "USER_SETTINGS_LEADING_ZEROS", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "getContainerFromElement", "Lorg/brailleblaster/math/numberLine/NumberLine;", "node", "Lnu/xom/Node;", "middleNumberLine", "", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "isNumberLine", "getNumberLineParent", "Lnu/xom/Element;", "initialize", "n", "currentIsNumberLine", "deleteNumberLine", "", "DEFAULT_NUM_POINTS", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @JvmStatic
        @NotNull
        public final NumberLine getContainerFromElement(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            NumberLine numberLine = new NumberLine();
            Element ele = (Element)node;
            if (BBX.CONTAINER.NUMBER_LINE.isA((Node)ele)) {
                if (!BBX.CONTAINER.NUMBER_LINE.ATTRIB_VERSION.has((Node)ele)) {
                    ele = VersionConverter.INSTANCE.convertNumberLine(ele);
                }
                Object t = BBX.CONTAINER.NUMBER_LINE.JSON_NUMBER_LINE.get(ele);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.brailleblaster.math.numberLine.NumberLineJson");
                NumberLineJson json = (NumberLineJson)t;
                ISpatialMathContainer iSpatialMathContainer = json.jsonToContainer();
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.numberLine.NumberLine");
                numberLine = (NumberLine)iSpatialMathContainer;
            }
            return numberLine;
        }

        @JvmStatic
        public final boolean middleNumberLine(@NotNull TextMapElement currentElement) {
            Intrinsics.checkNotNullParameter((Object)currentElement, (String)"currentElement");
            if (currentElement.getNode() == null || currentElement instanceof LineBreakElement) {
                return false;
            }
            Node node = currentElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element numberLine = XMLHandler.Companion.ancestorVisitorElement(node, Companion::middleNumberLine$lambda$0);
            return numberLine != null;
        }

        @JvmStatic
        public final boolean isNumberLine(@Nullable Node node) {
            if (node == null || node.getDocument() == null) {
                return false;
            }
            return XMLHandler.Companion.ancestorElementIs(node, Companion::isNumberLine$lambda$0);
        }

        @JvmStatic
        @Nullable
        public final Element getNumberLineParent(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return XMLHandler.Companion.ancestorVisitorElement(node, Companion::getNumberLineParent$lambda$0);
        }

        @JvmStatic
        @NotNull
        public final Element initialize(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Element e = (Element)n;
            NumberLine t = this.getContainerFromElement((Node)e);
            t.format();
            Element newElement = BBX.CONTAINER.NUMBER_LINE.create(t);
            try {
                Intrinsics.checkNotNull((Object)newElement);
                SpatialMathBlock.INSTANCE.format(newElement, t.getLines());
            }
            catch (MathFormattingException e1) {
                e1.printStackTrace();
            }
            e.getParent().replaceChild((Node)e, (Node)newElement);
            Intrinsics.checkNotNull((Object)newElement);
            return newElement;
        }

        @JvmStatic
        public final boolean currentIsNumberLine() {
            Node current = (Node)XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), Companion::currentIsNumberLine$lambda$0);
            boolean isWhitespace = WPManager.Companion.getInstance().getController().getMapList().getCurrent() instanceof WhiteSpaceElement;
            return !isWhitespace && current != null;
        }

        public final void deleteNumberLine() {
            Element element = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), Companion::deleteNumberLine$lambda$0);
            Intrinsics.checkNotNull((Object)element);
            Element current = element;
            Node previous = XMLHandler.Companion.previousSiblingNode((Node)current);
            ParentNode parent = current.getParent();
            parent.removeChild((Node)current);
            BBSimpleManager bBSimpleManager = WPManager.Companion.getInstance().getController().getSimpleManager();
            Node[] nodeArray = new Node[1];
            Intrinsics.checkNotNull((Object)parent);
            nodeArray[0] = parent;
            bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, true, nodeArray));
            if (previous != null) {
                WPManager.Companion.getInstance().getController().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TEXT, new XMLNodeCaret(previous, null, 2, null), null, 4, null));
            }
        }

        private static final boolean middleNumberLine$lambda$0(Element node) {
            return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
        }

        private static final boolean isNumberLine$lambda$0(Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.CONTAINER.NUMBER_LINE.isA((Node)e);
        }

        private static final boolean getNumberLineParent$lambda$0(Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.CONTAINER.NUMBER_LINE.isA((Node)e);
        }

        private static final boolean currentIsNumberLine$lambda$0(Element node) {
            return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
        }

        private static final boolean deleteNumberLine$lambda$0(Element node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.NumberLineViews.values().length];
            try {
                nArray[SpatialMathEnum.NumberLineViews.AUTOMATIC_MATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.NumberLineViews.BLANKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.NumberLineViews.LABELS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

