/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineComponent;
import org.brailleblaster.math.numberLine.NumberLineSegment;
import org.brailleblaster.math.numberLine.NumberLineText;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 42\u00020\u0001:\u00014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020(J\u0006\u0010\u0014\u001a\u00020(J\u0006\u0010\u0016\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-J\u0018\u0010.\u001a\u00020\u00132\b\u0010/\u001a\u0004\u0018\u00010(2\u0006\u00100\u001a\u00020\fJ\u0010\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u00102\u001a\u00020\fJ\u0006\u00103\u001a\u00020\u0013R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u001e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0019\"\u0004\b#\u0010\u001bR\u001a\u0010$\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0019\"\u0004\b&\u0010\u001b\u00a8\u00065"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineStringParser;", "", "<init>", "()V", "unparseDecimal", "", "component", "Lorg/brailleblaster/math/numberLine/NumberLineComponent;", "unparseImproper", "unparseMixed", "unparseWhole", "parseComponents", "Lorg/brailleblaster/math/numberLine/NumberLineText;", "parseDecimal", "s", "parseMixed", "parseImproper", "parseWhole", "setLineStart", "", "lineStart", "setLineEnd", "lineEnd", "intervalString", "getIntervalString", "()Ljava/lang/String;", "setIntervalString", "(Ljava/lang/String;)V", "value", "lineStartString", "getLineStartString", "lineEndString", "getLineEndString", "segmentStart", "getSegmentStart", "setSegmentStart", "segmentEnd", "getSegmentEnd", "setSegmentEnd", "interval", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$IntervalType;", "parseComponent", "parseType", "getNumberLineType", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "unparse", "type", "text", "getTypeAndParse", "parse", "clear", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nNumberLineStringParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberLineStringParser.kt\norg/brailleblaster/math/numberLine/NumberLineStringParser\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,295:1\n106#2:296\n78#2,22:297\n106#2:319\n78#2,22:320\n106#2:342\n78#2,22:343\n106#2:376\n78#2,22:377\n106#2:412\n78#2,22:413\n106#2:446\n78#2,22:447\n106#2:469\n78#2,22:470\n106#2:492\n78#2,22:493\n106#2:515\n78#2,22:516\n106#2:538\n78#2,22:539\n106#2:561\n78#2,22:562\n742#3,9:365\n742#3,9:401\n742#3,9:435\n37#4,2:374\n37#4,2:399\n37#4,2:410\n37#4,2:444\n*S KotlinDebug\n*F\n+ 1 NumberLineStringParser.kt\norg/brailleblaster/math/numberLine/NumberLineStringParser\n*L\n78#1:296\n78#1:297,22\n79#1:319\n79#1:320,22\n89#1:342\n89#1:343,22\n93#1:376\n93#1:377,22\n101#1:412\n101#1:413,22\n111#1:446\n111#1:447,22\n112#1:469\n112#1:470,22\n113#1:492\n113#1:493,22\n139#1:515\n139#1:516,22\n140#1:538\n140#1:539,22\n146#1:561\n146#1:562,22\n89#1:365,9\n94#1:401,9\n101#1:435,9\n90#1:374,2\n93#1:399,2\n95#1:410,2\n102#1:444,2\n*E\n"})
public final class NumberLineStringParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String intervalString = "";
    @NotNull
    private String lineStartString = "";
    @NotNull
    private String lineEndString = "";
    @NotNull
    private String segmentStart = "";
    @NotNull
    private String segmentEnd = "";
    private static final Logger log = LoggerFactory.getLogger(NumberLineStringParser.class);

    @NotNull
    public final String unparseDecimal(@NotNull NumberLineComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component.getWhole() + (String)(((CharSequence)component.getDecimal()).length() == 0 ? "" : "." + component.getDecimal());
    }

    @NotNull
    public final String unparseImproper(@NotNull NumberLineComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component.getNumerator() + "/" + component.getDenominator();
    }

    @NotNull
    public final String unparseMixed(@NotNull NumberLineComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return (String)(((CharSequence)component.getWhole()).length() == 0 ? "" : component.getWhole() + " ") + (String)(((CharSequence)component.getNumerator()).length() == 0 ? "" : component.getNumerator() + "/" + component.getDenominator());
    }

    @NotNull
    public final String unparseWhole(@NotNull NumberLineComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component.getWhole();
    }

    @NotNull
    public final NumberLineText parseComponents() throws MathFormattingException {
        NumberLineComponent numberLineComponent = this.parseComponent(this.intervalString);
        NumberLineComponent numberLineComponent2 = this.parseComponent(this.lineEndString);
        NumberLineComponent numberLineComponent3 = this.parseComponent(this.lineStartString);
        NumberLineComponent numberLineComponent4 = this.parseComponent(this.segmentEnd);
        NumberLineComponent numberLineComponent5 = this.parseComponent(this.segmentStart);
        NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, numberLineComponent5, numberLineComponent4, 0, 0, 51, null);
        return new NumberLineText(numberLineComponent, numberLineSegment, numberLineComponent3, numberLineComponent2, null, 16, null);
    }

    @NotNull
    public final NumberLineComponent parseDecimal(@NotNull String s) {
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            return new NumberLineComponent(null, null, null, null, 15, null);
        }
        int index = 0;
        char c = s.charAt(index);
        StringBuilder whole = new StringBuilder();
        StringBuilder decimal = new StringBuilder();
        while (c != '.') {
            whole.append(c);
            if (index == s.length() - 1) break;
            c = s.charAt(++index);
        }
        ++index;
        while (index < s.length()) {
            c = s.charAt(index);
            decimal.append(c);
            ++index;
        }
        String string = whole.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String string3 = decimal.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        $this$trim$iv = string3;
        String string4 = string2;
        $i$f$trim = false;
        $this$trim$iv$iv = $this$trim$iv;
        $i$f$trim2 = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 12;
        String string5 = null;
        String string6 = null;
        String string7 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String string8 = string4;
        return new NumberLineComponent(string8, string7, string6, string5, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NumberLineComponent parseMixed(@NotNull String s) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            return new NumberLineComponent(null, null, null, null, 15, null);
        }
        String whole = "";
        String numerator = "";
        String denominator = "";
        Object $this$trim$iv = s;
        boolean $i$f$trim22 = false;
        CharSequence $this$trim$iv$iv22 = (CharSequence)$this$trim$iv;
        boolean $i$f$trim = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv22.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Regex $i$f$trim22 = new Regex("\\s+");
        int $this$trim$iv$iv22 = 0;
        $this$trim$iv = $i$f$trim22.split((CharSequence)$this$trim$iv, $this$trim$iv$iv22);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it2 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it2).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] splitBlank = thisCollection$iv.toArray(new String[0]);
        if (splitBlank.length > 1) {
            List list2;
            whole = splitBlank[0];
            $this$trim$iv = s;
            boolean $i$f$trim32 = false;
            CharSequence $this$trim$iv$iv32 = (CharSequence)$this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv32.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv32.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = ((Object)$this$trim$iv$iv32.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Regex $i$f$trim32 = new Regex("\\s+");
            int $this$trim$iv$iv32 = 2;
            $this$trim$iv = $i$f$trim32.split((CharSequence)$this$trim$iv, $this$trim$iv$iv32);
            boolean $i$f$toTypedArray22 = false;
            void thisCollection$iv22 = $this$toTypedArray$iv;
            $this$toTypedArray$iv = thisCollection$iv22.toArray(new String[0])[1];
            Regex $i$f$toTypedArray22 = new Regex("/");
            int thisCollection$iv22 = 0;
            $this$toTypedArray$iv = $i$f$toTypedArray22.split((CharSequence)$this$toTypedArray$iv, thisCollection$iv22);
            $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it3 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it3).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            splitFrac = thisCollection$iv.toArray(new String[0]);
            if (splitFrac.length > 1) {
                numerator = splitFrac[0];
                denominator = splitFrac[1];
            }
        } else {
            List list3;
            $this$trim$iv = s;
            boolean $i$f$trim42 = false;
            CharSequence $this$trim$iv$iv42 = (CharSequence)$this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv42.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv42.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = ((Object)$this$trim$iv$iv42.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Regex $i$f$trim42 = new Regex("/");
            int $this$trim$iv$iv42 = 0;
            $this$trim$iv = $i$f$trim42.split((CharSequence)$this$trim$iv, $this$trim$iv$iv42);
            $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it4 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it4).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            splitFrac = thisCollection$iv.toArray(new String[0]);
            if (splitFrac.length > 1) {
                numerator = splitFrac[0];
                denominator = splitFrac[1];
            } else {
                whole = s;
            }
        }
        $this$trim$iv = whole;
        boolean $i$f$trim3 = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        $i$f$trim = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = numerator;
        String string = null;
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        $i$f$trim3 = false;
        $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        $i$f$trim = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        $this$trim$iv = denominator;
        $i$f$trim3 = false;
        $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        $i$f$trim = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl7 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string4 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        String string5 = string4;
        String string6 = string3;
        String string7 = string;
        String string8 = string2;
        return new NumberLineComponent(string8, string7, string6, string5, n, defaultConstructorMarker);
    }

    @NotNull
    public final NumberLineComponent parseImproper(@NotNull String s) {
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        String $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            return new NumberLineComponent(null, null, null, null, 15, null);
        }
        int index = 0;
        char c = s.charAt(index);
        StringBuilder numerator = new StringBuilder();
        StringBuilder denominator = new StringBuilder();
        while (c != '/') {
            numerator.append(c);
            if (index == s.length() - 1) break;
            c = s.charAt(++index);
        }
        ++index;
        while (index < s.length()) {
            c = s.charAt(index);
            denominator.append(c);
            ++index;
        }
        String string = numerator.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        String string3 = null;
        String string4 = null;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string5 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String string6 = denominator.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        $this$trim$iv = string6;
        $i$f$trim = false;
        $this$trim$iv$iv = $this$trim$iv;
        $i$f$trim2 = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string7 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 3;
        String string8 = string7;
        String string9 = string5;
        String string10 = string3;
        String string11 = string4;
        return new NumberLineComponent(string11, string10, string9, string8, n, defaultConstructorMarker);
    }

    @NotNull
    public final NumberLineComponent parseWhole(@NotNull String s) {
        NumberLineComponent numberLineComponent;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            numberLineComponent = new NumberLineComponent(null, null, null, null, 15, null);
        } else {
            String $this$trim$iv = s;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 14;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            numberLineComponent = new NumberLineComponent(string4, string3, string2, string, n, defaultConstructorMarker);
        }
        return numberLineComponent;
    }

    public final void setLineStart(@NotNull String lineStart) {
        Intrinsics.checkNotNullParameter((Object)lineStart, (String)"lineStart");
        this.lineStartString = lineStart;
    }

    public final void setLineEnd(@NotNull String lineEnd) {
        Intrinsics.checkNotNullParameter((Object)lineEnd, (String)"lineEnd");
        this.lineEndString = lineEnd;
    }

    @NotNull
    public final String getIntervalString() {
        return this.intervalString;
    }

    public final void setIntervalString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.intervalString = string;
    }

    @NotNull
    public final String getLineStartString() {
        return this.lineStartString;
    }

    @NotNull
    public final String getLineEndString() {
        return this.lineEndString;
    }

    @NotNull
    public final String getSegmentStart() {
        return this.segmentStart;
    }

    public final void setSegmentStart(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.segmentStart = string;
    }

    @NotNull
    public final String getSegmentEnd() {
        return this.segmentEnd;
    }

    public final void setSegmentEnd(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.segmentEnd = string;
    }

    @NotNull
    public final SpatialMathEnum.IntervalType interval() throws MathFormattingException {
        return this.parseType(this.intervalString);
    }

    @NotNull
    public final SpatialMathEnum.IntervalType lineStart() throws MathFormattingException {
        return this.parseType(this.lineStartString);
    }

    @NotNull
    public final SpatialMathEnum.IntervalType lineEnd() throws MathFormattingException {
        return this.parseType(this.lineEndString);
    }

    @NotNull
    public final NumberLineComponent parseComponent(@NotNull String s) throws MathFormattingException {
        SpatialMathEnum.IntervalType intervalType;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            return new NumberLineComponent(null, null, null, null, 15, null);
        }
        Pattern mixed = Pattern.compile("-*-*\\s*\\d+\\s+\\d+\\s*/\\s*\\d+\\s*");
        Pattern improper = Pattern.compile("-*-*\\s*\\d+\\s*/\\s*\\d+\\s*");
        Pattern decimal = Pattern.compile("-*-*\\s*\\d*\\s*\\.\\s*\\d+\\s*");
        Pattern whole = Pattern.compile("-*-*\\s*\\d+\\s*");
        Matcher mixedMatcher = mixed.matcher(s);
        Matcher improperMatcher = improper.matcher(s);
        Matcher decimalMatcher = decimal.matcher(s);
        Matcher wholeMatcher = whole.matcher(s);
        if (mixedMatcher.matches()) {
            intervalType = SpatialMathEnum.IntervalType.MIXED;
        } else {
            SpatialMathEnum.IntervalType intervalType2 = improperMatcher.matches() ? SpatialMathEnum.IntervalType.IMPROPER : (decimalMatcher.matches() ? SpatialMathEnum.IntervalType.DECIMAL : (wholeMatcher.matches() ? SpatialMathEnum.IntervalType.WHOLE : null));
            intervalType = intervalType2;
            Intrinsics.checkNotNull((Object)((Object)intervalType2));
        }
        SpatialMathEnum.IntervalType type = intervalType;
        NumberLineComponent component = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.parseDecimal(s);
            case 2 -> this.parseImproper(s);
            case 3 -> this.parseMixed(s);
            case 4 -> this.parseWhole(s);
            default -> throw new NoWhenBranchMatchedException();
        };
        component.setIntervalType(type);
        return component;
    }

    @NotNull
    public final SpatialMathEnum.IntervalType parseType(@NotNull String s) throws MathFormattingException {
        SpatialMathEnum.IntervalType type;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Pattern mixed = Pattern.compile("-*-*\\s*\\d+\\s+\\d+\\s*/\\s*\\d+\\s*");
        Pattern improper = Pattern.compile("-*-*\\s*\\d+\\s*/\\s*\\d+\\s*");
        Pattern decimal = Pattern.compile("-*-*\\s*\\d*\\s*\\.\\s*\\d+\\s*");
        Pattern whole = Pattern.compile("-*-*\\s*\\d+\\s*");
        Matcher mixedMatcher = mixed.matcher(s);
        Matcher improperMatcher = improper.matcher(s);
        Matcher decimalMatcher = decimal.matcher(s);
        Matcher wholeMatcher = whole.matcher(s);
        SpatialMathEnum.IntervalType intervalType = mixedMatcher.matches() ? SpatialMathEnum.IntervalType.MIXED : (improperMatcher.matches() ? SpatialMathEnum.IntervalType.IMPROPER : (decimalMatcher.matches() ? SpatialMathEnum.IntervalType.DECIMAL : (type = wholeMatcher.matches() ? SpatialMathEnum.IntervalType.WHOLE : null)));
        if (type == null && ((CharSequence)s).length() > 0) {
            log.error("Pattern compile found no matches");
            throw new MathFormattingException("Pattern compile found no matches");
        }
        if (type == null) {
            type = SpatialMathEnum.IntervalType.WHOLE;
        }
        return type;
    }

    @NotNull
    public final SpatialMathEnum.IntervalType getNumberLineType(@NotNull NumberLine numberLine) {
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        NumberLineText text = numberLine.getNumberLineText();
        if (text.getInterval().getIntervalType() == SpatialMathEnum.IntervalType.MIXED || text.getLineStart().getIntervalType() == SpatialMathEnum.IntervalType.MIXED || text.getLineEnd().getIntervalType() == SpatialMathEnum.IntervalType.MIXED) {
            return SpatialMathEnum.IntervalType.MIXED;
        }
        if (numberLine.shouldFormatSegment() && (text.getSegment().getSegmentStart().getIntervalType() == SpatialMathEnum.IntervalType.MIXED || text.getSegment().getSegmentEnd().getIntervalType() == SpatialMathEnum.IntervalType.MIXED)) {
            return SpatialMathEnum.IntervalType.MIXED;
        }
        if (text.getInterval().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER || text.getLineStart().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER || text.getLineEnd().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER) {
            return SpatialMathEnum.IntervalType.IMPROPER;
        }
        if (numberLine.shouldFormatSegment() && (text.getSegment().getSegmentStart().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER || text.getSegment().getSegmentEnd().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER)) {
            return SpatialMathEnum.IntervalType.IMPROPER;
        }
        if (text.getInterval().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL || text.getLineStart().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL || text.getLineEnd().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL) {
            return SpatialMathEnum.IntervalType.DECIMAL;
        }
        if (numberLine.shouldFormatSegment() && (text.getSegment().getSegmentStart().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL || text.getSegment().getSegmentEnd().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL)) {
            return SpatialMathEnum.IntervalType.DECIMAL;
        }
        return SpatialMathEnum.IntervalType.WHOLE;
    }

    public final void unparse(@Nullable SpatialMathEnum.IntervalType type, @NotNull NumberLineText text) throws MathFormattingException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.intervalString = this.getTypeAndParse(text.getInterval());
        this.setLineStart(this.getTypeAndParse(text.getLineStart()));
        this.setLineEnd(this.getTypeAndParse(text.getLineEnd()));
        this.segmentStart = this.getTypeAndParse(text.getSegment().getSegmentStart());
        this.segmentEnd = this.getTypeAndParse(text.getSegment().getSegmentEnd());
    }

    private final String getTypeAndParse(NumberLineComponent component) {
        return switch (WhenMappings.$EnumSwitchMapping$0[component.getIntervalType().ordinal()]) {
            case 1 -> this.unparseDecimal(component);
            case 2 -> this.unparseImproper(component);
            case 3 -> this.unparseMixed(component);
            case 4 -> this.unparseWhole(component);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final NumberLineText parse() throws MathFormattingException {
        NumberLineText numberLineText;
        try {
            numberLineText = this.parseComponents();
        }
        catch (Exception e) {
            throw new MathFormattingException("Parsing error in number line string parser", e);
        }
        return numberLineText;
    }

    public final void clear() {
        this.intervalString = "";
        this.lineStartString = "";
        this.lineEndString = "";
        this.segmentStart = "";
        this.segmentEnd = "";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineStringParser$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.IntervalType.values().length];
            try {
                nArray[SpatialMathEnum.IntervalType.DECIMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.IMPROPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.MIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.WHOLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

