/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineInterval;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.numberLine.NumberLineWidget;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathDispatcher;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006 "}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineWidgetUserDefined;", "Lorg/brailleblaster/math/numberLine/NumberLineWidget;", "<init>", "()V", "addIntervalNumbers", "", "shell", "Lorg/eclipse/swt/widgets/Shell;", "menu", "Lorg/eclipse/swt/widgets/Menu;", "addMenuItems", "settingsMenu", "setTextData", "extractInfoFromTextBoxes", "defaultDebug", "fillDebug", "t", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "onOpen", "extractText", "getWidget", "Lorg/eclipse/swt/widgets/Composite;", "parent", "container", "makePointCombo", "makeSegmentEditBoxes", "makeEndSegmentCombo", "makeStartSegmentCombo", "makeSegmentCombo", "label", "", "Companion", "brailleblaster-core"})
public final class NumberLineWidgetUserDefined
extends NumberLineWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int INTERVAL_LIMIT = 10;

    private final void addIntervalNumbers(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(NumberLineConstants.MARKER_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        for (int i = 2; i < 11; ++i) {
            String s = String.valueOf(i);
            MenuItem b = new MenuItem(dropDownMenu, 16);
            b.setText(s);
            b.setSelection(this.getNumberLine().getSettings().getUserDefinedArray().size() == i);
            b.addListener(13, arg_0 -> NumberLineWidgetUserDefined.addIntervalNumbers$lambda$0(b, this, i, arg_0));
        }
    }

    @Override
    @NotNull
    public Menu addMenuItems(@NotNull Shell shell, @NotNull Menu menu, @NotNull Menu settingsMenu) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)settingsMenu, (String)"settingsMenu");
        this.addNumberLineType(shell, menu);
        this.addOptionsMenu(shell, menu, settingsMenu);
        this.addIntervalNumbers(shell, menu);
        this.addSectionTypeMenu(shell, menu);
        if (SpatialMathEnum.NumberLineSection.SEGMENT == this.getNumberLine().getSettings().getSectionType()) {
            this.addStartSegmentType(shell, menu);
            this.addEndSegmentType(shell, menu);
        } else if (SpatialMathEnum.NumberLineSection.POINTS == this.getNumberLine().getSettings().getSectionType()) {
            this.addAdditionalSegmentDropDown(shell, menu);
            this.addPointsType(shell, menu);
        }
        return menu;
    }

    private final void setTextData() {
    }

    private final void extractInfoFromTextBoxes() {
    }

    private final void defaultDebug() {
        for (int i = 0; i < 4; ++i) {
            if (this.getNumberLine().getSettings().getUserDefinedArray().size() >= i) continue;
            this.getNumberLine().getSettings().getUserDefinedArray().add(new NumberLineInterval(null, null, new MathText(String.valueOf(i + 1), SpatialMathUtils.translate(this.getNumberLine().getSettings().getTranslationUserDefined(), String.valueOf(i + 1)), false, 4, null), null, 11, null));
        }
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    @Override
    public void fillDebug(@NotNull ISpatialMathContainer t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.setNumberLine((NumberLine)t);
        this.defaultDebug();
    }

    @Override
    public void onOpen() {
        this.setTextData();
    }

    @Override
    public void extractText() {
        this.extractInfoFromTextBoxes();
    }

    @Override
    @NotNull
    public Composite getWidget(@NotNull Composite parent, @NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.setNumberLine((NumberLine)container);
        this.makeSegmentEditBoxes(parent);
        if (SpatialMathEnum.NumberLineSection.SEGMENT == this.getNumberLine().getSettings().getSectionType()) {
            this.makeStartSegmentCombo(parent);
            this.makeEndSegmentCombo(parent);
        } else if (SpatialMathEnum.NumberLineSection.POINTS == this.getNumberLine().getSettings().getSectionType()) {
            this.getNumberLine().initializePoints();
            this.makePointCombo(parent);
        }
        this.addBlankAndLabels(parent);
        return parent;
    }

    private final void makePointCombo(Composite shell) {
        Group g = EasySWT.makeGroup((Composite)shell, (int)0, (int)1, (boolean)true);
        g.setText(NumberLineConstants.POINT);
        int n = ((Collection)this.getNumberLine().getNumberLineText().getPoints()).size();
        for (int j = 0; j < n; ++j) {
            NumberLineSegmentPoint point = this.getNumberLine().getSegmentPoints().get(j);
            int n2 = 0;
            int n3 = this.getNumberLine().getSettings().getNumUserDefinedIntervals();
            String[] stringArray = new String[n3];
            while (n2 < n3) {
                int n4 = n2++;
                stringArray[n4] = NumberLineConstants.MARKER_LABEL + " " + (n4 + 1);
            }
            String[] items = stringArray;
            Combo c = new Combo((Composite)g, 12);
            c.setData((Object)new GridData(4, 4, true, true));
            c.setItems(Arrays.copyOf(items, items.length));
            c.select(c.indexOf(NumberLineConstants.MARKER_LABEL + " " + point.getInterval()));
            EasySWT.INSTANCE.addSelectionListener(c, arg_0 -> NumberLineWidgetUserDefined.makePointCombo$lambda$0(c, point, arg_0));
        }
    }

    private final void makeSegmentEditBoxes(Composite shell) {
        Group g = EasySWT.makeGroup((Composite)shell, (int)0, (int)2, (boolean)true);
        int n = this.getNumberLine().getSettings().getNumUserDefinedIntervals();
        for (int i = 0; i < n; ++i) {
            EasySWT.makeLabel((Composite)((Composite)g), (String)(NumberLineConstants.MARKER_LABEL + " " + (i + 1)), (int)1);
            Text t = EasySWT.makeText((Composite)((Composite)g), (int)50, (int)1);
            if (this.getNumberLine().getSettings().getUserDefinedArray().size() > i) {
                t.setText(this.getNumberLine().getSettings().getUserDefinedArray().get((int)i).getUserText().print);
            }
            EasySWT.INSTANCE.addModifyListener(t, arg_0 -> NumberLineWidgetUserDefined.makeSegmentEditBoxes$lambda$0(t, this, i, arg_0));
        }
    }

    private final void makeEndSegmentCombo(Composite shell) {
        this.makeSegmentCombo(shell, NumberLineConstants.SEGMENT_END_LABEL);
    }

    private final void makeStartSegmentCombo(Composite shell) {
        this.makeSegmentCombo(shell, NumberLineConstants.SEGMENT_START_LABEL);
    }

    private final void makeSegmentCombo(Composite shell, String label) {
        Group g = EasySWT.makeGroup((Composite)shell, (int)0, (int)2, (boolean)true);
        EasySWT.makeLabel((Composite)((Composite)g), (String)label, (int)1);
        Combo c = new Combo((Composite)g, 12);
        c.setData((Object)new GridData(4, 4, true, true));
        int n = 0;
        int n2 = this.getNumberLine().getSettings().getNumUserDefinedIntervals();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = NumberLineConstants.MARKER_LABEL + " " + (n3 + 1);
        }
        String[] items = stringArray;
        c.setItems(Arrays.copyOf(items, items.length));
        c.select(c.indexOf(NumberLineConstants.MARKER_LABEL + " " + this.getNumberLine().getSettings().getSegmentStartInterval()));
        c.addSelectionListener(new SelectionListener(c, this){
            final /* synthetic */ Combo $c;
            final /* synthetic */ NumberLineWidgetUserDefined this$0;
            {
                this.$c = $c;
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String s = this.$c.getText();
                Intrinsics.checkNotNull((Object)s);
                String string = s.substring(s.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int i = Integer.parseInt(string);
                this.this$0.getNumberLine().getSettings().setSegmentStartInterval(i);
                this.this$0.getNumberLine().getNumberLineText().getSegment().setStartInterval(i);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    private static final void addIntervalNumbers$lambda$0(MenuItem $b, NumberLineWidgetUserDefined this$0, int $i, Event it) {
        if (!$b.getSelection()) {
            return;
        }
        this$0.getNumberLine().getSettings().setNumUserDefinedIntervals($i);
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void makePointCombo$lambda$0(Combo $c, NumberLineSegmentPoint $point, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int index = $c.getSelectionIndex();
        $point.setInterval(index + 1);
    }

    private static final void makeSegmentEditBoxes$lambda$0(Text $t, NumberLineWidgetUserDefined this$0, int $i, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String print = $t.getText();
        SpatialMathEnum.Translation translation = this$0.getNumberLine().getSettings().getTranslationUserDefined();
        Intrinsics.checkNotNull((Object)print);
        String braille = SpatialMathUtils.translate(translation, print);
        if (this$0.getNumberLine().getSettings().getUserDefinedArray().size() > $i) {
            this$0.getNumberLine().getSettings().getUserDefinedArray().get($i).setUserText(new MathText(print, braille, false, 4, null));
        } else {
            this$0.getNumberLine().getSettings().getUserDefinedArray().add(new NumberLineInterval(null, null, new MathText(print, braille, false, 4, null), null, 11, null));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineWidgetUserDefined$Companion;", "", "<init>", "()V", "INTERVAL_LIMIT", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

