/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.spatial.ConnectingContainer;
import org.brailleblaster.math.spatial.ConnectingContainerSettings;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathWidget;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/brailleblaster/math/spatial/ConnectingContainerWidget;", "Lorg/brailleblaster/math/spatial/ISpatialMathWidget;", "<init>", "()V", "st", "Lorg/eclipse/swt/custom/StyledText;", "cc", "Lorg/brailleblaster/math/spatial/ConnectingContainer;", "getCc", "()Lorg/brailleblaster/math/spatial/ConnectingContainer;", "setCc", "(Lorg/brailleblaster/math/spatial/ConnectingContainer;)V", "fillDebug", "", "t", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "getWidget", "Lorg/eclipse/swt/widgets/Composite;", "parent", "container", "onOpen", "extractText", "addMenuItems", "Lorg/eclipse/swt/widgets/Menu;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "menu", "settingsMenu", "addTranslationMenu", "addHorizontalMenu", "addVerticalMenu", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nConnectingContainerWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectingContainerWidget.kt\norg/brailleblaster/math/spatial/ConnectingContainerWidget\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,115:1\n37#2,2:116\n37#2,2:118\n*S KotlinDebug\n*F\n+ 1 ConnectingContainerWidget.kt\norg/brailleblaster/math/spatial/ConnectingContainerWidget\n*L\n86#1:116,2\n99#1:118,2\n*E\n"})
public final class ConnectingContainerWidget
implements ISpatialMathWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StyledText st;
    @Nullable
    private ConnectingContainer cc;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @NotNull
    private static final String VERTICAL_LABEL = localeHandler.get("verticalLabel");
    @NotNull
    private static final String HORIZONTAL_LABEL = localeHandler.get("horizontalLabel");
    @NotNull
    private static final String TRANSLATE_AS_MATH = localeHandler.get("translateAsMath");
    @NotNull
    private static final String DEBUG_TEXT = "Debug text";

    @Nullable
    public final ConnectingContainer getCc() {
        return this.cc;
    }

    public final void setCc(@Nullable ConnectingContainer connectingContainer) {
        this.cc = connectingContainer;
    }

    @Override
    public void fillDebug(@NotNull ISpatialMathContainer t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        ConnectingContainer connectingContainer = this.cc = (ConnectingContainer)t;
        Intrinsics.checkNotNull((Object)connectingContainer);
        ConnectingContainer connectingContainer2 = this.cc;
        Intrinsics.checkNotNull((Object)connectingContainer2);
        connectingContainer.setText(new MathText(DEBUG_TEXT, connectingContainer2.getSettings().isTranslateAsMath() ? MathModuleUtils.INSTANCE.translateMathPrint(DEBUG_TEXT) : MathModuleUtils.INSTANCE.translateMainPrint(DEBUG_TEXT), false, 4, null));
    }

    @Override
    @NotNull
    public Composite getWidget(@NotNull Composite parent, @NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.cc = (ConnectingContainer)container;
        StyledText styledText = this.st = new StyledText(parent, 0);
        Intrinsics.checkNotNull((Object)styledText);
        styledText.setData((Object)new GridData(4, 4, true, true));
        StyledText styledText2 = this.st;
        Intrinsics.checkNotNull((Object)styledText2);
        styledText2.setText(StringsKt.repeat((CharSequence)" ", (int)50) + "\n\n");
        return parent;
    }

    @Override
    public void onOpen() {
        StyledText styledText = this.st;
        Intrinsics.checkNotNull((Object)styledText);
        ConnectingContainer connectingContainer = this.cc;
        Intrinsics.checkNotNull((Object)connectingContainer);
        styledText.setText(connectingContainer.getPrintText());
    }

    @Override
    public void extractText() {
        ConnectingContainer connectingContainer = this.cc;
        Intrinsics.checkNotNull((Object)connectingContainer);
        if (connectingContainer.getSettings().isTranslateAsMath()) {
            ConnectingContainer connectingContainer2 = this.cc;
            Intrinsics.checkNotNull((Object)connectingContainer2);
            StyledText styledText = this.st;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            StyledText styledText2 = this.st;
            Intrinsics.checkNotNull((Object)styledText2);
            String string2 = styledText2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            connectingContainer2.setText(new MathText(string, MathModuleUtils.INSTANCE.translateMathPrint(string2), false, 4, null));
        } else {
            ConnectingContainer connectingContainer3 = this.cc;
            Intrinsics.checkNotNull((Object)connectingContainer3);
            StyledText styledText = this.st;
            Intrinsics.checkNotNull((Object)styledText);
            String string = styledText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            StyledText styledText3 = this.st;
            Intrinsics.checkNotNull((Object)styledText3);
            String string3 = styledText3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            connectingContainer3.setText(new MathText(string, MathModuleUtils.INSTANCE.translateMainPrint(string3), false, 4, null));
        }
    }

    @Override
    @NotNull
    public Menu addMenuItems(@NotNull Shell shell, @NotNull Menu menu, @NotNull Menu settingsMenu) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)settingsMenu, (String)"settingsMenu");
        this.addVerticalMenu(shell, menu);
        this.addHorizontalMenu(shell, menu);
        this.addTranslationMenu(shell, settingsMenu);
        return menu;
    }

    private final void addTranslationMenu(Shell shell, Menu menu) {
        MenuItem numericPassage = new MenuItem(menu, 32);
        numericPassage.setText(TRANSLATE_AS_MATH);
        ConnectingContainer connectingContainer = this.cc;
        Intrinsics.checkNotNull((Object)connectingContainer);
        numericPassage.setSelection(connectingContainer.getSettings().isTranslateAsMath());
        numericPassage.addListener(13, arg_0 -> ConnectingContainerWidget.addTranslationMenu$lambda$0(this, arg_0));
    }

    private final void addHorizontalMenu(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(HORIZONTAL_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        Collection $this$toTypedArray$iv = (Collection)SpatialMathEnum.HorizontalJustify.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (SpatialMathEnum.HorizontalJustify vj : thisCollection$iv.toArray(new SpatialMathEnum.HorizontalJustify[0])) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(vj.name());
            ConnectingContainer connectingContainer = this.cc;
            Intrinsics.checkNotNull((Object)connectingContainer);
            blankBlock.setSelection(vj == connectingContainer.getSettings().getHorizontal());
            blankBlock.addListener(13, arg_0 -> ConnectingContainerWidget.addHorizontalMenu$lambda$0(this, vj, arg_0));
        }
    }

    private final void addVerticalMenu(Shell shell, Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(VERTICAL_LABEL);
        Menu dropDownMenu = new Menu((Decorations)shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        Collection $this$toTypedArray$iv = (Collection)SpatialMathEnum.VerticalJustify.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (SpatialMathEnum.VerticalJustify vj : thisCollection$iv.toArray(new SpatialMathEnum.VerticalJustify[0])) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(vj.name());
            ConnectingContainer connectingContainer = this.cc;
            Intrinsics.checkNotNull((Object)connectingContainer);
            blankBlock.setSelection(vj == connectingContainer.getSettings().getVertical());
            blankBlock.addListener(13, arg_0 -> ConnectingContainerWidget.addVerticalMenu$lambda$0(this, vj, arg_0));
        }
    }

    private static final void addTranslationMenu$lambda$0(ConnectingContainerWidget this$0, Event it) {
        ConnectingContainer connectingContainer = this$0.cc;
        Intrinsics.checkNotNull((Object)connectingContainer);
        ConnectingContainerSettings connectingContainerSettings = connectingContainer.getSettings();
        ConnectingContainer connectingContainer2 = this$0.cc;
        Intrinsics.checkNotNull((Object)connectingContainer2);
        connectingContainerSettings.setTranslateAsMath(!connectingContainer2.getSettings().isTranslateAsMath());
    }

    private static final void addHorizontalMenu$lambda$0(ConnectingContainerWidget this$0, SpatialMathEnum.HorizontalJustify $vj, Event it) {
        ConnectingContainer connectingContainer = this$0.cc;
        Intrinsics.checkNotNull((Object)connectingContainer);
        connectingContainer.getSettings().setHorizontal($vj);
    }

    private static final void addVerticalMenu$lambda$0(ConnectingContainerWidget this$0, SpatialMathEnum.VerticalJustify $vj, Event it) {
        ConnectingContainer connectingContainer = this$0.cc;
        Intrinsics.checkNotNull((Object)connectingContainer);
        connectingContainer.getSettings().setVertical($vj);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/math/spatial/ConnectingContainerWidget$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "VERTICAL_LABEL", "", "HORIZONTAL_LABEL", "TRANSLATE_AS_MATH", "DEBUG_TEXT", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

