/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.spatial.ISpatialMathSettings;
import org.brailleblaster.math.spatial.MatrixCell;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 <2\u00020\u0001:\u0001<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u00102\u001a\u000203H\u0002J\u001e\u00104\u001a\u0002032\u0016\u00105\u001a\u0012\u0012\u0004\u0012\u00020!06j\b\u0012\u0004\u0012\u00020!`7R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR&\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R!\u00108\u001a\u0012\u0012\u0004\u0012\u00020906j\b\u0012\u0004\u0012\u000209`78F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006="}, d2={"Lorg/brailleblaster/math/spatial/MatrixSettings;", "Lorg/brailleblaster/math/spatial/ISpatialMathSettings;", "<init>", "()V", "value", "", "rows", "getRows", "()I", "setRows", "(I)V", "cols", "getCols", "setCols", "bracketType", "Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;", "getBracketType", "()Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;", "setBracketType", "(Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;)V", "wideType", "Lorg/brailleblaster/math/spatial/MatrixConstants$Wide;", "getWideType", "()Lorg/brailleblaster/math/spatial/MatrixConstants$Wide;", "setWideType", "(Lorg/brailleblaster/math/spatial/MatrixConstants$Wide;)V", "isAddEllipses", "", "()Z", "setAddEllipses", "(Z)V", "model", "", "Lorg/brailleblaster/math/spatial/MatrixCell;", "getModel", "()Ljava/util/List;", "setModel", "(Ljava/util/List;)V", "passage", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "getPassage", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "setPassage", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;)V", "translation", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;", "getTranslation", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;", "setTranslation", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;)V", "buildModel", "", "setModelFromArray", "array", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "ellipsesArray", "", "getEllipsesArray", "()Ljava/util/ArrayList;", "Companion", "brailleblaster-core"})
public final class MatrixSettings
implements ISpatialMathSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int rows = 3;
    private int cols = 3;
    @NotNull
    private MatrixConstants.BracketType bracketType = DEFAULT_BRACKET;
    @NotNull
    private MatrixConstants.Wide wideType = DEFAULT_WIDE;
    private boolean isAddEllipses;
    @NotNull
    private List<List<MatrixCell>> model = new ArrayList();
    @NotNull
    private SpatialMathEnum.Passage passage = SpatialMathEnum.Passage.NONE;
    @Nullable
    private SpatialMathEnum.Translation translation = SpatialMathEnum.Translation.ASCII_MATH;
    private static final Logger log = LoggerFactory.getLogger(MatrixSettings.class);
    @JvmField
    @NotNull
    public static final MatrixConstants.BracketType DEFAULT_BRACKET = MatrixConstants.BracketType.BIG_SQUARE;
    public static final int DEFAULT_COLS = 3;
    public static final int DEFAULT_ROWS = 3;
    @JvmField
    @NotNull
    public static final MatrixConstants.Wide DEFAULT_WIDE = MatrixConstants.Wide.BLOCK_BLANK;

    public MatrixSettings() {
        this.buildModel();
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int value) {
        this.rows = value;
        this.buildModel();
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int value) {
        this.cols = value;
        this.buildModel();
    }

    @NotNull
    public final MatrixConstants.BracketType getBracketType() {
        return this.bracketType;
    }

    public final void setBracketType(@NotNull MatrixConstants.BracketType bracketType) {
        Intrinsics.checkNotNullParameter((Object)((Object)bracketType), (String)"<set-?>");
        this.bracketType = bracketType;
    }

    @NotNull
    public final MatrixConstants.Wide getWideType() {
        return this.wideType;
    }

    public final void setWideType(@NotNull MatrixConstants.Wide wide) {
        Intrinsics.checkNotNullParameter((Object)((Object)wide), (String)"<set-?>");
        this.wideType = wide;
    }

    public final boolean isAddEllipses() {
        return this.isAddEllipses;
    }

    public final void setAddEllipses(boolean bl) {
        this.isAddEllipses = bl;
    }

    @NotNull
    public final List<List<MatrixCell>> getModel() {
        return this.model;
    }

    public final void setModel(@NotNull List<List<MatrixCell>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.model = list;
    }

    @Override
    @NotNull
    public SpatialMathEnum.Passage getPassage() {
        return this.passage;
    }

    @Override
    public void setPassage(@NotNull SpatialMathEnum.Passage passage) {
        Intrinsics.checkNotNullParameter((Object)((Object)passage), (String)"<set-?>");
        this.passage = passage;
    }

    @Nullable
    public final SpatialMathEnum.Translation getTranslation() {
        return this.translation;
    }

    public final void setTranslation(@Nullable SpatialMathEnum.Translation translation) {
        this.translation = translation;
    }

    private final void buildModel() {
        int i;
        int n = this.rows;
        for (i = 0; i < n; ++i) {
            if (this.model.size() >= i + 1) continue;
            ArrayList row = new ArrayList();
            this.model.add(row);
        }
        n = this.rows;
        for (i = 0; i < n; ++i) {
            int n2 = this.cols;
            for (int j = 0; j < n2; ++j) {
                if (this.model.get(i).size() >= j + 1) continue;
                this.model.get(i).add(new MatrixCell("", false));
            }
        }
    }

    public final void setModelFromArray(@NotNull ArrayList<MatrixCell> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        int n = this.rows;
        for (int i = 0; i < n; ++i) {
            int n2 = this.cols;
            for (int j = 0; j < n2; ++j) {
                int index = i * this.cols + j;
                if (array.size() <= index) continue;
                MatrixCell matrixCell = array.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)matrixCell, (String)"get(...)");
                this.model.get(i).set(j, matrixCell);
            }
        }
    }

    @NotNull
    public final ArrayList<String> getEllipsesArray() {
        ArrayList<String> array = new ArrayList<String>();
        int n = this.rows;
        for (int i = 0; i < n; ++i) {
            int n2 = this.cols;
            for (int j = 0; j < n2; ++j) {
                array.add(String.valueOf(this.model.get(i).get(j).isEllipsis()));
            }
        }
        return array;
    }

    @JvmStatic
    @NotNull
    public static final MatrixConstants.Wide enumifyWide(@NotNull String s) {
        return Companion.enumifyWide(s);
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<MatrixCell> combineCellComponents(@NotNull ArrayList<String> text, @NotNull ArrayList<String> ellipses) {
        return Companion.combineCellComponents(text, ellipses);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007JL\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0013j\b\u0012\u0004\u0012\u00020\u0010`\u00152\u001a\u0010\u0017\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0013j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0010`\u0015H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/math/spatial/MatrixSettings$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "DEFAULT_BRACKET", "Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;", "DEFAULT_COLS", "", "DEFAULT_ROWS", "DEFAULT_WIDE", "Lorg/brailleblaster/math/spatial/MatrixConstants$Wide;", "enumifyBracket", "s", "", "enumifyWide", "combineCellComponents", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/spatial/MatrixCell;", "Lkotlin/collections/ArrayList;", "text", "ellipses", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MatrixConstants.BracketType enumifyBracket(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            for (MatrixConstants.BracketType b : MatrixConstants.BracketType.getEntries()) {
                if (!Intrinsics.areEqual((Object)b.getLabel(), (Object)s)) continue;
                return b;
            }
            log.error("Combo box does not match bracket enum options, using default");
            return DEFAULT_BRACKET;
        }

        @JvmStatic
        @NotNull
        public final MatrixConstants.Wide enumifyWide(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            for (MatrixConstants.Wide w : MatrixConstants.Wide.getEntries()) {
                if (!Intrinsics.areEqual((Object)w.getLabel(), (Object)s)) continue;
                return w;
            }
            log.error("Combo box does not match wide enum options, using default");
            return DEFAULT_WIDE;
        }

        @JvmStatic
        @NotNull
        public final ArrayList<MatrixCell> combineCellComponents(@NotNull ArrayList<String> text, @NotNull ArrayList<String> ellipses) {
            Intrinsics.checkNotNullParameter(text, (String)"text");
            Intrinsics.checkNotNullParameter(ellipses, (String)"ellipses");
            ArrayList<MatrixCell> array = new ArrayList<MatrixCell>();
            Iterator iterator = ((Iterable)text).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                String t = (String)iterator.next();
                boolean hasEllipsis = Boolean.parseBoolean(ellipses.get(i));
                array.add(new MatrixCell(hasEllipsis ? "" : t, hasEllipsis));
            }
            return array;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

