/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.spatial.Grid;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/brailleblaster/math/spatial/SpatialMathUtils;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "translate", "", "translation", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;", "input", "currentIsSpatialGrid", "", "print", "", "grid", "Lorg/brailleblaster/math/spatial/Grid;", "middleSpatialMathPage", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "isSpatialMathPage", "node", "Lnu/xom/Node;", "getSpatialPageParent", "Lnu/xom/Element;", "USE_EDITOR_WARNING", "ROW_GROUP", "COL_LABEL", "CANCEL_LABEL", "DELETE_CONTAINER", "PREVIOUS_LABEL", "NEXT_LABEL", "DELETE", "OK_LABEL", "brailleblaster-core"})
public final class SpatialMathUtils {
    @NotNull
    public static final SpatialMathUtils INSTANCE = new SpatialMathUtils();
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @JvmField
    @NotNull
    public static final String USE_EDITOR_WARNING = localeHandler.get("spatialPageUseEditorWarning");
    @JvmField
    @NotNull
    public static final String ROW_GROUP = localeHandler.get("rowGroup");
    @JvmField
    @NotNull
    public static final String COL_LABEL = localeHandler.get("col");
    @JvmField
    @NotNull
    public static final String CANCEL_LABEL = localeHandler.get("cancelLabel");
    @JvmField
    @NotNull
    public static final String DELETE_CONTAINER = localeHandler.get("deleteContainer");
    @JvmField
    @NotNull
    public static final String PREVIOUS_LABEL = localeHandler.get("previous");
    @JvmField
    @NotNull
    public static final String NEXT_LABEL = localeHandler.get("next");
    @JvmField
    @NotNull
    public static final String DELETE = localeHandler.get("delete");
    @JvmField
    @NotNull
    public static final String OK_LABEL = localeHandler.get("insertContainer");

    private SpatialMathUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String translate(@NotNull SpatialMathEnum.Translation translation, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)((Object)translation), (String)"translation");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return switch (WhenMappings.$EnumSwitchMapping$0[translation.ordinal()]) {
            case 1 -> MathModuleUtils.INSTANCE.translateAsciiMath(input);
            case 2 -> input;
            case 3 -> MathModuleUtils.INSTANCE.translateMainPrint(input);
            case 4 -> MathModuleUtils.INSTANCE.translateUncontracted(input);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    public static final boolean currentIsSpatialGrid() {
        Node current = (Node)XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), SpatialMathUtils::currentIsSpatialGrid$lambda$0);
        boolean isWhitespace = WPManager.Companion.getInstance().getController().getMapList().getCurrent() instanceof WhiteSpaceElement;
        return !isWhitespace && current != null;
    }

    @JvmStatic
    public static final void print(@NotNull Grid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        int n = ((Collection)grid.getLines()).size();
        for (int i = 0; i < n; ++i) {
            System.out.println((Object)grid.getLines().get(i).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean middleSpatialMathPage(@NotNull TextMapElement currentElement) {
        Intrinsics.checkNotNullParameter((Object)currentElement, (String)"currentElement");
        if (currentElement.getNode() == null) return false;
        if (currentElement instanceof LineBreakElement) return false;
        Node node = currentElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        if (XMLHandler.Companion.ancestorVisitorElement(node, SpatialMathUtils::middleSpatialMathPage$lambda$0) == null) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isSpatialMathPage(@Nullable Node node) {
        return node != null && node.getDocument() != null && XMLHandler.Companion.ancestorElementIs(node, SpatialMathUtils::isSpatialMathPage$lambda$0);
    }

    @JvmStatic
    @Nullable
    public static final Element getSpatialPageParent(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XMLHandler.Companion.ancestorVisitorElement(node, SpatialMathUtils::getSpatialPageParent$lambda$0);
    }

    private static final boolean currentIsSpatialGrid$lambda$0(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    private static final boolean middleSpatialMathPage$lambda$0(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    private static final boolean isSpatialMathPage$lambda$0(Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)e);
    }

    private static final boolean getSpatialPageParent$lambda$0(Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)e);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.Translation.values().length];
            try {
                nArray[SpatialMathEnum.Translation.ASCII_MATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.Translation.DIRECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.Translation.LITERARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.Translation.UNCONTRACTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

