/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineComponent;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineSegment;
import org.brailleblaster.math.numberLine.NumberLineSettings;
import org.brailleblaster.math.numberLine.NumberLineText;
import org.brailleblaster.math.spatial.ConnectingContainer;
import org.brailleblaster.math.spatial.ConnectingContainerSettings;
import org.brailleblaster.math.spatial.Grid;
import org.brailleblaster.math.spatial.GridSettings;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathSettings;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.MatrixCell;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.MatrixSettings;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/math/spatial/VersionConverter;", "", "<init>", "()V", "convertNumberLine", "Lnu/xom/Element;", "ele", "convertTemplate", "templateElement", "convertMatrix", "current", "convertConnectingContainer", "node", "convertGrid", "brailleblaster-core"})
public final class VersionConverter {
    @NotNull
    public static final VersionConverter INSTANCE = new VersionConverter();

    private VersionConverter() {
    }

    @NotNull
    public final Element convertNumberLine(@NotNull Element ele) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        NumberLine numberLine = new NumberLine();
        SpatialMathEnum.Passage passage = (SpatialMathEnum.Passage)((Object)BBX.CONTAINER.MATRIX.NUMERIC_PASSAGE.get(ele));
        NumberLineSettings numberLineSettings = numberLine.getSettings();
        Intrinsics.checkNotNull((Object)((Object)passage));
        numberLineSettings.setPassage(passage);
        boolean arrow = Boolean.parseBoolean(ele.getAttributeValue(NumberLineConstants.ATTRIB_ARROW, ele.getNamespaceURI()));
        numberLine.getSettings().setArrow(arrow);
        boolean isStretch = Boolean.parseBoolean(ele.getAttributeValue(NumberLineConstants.ATTRIB_STRETCH, ele.getNamespaceURI()));
        numberLine.getSettings().setStretch(isStretch);
        boolean reduce = Boolean.parseBoolean(ele.getAttributeValue("reduceFraction", ele.getNamespaceURI()));
        numberLine.getSettings().setReduceFraction(reduce);
        SpatialMathEnum.NumberLineType numberLineType = (SpatialMathEnum.NumberLineType)((Object)BBX.CONTAINER.NUMBER_LINE.NUMBER_LINE_TYPE.get(ele));
        numberLine.getSettings().setType(numberLineType);
        if (numberLineType == SpatialMathEnum.NumberLineType.USER_DEFINED) {
            SpatialMathEnum.Translation translation = (SpatialMathEnum.Translation)((Object)BBX.CONTAINER.NUMBER_LINE.USER_DEFINED_TRANSLATION.get(ele));
            NumberLineSettings numberLineSettings2 = numberLine.getSettings();
            Intrinsics.checkNotNull((Object)((Object)translation));
            numberLineSettings2.setTranslationUserDefined(translation);
            ArrayList userDefinedArray = (ArrayList)BBX.CONTAINER.NUMBER_LINE.USER_DEFINED_SEGMENTS.get(ele);
            NumberLineSettings numberLineSettings3 = numberLine.getSettings();
            Intrinsics.checkNotNull((Object)userDefinedArray);
            numberLineSettings3.setPrintArray(userDefinedArray);
        } else {
            String string = ele.getAttributeValue("intervalType", ele.getNamespaceURI());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            SpatialMathEnum.IntervalType type = SpatialMathEnum.IntervalType.valueOf(string);
            numberLine.getSettings().setIntervalType(type);
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    String endLineWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_WHOLE, ele.getNamespaceURI());
                    String startLineWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_WHOLE, ele.getNamespaceURI());
                    String endSegmentWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_WHOLE, ele.getNamespaceURI());
                    String startSegmentWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_WHOLE, ele.getNamespaceURI());
                    String intervalWhole = ele.getAttributeValue("interval", ele.getNamespaceURI());
                    String endLineDecimal = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_DECIMAL, ele.getNamespaceURI());
                    String startLineDecimal = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_DECIMAL, ele.getNamespaceURI());
                    String endSegmentDecimal = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_DECIMAL, ele.getNamespaceURI());
                    String startSegmentDecimal = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_DECIMAL, ele.getNamespaceURI());
                    String intervalDecimal = ele.getAttributeValue("intervalDecimal", ele.getNamespaceURI());
                    Intrinsics.checkNotNull((Object)intervalWhole);
                    Intrinsics.checkNotNull((Object)intervalDecimal);
                    NumberLineComponent interval = new NumberLineComponent(intervalWhole, intervalDecimal, null, null, 12, null);
                    Intrinsics.checkNotNull((Object)startSegmentDecimal);
                    String string2 = startSegmentDecimal;
                    Intrinsics.checkNotNull((Object)startSegmentWhole);
                    String string3 = startSegmentWhole;
                    NumberLineComponent startSegment = new NumberLineComponent(string3, string2, null, null, 12, null);
                    Intrinsics.checkNotNull((Object)endSegmentWhole);
                    Intrinsics.checkNotNull((Object)endSegmentDecimal);
                    NumberLineComponent endSegment = new NumberLineComponent(endSegmentWhole, endSegmentDecimal, null, null, 12, null);
                    Intrinsics.checkNotNull((Object)startLineWhole);
                    Intrinsics.checkNotNull((Object)startLineDecimal);
                    NumberLineComponent startLine = new NumberLineComponent(startLineWhole, startLineDecimal, null, null, 12, null);
                    Intrinsics.checkNotNull((Object)endLineWhole);
                    Intrinsics.checkNotNull((Object)endLineDecimal);
                    NumberLineComponent endLine = new NumberLineComponent(endLineWhole, endLineDecimal, null, null, 12, null);
                    SpatialMathEnum.Fill fill = numberLine.getSettings().getStartLineCircle();
                    SpatialMathEnum.Fill fill2 = numberLine.getSettings().getEndSegmentCircle();
                    NumberLineSegment numberLineSegment = new NumberLineSegment(fill, fill2, startSegment, endSegment, 0, 0, 48, null);
                    NumberLineText text = new NumberLineText(interval, numberLineSegment, startLine, endLine, null, 16, null);
                    numberLine.setNumberLineText(text);
                    break;
                }
                case 2: {
                    String endLineNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_NUMERATOR, ele.getNamespaceURI());
                    String startLineNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_NUMERATOR, ele.getNamespaceURI());
                    String endSegmentNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_NUMERATOR, ele.getNamespaceURI());
                    String startSegmentNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_NUMERATOR, ele.getNamespaceURI());
                    String intervalNumerator = ele.getAttributeValue("intervalNumerator", ele.getNamespaceURI());
                    String endLineDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_DENOMINATOR, ele.getNamespaceURI());
                    String startLineDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_DENOMINATOR, ele.getNamespaceURI());
                    String endSegmentDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_DENOMINATOR, ele.getNamespaceURI());
                    String startSegmentDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_DENOMINATOR, ele.getNamespaceURI());
                    String intervalDenominator = ele.getAttributeValue("intervalDenominator", ele.getNamespaceURI());
                    Intrinsics.checkNotNull((Object)intervalNumerator);
                    Intrinsics.checkNotNull((Object)intervalDenominator);
                    NumberLineComponent interval = new NumberLineComponent(null, null, intervalNumerator, intervalDenominator, 3, null);
                    Intrinsics.checkNotNull((Object)startSegmentDenominator);
                    Object endSegment = startSegmentDenominator;
                    Intrinsics.checkNotNull((Object)startSegmentNumerator);
                    Object startLine = startSegmentNumerator;
                    NumberLineComponent startSegment = new NumberLineComponent(null, null, (String)startLine, (String)endSegment, 3, null);
                    Intrinsics.checkNotNull((Object)endSegmentNumerator);
                    Intrinsics.checkNotNull((Object)endSegmentDenominator);
                    endSegment = new NumberLineComponent(null, null, endSegmentNumerator, endSegmentDenominator, 3, null);
                    Intrinsics.checkNotNull((Object)startLineNumerator);
                    Intrinsics.checkNotNull((Object)startLineDenominator);
                    startLine = new NumberLineComponent(null, null, startLineNumerator, startLineDenominator, 3, null);
                    Intrinsics.checkNotNull((Object)endLineNumerator);
                    Intrinsics.checkNotNull((Object)endLineDenominator);
                    NumberLineComponent endLine = new NumberLineComponent(null, null, endLineNumerator, endLineDenominator, 3, null);
                    NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, startSegment, (NumberLineComponent)endSegment, 0, 0, 51, null);
                    NumberLineText text = new NumberLineText(interval, numberLineSegment, (NumberLineComponent)startLine, endLine, null, 16, null);
                    numberLine.setNumberLineText(text);
                    break;
                }
                case 3: {
                    String endLineWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_WHOLE, ele.getNamespaceURI());
                    String startLineWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_WHOLE, ele.getNamespaceURI());
                    String endSegmentWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_WHOLE, ele.getNamespaceURI());
                    String startSegmentWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_WHOLE, ele.getNamespaceURI());
                    String intervalWhole = ele.getAttributeValue("interval", ele.getNamespaceURI());
                    String endLineNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_NUMERATOR, ele.getNamespaceURI());
                    String startLineNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_NUMERATOR, ele.getNamespaceURI());
                    String endSegmentNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_NUMERATOR, ele.getNamespaceURI());
                    String startSegmentNumerator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_NUMERATOR, ele.getNamespaceURI());
                    String intervalNumerator = ele.getAttributeValue("intervalNumerator", ele.getNamespaceURI());
                    String endLineDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_DENOMINATOR, ele.getNamespaceURI());
                    String startLineDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_DENOMINATOR, ele.getNamespaceURI());
                    String endSegmentDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_DENOMINATOR, ele.getNamespaceURI());
                    String startSegmentDenominator = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_DENOMINATOR, ele.getNamespaceURI());
                    String intervalDenominator = ele.getAttributeValue("intervalDenominator", ele.getNamespaceURI());
                    Intrinsics.checkNotNull((Object)intervalWhole);
                    Intrinsics.checkNotNull((Object)intervalNumerator);
                    Intrinsics.checkNotNull((Object)intervalDenominator);
                    NumberLineComponent interval = new NumberLineComponent(intervalWhole, null, intervalNumerator, intervalDenominator, 2, null);
                    Intrinsics.checkNotNull((Object)startSegmentDenominator);
                    String string4 = startSegmentDenominator;
                    Intrinsics.checkNotNull((Object)startSegmentNumerator);
                    String string5 = startSegmentNumerator;
                    Intrinsics.checkNotNull((Object)startSegmentWhole);
                    String string6 = startSegmentWhole;
                    NumberLineComponent startSegment = new NumberLineComponent(string6, null, string5, string4, 2, null);
                    Intrinsics.checkNotNull((Object)endSegmentWhole);
                    Intrinsics.checkNotNull((Object)endSegmentNumerator);
                    Intrinsics.checkNotNull((Object)endSegmentDenominator);
                    NumberLineComponent endSegment = new NumberLineComponent(endSegmentWhole, null, endSegmentNumerator, endSegmentDenominator, 2, null);
                    Intrinsics.checkNotNull((Object)startLineWhole);
                    Intrinsics.checkNotNull((Object)startLineNumerator);
                    Intrinsics.checkNotNull((Object)startLineDenominator);
                    NumberLineComponent startLine = new NumberLineComponent(startLineWhole, null, startLineNumerator, startLineDenominator, 2, null);
                    Intrinsics.checkNotNull((Object)endLineWhole);
                    Intrinsics.checkNotNull((Object)endLineNumerator);
                    Intrinsics.checkNotNull((Object)endLineDenominator);
                    NumberLineComponent endLine = new NumberLineComponent(endLineWhole, null, endLineNumerator, endLineDenominator, 2, null);
                    NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, startSegment, endSegment, 0, 0, 51, null);
                    NumberLineText text = new NumberLineText(interval, numberLineSegment, startLine, endLine, null, 16, null);
                    numberLine.setNumberLineText(text);
                    break;
                }
                default: {
                    String endLineWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_END_WHOLE, ele.getNamespaceURI());
                    String startLineWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_LINE_START_WHOLE, ele.getNamespaceURI());
                    String endSegmentWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_END_WHOLE, ele.getNamespaceURI());
                    String startSegmentWhole = ele.getAttributeValue(NumberLineConstants.ATTRIB_SEGMENT_START_WHOLE, ele.getNamespaceURI());
                    String intervalWhole = ele.getAttributeValue("interval", ele.getNamespaceURI());
                    Intrinsics.checkNotNull((Object)intervalWhole);
                    NumberLineComponent interval = new NumberLineComponent(intervalWhole, null, null, null, 14, null);
                    Intrinsics.checkNotNull((Object)startSegmentWhole);
                    NumberLineComponent startSegment = new NumberLineComponent(startSegmentWhole, null, null, null, 14, null);
                    Intrinsics.checkNotNull((Object)endSegmentWhole);
                    NumberLineComponent endSegment = new NumberLineComponent(endSegmentWhole, null, null, null, 14, null);
                    Intrinsics.checkNotNull((Object)startLineWhole);
                    NumberLineComponent startLine = new NumberLineComponent(startLineWhole, null, null, null, 14, null);
                    Intrinsics.checkNotNull((Object)endLineWhole);
                    NumberLineComponent endLine = new NumberLineComponent(endLineWhole, null, null, null, 14, null);
                    NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, startSegment, endSegment, 0, 0, 51, null);
                    NumberLineText text = new NumberLineText(interval, numberLineSegment, startLine, endLine, null, 16, null);
                    numberLine.setNumberLineText(text);
                }
            }
        }
        Element element = BBX.CONTAINER.NUMBER_LINE.create(numberLine);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        return element;
    }

    @NotNull
    public final Element convertTemplate(@Nullable Element templateElement) {
        Template template = new Template();
        TemplateSettings templateSettings = template.getSettings();
        Object t = BBX.CONTAINER.TEMPLATE.OPERATOR.get(templateElement);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        templateSettings.setOperator((SpatialMathEnum.OPERATOR)((Object)t));
        TemplateSettings templateSettings2 = template.getSettings();
        Object t2 = BBX.CONTAINER.TEMPLATE.TYPE.get(templateElement);
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        templateSettings2.setType((SpatialMathEnum.TemplateType)((Object)t2));
        ArrayList printNumbers = (ArrayList)BBX.CONTAINER.TEMPLATE.OPERANDS.get(templateElement);
        Intrinsics.checkNotNull((Object)printNumbers);
        template.setPrintOperands(printNumbers);
        ArrayList solutionNumbers = (ArrayList)BBX.CONTAINER.TEMPLATE.SOLUTIONS.get(templateElement);
        Intrinsics.checkNotNull((Object)solutionNumbers);
        template.setPrintSolutions(solutionNumbers);
        SpatialMathEnum.Passage p = (SpatialMathEnum.Passage)((Object)BBX.CONTAINER.TEMPLATE.PASSAGE_MODE.get(templateElement));
        if (MathModuleUtils.isNemeth() && p == SpatialMathEnum.Passage.NUMERIC) {
            p = SpatialMathEnum.Passage.NONE;
        }
        if (!MathModuleUtils.isNemeth() && p == SpatialMathEnum.Passage.NEMETH) {
            p = SpatialMathEnum.Passage.NONE;
        }
        TemplateSettings templateSettings3 = template.getSettings();
        SpatialMathEnum.Passage passage = p;
        Intrinsics.checkNotNull((Object)((Object)passage));
        templateSettings3.setPassage(passage);
        template.getSettings().setOperands(template.getOperands().size());
        template.getSettings().setSolutions(template.getSolutions().size());
        TemplateSettings templateSettings4 = template.getSettings();
        Object t3 = BBX.CONTAINER.TEMPLATE.STRAIGHT_RADICAL.get(templateElement);
        Intrinsics.checkNotNullExpressionValue(t3, (String)"get(...)");
        templateSettings4.setStraightRadicalSymbol((Boolean)t3);
        Boolean identifier = (Boolean)BBX.CONTAINER.TEMPLATE.IDENTIFER_AS_MATH.get(templateElement);
        if (identifier.booleanValue() && !MathModuleUtils.isNemeth()) {
            identifier = false;
        }
        TemplateSettings templateSettings5 = template.getSettings();
        Boolean bl = identifier;
        Intrinsics.checkNotNull((Object)bl);
        templateSettings5.setTranslateIdentifierAsMath(bl);
        Object t4 = BBX.CONTAINER.TEMPLATE.IDENTIFIER.get(templateElement);
        Intrinsics.checkNotNullExpressionValue(t4, (String)"get(...)");
        String string = (String)t4;
        Object t5 = BBX.CONTAINER.TEMPLATE.IDENTIFIER.get(templateElement);
        Intrinsics.checkNotNullExpressionValue(t5, (String)"get(...)");
        template.setIdentifier(new MathText(string, Template.Companion.translateIdentifier((String)t5, template), false, 4, null));
        TemplateSettings templateSettings6 = template.getSettings();
        Object t6 = BBX.CONTAINER.TEMPLATE.LINEAR.get(templateElement);
        Intrinsics.checkNotNullExpressionValue(t6, (String)"get(...)");
        templateSettings6.setLinear((Boolean)t6);
        Element element = BBX.CONTAINER.TEMPLATE.create(template);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        return element;
    }

    @JvmStatic
    @NotNull
    public static final Element convertMatrix(@Nullable Element current) {
        Matrix matrix = new Matrix();
        if (BBX.CONTAINER.MATRIX.isA((Node)current)) {
            ArrayList array = (ArrayList)BBX.CONTAINER.MATRIX.ASCII_MATH.get(current);
            MatrixConstants.BracketType type = (MatrixConstants.BracketType)((Object)BBX.CONTAINER.MATRIX.BRACKET.get(current));
            Integer cols = (Integer)BBX.CONTAINER.MATRIX.COLS.get(current);
            Integer rows = (Integer)BBX.CONTAINER.MATRIX.ROWS.get(current);
            MatrixConstants.Wide wide = (MatrixConstants.Wide)((Object)BBX.CONTAINER.MATRIX.WIDE_TYPE.get(current));
            ArrayList ellipses = (ArrayList)BBX.CONTAINER.MATRIX.ELLIPSES_ARRAY.get(current);
            SpatialMathEnum.Passage passage = (SpatialMathEnum.Passage)((Object)BBX.CONTAINER.MATRIX.NUMERIC_PASSAGE.get(current));
            Intrinsics.checkNotNull((Object)array);
            Intrinsics.checkNotNull((Object)ellipses);
            ArrayList<MatrixCell> matrixCells = MatrixSettings.Companion.combineCellComponents(array, ellipses);
            SpatialMathEnum.Translation translation = (SpatialMathEnum.Translation)((Object)BBX.CONTAINER.MATRIX.MATRIX_TRANSLATION.get(current));
            matrix.getSettings().setTranslation(translation);
            MatrixSettings matrixSettings = matrix.getSettings();
            Intrinsics.checkNotNull((Object)((Object)passage));
            matrixSettings.setPassage(passage);
            MatrixSettings matrixSettings2 = matrix.getSettings();
            Intrinsics.checkNotNull((Object)((Object)type));
            matrixSettings2.setBracketType(type);
            MatrixSettings matrixSettings3 = matrix.getSettings();
            Intrinsics.checkNotNull((Object)cols);
            matrixSettings3.setCols(cols);
            MatrixSettings matrixSettings4 = matrix.getSettings();
            Intrinsics.checkNotNull((Object)rows);
            matrixSettings4.setRows(rows);
            MatrixSettings matrixSettings5 = matrix.getSettings();
            Intrinsics.checkNotNull((Object)((Object)wide));
            matrixSettings5.setWideType(wide);
            matrix.setPrintCells(array);
            matrix.getSettings().setModelFromArray(matrixCells);
        }
        Element element = BBX.CONTAINER.MATRIX.create(matrix);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        return element;
    }

    @JvmStatic
    @NotNull
    public static final Element convertConnectingContainer(@Nullable Element node) {
        ConnectingContainer container = new ConnectingContainer();
        if (BBX.CONTAINER.CONNECTING_CONTAINER.isA((Node)node)) {
            Boolean isMath = (Boolean)BBX.CONTAINER.CONNECTING_CONTAINER.IS_MATH.get(node);
            SpatialMathEnum.VerticalJustify vertical = (SpatialMathEnum.VerticalJustify)((Object)BBX.CONTAINER.CONNECTING_CONTAINER.VERTICAL.get(node));
            SpatialMathEnum.HorizontalJustify horizontal = (SpatialMathEnum.HorizontalJustify)((Object)BBX.CONTAINER.CONNECTING_CONTAINER.HORIZONTAL.get(node));
            String text = (String)BBX.CONTAINER.CONNECTING_CONTAINER.TEXT.get(node);
            ConnectingContainerSettings connectingContainerSettings = container.getSettings();
            Intrinsics.checkNotNull((Object)((Object)horizontal));
            connectingContainerSettings.setHorizontal(horizontal);
            ConnectingContainerSettings connectingContainerSettings2 = container.getSettings();
            Intrinsics.checkNotNull((Object)((Object)vertical));
            connectingContainerSettings2.setVertical(vertical);
            ConnectingContainerSettings connectingContainerSettings3 = container.getSettings();
            Intrinsics.checkNotNull((Object)isMath);
            connectingContainerSettings3.setTranslateAsMath(isMath);
            Intrinsics.checkNotNull((Object)text);
            container.setText(new MathText(text, isMath != false ? MathModuleUtils.INSTANCE.translateMathPrint(text) : MathModuleUtils.INSTANCE.translateMainPrint(text), false, 4, null));
        }
        Element element = BBX.CONTAINER.CONNECTING_CONTAINER.create(container);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        return element;
    }

    @JvmStatic
    @NotNull
    public static final Element convertGrid(@Nullable Element current) {
        Grid page = new Grid();
        Integer rows = (Integer)BBX.CONTAINER.SPATIAL_GRID.ROWS.get(current);
        Integer cols = (Integer)BBX.CONTAINER.SPATIAL_GRID.COLS.get(current);
        GridSettings gridSettings = page.getSettings();
        Intrinsics.checkNotNull((Object)rows);
        gridSettings.setRows(rows);
        GridSettings gridSettings2 = page.getSettings();
        Intrinsics.checkNotNull((Object)cols);
        gridSettings2.setCols(cols);
        Node parent = (Node)BBX.CONTAINER.SPATIAL_GRID.GRID.get(current);
        if (parent instanceof Element) {
            int index;
            int j;
            int n;
            int i;
            ArrayList<ISpatialMathContainer> containers = new ArrayList<ISpatialMathContainer>();
            int n2 = ((Element)parent).getChildCount();
            for (int k = 0; k < n2; ++k) {
                boolean bl;
                Node node = ((Element)parent).getChild(k);
                Element element = node instanceof Element ? (Element)node : null;
                if (element == null) continue;
                Element node2 = element;
                if (BBX.CONTAINER.NUMBER_LINE.isA((Node)node2)) {
                    NumberLine numberLine = NumberLine.Companion.getContainerFromElement((Node)node2);
                    bl = containers.add(numberLine);
                    continue;
                }
                if (BBX.CONTAINER.TEMPLATE.isA((Node)node2)) {
                    Template template = Template.Companion.getTemplateFromElement(node2);
                    bl = containers.add(template);
                    continue;
                }
                if (BBX.CONTAINER.MATRIX.isA((Node)node2)) {
                    Matrix matrix = Matrix.Companion.getContainerFromElement(node2);
                    bl = containers.add(matrix);
                    continue;
                }
                ConnectingContainer connectingContainer = ConnectingContainer.Companion.getContainerFromElement(node2);
                bl = containers.add(connectingContainer);
            }
            ArrayList elements = new ArrayList();
            int node2 = rows;
            for (int i2 = 0; i2 < node2; ++i2) {
                if (i2 >= rows) continue;
                ArrayList array = new ArrayList();
                elements.add(array);
            }
            boolean passage = false;
            SpatialMathEnum.Passage passageType = MathModuleUtils.isNemeth() ? SpatialMathEnum.Passage.NEMETH : SpatialMathEnum.Passage.NUMERIC;
            int n3 = rows;
            for (i = 0; i < n3; ++i) {
                n = cols;
                for (j = 0; j < n; ++j) {
                    index = i * cols + j;
                    if (index >= containers.size() || ((ISpatialMathContainer)containers.get(index)).getSettings().getPassage() != passageType) continue;
                    passage = true;
                }
            }
            page.getSettings().setPassage(passage ? passageType : SpatialMathEnum.Passage.NONE);
            n3 = rows;
            for (i = 0; i < n3; ++i) {
                n = cols;
                for (j = 0; j < n; ++j) {
                    index = i * cols + j;
                    if (index < containers.size()) {
                        ((ArrayList)elements.get(i)).add(containers.get(index));
                        if (!(containers.get(index) instanceof Template)) continue;
                        GridSettings gridSettings3 = page.getSettings();
                        ISpatialMathSettings iSpatialMathSettings = ((ISpatialMathContainer)containers.get(index)).getSettings();
                        Intrinsics.checkNotNull((Object)iSpatialMathSettings, (String)"null cannot be cast to non-null type org.brailleblaster.math.template.TemplateSettings");
                        gridSettings3.setTranslateIdentifierAsMath(((TemplateSettings)iSpatialMathSettings).isTranslateIdentifierAsMath());
                        continue;
                    }
                    ((ArrayList)elements.get(i)).add(new ConnectingContainer());
                }
            }
            page.getArray().clear();
            page.getArray().addAll(elements);
        }
        Element element = BBX.CONTAINER.SPATIAL_GRID.create(page);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        return element;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.IntervalType.values().length];
            try {
                nArray[SpatialMathEnum.IntervalType.DECIMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.IMPROPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.MIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

