/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateNumber;
import org.brailleblaster.math.template.TemplateSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/math/template/NemethRadical;", "", "<init>", "()V", "templateLine", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/template/TemplateNumber;", "Lkotlin/collections/ArrayList;", "verticalRadical", "", "getVerticalRadical", "()Ljava/lang/String;", "setVerticalRadical", "(Ljava/lang/String;)V", "format", "Lorg/brailleblaster/math/template/Template;", "template", "formatLinear", "", "addLine", "divisor", "dividend", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nNemethRadical.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NemethRadical.kt\norg/brailleblaster/math/template/NemethRadical\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,138:1\n106#2:139\n78#2,22:140\n106#2:162\n78#2,22:163\n*S KotlinDebug\n*F\n+ 1 NemethRadical.kt\norg/brailleblaster/math/template/NemethRadical\n*L\n71#1:139\n71#1:140,22\n82#1:162\n82#1:163,22\n*E\n"})
public final class NemethRadical {
    @NotNull
    private final ArrayList<TemplateNumber> templateLine = new ArrayList();
    @Nullable
    private String verticalRadical;

    @Nullable
    public final String getVerticalRadical() {
        return this.verticalRadical;
    }

    public final void setVerticalRadical(@Nullable String string) {
        this.verticalRadical = string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Template format(@NotNull Template template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (Template.Companion.operandsBlank(template)) {
            return template;
        }
        this.verticalRadical = template.getSettings().isStraightRadicalSymbol() ? "_" : "o";
        this.verticalRadical = "_";
        if (TemplateSettings.Companion.shouldFormatLinear(template)) {
            this.formatLinear(template);
        } else {
            void $this$trim$iv;
            TemplateNumber dividend = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleOperands().get(1)).build();
            this.templateLine.add(dividend);
            TemplateNumber quotient = null;
            if (template.getSettings().getSolutions() > 0) {
                quotient = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(0)).build();
                this.templateLine.add(quotient);
            }
            TemplateNumber remainder = null;
            if (Template.Companion.hasRemainder(template)) {
                remainder = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(1)).build();
            }
            TemplateNumber.Companion.makeColumnsEqualWidth((List<TemplateNumber>)this.templateLine);
            TemplateNumber divisor = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleOperands().get(0)).build();
            Line dividendDivisorLine = new Line();
            dividendDivisorLine.getElements().add(dividendDivisorLine.getTextSegment(divisor.toStringPart()));
            ArrayList<Line.Segment> arrayList = dividendDivisorLine.getElements();
            String string = this.verticalRadical;
            Intrinsics.checkNotNull((Object)string);
            arrayList.add(dividendDivisorLine.getTextSegment(string));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(dividend.getLeftPadding()));
            String string2 = dividend.toStringPart();
            Line line = dividendDivisorLine;
            ArrayList<Line.Segment> arrayList2 = dividendDivisorLine.getElements();
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            arrayList2.add(line.getTextSegment(string3));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(dividend.getRightPadding()));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(1));
            Line quotientLine = new Line();
            if (quotient != null && template.getSettings().getSolutions() > 0) {
                void $this$trim$iv2;
                ArrayList<Line.Segment> arrayList3 = quotientLine.getElements();
                int n = divisor.toStringPart().length();
                String string4 = this.verticalRadical;
                Intrinsics.checkNotNull((Object)string4);
                arrayList3.add(quotientLine.getWhitespaceSegment(n + string4.length() + quotient.getLeftPadding()));
                String $i$f$trim3 = quotient.toStringPart();
                line = quotientLine;
                arrayList2 = quotientLine.getElements();
                boolean $i$f$trim4 = false;
                CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv2;
                boolean $i$f$trim5 = false;
                int startIndex$iv$iv2 = 0;
                int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                boolean startFound$iv$iv2 = false;
                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                    char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv2;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv2;
                }
                string3 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                arrayList2.add(line.getTextSegment(string3));
                quotientLine.getElements().add(quotientLine.getWhitespaceSegment(quotient.getRightPadding()));
                quotientLine.getElements().add(quotientLine.getWhitespaceSegment(1));
                if (remainder != null && Template.Companion.hasRemainder(template)) {
                    quotientLine.getElements().add(quotientLine.getTextSegment("R\"" + remainder.toStringPart()));
                    quotientLine.getElements().add(quotientLine.getWhitespaceSegment(1));
                    dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(2 + remainder.toStringPart().length() + 1));
                }
                ((ArrayList)template.getLines()).add(quotientLine);
            }
            this.addLine(template, divisor, dividend);
            ((ArrayList)template.getLines()).add(dividendDivisorLine);
        }
        return template;
    }

    private final void formatLinear(Template template) {
        CharSequence charSequence = template.getBrailleOperands().get(1);
        Object object = new Regex("#");
        String string = "";
        String dividend = object.replace(charSequence, string);
        object = template.getBrailleOperands().get(0);
        string = new Regex("#");
        String string2 = "";
        String divisor = string.replace((CharSequence)object, string2);
        String equation = "#" + divisor + this.verticalRadical + dividend;
        Line l = new Line();
        l.getElements().add(l.getTextSegment(equation));
        ((ArrayList)template.getLines()).add(l);
    }

    private final void addLine(Template template, TemplateNumber divisor, TemplateNumber dividend) {
        Line line = new Line();
        line.setSeparatorLine(true);
        int whitespace = divisor.toStringPart().length();
        line.getElements().add(line.getWhitespaceSegment(whitespace));
        int n = dividend.toStringPart().length();
        String string = this.verticalRadical;
        Intrinsics.checkNotNull((Object)string);
        int lineChars = n + string.length() + 1;
        if (Template.Companion.hasRemainder(template)) {
            TemplateNumber remainder = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(1)).build();
            lineChars += 2 + remainder.toStringPart().length() + 1;
        }
        line.getElements().add(line.getTextSegment(StringsKt.repeat((CharSequence)"3", (int)lineChars)));
        ((ArrayList)template.getLines()).add(line);
    }
}

