/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathBlock;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.VersionConverter;
import org.brailleblaster.math.template.NemethFractionTemplate;
import org.brailleblaster.math.template.NemethRadical;
import org.brailleblaster.math.template.NemethTemplate;
import org.brailleblaster.math.template.TemplateJson;
import org.brailleblaster.math.template.TemplateOperand;
import org.brailleblaster.math.template.TemplateSettings;
import org.brailleblaster.math.template.TemplateUISettings;
import org.brailleblaster.math.template.TemplateWidget;
import org.brailleblaster.math.template.UebFractionTemplate;
import org.brailleblaster.math.template.UebRadical;
import org.brailleblaster.math.template.UebTemplate;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 X2\u00020\u0001:\u0001XB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u00107\u001a\u000208H\u0096\u0080\u0004J\b\u00109\u001a\u00020:H\u0016J\b\u0010L\u001a\u00020:H\u0016J\b\u0010M\u001a\u00020:H\u0016J\b\u0010V\u001a\u000202H\u0016J\u0006\u0010W\u001a\u000202R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R*\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0011j\b\u0012\u0004\u0012\u00020\u001c`\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0015\"\u0004\b\u001e\u0010\u0017R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0011\u0010;\u001a\u0002088F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R0\u0010@\u001a\b\u0012\u0004\u0012\u0002080?2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002080?8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0017\u0010E\u001a\b\u0012\u0004\u0012\u0002080?8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010BR0\u0010G\u001a\b\u0012\u0004\u0012\u0002080?2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002080?8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010B\"\u0004\bI\u0010DR\u0017\u0010J\u001a\b\u0012\u0004\u0012\u0002080?8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010BR\u0014\u0010N\u001a\u00020OX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0014\u0010R\u001a\u00020S8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u00a8\u0006Y"}, d2={"Lorg/brailleblaster/math/template/Template;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "<init>", "()V", "settings", "Lorg/brailleblaster/math/template/TemplateSettings;", "getSettings", "()Lorg/brailleblaster/math/template/TemplateSettings;", "setSettings", "(Lorg/brailleblaster/math/template/TemplateSettings;)V", "ui", "Lorg/brailleblaster/math/template/TemplateUISettings;", "getUi", "()Lorg/brailleblaster/math/template/TemplateUISettings;", "setUi", "(Lorg/brailleblaster/math/template/TemplateUISettings;)V", "operands", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/template/TemplateOperand;", "Lkotlin/collections/ArrayList;", "getOperands", "()Ljava/util/ArrayList;", "setOperands", "(Ljava/util/ArrayList;)V", "solutions", "getSolutions", "setSolutions", "lines", "Lorg/brailleblaster/math/spatial/Line;", "getLines", "setLines", "identifier", "Lorg/brailleblaster/math/spatial/MathText;", "getIdentifier", "()Lorg/brailleblaster/math/spatial/MathText;", "setIdentifier", "(Lorg/brailleblaster/math/spatial/MathText;)V", "widestLine", "", "getWidestLine", "()I", "setWidestLine", "(I)V", "widget", "Lorg/brailleblaster/math/template/TemplateWidget;", "getWidget", "()Lorg/brailleblaster/math/template/TemplateWidget;", "setWidget", "(Lorg/brailleblaster/math/template/TemplateWidget;)V", "blank", "", "getBlank", "()Z", "setBlank", "(Z)V", "toString", "", "format", "", "brailleOperator", "getBrailleOperator", "()Ljava/lang/String;", "value", "", "printOperands", "getPrintOperands", "()Ljava/util/List;", "setPrintOperands", "(Ljava/util/List;)V", "brailleOperands", "getBrailleOperands", "printSolutions", "getPrintSolutions", "setPrintSolutions", "brailleSolutions", "getBrailleSolutions", "saveSettings", "loadSettingsFromFile", "typeEnum", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "getTypeEnum", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "json", "Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "getJson", "()Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "preFormatChecks", "hasMinus", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Template.kt\norg/brailleblaster/math/template/Template\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n1391#2:399\n1480#2,5:400\n1391#2:405\n1480#2,5:406\n1391#2:411\n1480#2,5:412\n1391#2:417\n1480#2,5:418\n*S KotlinDebug\n*F\n+ 1 Template.kt\norg/brailleblaster/math/template/Template\n*L\n86#1:399\n86#1:400,5\n122#1:405\n122#1:406,5\n131#1:411\n131#1:412,5\n169#1:417\n169#1:418,5\n*E\n"})
public final class Template
implements ISpatialMathContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TemplateSettings settings = new TemplateSettings();
    @NotNull
    private TemplateUISettings ui = new TemplateUISettings();
    @NotNull
    private ArrayList<TemplateOperand> operands = new ArrayList();
    @NotNull
    private ArrayList<TemplateOperand> solutions = new ArrayList();
    @NotNull
    private ArrayList<Line> lines = new ArrayList();
    @NotNull
    private MathText identifier = new MathText(null, null, false, 7, null);
    private int widestLine;
    @NotNull
    private TemplateWidget widget = new TemplateWidget();
    private boolean blank;
    @NotNull
    private final SpatialMathEnum.SpatialMathContainers typeEnum;
    private static final int IDENTIFIER_BUFFER = 1;

    public Template() {
        this.loadSettingsFromFile();
        this.setSettings(new TemplateSettings());
        this.typeEnum = SpatialMathEnum.SpatialMathContainers.TEMPLATE;
    }

    @Override
    @NotNull
    public TemplateSettings getSettings() {
        return this.settings;
    }

    public void setSettings(@NotNull TemplateSettings templateSettings) {
        Intrinsics.checkNotNullParameter((Object)templateSettings, (String)"<set-?>");
        this.settings = templateSettings;
    }

    @NotNull
    public final TemplateUISettings getUi() {
        return this.ui;
    }

    public final void setUi(@NotNull TemplateUISettings templateUISettings) {
        Intrinsics.checkNotNullParameter((Object)templateUISettings, (String)"<set-?>");
        this.ui = templateUISettings;
    }

    @NotNull
    public final ArrayList<TemplateOperand> getOperands() {
        return this.operands;
    }

    public final void setOperands(@NotNull ArrayList<TemplateOperand> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.operands = arrayList;
    }

    @NotNull
    public final ArrayList<TemplateOperand> getSolutions() {
        return this.solutions;
    }

    public final void setSolutions(@NotNull ArrayList<TemplateOperand> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.solutions = arrayList;
    }

    @NotNull
    public ArrayList<Line> getLines() {
        return this.lines;
    }

    public void setLines(@NotNull ArrayList<Line> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.lines = arrayList;
    }

    @NotNull
    public final MathText getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(@NotNull MathText mathText) {
        Intrinsics.checkNotNullParameter((Object)mathText, (String)"<set-?>");
        this.identifier = mathText;
    }

    @Override
    public int getWidestLine() {
        return this.widestLine;
    }

    @Override
    public void setWidestLine(int n) {
        this.widestLine = n;
    }

    @Override
    @NotNull
    public TemplateWidget getWidget() {
        return this.widget;
    }

    public void setWidget(@NotNull TemplateWidget templateWidget) {
        Intrinsics.checkNotNullParameter((Object)templateWidget, (String)"<set-?>");
        this.widget = templateWidget;
    }

    @Override
    public boolean getBlank() {
        return this.blank;
    }

    @Override
    public void setBlank(boolean bl) {
        this.blank = bl;
    }

    @NotNull
    public String toString() {
        String string = ((AbstractCollection)((Object)this.getLines())).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void format() {
        Template template;
        if (MathModuleUtils.isNemeth()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getSettings().getType().ordinal()]) {
                case 1: {
                    template = new NemethTemplate().format(this);
                    break;
                }
                case 2: {
                    template = new NemethRadical().format(this);
                    break;
                }
                default: {
                    template = new NemethFractionTemplate().format(this);
                    break;
                }
            }
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getSettings().getType().ordinal()]) {
                case 1: {
                    template = new UebTemplate().format(this);
                    break;
                }
                case 2: {
                    template = new UebRadical().format(this);
                    break;
                }
                default: {
                    template = new UebFractionTemplate().format(this);
                }
            }
        }
        Template template2 = template;
        Companion.addIdentifier(template2);
    }

    @NotNull
    public final String getBrailleOperator() {
        return MathModuleUtils.INSTANCE.translateMathPrint(this.getSettings().getOperator().symbol);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPrintOperands() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.operands;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            TemplateOperand it = (TemplateOperand)element$iv$iv;
            boolean bl = false;
            if (this.getSettings().getType() == SpatialMathEnum.TemplateType.FRACTION_ENUM) {
                Object[] objectArray = new String[]{it.getWhole().print, it.getNumerator().print, it.getDenominator().print};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)it.getWhole().print);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void setPrintOperands(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.operands.clear();
        if (this.getSettings().getType() == SpatialMathEnum.TemplateType.FRACTION_ENUM) {
            for (int i = 0; i < value.size(); i += 3) {
                MathText whole = new MathText(value.get(i), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i)), false, 4, null);
                if (Intrinsics.areEqual((Object)whole.print, (Object)"")) {
                    whole = new MathText("", "", false, 4, null);
                }
                MathText numerator = new MathText(value.get(i + 1), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i + 1)), false, 4, null);
                if (Intrinsics.areEqual((Object)numerator.print, (Object)"")) {
                    numerator = new MathText("", "", false, 4, null);
                }
                MathText denominator = new MathText(value.get(i + 2), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i + 2)), false, 4, null);
                if (Intrinsics.areEqual((Object)denominator.print, (Object)"")) {
                    denominator = new MathText("", "", false, 4, null);
                }
                this.operands.add(new TemplateOperand.TemplateOperandBuilder().whole(whole).numerator(numerator).denominator(denominator).build());
            }
        } else {
            int n = ((Collection)value).size();
            for (int i = 0; i < n; ++i) {
                MathText whole = new MathText(value.get(i), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i)), false, 4, null);
                if (Intrinsics.areEqual((Object)whole.print, (Object)"")) {
                    whole = new MathText("", "", false, 4, null);
                }
                this.operands.add(new TemplateOperand.TemplateOperandBuilder().whole(whole).build());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBrailleOperands() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.operands;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            TemplateOperand it = (TemplateOperand)element$iv$iv;
            boolean bl = false;
            if (this.getSettings().getType() == SpatialMathEnum.TemplateType.FRACTION_ENUM) {
                Object[] objectArray = new String[]{it.getWhole().braille, it.getNumerator().braille, it.getDenominator().braille};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)it.getWhole().braille);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPrintSolutions() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.solutions;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            TemplateOperand it = (TemplateOperand)element$iv$iv;
            boolean bl = false;
            if (this.getSettings().getType() == SpatialMathEnum.TemplateType.FRACTION_ENUM) {
                Object[] objectArray = new String[]{it.getWhole().print, it.getNumerator().print, it.getDenominator().print};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)it.getWhole().print);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void setPrintSolutions(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.solutions.clear();
        if (this.getSettings().getType() == SpatialMathEnum.TemplateType.FRACTION_ENUM) {
            for (int i = 0; i < value.size(); i += 3) {
                MathText whole = new MathText(value.get(i), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i)), false, 4, null);
                MathText numerator = new MathText(value.get(i + 1), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i + 1)), false, 4, null);
                MathText denominator = new MathText(value.get(i + 2), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i + 2)), false, 4, null);
                this.solutions.add(new TemplateOperand.TemplateOperandBuilder().whole(whole).numerator(numerator).denominator(denominator).build());
            }
        } else {
            int n = ((Collection)value).size();
            for (int i = 0; i < n; ++i) {
                if (!(!StringsKt.isBlank((CharSequence)value.get(i)))) continue;
                MathText whole = new MathText(value.get(i), MathModuleUtils.INSTANCE.translateAsciiMath(value.get(i)), false, 4, null);
                this.solutions.add(new TemplateOperand.TemplateOperandBuilder().whole(whole).build());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBrailleSolutions() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.solutions;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            TemplateOperand it = (TemplateOperand)element$iv$iv;
            boolean bl = false;
            if (this.getSettings().getType() == SpatialMathEnum.TemplateType.FRACTION_ENUM) {
                Object[] objectArray = new String[]{it.getWhole().braille, it.getNumerator().braille, it.getDenominator().braille};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)it.getWhole().braille);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void saveSettings() {
        BBIni.getPropertyFileManager().save("template.type", this.getSettings().getType().name());
        BBIni.getPropertyFileManager().save("template.operator", this.getSettings().getOperator().name());
        BBIni.getPropertyFileManager().save("template.passage", this.getSettings().getPassage().name());
        BBIni.getPropertyFileManager().save("t.operands", String.valueOf(this.getSettings().getOperands()));
        BBIni.getPropertyFileManager().save("t.solution", String.valueOf(this.getSettings().getSolutions()));
        BBIni.getPropertyFileManager().save("t.vertical", String.valueOf(this.getSettings().isStraightRadicalSymbol()));
        BBIni.getPropertyFileManager().save("t.identifierTranslation", String.valueOf(this.getSettings().isTranslateIdentifierAsMath()));
        BBIni.getPropertyFileManager().save("t.linear", String.valueOf(this.getSettings().isLinear()));
    }

    @Override
    public void loadSettingsFromFile() {
        String type = BBIni.getPropertyFileManager().getProperty("template.type", "SIMPLE_ENUM");
        String operator = BBIni.getPropertyFileManager().getProperty("template.operator", "PLUS_ENUM");
        String passage = BBIni.getPropertyFileManager().getProperty("template.passage", "NONE");
        this.getSettings().setType(SpatialMathEnum.TemplateType.valueOf(type));
        this.getSettings().setOperator(SpatialMathEnum.OPERATOR.valueOf(operator));
        try {
            this.getSettings().setPassage(SpatialMathEnum.Passage.valueOf(passage));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            passage = "NONE";
            BBIni.getPropertyFileManager().save("template.passage", passage);
            this.getSettings().setPassage(SpatialMathEnum.Passage.valueOf(passage));
        }
        String operands = BBIni.getPropertyFileManager().getProperty("t.operands", "2");
        String solution = BBIni.getPropertyFileManager().getProperty("t.solution", "0");
        String vertical = BBIni.getPropertyFileManager().getProperty("t.vertical", "false");
        String identifierString = BBIni.getPropertyFileManager().getProperty("t.identifierTranslation", "false");
        Boolean identifier = Boolean.valueOf(identifierString);
        if (identifier.booleanValue() && !MathModuleUtils.isNemeth()) {
            identifier = false;
        }
        String linear = BBIni.getPropertyFileManager().getProperty("t.linear", "true");
        TemplateSettings templateSettings = this.getSettings();
        Boolean bl = Boolean.valueOf(linear);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"valueOf(...)");
        templateSettings.setLinear(bl);
        TemplateSettings templateSettings2 = this.getSettings();
        Integer n = Integer.valueOf(operands);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(...)");
        templateSettings2.setOperands(((Number)n).intValue());
        TemplateSettings templateSettings3 = this.getSettings();
        Integer n2 = Integer.valueOf(solution);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(...)");
        templateSettings3.setSolutions(((Number)n2).intValue());
        TemplateSettings templateSettings4 = this.getSettings();
        Boolean bl2 = Boolean.valueOf(vertical);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"valueOf(...)");
        templateSettings4.setStraightRadicalSymbol(bl2);
        TemplateSettings templateSettings5 = this.getSettings();
        Boolean bl3 = identifier;
        Intrinsics.checkNotNull((Object)bl3);
        templateSettings5.setTranslateIdentifierAsMath(bl3);
    }

    @Override
    @NotNull
    public SpatialMathEnum.SpatialMathContainers getTypeEnum() {
        return this.typeEnum;
    }

    @Override
    @NotNull
    public ISpatialMathContainerJson getJson() {
        ISpatialMathContainerJson iSpatialMathContainerJson = new TemplateJson().containerToJson(this);
        Intrinsics.checkNotNull((Object)iSpatialMathContainerJson, (String)"null cannot be cast to non-null type org.brailleblaster.math.template.TemplateJson");
        return (TemplateJson)iSpatialMathContainerJson;
    }

    @Override
    public boolean preFormatChecks() {
        return true;
    }

    public final boolean hasMinus() {
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Element initialize(@NotNull Node node) {
        return Companion.initialize(node);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/brailleblaster/math/template/Template$Companion;", "", "<init>", "()V", "IDENTIFIER_BUFFER", "", "isEmpty", "", "template", "Lorg/brailleblaster/math/template/Template;", "identifierBlank", "solutionsBlank", "operandsBlank", "addIdentifier", "", "currentIsTemplate", "getTemplateFromElement", "myTemplateElement", "Lnu/xom/Element;", "middleTemplate", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "isTemplate", "node", "Lnu/xom/Node;", "getTemplateParent", "initialize", "translateIdentifier", "", "string", "hasRemainder", "t", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEmpty(@NotNull Template template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            return this.operandsBlank(template) && this.solutionsBlank(template) && this.identifierBlank(template);
        }

        private final boolean identifierBlank(Template template) {
            return StringsKt.isBlank((CharSequence)template.getIdentifier().print);
        }

        private final boolean solutionsBlank(Template template) {
            int n = ((Collection)template.getPrintSolutions()).size();
            for (int i = 0; i < n; ++i) {
                if (!(!StringsKt.isBlank((CharSequence)template.getPrintSolutions().get(i)))) continue;
                return false;
            }
            return true;
        }

        public final boolean operandsBlank(@NotNull Template template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            int n = ((Collection)template.getPrintOperands()).size();
            for (int i = 0; i < n; ++i) {
                if (!(!StringsKt.isBlank((CharSequence)template.getPrintOperands().get(i)))) continue;
                return false;
            }
            return true;
        }

        public final void addIdentifier(@NotNull Template template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            if (((CharSequence)template.getIdentifier().braille).length() == 0) {
                return;
            }
            Line l = new Line();
            l.getElements().add(l.getTextSegment(template.getIdentifier().braille));
            int widestLine = 0;
            int n = ((Collection)template.getLines()).size();
            for (int k = 0; k < n; ++k) {
                int lineLength = ((Line)((ArrayList)template.getLines()).get(k)).toString().length();
                if (lineLength <= widestLine) continue;
                widestLine = lineLength;
            }
            l.getElements().add(l.getWhitespaceSegment(widestLine + 1));
            ((ArrayList)template.getLines()).add(0, l);
            n = ((ArrayList)template.getLines()).size();
            for (int i = 1; i < n; ++i) {
                ((Line)((ArrayList)template.getLines()).get(i)).getElements().add(0, ((Line)((ArrayList)template.getLines()).get(i)).getWhitespaceSegment(template.getIdentifier().braille.length() + 1));
            }
        }

        public final boolean currentIsTemplate() {
            Node current = (Node)XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), Companion::currentIsTemplate$lambda$0);
            boolean isWhitespace = WPManager.Companion.getInstance().getController().getMapList().getCurrent() instanceof WhiteSpaceElement;
            return !isWhitespace && current != null;
        }

        @NotNull
        public final Template getTemplateFromElement(@Nullable Element myTemplateElement) {
            Element templateElement = myTemplateElement;
            Template template = new Template();
            if (BBX.CONTAINER.TEMPLATE.isA((Node)templateElement)) {
                if (!BBX.CONTAINER.TEMPLATE.ATTRIB_VERSION.has((Node)templateElement)) {
                    templateElement = VersionConverter.INSTANCE.convertTemplate(templateElement);
                }
                Object t = BBX.CONTAINER.TEMPLATE.JSON_TEMPLATE.get(templateElement);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.brailleblaster.math.template.TemplateJson");
                TemplateJson json = (TemplateJson)t;
                ISpatialMathContainer iSpatialMathContainer = json.jsonToContainer();
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.template.Template");
                template = (Template)iSpatialMathContainer;
            }
            return template;
        }

        public final boolean middleTemplate(@NotNull TextMapElement currentElement) {
            Intrinsics.checkNotNullParameter((Object)currentElement, (String)"currentElement");
            if (currentElement.getNode() == null || currentElement instanceof LineBreakElement) {
                return false;
            }
            Node node = currentElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Element template = XMLHandler.Companion.ancestorVisitorElement(node, Companion::middleTemplate$lambda$0);
            return template != null;
        }

        public final boolean isTemplate(@Nullable Node node) {
            if (node == null || node.getDocument() == null) {
                return false;
            }
            return XMLHandler.Companion.ancestorElementIs(node, Companion::isTemplate$lambda$0);
        }

        @Nullable
        public final Element getTemplateParent(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return XMLHandler.Companion.ancestorVisitorElement(node, Companion::getTemplateParent$lambda$0);
        }

        @JvmStatic
        @NotNull
        public final Element initialize(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Element e = (Element)node;
            Template t = this.getTemplateFromElement(e);
            t.format();
            Element newElement = BBX.CONTAINER.TEMPLATE.create(t);
            try {
                Intrinsics.checkNotNull((Object)newElement);
                SpatialMathBlock.INSTANCE.format(newElement, t.getLines());
            }
            catch (MathFormattingException e1) {
                e1.printStackTrace();
            }
            e.getParent().replaceChild((Node)e, (Node)newElement);
            Intrinsics.checkNotNull((Object)newElement);
            return newElement;
        }

        @NotNull
        public final String translateIdentifier(@NotNull String string, @NotNull Template template) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            return template.getSettings().isTranslateIdentifierAsMath() ? MathModuleUtils.INSTANCE.translateAsciiMath(string) : MathModuleUtils.INSTANCE.translateMainPrint(string);
        }

        public final boolean hasRemainder(@NotNull Template t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return t.getSettings().getType() == SpatialMathEnum.TemplateType.RADICAL_ENUM && t.getBrailleSolutions().size() > 1 && !StringsKt.isBlank((CharSequence)t.getBrailleSolutions().get(1));
        }

        private static final boolean currentIsTemplate$lambda$0(Element node) {
            return BBX.CONTAINER.TEMPLATE.isA((Node)node);
        }

        private static final boolean middleTemplate$lambda$0(Element node) {
            return BBX.CONTAINER.TEMPLATE.isA((Node)node);
        }

        private static final boolean isTemplate$lambda$0(Element elm) {
            return BBX.CONTAINER.TEMPLATE.isA((Node)elm);
        }

        private static final boolean getTemplateParent$lambda$0(Element elm) {
            Intrinsics.checkNotNullParameter((Object)elm, (String)"elm");
            return BBX.CONTAINER.TEMPLATE.isA((Node)elm);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.TemplateType.values().length];
            try {
                nArray[SpatialMathEnum.TemplateType.SIMPLE_ENUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.TemplateType.RADICAL_ENUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

