/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020)H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lorg/brailleblaster/math/template/TemplateJson;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "<init>", "()V", "straightRadical", "", "operator", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$OPERATOR;", "getOperator", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$OPERATOR;", "setOperator", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$OPERATOR;)V", "templateType", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$TemplateType;", "operands", "", "", "getOperands", "()Ljava/util/List;", "setOperands", "(Ljava/util/List;)V", "solutions", "passage", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "getPassage", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "setPassage", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;)V", "identifier", "Lorg/brailleblaster/math/spatial/MathText;", "getIdentifier", "()Lorg/brailleblaster/math/spatial/MathText;", "setIdentifier", "(Lorg/brailleblaster/math/spatial/MathText;)V", "identifierAsMath", "linear", "getLinear", "()Z", "setLinear", "(Z)V", "jsonToContainer", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "containerToJson", "container", "brailleblaster-core"})
public final class TemplateJson
implements ISpatialMathContainerJson {
    private boolean straightRadical;
    public SpatialMathEnum.OPERATOR operator;
    private SpatialMathEnum.TemplateType templateType;
    @NotNull
    private List<String> operands = CollectionsKt.emptyList();
    @NotNull
    private List<String> solutions = CollectionsKt.emptyList();
    public SpatialMathEnum.Passage passage;
    @Nullable
    private MathText identifier;
    private boolean identifierAsMath;
    private boolean linear;

    @NotNull
    public final SpatialMathEnum.OPERATOR getOperator() {
        SpatialMathEnum.OPERATOR oPERATOR = this.operator;
        if (oPERATOR != null) {
            return oPERATOR;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"operator");
        return null;
    }

    public final void setOperator(@NotNull SpatialMathEnum.OPERATOR oPERATOR) {
        Intrinsics.checkNotNullParameter((Object)((Object)oPERATOR), (String)"<set-?>");
        this.operator = oPERATOR;
    }

    @NotNull
    public final List<String> getOperands() {
        return this.operands;
    }

    public final void setOperands(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.operands = list;
    }

    @NotNull
    public final SpatialMathEnum.Passage getPassage() {
        SpatialMathEnum.Passage passage = this.passage;
        if (passage != null) {
            return passage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"passage");
        return null;
    }

    public final void setPassage(@NotNull SpatialMathEnum.Passage passage) {
        Intrinsics.checkNotNullParameter((Object)((Object)passage), (String)"<set-?>");
        this.passage = passage;
    }

    @Nullable
    public final MathText getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(@Nullable MathText mathText) {
        this.identifier = mathText;
    }

    public final boolean getLinear() {
        return this.linear;
    }

    public final void setLinear(boolean bl) {
        this.linear = bl;
    }

    @Override
    @NotNull
    public ISpatialMathContainer jsonToContainer() {
        Template template = new Template();
        template.getSettings().setStraightRadicalSymbol(this.straightRadical);
        template.getSettings().setOperator(this.getOperator());
        TemplateSettings templateSettings = template.getSettings();
        SpatialMathEnum.TemplateType templateType = this.templateType;
        if (templateType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"templateType");
            templateType = null;
        }
        templateSettings.setType(templateType);
        template.setPrintOperands(this.operands);
        template.setPrintSolutions(this.solutions);
        template.getSettings().setOperands(this.operands.size());
        template.getSettings().setSolutions(this.solutions.size());
        template.getSettings().setPassage(this.getPassage());
        MathText mathText = this.identifier;
        Intrinsics.checkNotNull((Object)mathText);
        template.setIdentifier(mathText);
        template.getSettings().setTranslateIdentifierAsMath(this.identifierAsMath);
        template.getSettings().setLinear(this.linear);
        return template;
    }

    @Override
    @NotNull
    public ISpatialMathContainerJson containerToJson(@NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Template template = (Template)container;
        this.straightRadical = template.getSettings().isStraightRadicalSymbol();
        this.setOperator(template.getSettings().getOperator());
        this.templateType = template.getSettings().getType();
        this.operands = template.getPrintOperands();
        this.solutions = template.getPrintSolutions();
        this.setPassage(template.getSettings().getPassage());
        this.identifier = template.getIdentifier();
        this.identifierAsMath = template.getSettings().isTranslateIdentifierAsMath();
        this.linear = template.getSettings().isLinear();
        return this;
    }
}

