/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.UebTranslations;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/math/template/UebRadical;", "", "<init>", "()V", "templateLine", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/template/TemplateNumber;", "Lkotlin/collections/ArrayList;", "longestLine", "", "whitespaceBetweenDivisorAndRadical", "whitespaceBetweenRadicalAndDividend", "verticalRadical", "", "format", "Lorg/brailleblaster/math/template/Template;", "template", "addLine", "", "divisor", "dividend", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUebRadical.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UebRadical.kt\norg/brailleblaster/math/template/UebRadical\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,199:1\n106#2:200\n78#2,22:201\n106#2:223\n78#2,22:224\n106#2:246\n78#2,22:247\n*S KotlinDebug\n*F\n+ 1 UebRadical.kt\norg/brailleblaster/math/template/UebRadical\n*L\n71#1:200\n71#1:201,22\n90#1:223\n90#1:224,22\n106#1:246\n106#1:247,22\n*E\n"})
public final class UebRadical {
    @NotNull
    private final ArrayList<TemplateNumber> templateLine = new ArrayList();
    private int longestLine;
    private final int whitespaceBetweenDivisorAndRadical;
    private int whitespaceBetweenRadicalAndDividend = 1;
    @Nullable
    private String verticalRadical;

    public UebRadical() {
        this.whitespaceBetweenDivisorAndRadical = 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Template format(@NotNull Template template) {
        String string;
        ArrayList<Line.Segment> arrayList;
        Line line;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (Template.Companion.operandsBlank(template)) {
            return template;
        }
        this.verticalRadical = template.getSettings().isStraightRadicalSymbol() ? UebTranslations.INSTANCE.getVERTICAL_LINE_STRAIGHT() : UebTranslations.INSTANCE.getVERTICAL_LINE_CURLY();
        this.verticalRadical = UebTranslations.INSTANCE.getVERTICAL_LINE_STRAIGHT();
        TemplateNumber dividend = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleOperands().get(1)).build();
        this.templateLine.add(dividend);
        TemplateNumber quotient = null;
        if (template.getSettings().getSolutions() > 0) {
            quotient = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(0)).build();
            this.templateLine.add(quotient);
        }
        TemplateNumber.Companion.makeColumnsEqualWidth((List<TemplateNumber>)this.templateLine);
        TemplateNumber divisor = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleOperands().get(0)).build();
        Line dividendDivisorLine = new Line();
        int minWhitespaceBetweenRadicalAndDividend = 1;
        this.whitespaceBetweenRadicalAndDividend = (dividend.getLeftPadding() > minWhitespaceBetweenRadicalAndDividend ? StringsKt.repeat((CharSequence)" ", (int)dividend.getLeftPadding()) : StringsKt.repeat((CharSequence)" ", (int)minWhitespaceBetweenRadicalAndDividend)).length();
        if (template.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
            dividendDivisorLine.getElements().add(dividendDivisorLine.getTextSegment(divisor.toStringPart()));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(this.whitespaceBetweenDivisorAndRadical));
            ArrayList<Line.Segment> arrayList2 = dividendDivisorLine.getElements();
            String string2 = this.verticalRadical;
            Intrinsics.checkNotNull((Object)string2);
            arrayList2.add(dividendDivisorLine.getTextSegment(string2));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(this.whitespaceBetweenRadicalAndDividend + dividend.getLeftPadding()));
            String string3 = dividend.toStringPart();
            line = dividendDivisorLine;
            arrayList = dividendDivisorLine.getElements();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            arrayList.add(line.getTextSegment(string));
            v3 = dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(dividend.getRightPadding()));
        } else {
            dividendDivisorLine.getElements().add(dividendDivisorLine.getTextSegment("#"));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getTextSegment(divisor.toStringPart()));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(this.whitespaceBetweenDivisorAndRadical));
            ArrayList<Line.Segment> arrayList3 = dividendDivisorLine.getElements();
            String string4 = this.verticalRadical;
            Intrinsics.checkNotNull((Object)string4);
            arrayList3.add(dividendDivisorLine.getTextSegment(string4));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(this.whitespaceBetweenRadicalAndDividend));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getTextSegment("#"));
            dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(dividend.getLeftPadding()));
            $this$trim$iv = dividend.toStringPart();
            line = dividendDivisorLine;
            arrayList = dividendDivisorLine.getElements();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            arrayList.add(line.getTextSegment(string));
            v3 = dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(dividend.getRightPadding()));
        }
        this.longestLine = dividendDivisorLine.toString().length();
        if (quotient != null && template.getSettings().getSolutions() > 0) {
            if (template.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
                void $this$trim$iv;
                line = new Line();
                ArrayList<Line.Segment> arrayList4 = line.getElements();
                int n = divisor.toStringPart().length() + this.whitespaceBetweenRadicalAndDividend;
                String string5 = this.verticalRadical;
                Intrinsics.checkNotNull((Object)string5);
                arrayList4.add(line.getWhitespaceSegment(n + string5.length() + this.whitespaceBetweenDivisorAndRadical + quotient.getLeftPadding()));
                String $i$f$trim = quotient.toStringPart();
                line = line;
                arrayList = line.getElements();
                boolean $i$f$trim2 = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                arrayList.add(line.getTextSegment(string));
                line.getElements().add(line.getWhitespaceSegment(quotient.getRightPadding()));
                if (Template.Companion.hasRemainder(template)) {
                    TemplateNumber remainder = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(1)).build();
                    line.getElements().add(line.getWhitespaceSegment(1));
                    line.getElements().add(line.getTextSegment("r#" + remainder.toStringPart()));
                }
                v11 = ((ArrayList)template.getLines()).add(line);
            } else {
                line = new Line();
                line.getElements().add(line.getWhitespaceSegment(this.longestLine - 1 - quotient.toStringPart().length()));
                line.getElements().add(line.getTextSegment("#"));
                Object remainder = new char[]{' '};
                line.getElements().add(line.getTextSegment(StringsKt.trim((String)quotient.toStringPart(), (char[])remainder)));
                line.getElements().add(line.getWhitespaceSegment(quotient.getRightPadding()));
                if (Template.Companion.hasRemainder(template)) {
                    remainder = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(1)).build();
                    line.getElements().add(line.getWhitespaceSegment(1));
                    line.getElements().add(line.getTextSegment("r#" + remainder.toStringPart()));
                    dividendDivisorLine.getElements().add(dividendDivisorLine.getWhitespaceSegment(3 + remainder.toStringPart().length()));
                }
                v11 = ((ArrayList)template.getLines()).add(line);
            }
            this.addLine(template, divisor, dividend);
        }
        ((ArrayList)template.getLines()).add(dividendDivisorLine);
        return template;
    }

    private final void addLine(Template template, TemplateNumber divisor, TemplateNumber dividend) {
        Line line = new Line();
        line.setSeparatorLine(true);
        TemplateNumber remainder = null;
        if (Template.Companion.hasRemainder(template)) {
            remainder = new TemplateNumber.TemplateNumberBuilder().wholeNum(template.getBrailleSolutions().get(1)).build();
        }
        if (template.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
            int whitespace = divisor.toStringPart().length() + this.whitespaceBetweenDivisorAndRadical;
            line.getElements().add(line.getWhitespaceSegment(whitespace));
            int lineChars = this.longestLine - 1 - divisor.toStringPart().length() - this.whitespaceBetweenDivisorAndRadical;
            if (remainder != null && Template.Companion.hasRemainder(template)) {
                lineChars += 3 + remainder.toStringPart().length();
            }
            v0 = line.getElements().add(line.getTextSegment("\"" + StringsKt.repeat((CharSequence)"3", (int)lineChars)));
        } else {
            int whitespace = divisor.toStringPart().length() + this.whitespaceBetweenDivisorAndRadical + 1;
            line.getElements().add(line.getWhitespaceSegment(whitespace));
            int n = dividend.toStringPart().length() + this.whitespaceBetweenRadicalAndDividend;
            String string = this.verticalRadical;
            Intrinsics.checkNotNull((Object)string);
            int lineChars = n + string.length() - 1 + 1;
            if (remainder != null && Template.Companion.hasRemainder(template)) {
                lineChars += 3 + remainder.toStringPart().length();
            }
            v0 = line.getElements().add(line.getTextSegment("\"" + StringsKt.repeat((CharSequence)"3", (int)lineChars)));
        }
        ((ArrayList)template.getLines()).add(line);
    }
}

