/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/math/template/UebTemplate;", "", "<init>", "()V", "templateLine", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/template/TemplateNumber;", "Lkotlin/collections/ArrayList;", "longestLine", "", "format", "Lorg/brailleblaster/math/template/Template;", "template", "addLine", "", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nUebTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UebTemplate.kt\norg/brailleblaster/math/template/UebTemplate\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,133:1\n106#2:134\n78#2,22:135\n106#2:157\n78#2,22:158\n106#2:180\n78#2,22:181\n106#2:203\n78#2,22:204\n*S KotlinDebug\n*F\n+ 1 UebTemplate.kt\norg/brailleblaster/math/template/UebTemplate\n*L\n65#1:134\n65#1:135,22\n75#1:157\n75#1:158,22\n92#1:180\n92#1:181,22\n103#1:203\n103#1:204,22\n*E\n"})
public final class UebTemplate {
    @NotNull
    private final ArrayList<TemplateNumber> templateLine = new ArrayList();
    private int longestLine;

    @NotNull
    public final Template format(@NotNull Template template) {
        Object wholeString;
        int i;
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (Template.Companion.operandsBlank(template)) {
            return template;
        }
        int n = ((Collection)template.getBrailleOperands()).size();
        for (i = 0; i < n; ++i) {
            wholeString = template.getBrailleOperands().get(i);
            this.templateLine.add(new TemplateNumber.TemplateNumberBuilder().wholeNum((String)wholeString).build());
        }
        n = ((Collection)template.getBrailleSolutions()).size();
        for (i = 0; i < n; ++i) {
            wholeString = template.getBrailleSolutions().get(i);
            this.templateLine.add(new TemplateNumber.TemplateNumberBuilder().wholeNum((String)wholeString).build());
        }
        TemplateNumber.Companion.makeColumnsEqualWidth((List<TemplateNumber>)this.templateLine);
        String operator = template.getBrailleOperator();
        String operatorLine = this.templateLine.get(template.getBrailleOperands().size() - 1).toStringWhole(template);
        if (operator.length() + operatorLine.length() > this.longestLine) {
            this.longestLine = operator.length() + operatorLine.length();
        }
        Iterator<TemplateNumber> iterator = this.templateLine.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        wholeString = iterator;
        while (wholeString.hasNext()) {
            Object e = wholeString.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TemplateNumber number = (TemplateNumber)e;
            if (number.toStringPart().length() <= this.longestLine) continue;
            this.longestLine = number.toStringPart().length();
        }
        int n2 = ((Collection)this.templateLine).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Intrinsics.checkNotNullExpressionValue((Object)this.templateLine.get(i2), (String)"get(...)");
            Line line = new Line();
            if (template.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
                if (i2 == template.getBrailleOperands().size() - 1) {
                    line.getElements().add(line.getTextSegment(operator + (number.isMinus() ? "\"\u2212" : (number.isColumnHasMinus() ? StringsKt.repeat((CharSequence)" ", (int)2) : ""))));
                    line.getElements().add(line.getWhitespaceSegment(number.getLeftPadding()));
                    String string = number.toStringPart();
                    var19_23 = line;
                    var18_22 = line.getElements();
                    $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    var20_24 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    var18_22.add(var19_23.getTextSegment(var20_24));
                    v3 = line.getElements().add(line.getWhitespaceSegment(number.getRightPadding()));
                } else {
                    line.getElements().add(line.getWhitespaceSegment(operator.length() + number.getLeftPadding()));
                    $this$trim$iv = number.toStringPart();
                    var20_24 = number.isMinus() ? "\"\u2212" : (number.isColumnHasMinus() ? StringsKt.repeat((CharSequence)" ", (int)2) : "");
                    var19_23 = line;
                    var18_22 = line.getElements();
                    $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    var21_25 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    var18_22.add(var19_23.getTextSegment(var20_24 + var21_25));
                    v3 = line.getElements().add(line.getWhitespaceSegment(number.getRightPadding()));
                }
            } else if (i2 == template.getBrailleOperands().size() - 1) {
                line.getElements().add(line.getTextSegment(operator + (number.isMinus() ? "\"\u2212" : (number.isColumnHasMinus() ? StringsKt.repeat((CharSequence)" ", (int)2) : "")) + "#"));
                line.getElements().add(line.getWhitespaceSegment(number.getLeftPadding()));
                $this$trim$iv = number.toStringPart();
                var19_23 = line;
                var18_22 = line.getElements();
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                var20_24 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                var18_22.add(var19_23.getTextSegment(var20_24));
                v3 = line.getElements().add(line.getWhitespaceSegment(number.getRightPadding()));
            } else {
                line.getElements().add(line.getWhitespaceSegment(operator.length()));
                line.getElements().add(line.getWhitespaceSegment(number.getLeftPadding()));
                $this$trim$iv = number.toStringPart();
                var20_24 = number.isMinus() ? "\"\u2212" : (number.isColumnHasMinus() ? StringsKt.repeat((CharSequence)" ", (int)2) : "");
                var19_23 = line;
                var18_22 = line.getElements();
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                var21_25 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                var18_22.add(var19_23.getTextSegment(var20_24 + "#" + var21_25));
                v3 = line.getElements().add(line.getWhitespaceSegment(number.getRightPadding()));
            }
            ((ArrayList)template.getLines()).add(line);
            if (i2 != template.getBrailleOperands().size() - 1) continue;
            this.addLine(template);
        }
        return template;
    }

    private final void addLine(Template template) {
        Line line = new Line();
        line.setSeparatorLine(true);
        line.getElements().add(line.getWhitespaceSegment(template.getBrailleOperator().length()));
        int lineChars = this.longestLine - 1 - template.getBrailleOperator().length();
        if (lineChars < 1) {
            lineChars = 1;
        }
        line.getElements().add(line.getTextSegment("\"" + StringsKt.repeat((CharSequence)"3", (int)lineChars)));
        ((ArrayList)template.getLines()).add(line);
    }
}

