/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.pandoc;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.pandoc.Fixer;
import org.brailleblaster.pandoc.FixerInf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0017\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u001a\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u001f\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/brailleblaster/pandoc/FixNestedList;", "Lorg/brailleblaster/pandoc/FixerInf;", "<init>", "()V", "bbUri", "", "rootElem", "Lnu/xom/Element;", "setFixer", "", "fixer", "Lorg/brailleblaster/pandoc/Fixer;", "process", "unnest", "elem", "setListAttributes", "e", "level", "isList", "", "p", "Lnu/xom/Node;", "isListItem", "moveListItems", "parent", "Lnu/xom/ParentNode;", "setListLevel", "list", "mergeLists", "l1", "l2", "checkAndMergeLists", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nFixNestedList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixNestedList.kt\norg/brailleblaster/pandoc/FixNestedList\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,208:1\n106#2:209\n78#2,22:210\n*S KotlinDebug\n*F\n+ 1 FixNestedList.kt\norg/brailleblaster/pandoc/FixNestedList\n*L\n197#1:209\n197#1:210,22\n*E\n"})
public final class FixNestedList
implements FixerInf {
    @Nullable
    private String bbUri;
    @Nullable
    private Element rootElem;

    @Override
    public void setFixer(@NotNull Fixer fixer) {
        Intrinsics.checkNotNullParameter((Object)fixer, (String)"fixer");
        this.bbUri = fixer.getBbUri();
        this.rootElem = fixer.getRootElement();
    }

    @Override
    public void process() throws Exception {
        this.unnest(this.rootElem);
    }

    private final void unnest(Element elem) throws Exception {
        ParentNode parent = null;
        Node node = null;
        int listCtr = 0;
        boolean isList = false;
        boolean isListItem = false;
        if (this.isList((Node)elem)) {
            Node node2 = node = (Node)elem;
            Intrinsics.checkNotNull((Object)node2);
            ParentNode parentNode = ((Element)node2).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            parent = parentNode;
            isList = this.isList((Node)parent);
            isListItem = this.isListItem((Node)parent);
            while (isList || isListItem) {
                if (isList) {
                    ++listCtr;
                }
                Intrinsics.checkNotNullExpressionValue((Object)parent.getParent(), (String)"getParent(...)");
                isList = this.isList((Node)parent);
                isListItem = this.isListItem((Node)parent);
            }
            this.setListAttributes(elem, String.valueOf(listCtr));
        }
        Element element = elem;
        Intrinsics.checkNotNull((Object)element);
        Elements elems = element.getChildElements();
        int n = elems.size();
        for (int i = 0; i < n; ++i) {
            this.unnest(elems.get(i));
        }
        ParentNode parentNode = elem.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        parent = parentNode;
        if (this.isListItem((Node)parent)) {
            this.moveListItems(elem, parent);
        }
        if (this.isList((Node)elem) && !this.isListItem((Node)parent)) {
            this.checkAndMergeLists(elem, parent);
        }
    }

    private final void setListAttributes(Element e, String level) {
        Element block = null;
        Element element = e;
        Intrinsics.checkNotNull((Object)element);
        Attribute attr = element.getAttribute("listLevel", this.bbUri);
        attr.setValue(level);
        Elements children = e.getChildElements("BLOCK", this.bbUri);
        if (children != null) {
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                attr = block.getAttribute("itemLevel", this.bbUri);
                attr.setValue(level);
            }
        }
    }

    private final boolean isList(Node p) {
        Element elP = null;
        boolean isAList = false;
        if (p instanceof Element && StringsKt.equals((String)(elP = (Element)p).getLocalName(), (String)"CONTAINER", (boolean)true) && StringsKt.equals((String)elP.getAttributeValue("type", this.bbUri), (String)"LIST", (boolean)true)) {
            isAList = true;
        }
        return isAList;
    }

    private final boolean isListItem(Node p) {
        Element elP = null;
        boolean isListItem = false;
        if (p instanceof Element && StringsKt.equals((String)(elP = (Element)p).getLocalName(), (String)"BLOCK", (boolean)true) && StringsKt.equals((String)elP.getAttributeValue("type", this.bbUri), (String)"LIST_ITEM", (boolean)true)) {
            isListItem = true;
        }
        return isListItem;
    }

    private final void moveListItems(Element elem, ParentNode parent) {
        Element block = null;
        ParentNode listParent = parent.getParent();
        int index = listParent.indexOf((Node)parent);
        Element element = elem;
        Intrinsics.checkNotNull((Object)element);
        Elements children = element.getChildElements("BLOCK", this.bbUri);
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
            block.detach();
            listParent.insertChild((Node)block, index + i + 1);
        }
        if (elem.getChildCount() == 0) {
            parent.removeChild((Node)elem);
            if (parent.getChildCount() == 0) {
                listParent.removeChild((Node)parent);
            }
        }
        Intrinsics.checkNotNull((Object)listParent);
        this.setListLevel((Node)listParent);
    }

    private final void setListLevel(Node list) {
        Element listEl = null;
        Elements children = null;
        Element child = null;
        int maxLevel = 0;
        int level = 0;
        Attribute attr = null;
        Attribute maxAttr = null;
        if (list instanceof Element) {
            listEl = (Element)list;
            maxAttr = listEl.getAttribute("listLevel", this.bbUri);
            String string = maxAttr.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            maxLevel = Integer.parseInt(string);
            Elements elements = listEl.getChildElements();
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getChildElements(...)");
            children = elements;
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
                if (this.isListItem((Node)child)) {
                    attr = child.getAttribute("itemLevel", this.bbUri);
                } else if (this.isList((Node)child)) {
                    attr = child.getAttribute("listLevel", this.bbUri);
                }
                Attribute attribute = attr;
                Intrinsics.checkNotNull((Object)attribute);
                String string2 = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                level = Integer.parseInt(string2);
                if (maxLevel >= level) continue;
                maxLevel = level;
            }
            maxAttr.setValue(String.valueOf(maxLevel));
        }
    }

    private final void mergeLists(Element l1, Element l2) {
        int maxLev = 0;
        Element child = null;
        Element element = l2;
        Intrinsics.checkNotNull((Object)element);
        Elements children = element.getChildElements("BLOCK", this.bbUri);
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)children.get(i), (String)"get(...)");
            child.detach();
            l1.appendChild((Node)children.get(i));
        }
        String string = l1.getAttributeValue("listLevel", this.bbUri);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
        int lev1 = Integer.parseInt(string);
        String string2 = l2.getAttributeValue("listLevel", this.bbUri);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
        int lev2 = Integer.parseInt(string2);
        maxLev = Math.max(lev2, lev1);
        l1.getAttribute("listLevel", this.bbUri).setValue(String.valueOf(maxLev));
        l2.getParent().removeChild((Node)l2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAndMergeLists(Element elem, ParentNode parent) {
        int index = parent.indexOf((Node)elem);
        Element list = null;
        Node node = null;
        int k = 0;
        int n = 0;
        for (int i = 0; i < index; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)parent.getChild(i), (String)"getChild(...)");
            k = parent.indexOf(node);
            if (!this.isList(node)) continue;
            list = (Element)node;
            n = 0;
            for (int j = k + 1; j < index; ++j) {
                int n2;
                Intrinsics.checkNotNullExpressionValue((Object)parent.getChild(j), (String)"getChild(...)");
                int n3 = n;
                if (node instanceof Text) {
                    void $this$trim$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)((Text)node).getValue(), (String)"getValue(...)");
                    int n4 = n3;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    n3 = n4;
                    n2 = string.length();
                } else {
                    n2 = 1;
                }
                n = n3 + n2;
            }
            if (n != 0) continue;
            this.mergeLists(list, elem);
        }
    }
}

