/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.NoSuchChildException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.document.BBDocument;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.mathml.MathSubject;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.RemoveNodeMessage;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.views.wp.MathEditHandler;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.UTDTranslationEngineCallback;
import org.brailleblaster.utd.actions.GenericAction;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.actions.RemoveLineAttributeAction;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.util.WhitespaceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020 H\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0012H\u0002J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010J\u0010\u0010&\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u001a\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010%\u001a\u0004\u0018\u00010\u0010J\u001a\u0010*\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010%\u001a\u0004\u0018\u00010\u0010J\u0010\u0010-\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\u0010J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010J\u000e\u0010/\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u001e\u00102\u001a\u00020\u00102\u0016\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u001004j\b\u0012\u0004\u0012\u00020\u0010`5J\u0016\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0010\u00a8\u0006:"}, d2={"Lorg/brailleblaster/perspectives/braille/document/BrailleDocument;", "Lorg/brailleblaster/document/BBDocument;", "dm", "Lorg/brailleblaster/perspectives/braille/Manager;", "doc", "Lnu/xom/Document;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lnu/xom/Document;)V", "updateNode", "", "manager", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "text", "", "insertElement", "Lnu/xom/Element;", "current", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "offset", "", "subType", "Lorg/brailleblaster/bbx/BBX$SubType;", "atStart", "", "parent", "insertIndex", "changeTextNode", "n", "Lnu/xom/Node;", "removeNode", "message", "Lorg/brailleblaster/perspectives/braille/messages/RemoveNodeMessage;", "removeElement", "m", "t", "translateElement", "e", "removeBraille", "changeStyle", "style", "Lorg/brailleblaster/utd/IStyle;", "changeAction", "action", "Lorg/brailleblaster/utd/actions/IAction;", "removeAction", "retranslateElement", "getParent", "findAndRemoveBrailleElement", "element", "createDontSplitSpan", "parents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "mergeElements", "originalParent", "child", "Companion", "brailleblaster-core"})
public final class BrailleDocument
extends BBDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(BrailleDocument.class);

    public BrailleDocument(@NotNull Manager dm, @NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)dm, (String)"dm");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        super(dm, doc);
        this.getEngine().setCallback(new UTDTranslationEngineCallback(){

            public void onUpdateNode(Node n) {
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            }

            public void onFormatComplete(Node root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            }
        });
    }

    public final void updateNode(@NotNull Manager manager, @NotNull MapList list, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object text2 = text;
        manager.stopFormatting();
        text2 = StringsKt.replace$default((String)StringsKt.replace$default((String)text2, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        Node[] nodeArray = list.getCurrent().getNode();
        if (nodeArray == null) {
            throw new NullPointerException("CurrentNode is null. TME: " + list.getCurrent());
        }
        Node[] currentNode = nodeArray;
        Node block = this.getEngine().findTranslationBlock((Node)currentNode);
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type nu.xom.Element");
        this.findAndRemoveBrailleElement((Element)block);
        if (currentNode instanceof Element && MathModuleUtils.isMath((Node)currentNode)) {
            log.debug("Insert new into math from Braille Document");
            MathEditHandler.INSTANCE.translateAndReplaceAtCursor(new MathSubject(text2));
            return;
        }
        if (!list.getCurrent().isFullyVisible()) {
            text2 = list.getCurrent().getStart(list) == 0 ? list.getCurrent().getInvisibleText() + (String)text2 : (String)text2 + list.getCurrent().getInvisibleText();
        }
        Node[] parentNode = currentNode instanceof Text ? (Node)((Text)currentNode).getParent() : currentNode;
        this.changeTextNode((Node)currentNode, (String)text2);
        Node[] nodeArray2 = parentNode;
        Intrinsics.checkNotNull((Object)nodeArray2);
        Node parent = BBXUtils.cleanupBlock((Node)nodeArray2);
        if (parentNode.getDocument() == null && list.getPrevious(true) != null) {
            boolean lastTextTME = true;
            int n = list.size();
            for (int index = list.getCurrentIndex() + 1; index < n; ++index) {
                if (list.get(index) instanceof WhiteSpaceElement) continue;
                lastTextTME = false;
                break;
            }
            if (lastTextTME) {
                WhitespaceUtils.removeLineBreakElements(list, list.indexOf(list.getPrevious(true)), list.size() - 1);
            }
        }
        if (parent != null) {
            parentNode = parent;
        }
        BBSimpleManager bBSimpleManager = manager.getSimpleManager();
        nodeArray2 = new Node[1];
        Node[] nodeArray3 = parentNode;
        Intrinsics.checkNotNull((Object)nodeArray3);
        nodeArray2[0] = nodeArray3;
        bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.SIMPLEMANAGER, true, nodeArray2));
    }

    @NotNull
    public final Element insertElement(@NotNull TextMapElement current, int offset, @NotNull BBX.SubType subType, boolean atStart) {
        Element parent;
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        int offset2 = offset;
        Element p = this.makeElement(subType);
        p.appendChild((Node)new Text(""));
        if (current instanceof BoxLineTextMapElement) {
            v0 = ((BoxLineTextMapElement)current).getNodeParent();
        } else {
            UTDTranslationEngine uTDTranslationEngine = this.getEngine();
            Node node = current.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Node node2 = uTDTranslationEngine.findTranslationBlock(node);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            v0 = parent = (Element)node2;
        }
        if (Companion.isEmptyPlaceholder(parent)) {
            parent.getParent().replaceChild((Node)parent, (Node)p);
        } else {
            int nodeIndex = 0;
            if (current instanceof BoxLineTextMapElement) {
                if (Intrinsics.areEqual((Object)((BoxLineTextMapElement)current).getNodeParent(), (Object)((BoxLineTextMapElement)current).getNodeParent())) {
                    if (atStart) {
                        ParentNode parentNode = parent.getParent();
                        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                        parent = (Element)parentNode;
                        nodeIndex = parent.indexOf((Node)((BoxLineTextMapElement)current).getNodeParent());
                        offset2 = 0;
                    } else {
                        nodeIndex = 0;
                    }
                } else {
                    parent = ((BoxLineTextMapElement)current).getNodeParent();
                    nodeIndex = parent.indexOf(((BoxLineTextMapElement)current).getNode());
                }
            } else if (current instanceof PageIndicatorTextMapElement) {
                ParentNode parentNode = parent.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                parent = (Element)parentNode;
                nodeIndex = parent.indexOf((Node)((PageIndicatorTextMapElement)current).getNodeParent());
            } else if (this.getEngine().getActionMap().findValueOrDefault((Node)parent) instanceof GenericAction || this.getEngine().getActionMap().findValueOrDefault((Node)parent) instanceof RemoveLineAttributeAction) {
                nodeIndex = parent.getParent().indexOf((Node)parent);
                ParentNode parentNode = parent.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                parent = (Element)parentNode;
            } else {
                while (!(this.getEngine().getActionMap().findValueOrDefault((Node)parent) instanceof GenericAction)) {
                    nodeIndex = parent.getParent().indexOf((Node)parent);
                    ParentNode parentNode = parent.getParent();
                    Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                    parent = (Element)parentNode;
                }
                nodeIndex = parent.getParent().indexOf((Node)parent);
                ParentNode parentNode = parent.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                parent = (Element)parentNode;
            }
            parent.insertChild((Node)p, nodeIndex + offset2);
        }
        return p;
    }

    @NotNull
    public final Element insertElement(@NotNull Element parent, int insertIndex, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Element child = BBX.BLOCK.STYLE.create("Body Text");
        child.appendChild((Node)new Text(text));
        parent.insertChild((Node)child, insertIndex);
        Intrinsics.checkNotNull((Object)child);
        return child;
    }

    private final void changeTextNode(Node n, String text) {
        if (n instanceof Text) {
            if (((CharSequence)text).length() == 0) {
                n.detach();
                return;
            }
            String string = ((Text)n).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                ParentNode parent = ((Text)n).getParent();
                int index = parent.indexOf(n);
                if (parent.getChildCount() - index > 1 && BBX.SPAN.PAGE_NUM.isA(parent.getChild(index + 1))) {
                    Node copy2 = parent.removeChild(index + 1);
                    parent.insertChild(copy2, index);
                }
            }
            ((Text)n).setValue(text);
        }
    }

    public final void removeNode(@NotNull MapList list, @NotNull RemoveNodeMessage message) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.contains("element")) {
            this.removeElement(message);
        } else {
            Object e = list.get(message.index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            this.removeNode((TextMapElement)e);
        }
    }

    private final void removeElement(RemoveNodeMessage m) {
        Object object = m.getValue("element");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element e = (Element)object;
        e.getParent().removeChild((Node)e);
    }

    private final void removeNode(TextMapElement t) {
        Element e;
        LinkedList<BrailleMapElement> linkedList = t.brailleList;
        Intrinsics.checkNotNullExpressionValue(linkedList, (String)"brailleList");
        BrailleMapElement brailleMapElement = (BrailleMapElement)CollectionsKt.firstOrNull((List)linkedList);
        Object object = e = brailleMapElement != null ? brailleMapElement.getNodeParent() : null;
        if (e != null && e != t.getNode()) {
            t.getNodeParent().removeChild((Node)e);
        }
        try {
            t.getNodeParent().removeChild(t.getNode());
        }
        catch (NoSuchChildException noSuchChildException) {
            // empty catch block
        }
    }

    @NotNull
    public final Element translateElement(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.removeBraille(e);
        Nodes nodes = this.getEngine().translate((Node)e);
        Node node = nodes.get(0);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        return (Element)node;
    }

    private final void removeBraille(Element e) {
        Elements els = e.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            if (UTDElements.BRL.isA((Node)els.get(i))) {
                e.removeChild((Node)els.get(i));
                continue;
            }
            Element element = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"get(...)");
            this.removeBraille(element);
        }
    }

    public final void changeStyle(@Nullable IStyle style, @Nullable Element e) {
        UTDManager uTDManager = this.getUtdManager();
        Style style2 = (Style)style;
        Element element = e;
        Intrinsics.checkNotNull((Object)element);
        uTDManager.applyStyle(style2, element);
    }

    public final void changeAction(@Nullable IAction action, @Nullable Element e) {
        UTDManager uTDManager = this.getUtdManager();
        Element element = e;
        Intrinsics.checkNotNull((Object)element);
        uTDManager.applyAction(action, element);
    }

    public final void removeAction(@Nullable Element e) {
        UTDManager uTDManager = this.getUtdManager();
        Element element = e;
        Intrinsics.checkNotNull((Object)element);
        uTDManager.removeOverrideAction(element);
    }

    @NotNull
    public final Element retranslateElement(@NotNull Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.removeBraille(e);
        ParentNode parentNode = e.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        Node node = this.getEngine().translate((Node)e).get(0);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element translatedElement = (Element)node;
        parent.replaceChild((Node)e, (Node)translatedElement);
        return translatedElement;
    }

    @NotNull
    public final Element getParent(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        Element element = BBXUtilsKt.findBlockOrNull((Node)parentNode);
        if (element == null) {
            Node node = this.getEngine().findTranslationBlock(n);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            return (Element)node;
        }
        return element;
    }

    public final void findAndRemoveBrailleElement(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Elements els = element.getChildElements();
        int n = els.size();
        for (int i = 0; i < n; ++i) {
            if (UTDElements.BRL.isA((Node)els.get(i))) {
                Element element2 = els.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"get(...)");
                this.removeElement(element2);
                continue;
            }
            Element element3 = els.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"get(...)");
            this.findAndRemoveBrailleElement(element3);
        }
    }

    private final void removeElement(Element e) {
        e.getParent().removeChild((Node)e);
    }

    @NotNull
    public final Element createDontSplitSpan(@NotNull ArrayList<Element> parents) {
        Intrinsics.checkNotNullParameter(parents, (String)"parents");
        Element span = BBX.CONTAINER.DONT_SPLIT.create();
        span.addAttribute(new Attribute("class", "dontsplit"));
        ParentNode parentNode = parents.get(0).getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element grandparent = (Element)parentNode;
        int grandParentIndex = grandparent.indexOf((Node)parents.get(0));
        List elementsToInsert = new ArrayList();
        Iterator<Element> iterator = parents.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element parent = iterator2.next();
            if (parent.getDocument() == null) continue;
            parent.detach();
            elementsToInsert.add(parent);
        }
        for (Element element : elementsToInsert) {
            span.appendChild((Node)element);
        }
        grandparent.insertChild((Node)span, grandParentIndex);
        Intrinsics.checkNotNull((Object)span);
        return span;
    }

    @NotNull
    public final Element mergeElements(@NotNull Element originalParent, @NotNull Element child) {
        Intrinsics.checkNotNullParameter((Object)originalParent, (String)"originalParent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Element parent = originalParent.copy();
        Intrinsics.checkNotNull((Object)parent);
        this.removeBraille(parent);
        this.removeBraille(child);
        while (child.getChildCount() > 0) {
            if (parent.getChild(parent.getChildCount() - 1) instanceof Text && child.getChild(0) instanceof Text) {
                Node node = parent.getChild(parent.getChildCount() - 1);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
                ((Text)node).setValue(parent.getChild(parent.getChildCount() - 1).getValue() + child.getChild(0).getValue());
                child.removeChild(0);
                continue;
            }
            if (child.getChild(0) instanceof Element && BBX.SPAN.DEFINITION_TERM.isA(child.getChild(0))) {
                Node gw = child.getChild(0).getChild(0).copy();
                child.getChild(0).detach();
                parent.appendChild(gw);
                continue;
            }
            Node e1 = parent.getChild(parent.getChildCount() - 1);
            Node e2 = child.getChild(0);
            if (e1 instanceof Element && e2 instanceof Element) {
                boolean merged = false;
                if (!(this.getEngine().getActionMap().findValueOrDefault(e1) instanceof GenericAction) && !(this.getEngine().getActionMap().findValueOrDefault(e2) instanceof GenericAction) && Intrinsics.areEqual((Object)this.getEngine().getActionMap().findValueOrDefault(e1), (Object)this.getEngine().getActionMap().findValueOrDefault(e2)) && ((Element)e1).getChildCount() > 0 && ((Element)e1).getChild(0) instanceof Text && ((Element)e2).getChildCount() > 0 && ((Element)e2).getChild(0) instanceof Text) {
                    Node node = ((Element)e1).getChild(0);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
                    ((Text)node).setValue(((Element)e1).getChild(0).getValue() + ((Element)e2).getChild(0).getValue());
                    Elements els = ((Element)e2).getChildElements();
                    int n = els.size();
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl = false;
                        Element element = (Element)e1;
                        Element element2 = (Element)e2;
                        Intrinsics.checkNotNull((Object)els);
                        element.appendChild(element2.removeChild((Node)CollectionsKt.first((Iterable)((Iterable)els))));
                    }
                    ((Element)e2).getParent().removeChild(e2);
                    merged = true;
                }
                if (merged) continue;
                parent.appendChild(child.removeChild(0));
                continue;
            }
            parent.appendChild(child.removeChild(0));
        }
        ParentNode parentNode = child.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element childParent = (Element)parentNode;
        int position = childParent.indexOf((Node)child);
        while (position > 0 && UTDElements.NEW_LINE.isA(childParent.getChild(position - 1))) {
            childParent.getChild(position - 1).detach();
        }
        child.detach();
        originalParent.getParent().replaceChild((Node)originalParent, (Node)parent);
        return parent;
    }

    @JvmStatic
    public static final boolean isEmptyPlaceholder(@NotNull Element e) {
        return Companion.isEmptyPlaceholder(e);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/perspectives/braille/document/BrailleDocument$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isEmptyPlaceholder", "", "e", "Lnu/xom/Element;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isEmptyPlaceholder(@NotNull Element e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (BBX.BLOCK.ATTRIB_BLANKDOC_PLACEHOLDER.has((Node)e)) {
                String string = e.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                bl = ((CharSequence)string).length() == 0;
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

