/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.elements;

import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMapElement {
    public static final int NOT_SET = -1;
    protected int start;
    protected int end;

    public AbstractMapElement(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public AbstractMapElement() {
        this(-1, -1);
    }

    public Element getNodeParent() {
        Node n = this.getNode();
        return n != null ? (Element)n.getParent() : null;
    }

    @NotNull
    public String getText() {
        Node n = this.getNode();
        return n != null ? n.getValue() : "";
    }

    public void setOffsets(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public void resetOffsets() {
        this.start = -1;
        this.end = -1;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getStart(MapList list) {
        return this.start;
    }

    public int getEnd(MapList list) {
        return this.end;
    }

    public abstract Node getNode();

    public String toString() {
        return this.getClass().getSimpleName() + "{start=" + this.start + ", end=" + this.end + ", n=" + XMLHandler.toXMLSimple((Node)this.getNode()) + "}";
    }
}

