/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.elements;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.mapping.elements.AbstractMapElement;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.Nullable;

public class BrailleMapElement
extends AbstractMapElement {
    private static final String VPOS = "vPos";
    private static final String HPOS = "hPos";
    private boolean insideTable = false;
    private Double vPos;
    private Double hPos;
    private final Node node;

    public BrailleMapElement(int start, int end, @Nullable Node n) {
        super(start, end);
        this.node = n;
        this.vPos = null;
        this.hPos = null;
    }

    public BrailleMapElement(@Nullable Node n) {
        this.node = n;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public void setPosition(Element moveTo) {
        if (UTDElements.MOVE_TO.isA((Node)moveTo)) {
            this.setVPos(moveTo);
            this.setHPos(moveTo);
        }
    }

    public void setPosition(double vPos, double hPos) {
        this.vPos = vPos;
        this.hPos = hPos;
    }

    private void setVPos(Element moveTo) {
        Attribute vert = moveTo.getAttribute(VPOS);
        if (vert != null) {
            this.vPos = Double.valueOf(vert.getValue());
        }
    }

    private void setHPos(Element moveTo) {
        Attribute hor = moveTo.getAttribute(HPOS);
        if (hor != null) {
            this.hPos = Double.valueOf(hor.getValue());
        }
    }

    public Double getVPos() {
        return this.vPos;
    }

    public Double getHPos() {
        return this.hPos;
    }

    public void setInsideTable(boolean value) {
        this.insideTable = value;
    }

    public boolean isInsideTable() {
        return this.insideTable;
    }
}

