/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.elements;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.abstractClasses.BBEditorView;
import org.brailleblaster.abstractClasses.ViewUtils;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.PaintedElement;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.wordprocessor.FontManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Listener;
import org.jetbrains.annotations.NotNull;

public class PageIndicator
implements PaintedElement {
    private int line;
    private PaintedText runningHead;
    private PaintedText guideWords;
    private PaintedText braillePageNum;
    private PaintedText printPageNum;
    private final Manager manager;
    private Node printPageElement;
    private Node braillePageElement;
    public Listener listener;
    final BrlCell cellType;
    private static final int PAGE_NUM_PADDING = 3;
    private final int BRAILLE_LINE_OFFSET = -20;
    private final int PRINT_LINE_OFFSET = 5;

    public PageIndicator(Manager manager) {
        this.manager = manager;
        this.cellType = manager.getDocument().getEngine().getBrailleSettings().getCellType();
    }

    public PageIndicator(Manager manager, int line) {
        this.manager = manager;
        this.line = line;
        this.cellType = manager.getDocument().getEngine().getBrailleSettings().getCellType();
    }

    public void findPageNums(Node startPoint) {
        boolean backwards;
        if (UTDElements.BRL_PAGE_NUM.isA(startPoint)) {
            this.braillePageElement = startPoint;
            this.braillePageNum = new PaintedText(this.parsePage(startPoint.getValue()), this.findHPos(this.braillePageElement));
            this.handleRunningHeads(startPoint);
            this.handleGuideWords(startPoint);
            return;
        }
        if (UTDElements.PRINT_PAGE_NUM.isA(startPoint)) {
            this.printPageElement = startPoint;
            this.printPageNum = new PaintedText(this.retrievePrintPage((Element)startPoint), this.findHPos(this.printPageElement));
            this.handleRunningHeads(startPoint);
            this.handleGuideWords(startPoint);
            return;
        }
        this.handleRunningHeads(startPoint);
        this.handleGuideWords(startPoint);
        int isPos = this.isPageNumberBottom(Integer.parseInt(((Element)startPoint).getAttributeValue("brlnum")), "PRINT");
        boolean bl = backwards = isPos == 1;
        if (isPos != -1) {
            this.printPageElement = this.findPageNum(startPoint, backwards, UTDElements.PRINT_PAGE_NUM);
            if (this.printPageElement != null) {
                this.printPageNum = new PaintedText(this.retrievePrintPage((Element)this.printPageElement), this.findHPos(this.printPageElement));
            }
        }
        if ((isPos = this.isPageNumberBottom(Integer.parseInt(((Element)startPoint).getAttributeValue("brlnum")), "BRAILLE")) != -1) {
            backwards = isPos == 1;
            this.braillePageElement = this.findPageNum(startPoint, backwards, UTDElements.BRL_PAGE_NUM);
            if (this.braillePageElement != null) {
                this.braillePageNum = new PaintedText(this.parsePage(this.braillePageElement.getValue()), this.findHPos(this.braillePageElement));
            }
        }
    }

    private void handleRunningHeads(Node startPoint) {
        PageSettings pageSettings = this.manager.getDocument().getEngine().getPageSettings();
        Node runningHeadNode = this.searchForNode(startPoint, n -> n instanceof Element && (this.isRunningHead((Element)n) || UTDElements.NEW_PAGE.isA(n)));
        if (runningHeadNode != null && !UTDElements.NEW_PAGE.isA(runningHeadNode)) {
            String runningHeadText = !pageSettings.getRunningHead().isEmpty() ? pageSettings.getRunningHead() : runningHeadNode.getValue();
            this.runningHead = new PaintedText(runningHeadText, this.findHPos(runningHeadNode));
        }
    }

    private void handleGuideWords(Node startPoint) {
        Node guideWordsNode = this.searchForPreviousNode(startPoint, n -> n instanceof Element && (this.isGuideWord((Element)n) || UTDElements.NEW_PAGE.isA(n)));
        if (guideWordsNode != null && !UTDElements.NEW_PAGE.isA(guideWordsNode)) {
            String guideWordsText = ((Element)guideWordsNode).getAttribute("printIndicator") != null ? ((Element)guideWordsNode).getAttributeValue("printIndicator") : guideWordsNode.getValue();
            this.guideWords = new PaintedText(guideWordsText, this.findHPos(guideWordsNode));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int isPageNumberBottom(int newPageNum, String keyword) {
        boolean isEven;
        PageSettings pageSettings = this.manager.getDocument().getEngine().getPageSettings();
        boolean bl = isEven = newPageNum % 2 == 0;
        if (keyword.equals("PRINT")) {
            if (isEven) {
                if (pageSettings.getEvenPrintPageNumberAt().isTop()) return 0;
                if (!pageSettings.getOddPrintPageNumberAt().isBottom()) return -1;
                return 1;
            }
            if (pageSettings.getOddPrintPageNumberAt().isTop()) return 0;
            if (!pageSettings.getEvenPrintPageNumberAt().isBottom()) return -1;
            return 1;
        }
        if (!keyword.equals("BRAILLE")) return -1;
        if (isEven) {
            if (pageSettings.getEvenBraillePageNumberAt().isTop()) return 0;
            if (!pageSettings.getOddBraillePageNumberAt().isBottom()) return -1;
            return 1;
        }
        if (pageSettings.getOddBraillePageNumberAt().isTop()) return 0;
        if (!pageSettings.getEvenBraillePageNumberAt().isBottom()) return -1;
        return 1;
    }

    private Node findPageNum(Node startPoint, boolean backwards, UTDElements element) {
        Predicate<Node> test = n -> n instanceof Element && (element.isA(n) || UTDElements.NEW_PAGE.isA(n));
        Node returnNode = backwards ? this.searchForPreviousNode(startPoint, test) : this.searchForNode(startPoint, test);
        if (returnNode == null || UTDElements.NEW_PAGE.isA(returnNode)) {
            return null;
        }
        return returnNode;
    }

    private Node searchForPreviousNode(Node startPoint, Predicate<Node> test) {
        int startIndex;
        Element curElement = (Element)startPoint.getParent();
        Node searchResult = this.searchDescendantsForNodeBackwards(curElement, startIndex = curElement.indexOf(startPoint) - 1, test);
        if (searchResult != null) {
            return searchResult;
        }
        ParentNode parent = curElement.getParent();
        if (parent == null || parent instanceof Document) {
            return null;
        }
        return this.searchForPreviousNode((Node)curElement, test);
    }

    private Node searchDescendantsForNodeBackwards(Element parent, Predicate<Node> test) {
        return this.searchDescendantsForNodeBackwards(parent, parent.getChildCount() - 1, test);
    }

    private Node searchDescendantsForNodeBackwards(Element parent, int startIndex, Predicate<Node> test) {
        for (int i = startIndex; i >= 0; --i) {
            Node searchElement;
            Node child = parent.getChild(i);
            if (test.test(child)) {
                return child;
            }
            if (!(child instanceof Element) || (searchElement = this.searchDescendantsForNodeBackwards((Element)child, test)) == null) continue;
            return searchElement;
        }
        return null;
    }

    private Node searchForNode(Node startPoint, Predicate<Node> test) {
        int startIndex;
        Element curElement = (Element)startPoint.getParent();
        Node searchResult = this.searchDescendantsForNode(curElement, startIndex = curElement.indexOf(startPoint) + 1, test);
        if (searchResult != null) {
            return searchResult;
        }
        ParentNode parent = curElement.getParent();
        if (parent == null || parent instanceof Document) {
            return null;
        }
        return this.searchForNode((Node)curElement, test);
    }

    private Node searchDescendantsForNode(Element parent, Predicate<Node> test) {
        return this.searchDescendantsForNode(parent, 0, test);
    }

    private Node searchDescendantsForNode(Element parent, int startIndex, Predicate<Node> test) {
        for (int i = startIndex; i < parent.getChildCount(); ++i) {
            Node searchElement;
            Node child = parent.getChild(i);
            if (test.test(child)) {
                return child;
            }
            if (!(child instanceof Element) || (searchElement = this.searchDescendantsForNode((Element)child, test)) == null) continue;
            return searchElement;
        }
        return null;
    }

    private int findHPos(Node node) {
        ParentNode parent = node.getParent();
        int index = parent.indexOf(node);
        if (index > 0 && UTDElements.MOVE_TO.isA(parent.getChild(index - 1))) {
            String hPosAttribute = ViewUtils.getAttributeValue((Element)parent.getChild(index - 1), "hPos");
            if (hPosAttribute != null) {
                BigDecimal bd = new BigDecimal(hPosAttribute);
                double hPos = bd.doubleValue();
                return this.manager.getDocument().getEngine().getBrailleSettings().getCellType().getCellsForWidth(BigDecimal.valueOf(hPos));
            }
            return 0;
        }
        return 0;
    }

    public void startListener(BBEditorView view) {
        if (this.listener != null) {
            view.getView().removeListener(9, this.listener);
        }
        this.listener = event -> {
            this.calculateNewPos(event.gc, view, 0, this.guideWords, this.braillePageNum);
            this.calculateNewPos(event.gc, view, 1, this.runningHead, this.printPageNum);
            int x1 = 0;
            int y1 = view.getView().getLinePixel(this.line == 0 ? 0 : this.line + 1);
            int x2 = view.getView().getBounds().width;
            FontManager.copyViewFont(this.manager, view, event.gc);
            int brailleLine = y1 + -20;
            int printLine = y1 + 5;
            if (this.guideWords != null) {
                event.gc.drawText(this.guideWords.text, this.guideWords.pos, brailleLine);
            }
            if (this.braillePageNum != null) {
                event.gc.drawText(this.braillePageNum.text, this.braillePageNum.pos, brailleLine);
            }
            if (this.runningHead != null) {
                event.gc.drawText(this.runningHead.text, this.runningHead.pos, printLine);
            }
            if (this.printPageNum != null) {
                event.gc.drawText(this.printPageNum.text, this.printPageNum.pos, printLine);
            }
            event.gc.drawLine(x1, y1, x2, y1);
        };
        view.getView().addListener(9, this.listener);
    }

    @Override
    public void removeListener(@NotNull BBEditorView view) {
        if (this.listener != null) {
            view.getView().removeListener(9, this.listener);
        }
    }

    public boolean hasRunningHead() {
        return this.runningHead != null;
    }

    public boolean hasGuideWord() {
        return this.guideWords != null;
    }

    private void calculateNewPos(GC gc, BBEditorView view, int lineOffset, PaintedText ... texts) {
        int curLine = this.line + lineOffset;
        int cellWidth = gc.textExtent((String)" ").x;
        int textViewLineWidth = curLine >= view.getView().getLineCount() ? 0 : view.getView().getLine(curLine).length() + view.getView().getLineIndent(curLine) / view.getCharWidth();
        List<PaintedText> textList = Arrays.asList(texts);
        textList.sort((t1, t2) -> {
            if (t1 == null) {
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            return t1.pos - t2.pos;
        });
        int curEndPos = textViewLineWidth;
        for (PaintedText text : textList) {
            if (text == null) continue;
            text.pos = text.actualPos;
            if (text.actualPos - 3 < curEndPos) {
                text.pos = curEndPos + 3;
            }
            curEndPos = text.pos;
            text.pos *= cellWidth;
        }
    }

    private boolean isGuideWord(Element node) {
        String typeAttr = node.getAttributeValue("type");
        return "guideWord".equals(typeAttr);
    }

    private boolean isRunningHead(Element node) {
        String typeAttr = node.getAttributeValue("type");
        return "runningHead".equals(typeAttr);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getBraillePageNum() {
        if (this.braillePageNum != null) {
            return this.braillePageNum.text;
        }
        return "";
    }

    public String getPrintPageNum() {
        if (this.printPageNum != null) {
            return this.printPageNum.text;
        }
        return "";
    }

    public Node getPrintPageElement() {
        return this.printPageElement;
    }

    public Node getBraillePageElement() {
        return this.braillePageElement;
    }

    private String retrievePrintPage(Element printNode) {
        if (printNode.getAttribute("printPageBrl") == null && printNode.getAttribute("contLetter") == null) {
            throw new IllegalArgumentException("Missing needed attributes: printPage and/or contLetter");
        }
        return printNode.getAttributeValue("contLetter") + this.parsePage(printNode.getAttributeValue("printPageBrl"));
    }

    private String parsePage(String text) {
        StringBuilder num = new StringBuilder();
        int index = text.indexOf(35);
        if (index != -1) {
            int i;
            for (i = 0; i < index; ++i) {
                if (text.charAt(i) == ',') {
                    num.append(Character.toUpperCase(text.charAt(i + 1)));
                    ++i;
                    continue;
                }
                num.append(text.charAt(i));
            }
            for (i = index + 1; i < text.length(); ++i) {
                if (text.charAt(i) == 'j') {
                    num.append('0');
                    continue;
                }
                if (text.charAt(i) == '-') {
                    num.append('-');
                    continue;
                }
                if (text.charAt(i) == '4') {
                    num.append('.');
                    continue;
                }
                if (text.charAt(i) == ',') {
                    num.append(Character.toUpperCase(text.charAt(i + 1)));
                    ++i;
                    continue;
                }
                if (text.charAt(i) == '#') continue;
                num.append(text.charAt(i) - 97 + 1);
            }
        } else {
            text = text.replace(";", "");
            for (int i = index + 1; i < text.length(); ++i) {
                if (text.charAt(i) == ',') {
                    num.append(Character.toUpperCase(text.charAt(i + 1)));
                    ++i;
                    continue;
                }
                num.append(text.charAt(i));
            }
        }
        return num.toString();
    }

    private static class PaintedText {
        final String text;
        final int actualPos;
        int pos;

        public PaintedText(String text, int pos) {
            this.text = text;
            this.pos = this.actualPos = pos;
        }
    }
}

