/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.mapping.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.exceptions.OutdatedMapListException;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BraillePageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BrlOnlyBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.NewPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PrintPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.mvc.modules.misc.TableSelectionModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00014B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010#\u001a\u00020\u0004J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010%\u001a\u00020\u0004J\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)J\b\u0010*\u001a\u00020\u0004H\u0002J\u0006\u0010+\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0004J\u0016\u0010/\u001a\u00020'2\u0006\u0010\u0003\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0017J\n\u00100\u001a\u00020\u001eH\u0096\u0080\u0004J\b\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement;", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "Lorg/brailleblaster/perspectives/braille/mapping/interfaces/Uneditable;", "start", "", "end", "n", "Lnu/xom/Node;", "<init>", "(IILnu/xom/Node;)V", "(Lnu/xom/Node;)V", "tableElements", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TableCellTextMapElement;", "columns", "", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement$TableColumn;", "getColumns", "()[Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement$TableColumn;", "setColumns", "([Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement$TableColumn;)V", "[Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement$TableColumn;", "value", "", "startingVPos", "getStartingVPos", "()D", "endingVPos", "getEndingVPos", "tableType", "", "getTableType", "()Ljava/lang/String;", "getCellsInRow", "", "row", "getCellsInCol", "col", "setLines", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "findTotalCols", "findEarliestVPos", "setEarliestOffset", "pos", "setLatestOffset", "setStartAndEndVPos", "toString", "getNodeParent", "Lnu/xom/Element;", "blockEdit", "TableColumn", "brailleblaster-core"})
public final class TableTextMapElement
extends TextMapElement
implements Uneditable {
    @JvmField
    @NotNull
    public final List<TableCellTextMapElement> tableElements = new ArrayList();
    public TableColumn[] columns;
    private double startingVPos;
    private double endingVPos;

    @NotNull
    public final TableColumn[] getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"columns");
        return null;
    }

    public final void setColumns(@NotNull TableColumn[] tableColumnArray) {
        Intrinsics.checkNotNullParameter((Object)tableColumnArray, (String)"<set-?>");
        this.columns = tableColumnArray;
    }

    public final double getStartingVPos() {
        return this.startingVPos;
    }

    public final double getEndingVPos() {
        return this.endingVPos;
    }

    public TableTextMapElement(int start, int end, @Nullable Node n) {
        super(start, end, n);
        this.setReadOnly(true);
    }

    public TableTextMapElement(@Nullable Node n) {
        super(n);
        this.setReadOnly(true);
    }

    @NotNull
    public final String getTableType() {
        Node node = this.getNode();
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        if (((Element)node).getAttribute("class") != null) {
            Node node2 = this.getNode();
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
            String tableClass = ((Element)node2).getAttributeValue("class");
            Intrinsics.checkNotNull((Object)tableClass);
            if (StringsKt.contains$default((CharSequence)tableClass, (CharSequence)"utd:table", (boolean)false, (int)2, null)) {
                String string = tableClass.substring(9);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                return string3;
            }
        }
        return "";
    }

    @NotNull
    public final List<TableCellTextMapElement> getCellsInRow(int row) {
        List returnList = new ArrayList();
        boolean foundRowFlag = false;
        for (TableCellTextMapElement cell : this.tableElements) {
            if (cell.getRow() == row) {
                returnList.add(cell);
                foundRowFlag = true;
                continue;
            }
            if (!foundRowFlag) continue;
            break;
        }
        return returnList;
    }

    @NotNull
    public final List<TableCellTextMapElement> getCellsInCol(int col) {
        List returnList = new ArrayList();
        for (TableCellTextMapElement cell : this.tableElements) {
            if (cell.getCol() != col) continue;
            returnList.add(cell);
        }
        return returnList;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLines(@Nullable Manager m) {
        void $this$setLines_u24lambda_u240;
        int totalCols = this.findTotalCols();
        int n = 0;
        TableColumn[] tableColumnArray = new TableColumn[totalCols];
        TableTextMapElement tableTextMapElement = this;
        while (n < totalCols) {
            int n2 = n++;
            tableColumnArray[n2] = new TableColumn();
        }
        TableColumn[] tableColumnArray2 = tableColumnArray;
        tableColumnArray = tableColumnArray2;
        boolean bl = false;
        TableColumn tableColumn = (TableColumn)ArraysKt.lastOrNull((Object[])$this$setLines_u24lambda_u240);
        if (tableColumn != null) {
            tableColumn.setLastColumn(true);
        }
        tableTextMapElement.setColumns(tableColumnArray2);
        for (TableCellTextMapElement tableElement : this.tableElements) {
            TableColumn curColumn = this.getColumns()[tableElement.getCol()];
            curColumn.findBrlWidth(tableElement);
        }
        double startVPos = 0.0;
        int n3 = ((Collection)this.tableElements).size();
        for (int j = 0; j < n3; ++j) {
            TableColumn column = this.getColumns()[this.tableElements.get(j).getCol()];
            Manager manager = m;
            Intrinsics.checkNotNull((Object)manager);
            this.tableElements.get(j).splitIntoLines(manager, column.getBrlWidth(), column.isLastColumn());
            if (j == 0) {
                startVPos = this.findEarliestVPos();
            }
            if (j != this.tableElements.size() - 1) continue;
            this.setStartAndEndVPos(startVPos, this.tableElements.get(j).getEndingVPos());
        }
        n3 = this.getColumns().length;
        for (int i = 0; i < n3; ++i) {
            this.getColumns()[i].findPrintWidth(i);
        }
    }

    private final int findTotalCols() {
        int totalCols = 0;
        for (TableCellTextMapElement tableElement : this.tableElements) {
            totalCols = (int)Math.max((double)totalCols, (double)tableElement.getCol());
        }
        return totalCols + 1;
    }

    public final double findEarliestVPos() {
        List<TableCellTextMapElement> firstRow = this.getCellsInRow(0);
        if (firstRow.isEmpty()) {
            return 0.0;
        }
        double start = -1.0;
        block0: for (TableCellTextMapElement cell : firstRow) {
            int n = ((Collection)cell.brailleList).size();
            for (int i = 0; i < n; ++i) {
                if (cell.brailleList.get(i) instanceof BrlOnlyBrlMapElement || cell.brailleList.get(i) instanceof NewPageBrlMapElement || cell.brailleList.get(i) instanceof BraillePageBrlMapElement || cell.brailleList.get(i) instanceof PrintPageBrlMapElement) continue;
                if (((BrailleMapElement)cell.brailleList.get(i)).getVPos() == null || !(((BrailleMapElement)cell.brailleList.get(i)).getVPos() < start) && !(start == -1.0)) continue block0;
                Double d = ((BrailleMapElement)cell.brailleList.get(i)).getVPos();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getVPos(...)");
                start = ((Number)d).doubleValue();
                continue block0;
            }
        }
        if (start < 0.0) {
            return 0.0;
        }
        return start;
    }

    public final void setEarliestOffset(int pos) {
        if (!((Collection)this.tableElements).isEmpty() && !this.tableElements.get((int)0).brailleList.isEmpty()) {
            ((BrailleMapElement)this.tableElements.get((int)0).brailleList.get(0)).setOffsets(pos, pos);
        }
    }

    public final void setLatestOffset(int pos) {
        if (!((Collection)this.tableElements).isEmpty() && !this.tableElements.get((int)(this.tableElements.size() - 1)).brailleList.isEmpty()) {
            LinkedList linkedList = this.tableElements.get((int)(this.tableElements.size() - 1)).brailleList;
            Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"brailleList");
            ((BrailleMapElement)CollectionsKt.last((List)linkedList)).setOffsets(pos, pos);
        }
    }

    public final void setStartAndEndVPos(double start, double end) {
        this.startingVPos = start;
        this.endingVPos = end;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder returnString = new StringBuilder();
        returnString.append("Node: ").append(this.getNode().toXML()).append("\nTableElements:");
        for (TableCellTextMapElement tableElement : this.tableElements) {
            Iterator iterator;
            returnString.append("\n").append(tableElement.getNode().toXML()).append("\n\tBrailleList: ");
            Intrinsics.checkNotNullExpressionValue(tableElement.brailleList.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                BrailleMapElement bme = (BrailleMapElement)iterator.next();
                returnString.append("\n\t\t").append(bme.getNode().toXML());
            }
            returnString.append("\n\tLines: ").append(tableElement.getLines());
        }
        String string = returnString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public Element getNodeParent() {
        if (this.getNode().getParent() == null) {
            throw new OutdatedMapListException("Table has no parent", null, 2, null);
        }
        ParentNode p = this.getNode().getParent();
        int index = p.indexOf(this.getNode());
        Node node = p.getChild(index - 1);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        return (Element)node;
    }

    @Override
    public void blockEdit(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        TableSelectionModule.Companion.displayInvalidTableMessage(m.getWpManager().getShell());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement$TableColumn;", "", "<init>", "(Lorg/brailleblaster/perspectives/braille/mapping/elements/TableTextMapElement;)V", "isLastColumn", "", "()Z", "setLastColumn", "(Z)V", "brlWidth", "", "getBrlWidth", "()I", "setBrlWidth", "(I)V", "printWidth", "getPrintWidth", "setPrintWidth", "findPrintWidth", "", "colNum", "findBrlWidth", "cell", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TableCellTextMapElement;", "brailleblaster-core"})
    public final class TableColumn {
        private boolean isLastColumn;
        private int brlWidth = -1;
        private int printWidth = -1;

        public final boolean isLastColumn() {
            return this.isLastColumn;
        }

        public final void setLastColumn(boolean bl) {
            this.isLastColumn = bl;
        }

        public final int getBrlWidth() {
            return this.brlWidth;
        }

        public final void setBrlWidth(int n) {
            this.brlWidth = n;
        }

        public final int getPrintWidth() {
            return this.printWidth;
        }

        public final void setPrintWidth(int n) {
            this.printWidth = n;
        }

        public final void findPrintWidth(int colNum) {
            int cellTotal = 0;
            int prevRow = -1;
            int prevCol = -1;
            int n = ((Collection)TableTextMapElement.this.tableElements).size();
            for (int i = 0; i < n; ++i) {
                TableCellTextMapElement curCell = TableTextMapElement.this.tableElements.get(i);
                if (curCell.getCol() != colNum) continue;
                for (Object value : curCell.getLines().values()) {
                    double d = cellTotal;
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                    cellTotal = (int)Math.max(d, (double)((String)value).length());
                }
                if (prevRow == curCell.getRow() && prevCol == curCell.getCol()) {
                    int prevLength = 0;
                    int thisLength = 0;
                    TableCellTextMapElement prevCell = TableTextMapElement.this.tableElements.get(i - 1);
                    if (!prevCell.isImage(prevCell.getLines()) && !curCell.isImage(curCell.getLines())) {
                        String lastLine = (String)prevCell.getLines().get(prevCell.getEndingVPos());
                        String thisLine = (String)curCell.getLines().get(prevCell.getEndingVPos());
                        CharSequence charSequence = lastLine;
                        if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)thisLine) == null || charSequence.length() == 0)) {
                            cellTotal = (int)Math.max((double)cellTotal, (double)(lastLine.length() + thisLine.length()));
                        }
                    } else {
                        if (prevCell.isImage(prevCell.getLines())) {
                            prevLength = 1;
                        } else if (prevCell.getLines().get(prevCell.getEndingVPos()) != null) {
                            String string = (String)prevCell.getLines().get(prevCell.getEndingVPos());
                            Intrinsics.checkNotNull((Object)string);
                            prevLength = string.length();
                        }
                        if (curCell.isImage(curCell.getLines())) {
                            thisLength = 1;
                        } else if (curCell.getLines().get(curCell.getEndingVPos()) != null) {
                            String string = (String)curCell.getLines().get(curCell.getEndingVPos());
                            Intrinsics.checkNotNull((Object)string);
                            thisLength = string.length();
                        }
                        if (thisLength != 0 && prevLength != 0) {
                            cellTotal = (int)Math.max((double)cellTotal, (double)(prevLength + thisLength));
                        }
                    }
                }
                prevRow = curCell.getRow();
                prevCol = curCell.getCol();
            }
            this.printWidth = cellTotal;
        }

        public final void findBrlWidth(@NotNull TableCellTextMapElement cell) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            int n = ((Collection)cell.brailleList).size();
            for (int i = 0; i < n; ++i) {
                String string = ((BrailleMapElement)cell.brailleList.get(i)).getNode().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\"3", (boolean)false, (int)2, null)) continue;
                this.brlWidth = ((BrailleMapElement)cell.brailleList.get(i)).getNode().getValue().length();
            }
        }
    }
}

