/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.stylers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.interfaces.Uneditable;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.perspectives.braille.views.wp.BrailleView;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.actions.PageAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\b\u0010\u0018\u001a\u00020\u0011H\u0004J\b\u0010\u0019\u001a\u00020\u0011H\u0004J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fH\u0004J\u0012\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\u0012\u0010#\u001a\u00020\u00152\b\u0010$\u001a\u0004\u0018\u00010%H\u0004J\u0012\u0010&\u001a\u00020\u00152\b\u0010$\u001a\u0004\u0018\u00010%H\u0004J\u0012\u0010&\u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\u0012\u0010'\u001a\u00020(2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0004J\u0010\u0010)\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/Handler;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "vi", "Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;", "list", "Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/viewInitializer/ViewInitializer;Lorg/brailleblaster/perspectives/braille/mapping/maps/MapList;)V", "text", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "braille", "Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "getBraille", "()Lorg/brailleblaster/perspectives/braille/views/wp/BrailleView;", "reformat", "", "n", "Lnu/xom/Node;", "translate", "", "nodes", "", "removeListeners", "initializeListeners", "getParent", "Lnu/xom/ParentNode;", "indexes", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "isBoxLine", "e", "Lnu/xom/Element;", "isWhitespace", "t", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "readOnly", "getStyle", "Lorg/brailleblaster/utd/IStyle;", "findParent", "brailleblaster-core"})
public abstract class Handler {
    @JvmField
    @NotNull
    protected final Manager manager;
    @JvmField
    @NotNull
    protected final ViewInitializer vi;
    @JvmField
    @NotNull
    protected final MapList list;
    @JvmField
    @NotNull
    protected final TextView text;
    @NotNull
    private final BrailleView braille;

    public Handler(@NotNull Manager manager, @NotNull ViewInitializer vi, @NotNull MapList list) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)vi, (String)"vi");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.manager = manager;
        this.vi = vi;
        this.list = list;
        TextView textView = this.manager.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"getText(...)");
        this.text = textView;
        BrailleView brailleView = this.manager.getBraille();
        Intrinsics.checkNotNullExpressionValue((Object)brailleView, (String)"getBraille(...)");
        this.braille = brailleView;
    }

    @NotNull
    protected final BrailleView getBraille() {
        return this.braille;
    }

    protected final void reformat(@NotNull Node n, boolean translate) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Node[] nodeArray = new Node[]{n};
        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.HANDLER, translate, nodeArray));
    }

    protected final void reformat(@NotNull List<? extends Node> nodes, boolean translate) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.manager.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.HANDLER, nodes, translate));
    }

    protected final void removeListeners() {
        this.text.removeListeners();
        this.braille.removeListeners();
    }

    protected final void initializeListeners() {
        this.text.initializeListeners();
        this.braille.initializeListeners();
    }

    @Nullable
    protected final ParentNode getParent(@NotNull ArrayList<Integer> indexes) {
        Element element;
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        if (!((Collection)indexes).isEmpty()) {
            Document document = this.manager.getDocument().doc.getDocument();
            Integer n = indexes.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            Node node = document.getChild(((Number)n).intValue());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            element = (Element)node;
        } else {
            element = null;
        }
        Element e = element;
        int n = indexes.size();
        for (int i = 1; i < n; ++i) {
            Element element2 = e;
            Intrinsics.checkNotNull(element2);
            Integer n2 = indexes.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"get(...)");
            Node node = element2.getChild(((Number)n2).intValue());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            e = (Element)node;
        }
        return (ParentNode)e;
    }

    protected final boolean isBoxLine(@Nullable Element e) {
        IStyle style = this.getStyle((Node)e);
        CharSequence charSequence = style.getStartSeparator();
        return !(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)style.getEndSeparator()) == null || charSequence.length() == 0);
    }

    protected final boolean isWhitespace(@Nullable TextMapElement t) {
        return t instanceof WhiteSpaceElement;
    }

    protected final boolean readOnly(@Nullable TextMapElement t) {
        return t instanceof Uneditable;
    }

    protected final boolean readOnly(@Nullable Element e) {
        return this.manager.getAction((Node)e) instanceof PageAction || this.isBoxLine(e);
    }

    @NotNull
    protected final IStyle getStyle(@Nullable Node n) {
        IStyleMap iStyleMap = this.manager.getDocument().getEngine().getStyleMap();
        Node node = n;
        Intrinsics.checkNotNull((Object)node);
        return (IStyle)iStyleMap.findValueOrDefault(node);
    }

    @NotNull
    protected final Element findParent(@NotNull TextMapElement t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        BrailleDocument brailleDocument = this.manager.getDocument();
        Node node = t.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        return brailleDocument.getParent(node);
    }
}

