/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.stylers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.exceptions.EditingException;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BoxLineTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.LineBreakElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.mapping.maps.MapList;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.messages.WhitespaceMessage;
import org.brailleblaster.perspectives.braille.stylers.Handler;
import org.brailleblaster.perspectives.braille.viewInitializer.ViewInitializer;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.util.WhitespaceUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/WhitespaceTransformer;", "Lorg/brailleblaster/perspectives/braille/stylers/Handler;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "transformWhiteSpace", "", "message", "Lorg/brailleblaster/perspectives/braille/messages/WhitespaceMessage;", "wse", "Lorg/brailleblaster/perspectives/braille/mapping/elements/WhiteSpaceElement;", "node", "Lnu/xom/Node;", "transformWhitespace", "text", "", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nWhitespaceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhitespaceTransformer.kt\norg/brailleblaster/perspectives/braille/stylers/WhitespaceTransformer\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,219:1\n106#2:220\n78#2,22:221\n*S KotlinDebug\n*F\n+ 1 WhitespaceTransformer.kt\norg/brailleblaster/perspectives/braille/stylers/WhitespaceTransformer\n*L\n184#1:220\n184#1:221,22\n*E\n"})
public final class WhitespaceTransformer
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> STYLES_NOT_TO_BE_RETAINED = SetsKt.setOf((Object)"Spatial Math");

    public WhitespaceTransformer(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ViewInitializer viewInitializer = manager.getViewInitializer();
        Intrinsics.checkNotNullExpressionValue((Object)viewInitializer, (String)"getViewInitializer(...)");
        MapList mapList = manager.getMapList();
        Intrinsics.checkNotNullExpressionValue((Object)mapList, (String)"getMapList(...)");
        super(manager, viewInitializer, mapList);
    }

    public final void transformWhiteSpace(@NotNull WhitespaceMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object e = this.list.get(message.index);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement");
        this.transformWhitespace((WhiteSpaceElement)e, message.newText);
    }

    public final void transformWhiteSpace(@NotNull WhiteSpaceElement wse, @NotNull Node node) {
        int blankLinesAfter;
        Intrinsics.checkNotNullParameter((Object)wse, (String)"wse");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int index = this.list.indexOf(wse);
        TextMapElement curElement = this.list.findPreviousNonWhitespace(index);
        TextMapElement nextElement = this.list.findNextNonWhitespace(index);
        boolean atBeginning = false;
        boolean betweenSpatialMath = false;
        if (curElement == null && nextElement == null) {
            throw new NullPointerException("Empty maplist?");
        }
        if (curElement == null) {
            curElement = nextElement;
            atBeginning = true;
        }
        TextMapElement textMapElement = curElement;
        Intrinsics.checkNotNull((Object)textMapElement);
        if (textMapElement.isSpatialMath() && nextElement != null && nextElement.isSpatialMath()) {
            betweenSpatialMath = true;
        }
        int blankLinesBefore = atBeginning ? index : index - this.list.indexOf(curElement);
        int n = blankLinesAfter = nextElement == null ? -1 : this.list.indexOf(nextElement) - index;
        if (wse instanceof LineBreakElement && !atBeginning) {
            --blankLinesBefore;
        }
        if (nextElement != null) {
            try {
                WhitespaceUtils.removeLineBreakElements(this.list, atBeginning ? 0 : this.list.indexOf(curElement), this.list.indexOf(nextElement));
            }
            catch (RuntimeException e) {
                throw new EditingException("Error removing lines breaks from index " + this.list.indexOf(curElement) + " to index " + this.list.indexOf(nextElement) + ". AtBeginning: " + atBeginning, (Throwable)e);
            }
        }
        Element targetElement = null;
        boolean isSidebar = curElement instanceof BoxLineTextMapElement;
        int offset = 1;
        if (isSidebar) {
            if (((BoxLineTextMapElement)curElement).isStartSeparator()) {
                Node node2 = ((BoxLineTextMapElement)curElement).getNode();
                Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                targetElement = (Element)node2;
            } else {
                targetElement = ((BoxLineTextMapElement)curElement).getNodeParent();
                offset = 2;
            }
        } else if (Manager.getTableParent((Node)curElement.getNodeParent()) != null) {
            targetElement = !atBeginning ? (Manager.getTableBrlCopy((Node)curElement.getNodeParent()) != null ? Manager.getTableBrlCopy((Node)curElement.getNodeParent()) : Manager.getTableParent((Node)curElement.getNodeParent())) : Manager.getTableParent((Node)curElement.getNodeParent());
        } else if (SpatialMathUtils.isSpatialMathPage(curElement.getNode())) {
            Node node3 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getNode(...)");
            targetElement = SpatialMathUtils.getSpatialPageParent(node3);
        } else if (NumberLine.Companion.isNumberLine(curElement.getNode())) {
            Node node4 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"getNode(...)");
            targetElement = NumberLine.Companion.getNumberLineParent(node4);
        } else if (Matrix.Companion.isMatrix(curElement.getNode())) {
            Node node5 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node5, (String)"getNode(...)");
            targetElement = Matrix.Companion.getMatrixParent(node5);
        } else if (Template.Companion.isTemplate(curElement.getNode())) {
            Node node6 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node6, (String)"getNode(...)");
            targetElement = Template.Companion.getTemplateParent(node6);
        } else {
            Node node7 = curElement.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node7, (String)"getNode(...)");
            targetElement = BBXUtilsKt.findBlock(node7);
            if (targetElement == null && (targetElement = this.findParent(curElement)) == targetElement.getDocument().getRootElement()) {
                throw new EditingException("CurElement has no block or translation block ancestor: " + curElement.getNode(), null, 2, null);
            }
        }
        Element element = targetElement;
        Intrinsics.checkNotNull((Object)element);
        ParentNode parent = element.getParent();
        if (MathModuleUtils.isSpatialMath((Node)targetElement) && betweenSpatialMath) {
            offset = 0;
        }
        int insertIndex = atBeginning ? parent.indexOf((Node)targetElement) : parent.indexOf((Node)targetElement) + offset;
        parent.insertChild(node, insertIndex);
        if (blankLinesBefore > 1 || atBeginning && blankLinesBefore > 0) {
            while (blankLinesBefore > 0) {
                Element element2;
                if (atBeginning) {
                    try {
                        element2 = WhitespaceUtils.prependLineBreakElement(node);
                    }
                    catch (RuntimeException e) {
                        throw new EditingException("Error prepending line breaks to node " + node.toXML(), (Throwable)e);
                    }
                }
                try {
                    Node node8 = curElement.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)node8, (String)"getNode(...)");
                    element2 = WhitespaceUtils.appendLineBreakElement(node8);
                }
                catch (RuntimeException e) {
                    throw new EditingException("Error appending line breaks to node " + node.toXML(), (Throwable)e);
                }
                --blankLinesBefore;
            }
        }
        if (blankLinesAfter > 1) {
            while (blankLinesAfter > 0) {
                try {
                    WhitespaceUtils.appendLineBreakElement(node);
                }
                catch (RuntimeException e) {
                    throw new EditingException("Error appending line breaks to node " + node.toXML(), (Throwable)e);
                }
                --blankLinesAfter;
            }
        }
        this.reformat(node, true);
    }

    private final void transformWhitespace(WhiteSpaceElement wse, String text) {
        int index = this.list.indexOf(wse);
        TextMapElement curElement = this.list.findPreviousNonWhitespace(index);
        TextMapElement nextElement = this.list.findNextNonWhitespace(index);
        String $this$trim$iv = text;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
            if (curElement != null) {
                Node node = curElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                this.reformat(node, false);
            } else {
                Node node = nextElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                this.reformat(node, false);
            }
        } else {
            String style = "Body Text";
            if (curElement != null) {
                String curStyle;
                Element block;
                Element element = block = curElement.getBlock();
                String string = curStyle = element != null ? element.getAttributeValue("utd-style") : null;
                if (curStyle != null && !STYLES_NOT_TO_BE_RETAINED.contains(curStyle)) {
                    style = this.manager.getSimpleManager().getUtdManager().getBaseStyle(curStyle, (Node)block);
                }
            }
            Element newElement = BBX.BLOCK.STYLE.create(style);
            Text textNode = new Text(text);
            newElement.appendChild((Node)textNode);
            Intrinsics.checkNotNull((Object)newElement);
            this.transformWhiteSpace(wse, (Node)newElement);
            if (curElement != null && curElement.isSpatialMath()) {
                this.manager.getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.NO_SENDER, new XMLTextCaret(textNode, 0, null, 4, null), null, 4, null));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/perspectives/braille/stylers/WhitespaceTransformer$Companion;", "", "<init>", "()V", "STYLES_NOT_TO_BE_RETAINED", "", "", "getSTYLES_NOT_TO_BE_RETAINED", "()Ljava/util/Set;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSTYLES_NOT_TO_BE_RETAINED() {
            return STYLES_NOT_TO_BE_RETAINED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

