/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.utd.BBXDynamicOptionStyleMap;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.mathml.MathUtils;
import org.brailleblaster.perspectives.braille.views.wp.TextRenderer;
import org.brailleblaster.perspectives.mvc.modules.misc.ChangeTranslationModule;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.internal.DynamicOptionStyleMap;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.ColorManager;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 o2\u00020\u0001:\u000befghijklmnoB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020(J\u0006\u0010,\u001a\u00020+J\u001e\u0010-\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/H\u0002J&\u00100\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/2\u0006\u00101\u001a\u00020\u0006H\u0002J\u001e\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/H\u0002J\u000e\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u000bJ\u0010\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020\u0006H\u0002J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020(H\u0002J\u0006\u00109\u001a\u00020+J\u000e\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020<J\u0010\u0010:\u001a\u00020+2\b\u0010;\u001a\u0004\u0018\u00010=J\u000e\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020>J\u000e\u0010?\u001a\u00020+2\u0006\u0010;\u001a\u00020<J\u000e\u0010?\u001a\u00020+2\u0006\u0010;\u001a\u00020=J\u0016\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u0006J\u0010\u0010C\u001a\u00020\"2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010C\u001a\u00020\"2\u0006\u0010;\u001a\u00020=H\u0002J\u0010\u0010C\u001a\u00020\"2\u0006\u0010;\u001a\u00020>H\u0002J\u0010\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020\"H\u0002J\u0010\u0010?\u001a\u00020+2\u0006\u0010;\u001a\u00020\"H\u0002J\b\u0010D\u001a\u00020+H\u0002J\b\u0010E\u001a\u00020+H\u0002J\b\u0010F\u001a\u00020+H\u0002J\b\u0010G\u001a\u00020+H\u0002J\b\u0010H\u001a\u00020+H\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020$H\u0002J\u0018\u0010L\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u00062\u0006\u0010N\u001a\u00020\u0006H\u0002J\u001e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00100/2\u0006\u0010M\u001a\u00020\u00062\u0006\u0010N\u001a\u00020\u0006H\u0002J \u0010P\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u00062\u0006\u0010N\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\"H\u0002J\b\u0010Q\u001a\u00020+H\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010\"2\u0006\u0010S\u001a\u00020TH\u0002J\b\u0010U\u001a\u00020+H\u0002J\b\u0010V\u001a\u00020\u000bH\u0002J$\u0010W\u001a\u00020+2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010X\u001a\u00020T2\u0006\u0010M\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010ZH\u0002J\u000e\u0010[\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\\\u001a\u00020+2\u0006\u0010]\u001a\u00020$J\u0010\u0010^\u001a\u00020+2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010_\u001a\u00020+J\b\u0010`\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020\u000bH\u0002J\b\u0010d\u001a\u00020&H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText;", "", "parent", "Lorg/eclipse/swt/widgets/Composite;", "buttonPanel", "buttons", "", "style", "<init>", "(Lorg/eclipse/swt/widgets/Composite;Lorg/eclipse/swt/widgets/Composite;II)V", "newLineWrap", "", "text", "Lorg/eclipse/swt/custom/StyledText;", "styles", "", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Range;", "margins", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Margin;", "fontSize", "display", "Lorg/eclipse/swt/widgets/Display;", "getDisplay", "()Lorg/eclipse/swt/widgets/Display;", "setDisplay", "(Lorg/eclipse/swt/widgets/Display;)V", "buttonStyle", "getParent", "()Lorg/eclipse/swt/widgets/Composite;", "setParent", "(Lorg/eclipse/swt/widgets/Composite;)V", "disposeables", "Lorg/eclipse/swt/graphics/Resource;", "allTags", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "newLineStyle", "", "curMarginPaintListener", "Lorg/eclipse/swt/widgets/Listener;", "getXML", "Lnu/xom/Element;", "root", "setXML", "", "clear", "xmlToString", "tags", "", "extractTextFromXML", "startOffset", "extractXML", "setCustomMargins", "enabled", "updateMargins", "keyCode", "computeMargin", "element", "removeAllEmphasis", "toggleTag", "tag", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$EmphasisTags;", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$MathTags;", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$StyleTags;", "applyEmphasisToAll", "applyMargin", "firstLineIndent", "indent", "getEquivalent", "createButtons", "initTags", "openChangeTranslationDialog", "openCreateHeadingDialog", "openChangeMarginDialog", "splitSelection", "", "match", "findIndex", "start", "end", "getRangesInRange", "verifyToggle", "updateRanges", "getTagFromStyle", "sr", "Lorg/eclipse/swt/custom/StyleRange;", "repaint", "hasCustomMargins", "checkParams", "getSRForTextStyle", "length", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "setFontSize", "setNewLineWrapStyle", "newStyleName", "disableTab", "dispose", "disposeListener", "Lorg/eclipse/swt/events/DisposeListener;", "changeMarginLineIndent", "indented", "newMarginPaintListener", "TextStyle", "Tag", "MathTag", "StyleTag", "EmphasisTag", "Range", "EmphasisTags", "StyleTags", "MathTags", "Margin", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBBStyleableText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBStyleableText.kt\norg/brailleblaster/perspectives/braille/ui/BBStyleableText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1142:1\n231#2,2:1143\n742#2,9:1145\n742#2,9:1156\n37#3,2:1154\n37#3,2:1165\n1#4:1167\n*S KotlinDebug\n*F\n+ 1 BBStyleableText.kt\norg/brailleblaster/perspectives/braille/ui/BBStyleableText\n*L\n304#1:1143,2\n338#1:1145,9\n710#1:1156,9\n338#1:1154,2\n710#1:1165,2\n*E\n"})
public final class BBStyleableText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Composite buttonPanel;
    private boolean newLineWrap;
    @JvmField
    @NotNull
    public StyledText text;
    @NotNull
    private List<Range> styles;
    @NotNull
    private final List<Margin> margins;
    private int fontSize;
    @NotNull
    private Display display;
    private int buttonStyle;
    @NotNull
    private Composite parent;
    @NotNull
    private List<Resource> disposeables;
    @NotNull
    private List<Tag> allTags;
    @NotNull
    private String newLineStyle;
    @Nullable
    private Listener curMarginPaintListener;
    private static final Logger log = LoggerFactory.getLogger(BBStyleableText.class);
    public static final int TRANSCRIBEREMPHASIS = 2;
    public static final int BOLD = 4;
    public static final int ITALIC = 8;
    public static final int SCRIPT = 16;
    public static final int UNDERLINE = 32;
    public static final int CREATEHEADING = 64;
    public static final int CHANGETRANSLATION = 128;
    public static final int CREATETPAGEHEADING = 256;
    public static final int SMALL_BUTTONS = 1024;
    public static final int CUSTOM_MARGINS = 2048;
    public static final int NONEWLINES = 32768;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Tag BOLDTAG;
    @NotNull
    private static final Tag ITALICTAG;
    @NotNull
    private static final Tag SCRIPTTAG;
    @NotNull
    private static final Tag UNDERLINETAG;
    @NotNull
    private static final Tag CTEXACTTAG;
    @NotNull
    private static final Tag CTUNCONTRACTEDTAG;
    @NotNull
    private static final Tag MATHTAG;
    @NotNull
    private static final Tag TE1;
    @NotNull
    private static final Tag TE2;
    @NotNull
    private static final Tag TE3;
    @NotNull
    private static final Tag TE4;
    @NotNull
    private static final Tag TE5;
    @NotNull
    private static final Tag BOLDITALICTAG;
    @NotNull
    private static final Tag ITALICBOLDTAG;
    @NotNull
    private static final Tag CENTEREDHEADING;
    @NotNull
    private static final Tag TPAGEHEADING;
    private static final int DEFAULT_FONT_SIZE = 10;
    @NotNull
    private static final String INDENT_ATTRIB;
    @NotNull
    private static final Margin DEFAULT_MARGIN;
    @NotNull
    private static final String FIRST_LINE_INDENT_ATTRIB;

    public BBStyleableText(@NotNull Composite parent, @Nullable Composite buttonPanel, int buttons, int style) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.newLineWrap = true;
        this.fontSize = 10;
        this.disposeables = new ArrayList();
        this.allTags = new ArrayList();
        this.newLineStyle = "Body Text";
        this.checkParams(parent, buttonPanel, buttons);
        this.parent = parent;
        this.buttonPanel = buttonPanel;
        this.buttonStyle = buttons;
        this.text = new StyledText(parent, style);
        if (this.hasCustomMargins()) {
            this.changeMarginLineIndent(true);
        }
        this.disableTab(this.text);
        if (buttonPanel != null) {
            this.createButtons();
        }
        this.initTags();
        this.styles = new ArrayList();
        this.margins = new ArrayList();
        ((ArrayList)this.margins).add(DEFAULT_MARGIN);
        if ((this.buttonStyle & 0x8000) != 0) {
            this.newLineWrap = false;
        }
        Display display = parent.getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"getDisplay(...)");
        this.display = display;
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateRanges();
                this.updateMargins(e.keyCode);
            }
        });
        this.text.addVerifyKeyListener(new VerifyKeyListener(){
            private final Logger log = LoggerFactory.getLogger(this.getClass());

            public void verifyKey(VerifyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.character == ' ' && e.stateMask == SWT.MOD1) {
                    e.doit = false;
                    this.log.info("adding nbps");
                    text.insert("\u00a0");
                    StyleRange sr = new StyleRange();
                    sr.start = text.getCaretOffset();
                    sr.length = 1;
                    sr.background = Display.getCurrent().getSystemColor(2);
                    text.setStyleRange(sr);
                    StyledText styledText = text;
                    styledText.setCaretOffset(styledText.getCaretOffset() + 1);
                    this.updateRanges();
                }
            }
        });
        this.text.addExtendedModifyListener(arg_0 -> BBStyleableText._init_$lambda$0(this, arg_0));
        this.text.addDisposeListener(this.disposeListener());
        if (this.hasCustomMargins()) {
            this.curMarginPaintListener = this.newMarginPaintListener();
            this.text.addListener(9, this.curMarginPaintListener);
        }
    }

    @NotNull
    public final Display getDisplay() {
        return this.display;
    }

    public final void setDisplay(@NotNull Display display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"<set-?>");
        this.display = display;
    }

    @NotNull
    public final Composite getParent() {
        return this.parent;
    }

    public final void setParent(@NotNull Composite composite) {
        Intrinsics.checkNotNullParameter((Object)composite, (String)"<set-?>");
        this.parent = composite;
    }

    @NotNull
    public final Element getXML(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.extractXML(root, this.allTags);
    }

    public final void setXML(@NotNull Element parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        String xmlString = this.xmlToString(parent, this.allTags);
        this.text.setText(xmlString);
        this.repaint();
    }

    public final void clear() {
        this.text.setText("");
        this.styles = new ArrayList();
        this.repaint();
    }

    private final String xmlToString(Element parent, List<? extends Tag> tags) {
        Element parent2 = parent;
        Element element = parent2.copy();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"copy(...)");
        parent2 = element;
        List brls = UTDHelper.getDescendantBrlFast((Node)((Node)parent2));
        for (Element brl : brls) {
            brl.detach();
        }
        NodeUtilsKt.detachAll((Iterable)TableUtils.INSTANCE.findTableBrls(parent2));
        return this.extractTextFromXML(parent2, tags, 0);
    }

    private final String extractTextFromXML(Element parent, List<? extends Tag> tags, int startOffset) {
        StringBuilder sb = new StringBuilder();
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node child = parent.getChild(i);
            if (child instanceof Text) {
                Comparable<StringBuilder> comparable;
                Tag relevantTag = null;
                for (Tag tag : tags) {
                    if (!tag.test(parent)) continue;
                    relevantTag = tag;
                    break;
                }
                if (relevantTag != null) {
                    int start = startOffset + sb.length();
                    sb.append(((Text)child).getValue());
                    int n2 = startOffset + sb.length();
                    comparable = this.styles.add(new Range(start, n2, relevantTag));
                    continue;
                }
                comparable = sb.append(((Text)child).getValue());
                continue;
            }
            if (MathModuleUtils.INSTANCE.isMathParent(child)) {
                Object element$iv22;
                List<Range> list;
                int n2;
                int n3;
                block7: {
                    int start = startOffset + sb.length();
                    sb.append(MathModuleUtils.getMathText(child));
                    int end = startOffset + sb.length();
                    Iterable iterable = tags;
                    n3 = end;
                    n2 = start;
                    list = this.styles;
                    boolean $i$f$first = false;
                    for (Object element$iv22 : iterable) {
                        Tag n4 = (Tag)element$iv22;
                        boolean bl = false;
                        if (!(n4 instanceof MathTag)) continue;
                        break block7;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv22;
                Tag tag = (Tag)t;
                int n5 = n3;
                int n6 = n2;
                list.add(new Range(n6, n5, tag));
                continue;
            }
            if (!(child instanceof Element)) continue;
            if (this.newLineWrap && BBX.BLOCK.isA(child) && ((CharSequence)sb).length() > 0) {
                sb.append(ConstantsKt.getLINE_BREAK());
                this.computeMargin((Element)child);
            }
            sb.append(this.extractTextFromXML((Element)child, tags, startOffset + sb.length()));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Element extractXML(Element root, List<? extends Tag> tags) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        int marginIndex = 0;
        Element parent = root;
        if (this.newLineWrap) {
            Element element = BBX.BLOCK.STYLE.create(this.newLineStyle);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            parent = element;
            if (this.hasCustomMargins()) {
                if (!Intrinsics.areEqual((Object)this.margins.get(marginIndex), (Object)DEFAULT_MARGIN)) {
                    BBXDynamicOptionStyleMap.Companion.setStyleOptionAttrib(parent, Style.StyleOption.FIRST_LINE_INDENT, this.margins.get(marginIndex).getFirstLineIndent());
                    BBXDynamicOptionStyleMap.Companion.setStyleOptionAttrib(parent, Style.StyleOption.INDENT, this.margins.get(marginIndex).getIndent());
                }
                ++marginIndex;
            }
        }
        String allText = this.text.getText();
        Intrinsics.checkNotNull((Object)allText);
        Object object = allText;
        Regex regex = new Regex(ConstantsKt.getLINE_BREAK());
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] lines = thisCollection$iv.toArray(new String[0]);
        int startOffset = 0;
        for (String line : lines) {
            List<Range> ranges = this.getRangesInRange(startOffset, startOffset + line.length());
            if (ranges.isEmpty()) {
                parent.appendChild(line);
            } else {
                int curOffset = startOffset;
                for (Range range : ranges) {
                    Tag tag;
                    log.error("range " + range);
                    if (range.getStart() > curOffset) {
                        String string = allText.substring(curOffset, range.getStart());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        parent.appendChild(string);
                    }
                    if ((tag = range.getTag()) instanceof EmphasisTag) {
                        newElement = BBX.INLINE.EMPHASIS.create(((EmphasisTag)tag).getTypes());
                        String string = allText.substring(range.getStart(), range.getEnd());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        newElement.appendChild(string);
                        parent.appendChild((Node)newElement);
                    } else if (tag instanceof StyleTag) {
                        String text;
                        newElement = BBX.BLOCK.STYLE.create(((StyleTag)tag).getStyle().getName());
                        Intrinsics.checkNotNullExpressionValue((Object)allText.substring(range.getStart(), range.getEnd()), (String)"substring(...)");
                        log.error("appending text '{}' {}", (Object)text, (Object)Character.getName(text.charAt(0)));
                        newElement.appendChild(text);
                        root.appendChild((Node)parent);
                        Intrinsics.checkNotNull((Object)newElement);
                        parent = newElement;
                    } else if (tag instanceof MathTag) {
                        String string = allText.substring(range.getStart(), range.getEnd());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        MathUtils.INSTANCE.wrapInMath(string, (ParentNode)parent, parent.getChildCount());
                        log.error("math in table {}", (Object)allText);
                    }
                    curOffset = range.getEnd();
                }
                if (curOffset < line.length() + startOffset) {
                    String string = allText.substring(curOffset, line.length() + startOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    parent.appendChild(string);
                }
            }
            startOffset += line.length() + ConstantsKt.getLINE_BREAK().length();
            if (!this.newLineWrap) continue;
            root.appendChild((Node)parent);
            Intrinsics.checkNotNullExpressionValue((Object)BBX.BLOCK.STYLE.create(this.newLineStyle), (String)"create(...)");
            if (!this.hasCustomMargins() || marginIndex >= this.margins.size()) continue;
            if (!Intrinsics.areEqual((Object)this.margins.get(marginIndex), (Object)DEFAULT_MARGIN)) {
                BBXDynamicOptionStyleMap.Companion.setStyleOptionAttrib(parent, Style.StyleOption.FIRST_LINE_INDENT, this.margins.get(marginIndex).getFirstLineIndent());
                BBXDynamicOptionStyleMap.Companion.setStyleOptionAttrib(parent, Style.StyleOption.INDENT, this.margins.get(marginIndex).getIndent());
            }
            ++marginIndex;
        }
        return root;
    }

    public final void setCustomMargins(boolean enabled) {
        this.buttonStyle ^= 0x800;
        if (!this.hasCustomMargins()) {
            if (this.curMarginPaintListener != null) {
                this.text.removeListener(9, this.curMarginPaintListener);
            }
            this.changeMarginLineIndent(false);
        } else {
            this.curMarginPaintListener = this.newMarginPaintListener();
            this.text.addListener(9, this.curMarginPaintListener);
            this.changeMarginLineIndent(true);
        }
        this.text.redraw();
    }

    private final void updateMargins(int keyCode) {
        if (this.hasCustomMargins()) {
            switch (keyCode) {
                case 13: 
                case 0x1000050: {
                    int curLine = this.text.getLineAtOffset(this.text.getCaretOffset());
                    this.margins.add(curLine, DEFAULT_MARGIN);
                    this.text.redraw();
                }
            }
        }
    }

    private final void computeMargin(Element element) {
        if (element.getAttribute(FIRST_LINE_INDENT_ATTRIB, "http://brailleblaster.org/ns/bb") != null && element.getAttribute(INDENT_ATTRIB, "http://brailleblaster.org/ns/bb") != null) {
            String string = element.getAttributeValue(FIRST_LINE_INDENT_ATTRIB, "http://brailleblaster.org/ns/bb");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            int n = Integer.parseInt(string);
            String string2 = element.getAttributeValue(INDENT_ATTRIB, "http://brailleblaster.org/ns/bb");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
            v3 = this.margins.add(new Margin(n, Integer.parseInt(string2)));
        } else {
            v3 = this.margins.add(Margin.copy$default(DEFAULT_MARGIN, 0, 0, 3, null));
        }
    }

    public final void removeAllEmphasis() {
        this.styles.clear();
        this.text.setStyleRange(null);
        this.repaint();
    }

    public final void toggleTag(@NotNull EmphasisTags tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.toggleTag(this.getEquivalent(tag));
    }

    public final void toggleTag(@Nullable MathTags tag) {
        this.toggleTag(this.getEquivalent(MathTags.MATH));
    }

    public final void toggleTag(@NotNull StyleTags tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.toggleTag(this.getEquivalent(tag));
    }

    public final void applyEmphasisToAll(@NotNull EmphasisTags tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.applyEmphasisToAll(this.getEquivalent(tag));
    }

    public final void applyEmphasisToAll(@NotNull MathTags tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.applyEmphasisToAll(this.getEquivalent(tag));
    }

    public final void applyMargin(int firstLineIndent, int indent) {
        if (!this.hasCustomMargins()) {
            return;
        }
        int curLine = this.text.getLineAtOffset(this.text.getCaretOffset());
        if (curLine > this.margins.size()) {
            log.error("curLine: " + curLine + " margin size: " + this.margins.size());
            return;
        }
        this.margins.remove(curLine);
        this.margins.add(curLine, new Margin(firstLineIndent, indent));
        this.text.redraw();
    }

    private final Tag getEquivalent(EmphasisTags tag) {
        return switch (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 1 -> BOLDTAG;
            case 2 -> BOLDITALICTAG;
            case 3 -> CTEXACTTAG;
            case 4 -> CTUNCONTRACTEDTAG;
            case 5 -> ITALICTAG;
            case 6 -> ITALICBOLDTAG;
            case 7 -> SCRIPTTAG;
            case 8 -> TE1;
            case 9 -> TE2;
            case 10 -> TE3;
            case 11 -> TE4;
            case 12 -> TE5;
            case 13 -> UNDERLINETAG;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Tag getEquivalent(MathTags tag) {
        if (WhenMappings.$EnumSwitchMapping$1[tag.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return MATHTAG;
    }

    private final Tag getEquivalent(StyleTags tag) {
        return switch (WhenMappings.$EnumSwitchMapping$2[tag.ordinal()]) {
            case 1 -> CENTEREDHEADING;
            case 2 -> TPAGEHEADING;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void toggleTag(Tag tag) {
        if (this.text.getSelectionCount() != 0) {
            int[] split = this.splitSelection(ConstantsKt.getLINE_BREAK());
            boolean cont = true;
            for (int i = 0; i < split.length; i += 2) {
                int start = split[i];
                int end = split[i + 1];
                if (this.verifyToggle(start, end, tag) && cont) {
                    int index = this.findIndex(start, end);
                    if (index == -1) {
                        this.styles.add(new Range(start, end, tag));
                        continue;
                    }
                    this.styles.add(index, new Range(start, end, tag));
                    continue;
                }
                cont = false;
            }
            this.repaint();
        }
        this.text.setSelection(this.text.getCaretOffset());
    }

    private final void applyEmphasisToAll(Tag tag) {
        String string = this.text.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        this.styles.clear();
        this.text.setStyleRange(null);
        this.text.setSelection(0, this.text.getText().length());
        this.toggleTag(tag);
    }

    private final void createButtons() {
        boolean includeHeading;
        boolean includeBold = (this.buttonStyle & 4) != 0;
        boolean includeItalic = (this.buttonStyle & 8) != 0;
        boolean includeCT = (this.buttonStyle & 0x80) != 0;
        boolean includeTE = (this.buttonStyle & 2) != 0;
        boolean includeScript = (this.buttonStyle & 0x10) != 0;
        boolean includeUnderline = (this.buttonStyle & 0x20) != 0;
        boolean bl = includeHeading = (this.buttonStyle & 0x40) != 0 || (this.buttonStyle & 0x100) != 0;
        if (includeBold || includeItalic || includeTE || includeScript || includeUnderline) {
            Combo styleCombo = new Combo(this.buttonPanel, 12);
            if (includeBold) {
                styleCombo.add("Bold");
                styleCombo.setData("Bold", (Object)BOLDTAG);
            }
            if (includeItalic) {
                styleCombo.add("Italic");
                styleCombo.setData("Italic", (Object)ITALICTAG);
            }
            if (includeBold && includeItalic) {
                styleCombo.add("Bold+Italic");
                styleCombo.setData("Bold+Italic", (Object)BOLDITALICTAG);
            }
            if (includeScript) {
                styleCombo.add("Script");
                styleCombo.setData("Script", (Object)SCRIPTTAG);
            }
            if (includeUnderline) {
                styleCombo.add("Underline");
                styleCombo.setData("Underline", (Object)UNDERLINETAG);
            }
            if (includeTE) {
                styleCombo.add("TE 1");
                styleCombo.setData("TE 1", (Object)TE1);
                styleCombo.add("TE 2");
                styleCombo.setData("TE 2", (Object)TE2);
                styleCombo.add("TE 3");
                styleCombo.setData("TE 3", (Object)TE3);
                styleCombo.add("TE 4");
                styleCombo.setData("TE 4", (Object)TE4);
                styleCombo.add("TE 5");
                styleCombo.setData("TE 5", (Object)TE5);
            }
            styleCombo.select(0);
            EasySWT.makePushButton((Composite)this.buttonPanel, (String)"Apply", (int)1, arg_0 -> BBStyleableText.createButtons$lambda$0(this, styleCombo, arg_0));
        }
        if (this.hasCustomMargins()) {
            EasySWT.makePushButton((Composite)this.buttonPanel, (String)((this.buttonStyle & 0x400) != 0 ? "Runover" : "Change Runover"), (int)1, arg_0 -> BBStyleableText.createButtons$lambda$1(this, arg_0));
        }
        if (includeCT) {
            EasySWT.makePushButton((Composite)this.buttonPanel, (String)((this.buttonStyle & 0x400) != 0 ? "Translation" : "Change Translation"), (int)1, arg_0 -> BBStyleableText.createButtons$lambda$2(this, arg_0));
        }
        if (includeHeading) {
            EasySWT.makePushButton((Composite)this.buttonPanel, (String)((this.buttonStyle & 0x400) != 0 ? "Heading" : "Create Heading"), (int)1, arg_0 -> BBStyleableText.createButtons$lambda$3(this, arg_0));
        }
    }

    private final void initTags() {
        this.allTags.add(BOLDTAG);
        this.allTags.add(ITALICTAG);
        this.allTags.add(0, BOLDITALICTAG);
        this.allTags.add(0, ITALICBOLDTAG);
        this.allTags.add(SCRIPTTAG);
        this.allTags.add(UNDERLINETAG);
        this.allTags.add(TE1);
        this.allTags.add(TE2);
        this.allTags.add(TE3);
        this.allTags.add(TE4);
        this.allTags.add(TE5);
        this.allTags.add(CTEXACTTAG);
        this.allTags.add(CTUNCONTRACTEDTAG);
        this.allTags.add(CENTEREDHEADING);
        this.allTags.add(TPAGEHEADING);
        this.allTags.add(MATHTAG);
    }

    private final void openChangeTranslationDialog() {
        Shell ctDialog = new Shell(this.parent.getShell(), 67680);
        ctDialog.setLayout((Layout)new RowLayout(512));
        Label newLabel = new Label((Composite)ctDialog, 0);
        newLabel.setText("Change translation to:");
        Combo dropDown = new Combo((Composite)ctDialog, 2052);
        dropDown.setData("0", (Object)CTUNCONTRACTEDTAG);
        dropDown.add("Uncontracted");
        dropDown.setData("1", (Object)CTEXACTTAG);
        dropDown.add("Direct");
        dropDown.setData("2", (Object)MATHTAG);
        dropDown.add("Math");
        dropDown.select(0);
        Button okButton = new Button((Composite)ctDialog, 8);
        okButton.setText("Ok");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, dropDown, ctDialog){
            final /* synthetic */ BBStyleableText this$0;
            final /* synthetic */ Combo $dropDown;
            final /* synthetic */ Shell $ctDialog;
            {
                this.this$0 = $receiver;
                this.$dropDown = $dropDown;
                this.$ctDialog = $ctDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = this.$dropDown.getData(String.valueOf(this.$dropDown.getSelectionIndex()));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.ui.BBStyleableText.Tag");
                BBStyleableText.access$toggleTag(this.this$0, (Tag)object);
                this.$ctDialog.close();
            }
        });
        ctDialog.pack(true);
        ctDialog.open();
    }

    private final void openCreateHeadingDialog() {
        Shell headingDialog = new Shell(this.parent.getShell(), 67680);
        headingDialog.setLayout((Layout)new RowLayout(512));
        Label newLabel = new Label((Composite)headingDialog, 0);
        newLabel.setText("Heading type:");
        Combo dropDown = new Combo((Composite)headingDialog, 2052);
        if ((this.buttonStyle & 0x40) != 0) {
            dropDown.setData("0", (Object)CENTEREDHEADING);
            dropDown.add("Centered");
        } else if ((this.buttonStyle & 0x100) != 0) {
            dropDown.setData("0", (Object)TPAGEHEADING);
            dropDown.add("Centered (TPage)");
        }
        dropDown.select(0);
        Button okButton = new Button((Composite)headingDialog, 8);
        okButton.setText("Ok");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, dropDown, headingDialog){
            final /* synthetic */ BBStyleableText this$0;
            final /* synthetic */ Combo $dropDown;
            final /* synthetic */ Shell $headingDialog;
            {
                this.this$0 = $receiver;
                this.$dropDown = $dropDown;
                this.$headingDialog = $headingDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = this.$dropDown.getData(String.valueOf(this.$dropDown.getSelectionIndex()));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.ui.BBStyleableText.Tag");
                BBStyleableText.access$toggleTag(this.this$0, (Tag)object);
                this.$headingDialog.close();
            }
        });
        headingDialog.pack(true);
        headingDialog.open();
    }

    private final void openChangeMarginDialog() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    private final int[] splitSelection(String match) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String selection = this.text.getSelectionText();
        Intrinsics.checkNotNull((Object)selection);
        if (!StringsKt.contains$default((CharSequence)selection, (CharSequence)match, (boolean)false, (int)2, null)) {
            int[] nArray = new int[]{this.text.getSelection().x, this.text.getSelection().y};
            return nArray;
        }
        int curOffset = this.text.getSelection().x;
        Object object = selection;
        Regex regex = new Regex(match);
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        int[] returnInts = new int[split.length * 2];
        int n2 = split.length;
        for (int i = 0; i < n2; ++i) {
            returnInts[i * 2] = curOffset;
            returnInts[i * 2 + 1] = curOffset += split[i].length();
            curOffset += match.length();
        }
        return returnInts;
    }

    private final int findIndex(int start, int end) {
        if (this.styles.isEmpty()) {
            return 0;
        }
        if (this.styles.size() == 1) {
            return start < this.styles.get(0).getStart() ? 0 : 1;
        }
        Iterator iterator = ((Iterable)this.styles).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Range curRange = (Range)iterator.next();
            if (i != 0) {
                Range prevRange = this.styles.get(i - 1);
                if (start < prevRange.getEnd() || end > curRange.getStart()) continue;
                return i;
            }
            if (end > curRange.getStart()) continue;
            return 0;
        }
        return -1;
    }

    private final List<Range> getRangesInRange(int start, int end) {
        List returnList = new ArrayList();
        for (Range point : this.styles) {
            if (start > point.getStart() && start < point.getEnd()) {
                returnList.add(point);
                if (end >= point.getEnd()) continue;
                return returnList;
            }
            if (end > point.getStart() && end < point.getEnd()) {
                returnList.add(point);
                return returnList;
            }
            if (point.getStart() < start || point.getEnd() > end) continue;
            returnList.add(point);
        }
        return returnList;
    }

    private final boolean verifyToggle(int start, int end, Tag tag) {
        boolean returnBool = true;
        List<Range> points = this.getRangesInRange(start, end);
        for (Range point : points) {
            Range replace1 = null;
            Range replace2 = null;
            if (start > point.getStart()) {
                replace1 = new Range(point.getStart(), start, point.getTag());
            }
            if (end < point.getEnd()) {
                replace2 = new Range(end, point.getEnd(), point.getTag());
            }
            Tag tag2 = point.getTag();
            Intrinsics.checkNotNull((Object)tag2);
            if (tag2.getTextStyle() == tag.getTextStyle()) {
                returnBool = false;
            }
            int index = this.styles.indexOf(point);
            this.styles.remove(index);
            if (replace1 != null) {
                this.styles.add(index, replace1);
                ++index;
            }
            if (replace2 == null) continue;
            this.styles.add(index, replace2);
        }
        return returnBool;
    }

    private final void updateRanges() {
        StyleRange[] styleRanges = this.text.getStyleRanges();
        this.styles = new ArrayList();
        Intrinsics.checkNotNull((Object)styleRanges);
        for (StyleRange sr : styleRanges) {
            if (sr.background != null) {
                Color color = sr.background;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                if (ColorManager.INSTANCE.equals(color, ColorManager.Colors.BLACK)) continue;
            }
            Intrinsics.checkNotNull((Object)sr);
            Tag tagFromStyle = this.getTagFromStyle(sr);
            this.styles.add(new Range(sr.start, sr.start + sr.length, tagFromStyle));
        }
    }

    private final Tag getTagFromStyle(StyleRange sr) {
        Tag curTag = null;
        Iterator<Tag> iterator = this.allTags.iterator();
        block18: while (iterator.hasNext()) {
            Tag allTag;
            curTag = allTag = iterator.next();
            TextStyle textStyle = curTag.getTextStyle();
            switch (textStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$3[textStyle.ordinal()]) {
                case 1: {
                    if (sr.fontStyle != 1) continue block18;
                    return curTag;
                }
                case 2: {
                    if (sr.fontStyle != 2) continue block18;
                    return curTag;
                }
                case 3: {
                    if (sr.fontStyle != 3) continue block18;
                    return curTag;
                }
                case 4: {
                    if (!sr.underline) continue block18;
                    return curTag;
                }
                case 5: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.LAVENDER)) continue block18;
                    return curTag;
                }
                case 6: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.SEAGLASS)) continue block18;
                    return curTag;
                }
                case 7: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.BLUSH)) continue block18;
                    return curTag;
                }
                case 8: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.BLUE)) continue block18;
                    return curTag;
                }
                case 9: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.BROWN)) continue block18;
                    return curTag;
                }
                case 10: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.GREEN)) continue block18;
                    return curTag;
                }
                case 11: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.KHAKI)) continue block18;
                    return curTag;
                }
                case 12: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.ORANGE)) continue block18;
                    return curTag;
                }
                case 13: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.PURPLE)) continue block18;
                    return curTag;
                }
                case 14: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.LIGHT_PURPLE)) continue block18;
                    return curTag;
                }
                case 15: {
                    if (sr.background == null) continue block18;
                    Color color = sr.background;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
                    if (!ColorManager.INSTANCE.equals(color, ColorManager.Colors.YELLOW)) continue block18;
                    return curTag;
                }
                case 16: {
                    if (sr.font == null || !(sr.font.getFontData()[0].height > (float)this.fontSize)) continue block18;
                    return curTag;
                }
            }
            return null;
        }
        return curTag;
    }

    private final void repaint() {
        block10: {
            block9: {
                this.text.setStyleRange(null);
                for (StyleRange styleRange : TextRenderer.Companion.setNonBreakingSpaceEmphasis(this.text, 0, this.text.getCharCount())) {
                    this.text.setStyleRange(styleRange);
                }
                if (this.styles.isEmpty()) break block9;
                String string = this.text.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!(((CharSequence)string).length() == 0)) break block10;
            }
            return;
        }
        StyleRange[] ranges = new StyleRange[this.styles.size()];
        int n = ((Collection)this.styles).size();
        for (int i = 0; i < n; ++i) {
            StyleRange styleRange;
            Range range = this.styles.get(i);
            int n2 = range.getStart();
            int n3 = range.getLength();
            Tag tag = range.getTag();
            Intrinsics.checkNotNull((Object)tag);
            ranges[i] = styleRange = this.getSRForTextStyle(n2, n3, tag.getTextStyle());
        }
        try {
            this.text.setStyleRanges(ranges);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (logger.isErrorEnabled()) {
                logger.error("Invalid StyleRange for BBMarkdownText. Style ranges:");
                int n4 = ranges.length;
                for (n = 0; n < n4; ++n) {
                    StyleRange range;
                    StyleRange styleRange = range = ranges[n];
                    Intrinsics.checkNotNull((Object)styleRange);
                    logger.error("Start: {} Length: {}", (Object)styleRange.start, (Object)range.length);
                }
                logger.error("Text content: {}", (Object)this.text.getText());
            }
            Notify.showMessage("An error occurred while opening the table.", new Object[0]);
        }
    }

    private final boolean hasCustomMargins() {
        return (this.buttonStyle & 0x800) != 0;
    }

    private final void checkParams(Composite parent, Composite buttonPanel, int buttons) {
        if (parent == null) {
            boolean $i$a$-requireNotNull-BBStyleableText$checkParams$22 = false;
            String $i$a$-requireNotNull-BBStyleableText$checkParams$22 = "Parent cannot be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-BBStyleableText$checkParams$22.toString());
        }
        if (buttonPanel == null) {
            StringBuilder errorType = new StringBuilder();
            if ((buttons & 4) != 0) {
                errorType.append("BOLD,");
            }
            if ((buttons & 8) != 0) {
                errorType.append("ITALIC,");
            }
            if ((buttons & 0x10) != 0) {
                errorType.append("SCRIPT,");
            }
            if ((buttons & 0x20) != 0) {
                errorType.append("UNDERLINE,");
            }
            if ((buttons & 0x40) != 0) {
                errorType.append("CREATEHEADING,");
            }
            if ((buttons & 0x80) != 0) {
                errorType.append("CHANGETRANSLATION,");
            }
            if (((CharSequence)errorType).length() > 0) {
                errorType.deleteCharAt(errorType.length() - 1);
                throw new IllegalArgumentException("ButtonPanel cannot be null with buttons: " + errorType);
            }
        }
    }

    private final StyleRange getSRForTextStyle(int start, int length, TextStyle style) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        TextStyle textStyle = style;
        switch (textStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$3[textStyle.ordinal()]) {
            case 1: {
                styleRange.fontStyle = 1;
                break;
            }
            case 2: {
                styleRange.fontStyle = 2;
                break;
            }
            case 3: {
                styleRange.fontStyle = 3;
                break;
            }
            case 4: {
                styleRange.underline = true;
                break;
            }
            case 5: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.LAVENDER, (Control)this.text);
                break;
            }
            case 6: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.SEAGLASS, (Control)this.text);
                break;
            }
            case 7: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.BLUSH, (Control)this.text);
                break;
            }
            case 8: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.BLUE, (Control)this.text);
                break;
            }
            case 9: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.BROWN, (Control)this.text);
                break;
            }
            case 10: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.GREEN, (Control)this.text);
                break;
            }
            case 11: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.KHAKI, (Control)this.text);
                break;
            }
            case 12: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.ORANGE, (Control)this.text);
                break;
            }
            case 13: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.PURPLE, (Control)this.text);
                break;
            }
            case 14: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.LIGHT_PURPLE, (Control)this.text);
                break;
            }
            case 15: {
                styleRange.background = ColorManager.INSTANCE.getColor(ColorManager.Colors.YELLOW, (Control)this.text);
                break;
            }
            case 16: {
                Font newFont;
                FontData font = this.text.getFont().getFontData()[0];
                font.setHeight(this.fontSize + 5);
                styleRange.font = newFont = new Font((Device)this.display, font);
                this.disposeables.add((Resource)newFont);
            }
        }
        return styleRange;
    }

    public final void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        FontData data = this.text.getFont().getFontData()[0];
        data.setHeight(fontSize);
        Font newFont = new Font((Device)this.display, data);
        this.text.setFont(newFont);
        this.disposeables.add((Resource)newFont);
    }

    public final void setNewLineWrapStyle(@NotNull String newStyleName) {
        Intrinsics.checkNotNullParameter((Object)newStyleName, (String)"newStyleName");
        this.newLineStyle = newStyleName;
    }

    private final void disableTab(StyledText text) {
        text.addTraverseListener(BBStyleableText::disableTab$lambda$0);
    }

    public final void dispose() {
        this.text.dispose();
        if (this.buttonPanel != null) {
            Composite composite = this.buttonPanel;
            Intrinsics.checkNotNull((Object)composite);
            Control[] controlArray = composite.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)controlArray, (String)"getChildren(...)");
            for (Control control : controlArray) {
                control.dispose();
            }
        }
    }

    private final DisposeListener disposeListener() {
        return arg_0 -> BBStyleableText.disposeListener$lambda$0(this, arg_0);
    }

    private final void changeMarginLineIndent(boolean indented) {
        if (indented) {
            this.text.setIndent(EasySWT.getWidthOfText((String)"[1-3] "));
        } else {
            this.text.setIndent(0);
        }
    }

    private final Listener newMarginPaintListener() {
        return arg_0 -> BBStyleableText.newMarginPaintListener$lambda$0(this, arg_0);
    }

    private static final void _init_$lambda$0(BBStyleableText this$0, ExtendedModifyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.replacedText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replacedText");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)ConstantsKt.getLINE_BREAK(), (boolean)false, (int)2, null)) {
            int startLine = this$0.text.getLineAtOffset(event.start) + 1;
            int index = 0;
            while (true) {
                String string2 = event.replacedText;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replacedText");
                if (StringsKt.indexOf$default((CharSequence)string2, (String)ConstantsKt.getLINE_BREAK(), (int)index, (boolean)false, (int)4, null) == -1) break;
                if (startLine >= ((ArrayList)this$0.margins).size()) {
                    log.error("Tried to delete a margin that did not exist. StartLine: " + startLine + " margins size:" + ((ArrayList)this$0.margins).size());
                    break;
                }
                ((ArrayList)this$0.margins).remove(startLine);
                String string3 = event.replacedText;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"replacedText");
                index = StringsKt.indexOf$default((CharSequence)string3, (String)ConstantsKt.getLINE_BREAK(), (int)index, (boolean)false, (int)4, null) + 1;
            }
        }
    }

    private static final void createButtons$lambda$0(BBStyleableText this$0, Combo $styleCombo, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = $styleCombo.getData($styleCombo.getItem($styleCombo.getSelectionIndex()));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.perspectives.braille.ui.BBStyleableText.Tag");
        this$0.toggleTag((Tag)object);
    }

    private static final void createButtons$lambda$1(BBStyleableText this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.openChangeMarginDialog();
    }

    private static final void createButtons$lambda$2(BBStyleableText this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.openChangeTranslationDialog();
    }

    private static final void createButtons$lambda$3(BBStyleableText this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.openCreateHeadingDialog();
    }

    private static final void disableTab$lambda$0(TraverseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }

    private static final void disposeListener$lambda$0$0(Resource obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.dispose();
    }

    private static final void disposeListener$lambda$0(BBStyleableText this$0, DisposeEvent it) {
        this$0.disposeables.forEach(BBStyleableText::disposeListener$lambda$0$0);
    }

    private static final void newMarginPaintListener$lambda$0(BBStyleableText this$0, Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (int curLine = 0; curLine < this$0.text.getLineCount() && curLine < this$0.margins.size(); ++curLine) {
            int x = this$0.text.getBounds().x - 7;
            int y = this$0.text.getLinePixel(curLine);
            event.gc.drawText(this$0.margins.get(curLine).getDisplayName(), x, y);
        }
    }

    public static final /* synthetic */ void access$toggleTag(BBStyleableText $this, Tag tag) {
        $this.toggleTag(tag);
    }

    static {
        Logger logger = LoggerFactory.getLogger(BBStyleableText.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        BBStyleableText.logger = logger;
        BOLDTAG = new EmphasisTag(EmphasisType.BOLD, TextStyle.BOLD);
        ITALICTAG = new EmphasisTag(EmphasisType.ITALICS, TextStyle.ITALIC);
        SCRIPTTAG = new EmphasisTag(EmphasisType.SCRIPT, TextStyle.COLOR_KHAKI);
        UNDERLINETAG = new EmphasisTag(EmphasisType.UNDERLINE, TextStyle.UNDERLINE);
        CTEXACTTAG = new EmphasisTag(EmphasisType.NO_TRANSLATE, TextStyle.COLOR_LAVENDER);
        CTUNCONTRACTEDTAG = new EmphasisTag(EmphasisType.NO_CONTRACT, TextStyle.COLOR_SEAGLASS);
        MATHTAG = new MathTag(TextStyle.COLOR_LIGHT_PURPLE);
        TE1 = new EmphasisTag(EmphasisType.TRANS_1, TextStyle.COLOR_YELLOW);
        TE2 = new EmphasisTag(EmphasisType.TRANS_2, TextStyle.COLOR_ORANGE);
        TE3 = new EmphasisTag(EmphasisType.TRANS_3, TextStyle.COLOR_GREEN);
        TE4 = new EmphasisTag(EmphasisType.TRANS_4, TextStyle.COLOR_BLUE);
        TE5 = new EmphasisTag(EmphasisType.TRANS_5, TextStyle.COLOR_LIGHT_PURPLE);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)EmphasisType.BOLD, (Enum)EmphasisType.ITALICS);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        BOLDITALICTAG = new EmphasisTag(enumSet, TextStyle.BOLDANDITALIC);
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)EmphasisType.BOLD, (Enum)EmphasisType.ITALICS);
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
        ITALICBOLDTAG = new EmphasisTag(enumSet2, TextStyle.BOLDANDITALIC);
        Style style = WPManager.Companion.getInstance().getList().get(0).getDocument().getEngine().getStyleDefinitions().getStyleByName("Centered Heading");
        Intrinsics.checkNotNull((Object)style);
        CENTEREDHEADING = new StyleTag((IStyle)style, TextStyle.LARGE_FONT);
        Style style2 = WPManager.Companion.getInstance().getList().get(0).getDocument().getEngine().getStyleDefinitions().getStyleByName("TPage Heading");
        Intrinsics.checkNotNull((Object)style2);
        TPAGEHEADING = new StyleTag((IStyle)style2, TextStyle.LARGE_FONT);
        INDENT_ATTRIB = DynamicOptionStyleMap.Companion.styleOptionName("overrideOption-", Style.StyleOption.INDENT);
        DEFAULT_MARGIN = new Margin(0, 2);
        FIRST_LINE_INDENT_ATTRIB = DynamicOptionStyleMap.Companion.styleOptionName("overrideOption-", Style.StyleOption.FIRST_LINE_INDENT);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TRANSCRIBEREMPHASIS", "", "BOLD", "ITALIC", "SCRIPT", "UNDERLINE", "CREATEHEADING", "CHANGETRANSLATION", "CREATETPAGEHEADING", "SMALL_BUTTONS", "CUSTOM_MARGINS", "NONEWLINES", "logger", "getLogger", "()Lorg/slf4j/Logger;", "createDefaultText", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText;", "parent", "Lorg/eclipse/swt/widgets/Composite;", "buttonPanel", "BOLDTAG", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "ITALICTAG", "SCRIPTTAG", "UNDERLINETAG", "CTEXACTTAG", "CTUNCONTRACTEDTAG", "MATHTAG", "TE1", "TE2", "TE3", "TE4", "TE5", "BOLDITALICTAG", "ITALICBOLDTAG", "CENTEREDHEADING", "TPAGEHEADING", "DEFAULT_FONT_SIZE", "INDENT_ATTRIB", "", "DEFAULT_MARGIN", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Margin;", "FIRST_LINE_INDENT_ATTRIB", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final BBStyleableText createDefaultText(@NotNull Composite parent, @Nullable Composite buttonPanel) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return new BBStyleableText(parent, buttonPanel, 33982, 2624);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$EmphasisTag;", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "types", "Ljava/util/EnumSet;", "Lorg/brailleblaster/utd/properties/EmphasisType;", "textStyle", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "<init>", "(Ljava/util/EnumSet;Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;)V", "type", "(Lorg/brailleblaster/utd/properties/EmphasisType;Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;)V", "getTypes", "()Ljava/util/EnumSet;", "setTypes", "(Ljava/util/EnumSet;)V", "test", "", "e", "Lnu/xom/Element;", "brailleblaster-core"})
    private static final class EmphasisTag
    extends Tag {
        @NotNull
        private EnumSet<EmphasisType> types;

        public EmphasisTag(@NotNull EnumSet<EmphasisType> types, @Nullable TextStyle textStyle) {
            Intrinsics.checkNotNullParameter(types, (String)"types");
            this.types = types;
            this.setTextStyle(textStyle);
        }

        @NotNull
        public final EnumSet<EmphasisType> getTypes() {
            return this.types;
        }

        public final void setTypes(@NotNull EnumSet<EmphasisType> enumSet) {
            Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
            this.types = enumSet;
        }

        public EmphasisTag(@NotNull EmphasisType type, @Nullable TextStyle textStyle) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)type);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            this(enumSet, textStyle);
        }

        @Override
        public boolean test(@NotNull Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.INLINE.EMPHASIS.isA((Node)e) && Intrinsics.areEqual(BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get(e), this.types);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$EmphasisTags;", "", "tagName", "", "defaultAccelerator", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;I)V", "getTagName", "()Ljava/lang/String;", "getDefaultAccelerator", "()I", "BOLD", "ITALIC", "BOLDITALIC", "ITALICBOLD", "SCRIPT", "UNDERLINE", "TE1", "TE2", "TE3", "TE4", "TE5", "CTEXACT", "CTUNCONTRACTED", "brailleblaster-core"})
    public static final class EmphasisTags
    extends Enum<EmphasisTags> {
        @NotNull
        private final String tagName;
        private final int defaultAccelerator;
        public static final /* enum */ EmphasisTags BOLD = new EmphasisTags("Bold", SWT.MOD1 | 0x42);
        public static final /* enum */ EmphasisTags ITALIC = new EmphasisTags("Italic", SWT.MOD1 | 0x49);
        public static final /* enum */ EmphasisTags BOLDITALIC = new EmphasisTags("Bold + Italic", SWT.MOD1 | SWT.MOD2 | 0x42);
        public static final /* enum */ EmphasisTags ITALICBOLD = new EmphasisTags("Italic + Bold", SWT.MOD1 | SWT.MOD2 | 0x42);
        public static final /* enum */ EmphasisTags SCRIPT = new EmphasisTags("Script", SWT.MOD1 | 0x53);
        public static final /* enum */ EmphasisTags UNDERLINE = new EmphasisTags("Underline", SWT.MOD1 | 0x55);
        public static final /* enum */ EmphasisTags TE1 = new EmphasisTags("Transcriber Emphasis 1", SWT.MOD1 | 0x31);
        public static final /* enum */ EmphasisTags TE2 = new EmphasisTags("Transcriber Emphasis 2", SWT.MOD1 | 0x32);
        public static final /* enum */ EmphasisTags TE3 = new EmphasisTags("Transcriber Emphasis 3", SWT.MOD1 | 0x33);
        public static final /* enum */ EmphasisTags TE4 = new EmphasisTags("Transcriber Emphasis 4", SWT.MOD1 | 0x34);
        public static final /* enum */ EmphasisTags TE5 = new EmphasisTags("Transcriber Emphasis 5", SWT.MOD1 | 0x35);
        public static final /* enum */ EmphasisTags CTEXACT = new EmphasisTags("Direct Translation", ChangeTranslationModule.DIRECT_HOTKEY);
        public static final /* enum */ EmphasisTags CTUNCONTRACTED = new EmphasisTags("Uncontracted Translation", ChangeTranslationModule.UNCONTRACTED_HOTKEY);
        private static final /* synthetic */ EmphasisTags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EmphasisTags(String tagName, int defaultAccelerator) {
            this.tagName = tagName;
            this.defaultAccelerator = defaultAccelerator;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public final int getDefaultAccelerator() {
            return this.defaultAccelerator;
        }

        public static EmphasisTags[] values() {
            return (EmphasisTags[])$VALUES.clone();
        }

        public static EmphasisTags valueOf(String value) {
            return Enum.valueOf(EmphasisTags.class, value);
        }

        @NotNull
        public static EnumEntries<EmphasisTags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = emphasisTagsArray = new EmphasisTags[]{EmphasisTags.BOLD, EmphasisTags.ITALIC, EmphasisTags.BOLDITALIC, EmphasisTags.ITALICBOLD, EmphasisTags.SCRIPT, EmphasisTags.UNDERLINE, EmphasisTags.TE1, EmphasisTags.TE2, EmphasisTags.TE3, EmphasisTags.TE4, EmphasisTags.TE5, EmphasisTags.CTEXACT, EmphasisTags.CTUNCONTRACTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u000eH\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Margin;", "", "firstLineIndent", "", "indent", "<init>", "(II)V", "getFirstLineIndent", "()I", "setFirstLineIndent", "(I)V", "getIndent", "setIndent", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "brailleblaster-core"})
    private static final class Margin {
        private int firstLineIndent;
        private int indent;

        public Margin(int firstLineIndent, int indent) {
            this.firstLineIndent = firstLineIndent;
            this.indent = indent;
        }

        public final int getFirstLineIndent() {
            return this.firstLineIndent;
        }

        public final void setFirstLineIndent(int n) {
            this.firstLineIndent = n;
        }

        public final int getIndent() {
            return this.indent;
        }

        public final void setIndent(int n) {
            this.indent = n;
        }

        @NotNull
        public final String getDisplayName() {
            return "[" + (this.firstLineIndent + 1) + "-" + (this.indent + 1) + "]";
        }

        public final int component1() {
            return this.firstLineIndent;
        }

        public final int component2() {
            return this.indent;
        }

        @NotNull
        public final Margin copy(int firstLineIndent, int indent) {
            return new Margin(firstLineIndent, indent);
        }

        public static /* synthetic */ Margin copy$default(Margin margin, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = margin.firstLineIndent;
            }
            if ((n3 & 2) != 0) {
                n2 = margin.indent;
            }
            return margin.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Margin(firstLineIndent=" + this.firstLineIndent + ", indent=" + this.indent + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.firstLineIndent);
            result = result * 31 + Integer.hashCode(this.indent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Margin)) {
                return false;
            }
            Margin margin = (Margin)other;
            if (this.firstLineIndent != margin.firstLineIndent) {
                return false;
            }
            return this.indent == margin.indent;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u00020\u000bH\u0096\u0080\u0004\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$MathTag;", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "textStyle", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "<init>", "(Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;)V", "test", "", "e", "Lnu/xom/Element;", "toString", "", "brailleblaster-core"})
    private static final class MathTag
    extends Tag {
        public MathTag(@Nullable TextStyle textStyle) {
            this.setTextStyle(textStyle);
        }

        @Override
        public boolean test(@NotNull Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return BBX.INLINE.MATHML.isA((Node)e);
        }

        @Override
        @NotNull
        public String toString() {
            return "MathTag{super=" + super.toString() + "}";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$MathTags;", "", "tagName", "", "acc", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;I)V", "getTagName", "()Ljava/lang/String;", "getAcc", "()I", "MATH", "brailleblaster-core"})
    public static final class MathTags
    extends Enum<MathTags> {
        @NotNull
        private final String tagName;
        private final int acc;
        public static final /* enum */ MathTags MATH = new MathTags("Math", 0);
        private static final /* synthetic */ MathTags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MathTags(String tagName, int acc) {
            this.tagName = tagName;
            this.acc = acc;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public final int getAcc() {
            return this.acc;
        }

        public static MathTags[] values() {
            return (MathTags[])$VALUES.clone();
        }

        public static MathTags valueOf(String value) {
            return Enum.valueOf(MathTags.class, value);
        }

        @NotNull
        public static EnumEntries<MathTags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mathTagsArray = new MathTags[]{MathTags.MATH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Range;", "", "start", "", "end", "tag", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "<init>", "(IILorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;)V", "getStart", "()I", "setStart", "(I)V", "getEnd", "setEnd", "getTag", "()Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "setTag", "(Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;)V", "length", "getLength", "toString", "", "brailleblaster-core"})
    private static final class Range {
        private int start;
        private int end;
        @Nullable
        private Tag tag;

        public Range(int start, int end, @Nullable Tag tag) {
            this.start = start;
            this.end = end;
            this.tag = tag;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        @Nullable
        public final Tag getTag() {
            return this.tag;
        }

        public final void setTag(@Nullable Tag tag) {
            this.tag = tag;
        }

        public final int getLength() {
            return this.end - this.start;
        }

        @NotNull
        public String toString() {
            return "Range{start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + "}";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$StyleTag;", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "style", "Lorg/brailleblaster/utd/IStyle;", "textStyle", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "<init>", "(Lorg/brailleblaster/utd/IStyle;Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;)V", "getStyle", "()Lorg/brailleblaster/utd/IStyle;", "setStyle", "(Lorg/brailleblaster/utd/IStyle;)V", "test", "", "e", "Lnu/xom/Element;", "toString", "", "brailleblaster-core"})
    private static final class StyleTag
    extends Tag {
        @NotNull
        private IStyle style;

        public StyleTag(@NotNull IStyle style, @Nullable TextStyle textStyle) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.style = style;
            this.setTextStyle(textStyle);
        }

        @NotNull
        public final IStyle getStyle() {
            return this.style;
        }

        public final void setStyle(@NotNull IStyle iStyle) {
            Intrinsics.checkNotNullParameter((Object)iStyle, (String)"<set-?>");
            this.style = iStyle;
        }

        @Override
        public boolean test(@NotNull Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!BBX.BLOCK.STYLE.isA((Node)e)) {
                return false;
            }
            IStyle elemStyle = (IStyle)WPManager.Companion.getInstance().getController().getDocument().getEngine().getStyleMap().findValueOrDefault((Node)e);
            return elemStyle.getName() != null && Intrinsics.areEqual((Object)elemStyle.getName(), (Object)this.style.getName());
        }

        @Override
        @NotNull
        public String toString() {
            return "StyleTag{style=" + this.style.getName() + ", super=" + super.toString() + "}";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$StyleTags;", "", "<init>", "(Ljava/lang/String;I)V", "CENTERED_HEADING", "TPAGE_HEADING", "brailleblaster-core"})
    public static final class StyleTags
    extends Enum<StyleTags> {
        public static final /* enum */ StyleTags CENTERED_HEADING = new StyleTags();
        public static final /* enum */ StyleTags TPAGE_HEADING = new StyleTags();
        private static final /* synthetic */ StyleTags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StyleTags[] values() {
            return (StyleTags[])$VALUES.clone();
        }

        public static StyleTags valueOf(String value) {
            return Enum.valueOf(StyleTags.class, value);
        }

        @NotNull
        public static EnumEntries<StyleTags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = styleTagsArray = new StyleTags[]{StyleTags.CENTERED_HEADING, StyleTags.TPAGE_HEADING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$Tag;", "", "<init>", "()V", "textStyle", "Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "getTextStyle", "()Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "setTextStyle", "(Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;)V", "test", "", "e", "Lnu/xom/Element;", "toString", "", "brailleblaster-core"})
    public static abstract class Tag {
        @Nullable
        private TextStyle textStyle;

        @Nullable
        public final TextStyle getTextStyle() {
            return this.textStyle;
        }

        public final void setTextStyle(@Nullable TextStyle textStyle) {
            this.textStyle = textStyle;
        }

        public abstract boolean test(@NotNull Element var1);

        @NotNull
        public String toString() {
            return "Tag{textStyle=" + this.textStyle + "}";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/BBStyleableText$TextStyle;", "", "<init>", "(Ljava/lang/String;I)V", "BOLD", "ITALIC", "BOLDANDITALIC", "UNDERLINE", "COLOR_YELLOW", "COLOR_ORANGE", "COLOR_GREEN", "COLOR_BLUE", "COLOR_PURPLE", "COLOR_LIGHT_PURPLE", "COLOR_BROWN", "COLOR_KHAKI", "LARGE_FONT", "COLOR_LAVENDER", "COLOR_BLUSH", "COLOR_SEAGLASS", "brailleblaster-core"})
    public static final class TextStyle
    extends Enum<TextStyle> {
        public static final /* enum */ TextStyle BOLD = new TextStyle();
        public static final /* enum */ TextStyle ITALIC = new TextStyle();
        public static final /* enum */ TextStyle BOLDANDITALIC = new TextStyle();
        public static final /* enum */ TextStyle UNDERLINE = new TextStyle();
        public static final /* enum */ TextStyle COLOR_YELLOW = new TextStyle();
        public static final /* enum */ TextStyle COLOR_ORANGE = new TextStyle();
        public static final /* enum */ TextStyle COLOR_GREEN = new TextStyle();
        public static final /* enum */ TextStyle COLOR_BLUE = new TextStyle();
        public static final /* enum */ TextStyle COLOR_PURPLE = new TextStyle();
        public static final /* enum */ TextStyle COLOR_LIGHT_PURPLE = new TextStyle();
        public static final /* enum */ TextStyle COLOR_BROWN = new TextStyle();
        public static final /* enum */ TextStyle COLOR_KHAKI = new TextStyle();
        public static final /* enum */ TextStyle LARGE_FONT = new TextStyle();
        public static final /* enum */ TextStyle COLOR_LAVENDER = new TextStyle();
        public static final /* enum */ TextStyle COLOR_BLUSH = new TextStyle();
        public static final /* enum */ TextStyle COLOR_SEAGLASS = new TextStyle();
        private static final /* synthetic */ TextStyle[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TextStyle[] values() {
            return (TextStyle[])$VALUES.clone();
        }

        public static TextStyle valueOf(String value) {
            return Enum.valueOf(TextStyle.class, value);
        }

        @NotNull
        public static EnumEntries<TextStyle> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = textStyleArray = new TextStyle[]{TextStyle.BOLD, TextStyle.ITALIC, TextStyle.BOLDANDITALIC, TextStyle.UNDERLINE, TextStyle.COLOR_YELLOW, TextStyle.COLOR_ORANGE, TextStyle.COLOR_GREEN, TextStyle.COLOR_BLUE, TextStyle.COLOR_PURPLE, TextStyle.COLOR_LIGHT_PURPLE, TextStyle.COLOR_BROWN, TextStyle.COLOR_KHAKI, TextStyle.LARGE_FONT, TextStyle.COLOR_LAVENDER, TextStyle.COLOR_BLUSH, TextStyle.COLOR_SEAGLASS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[EmphasisTags.values().length];
            try {
                nArray[EmphasisTags.BOLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.BOLDITALIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.CTEXACT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.CTUNCONTRACTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.ITALIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.ITALICBOLD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.SCRIPT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.TE1.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.TE2.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.TE3.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.TE4.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.TE5.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EmphasisTags.UNDERLINE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MathTags.values().length];
            try {
                nArray[MathTags.MATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[StyleTags.values().length];
            try {
                nArray[StyleTags.CENTERED_HEADING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StyleTags.TPAGE_HEADING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[TextStyle.values().length];
            try {
                nArray[TextStyle.BOLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.ITALIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.BOLDANDITALIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.UNDERLINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_LAVENDER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_SEAGLASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_BLUSH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_BLUE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_BROWN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_GREEN.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_KHAKI.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_ORANGE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_PURPLE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_LIGHT_PURPLE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.COLOR_YELLOW.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextStyle.LARGE_FONT.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

