/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.messages.TabInsertionMessage;
import org.brailleblaster.perspectives.braille.searcher.Searcher;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.braille.views.wp.ViewStateObject;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u00104\u001a\u000205H\u0002J\u0006\u00106\u001a\u000205J\u0018\u00107\u001a\u0002052\u0006\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020<H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006>"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/CellTab;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "currentElement", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "textView", "Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "stateObj", "Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;Lorg/brailleblaster/perspectives/braille/views/wp/TextView;Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;)V", "getManager", "()Lorg/brailleblaster/perspectives/braille/Manager;", "setManager", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "getCurrentElement", "()Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "setCurrentElement", "(Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;)V", "getTextView", "()Lorg/brailleblaster/perspectives/braille/views/wp/TextView;", "setTextView", "(Lorg/brailleblaster/perspectives/braille/views/wp/TextView;)V", "getStateObj", "()Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;", "setStateObj", "(Lorg/brailleblaster/perspectives/braille/views/wp/ViewStateObject;)V", "tabShell", "Lorg/eclipse/swt/widgets/Shell;", "getTabShell", "()Lorg/eclipse/swt/widgets/Shell;", "setTabShell", "(Lorg/eclipse/swt/widgets/Shell;)V", "tab", "Lorg/eclipse/swt/widgets/Text;", "getTab", "()Lorg/eclipse/swt/widgets/Text;", "setTab", "(Lorg/eclipse/swt/widgets/Text;)V", "buttonOK", "Lorg/eclipse/swt/widgets/Button;", "getButtonOK", "()Lorg/eclipse/swt/widgets/Button;", "setButtonOK", "(Lorg/eclipse/swt/widgets/Button;)V", "existingTab", "Lnu/xom/Element;", "getExistingTab", "()Lnu/xom/Element;", "setExistingTab", "(Lnu/xom/Element;)V", "intializeListeners", "", "open", "addTabElement", "tabValue", "", "getNumber", "num", "", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nCellTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CellTab.kt\norg/brailleblaster/perspectives/braille/ui/CellTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n296#2,2:155\n1#3:157\n*S KotlinDebug\n*F\n+ 1 CellTab.kt\norg/brailleblaster/perspectives/braille/ui/CellTab\n*L\n66#1:155,2\n*E\n"})
public final class CellTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Manager manager;
    @NotNull
    private TextMapElement currentElement;
    @NotNull
    private TextView textView;
    @NotNull
    private ViewStateObject stateObj;
    @NotNull
    private Shell tabShell;
    @NotNull
    private Text tab;
    @NotNull
    private Button buttonOK;
    @Nullable
    private Element existingTab;
    private static final Logger log = LoggerFactory.getLogger(CellTab.class);
    @NotNull
    public static final String MENU_NAME = "Set Cell Position";

    /*
     * WARNING - void declaration
     */
    public CellTab(@NotNull Manager manager, @NotNull TextMapElement currentElement, @NotNull TextView textView, @NotNull ViewStateObject stateObj) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)currentElement, (String)"currentElement");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)stateObj, (String)"stateObj");
        this.manager = manager;
        this.currentElement = currentElement;
        this.textView = textView;
        this.stateObj = stateObj;
        this.tabShell = new Shell(this.manager.getWpManager().getShell());
        this.tabShell.setSize(400, 100);
        this.tabShell.setText(MENU_NAME);
        this.tabShell.setLayout((Layout)new FillLayout(512));
        this.tab = new Text((Composite)this.tabShell, 2048);
        this.buttonOK = new Button((Composite)this.tabShell, 8);
        this.buttonOK.setText("OK");
        if (this.textView.getView().getCaretOffset() == this.currentElement.getEnd(this.manager.getMapList())) {
            throw new BBNotifyException("Cannot apply to end of line");
        }
        if (MathModuleUtils.isMath(this.currentElement.getNode())) {
            throw new BBNotifyException("Cannot apply to math");
        }
        if (this.textView.getView().getCaretOffset() == this.currentElement.getStart(this.manager.getMapList())) {
            Iterable iterable;
            Object v1;
            CellTab cellTab;
            Iterable iterable2;
            block6: {
                void $this$firstOrNull$iv;
                Node node = this.currentElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
                iterable2 = FastXPath.INSTANCE.preceding(node);
                cellTab = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Node it = (Node)element$iv;
                    boolean bl = false;
                    if (!(Searcher.Filters.noUTDAncestor(it) && BBX.SPAN.TAB.isA(it) && it instanceof Element)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            CellTab cellTab2 = cellTab;
            Element element = v1;
            if (element != null) {
                void it;
                Iterable $i$f$firstOrNull = iterable2 = element;
                cellTab = cellTab2;
                boolean bl = false;
                this.tab.setText(BBX.SPAN.TAB.ATTRIB_VALUE.getAttribute((Element)it).getValue());
                cellTab2 = cellTab;
                iterable = iterable2;
            } else {
                iterable = null;
            }
            cellTab2.existingTab = iterable;
        }
        this.intializeListeners();
    }

    @NotNull
    public final Manager getManager() {
        return this.manager;
    }

    public final void setManager(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"<set-?>");
        this.manager = manager;
    }

    @NotNull
    public final TextMapElement getCurrentElement() {
        return this.currentElement;
    }

    public final void setCurrentElement(@NotNull TextMapElement textMapElement) {
        Intrinsics.checkNotNullParameter((Object)textMapElement, (String)"<set-?>");
        this.currentElement = textMapElement;
    }

    @NotNull
    public final TextView getTextView() {
        return this.textView;
    }

    public final void setTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
        this.textView = textView;
    }

    @NotNull
    public final ViewStateObject getStateObj() {
        return this.stateObj;
    }

    public final void setStateObj(@NotNull ViewStateObject viewStateObject) {
        Intrinsics.checkNotNullParameter((Object)viewStateObject, (String)"<set-?>");
        this.stateObj = viewStateObject;
    }

    @NotNull
    public final Shell getTabShell() {
        return this.tabShell;
    }

    public final void setTabShell(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"<set-?>");
        this.tabShell = shell;
    }

    @NotNull
    public final Text getTab() {
        return this.tab;
    }

    public final void setTab(@NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"<set-?>");
        this.tab = text;
    }

    @NotNull
    public final Button getButtonOK() {
        return this.buttonOK;
    }

    public final void setButtonOK(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"<set-?>");
        this.buttonOK = button;
    }

    @Nullable
    public final Element getExistingTab() {
        return this.existingTab;
    }

    public final void setExistingTab(@Nullable Element element) {
        this.existingTab = element;
    }

    private final void intializeListeners() {
        int cellsPerLine = (int)(this.manager.getDocument().getEngine().getPageSettings().getDrawableWidth() / this.manager.getDocument().getEngine().getBrailleSettings().getCellType().getWidth().doubleValue());
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(this, cellsPerLine){
            final /* synthetic */ CellTab this$0;
            final /* synthetic */ int $cellsPerLine;
            {
                this.this$0 = $receiver;
                this.$cellsPerLine = $cellsPerLine;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.this$0.getTab().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                int v = CellTab.access$getNumber(this.this$0, string);
                if (v >= this.$cellsPerLine) {
                    MessageBox msg = new MessageBox(this.this$0.getTabShell());
                    msg.setMessage("Cell position exceeds maximum number of cells per line.");
                    msg.open();
                } else if (v >= 1) {
                    CellTab.access$addTabElement(this.this$0, v, this.this$0.getCurrentElement());
                    this.this$0.getTabShell().close();
                } else {
                    this.this$0.getTabShell().close();
                }
            }
        });
        this.tab.addKeyListener((KeyListener)new KeyAdapter(this, cellsPerLine){
            final /* synthetic */ CellTab this$0;
            final /* synthetic */ int $cellsPerLine;
            {
                this.this$0 = $receiver;
                this.$cellsPerLine = $cellsPerLine;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String string = this.this$0.getTab().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    int v = CellTab.access$getNumber(this.this$0, string);
                    if (v >= this.$cellsPerLine) {
                        MessageBox msg = new MessageBox(this.this$0.getTabShell());
                        msg.setMessage("Cell position exceeds maximum number of cells per line.");
                        msg.open();
                    } else if (v >= 1) {
                        CellTab.access$addTabElement(this.this$0, v, this.this$0.getCurrentElement());
                        this.this$0.getTabShell().close();
                    } else {
                        this.this$0.getTabShell().close();
                    }
                } else if (e.keyCode == 27) {
                    this.this$0.getTabShell().close();
                }
            }
        });
    }

    public final void open() {
        this.tabShell.open();
    }

    /*
     * WARNING - void declaration
     */
    private final void addTabElement(int tabValue, TextMapElement currentElement) {
        TabInsertionMessage tabInsertionMessage;
        Integer existingTabValue;
        String string;
        int xIndex = this.textView.getString(this.stateObj.getCurrentStart(), this.textView.getView().getCaretOffset() - this.stateObj.getCurrentStart()).length();
        Logger logger = log;
        String string2 = "tabValue {} element {}";
        Integer n = tabValue;
        Element element = this.existingTab;
        if (element != null) {
            void it;
            Element element2 = element;
            Integer n2 = n;
            String string3 = string2;
            Logger logger2 = logger;
            boolean bl = false;
            String string4 = XMLHandler.Companion.toXMLSimple((Node)it);
            logger = logger2;
            string2 = string3;
            n = n2;
            string = string4;
        } else {
            string = null;
        }
        logger.debug(string2, (Object)n, string);
        Integer n3 = existingTabValue = this.existingTab == null ? null : (Integer)BBX.SPAN.TAB.ATTRIB_VALUE.get(this.existingTab);
        if (this.existingTab != null) {
            Integer n4 = existingTabValue;
            Intrinsics.checkNotNull((Object)n4);
            tabInsertionMessage = new TabInsertionMessage(tabValue - n4, this.existingTab);
        } else {
            tabInsertionMessage = new TabInsertionMessage(tabValue, xIndex, currentElement);
        }
        TabInsertionMessage m = tabInsertionMessage;
        this.manager.dispatch(m);
    }

    private final int getNumber(String num) {
        int n;
        try {
            n = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        int val = n;
        return val;
    }

    public static final /* synthetic */ int access$getNumber(CellTab $this, String num) {
        return $this.getNumber(num);
    }

    public static final /* synthetic */ void access$addTabElement(CellTab $this, int tabValue, TextMapElement currentElement) {
        $this.addTabElement(tabValue, currentElement);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/CellTab$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MENU_NAME", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

