/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.document.BrailleDocument;
import org.brailleblaster.perspectives.braille.views.wp.TextView;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.settings.TableExceptions;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.util.FileUtils;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.mwhapples.jlouis.Louis;
import org.mwhapples.jlouis.TranslationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectTranslationDialog
extends Dialog
implements MenuToolModule {
    private static final LocaleHandler localeHandler = LocaleHandler.getDefault();
    private static final Logger log = LoggerFactory.getLogger(CorrectTranslationDialog.class);
    private static final String CORRECT_TRANSLATION_SHELL = localeHandler.get("correctTranslationShell");
    private static final String INSTRUCTION_P1 = localeHandler.get("instructionP1a");
    private static final String INSTRUCTION_P2 = localeHandler.get("instructionP2");
    private static final String INSTRUCTION_P3 = localeHandler.get("instructionP3");
    private static final String CHOOSE_OPERATION = localeHandler.get("chooseOperation");
    private static final String DEFINE_NEW_CHARACTER = localeHandler.get("defineNewCharacter");
    private static final String CORRECT_CHARACTER = localeHandler.get("correctCharacter");
    private static final String CORRECT_WORD = localeHandler.get("correctWord");
    private static final String PRINT = localeHandler.get("ctd.print");
    private static final String CHOOSE_ENTRY_METHOD_FOR_BRAILLE = localeHandler.get("chooseEntryForBraille");
    private static final String SIX_KEY = localeHandler.get("sixKey");
    private static final String ASCII = localeHandler.get("ascii");
    private static final String BRAILLE = localeHandler.get("braille");
    private static final String SAVE_TRANSLATION_LOCALLY = localeHandler.get("saveTranslationLocally");
    protected static final String BOTH_BOXES_NEED_INPUT = localeHandler.get("bothBoxesNeedInput");
    protected static final String ONE_WORD_CHARACTER_AT_ONCE = localeHandler.get("oneWordCharacterAtOnce");
    private static final String CANCEL = localeHandler.get("ctd.cancel");
    private static final String VIEW_CORRECTIONS = localeHandler.get("viewCorrections");
    private static final String CORRECT_UNDEFINED_CHARACTER_WARNING = localeHandler.get("correctUndefinedCharacterWarning");
    private static final String SUCCESS = localeHandler.get("success");
    private static final String TABLE_UPDATED_DOC_RETRANSLATED = localeHandler.get("tableUpdatedDocRetranslated");
    private static final String OK = localeHandler.get("ctd.ok");
    private static final String CORRECTED_TRANSLATIONS_SHELL = localeHandler.get("correctedTranslationsShell");
    private static final String EDIT_TRANSLATION = localeHandler.get("editTranslation");
    protected static final String SELECT_LIST_ITEM = localeHandler.get("selectListItem");
    private static final String DELETE_ENTRY = localeHandler.get("deleteEntry");
    private Manager man;
    private UTDTranslationEngine engine;
    private Properties dfnProps;
    private Properties corrProps;
    private BrailleDocument brailleDoc;
    private Shell ctDialog;
    private Shell vcDialog;
    private Text brailleText;
    private Text printText;
    private Button correctWord;
    private Button correctChar;
    private Button ascii;
    private Button sixKey;
    private List list;
    private static final String OP_NO_BACK = "noback";
    private static final String FILE_SEP = FileSystems.getDefault().getSeparator();
    private static final String PRINT_BLANK = " ";
    private String dfnPropertiesPath;
    private String corrPropertiesPath;
    private static final String FONT_PATH = String.valueOf(BBIni.getProgramDataPath()) + FILE_SEP + "fonts" + FILE_SEP + "APH_Braille_Font-6s.otf";
    private String dots = "";
    private String asciiBraille = "";
    private String unicode = "";
    private static final String OP_ALWAYS = "always";
    private static final String OP_WORD = "word";
    private static final String OP_SIGN = "sign";

    public CorrectTranslationDialog(Shell parent, int style) {
        super(parent, style);
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return TopMenu.TOOLS;
    }

    @Override
    @NotNull
    public String getTitle() {
        return localeHandler.get("&correctTranslation");
    }

    @Override
    public int getAccelerator() {
        return SWT.MOD1 | 0x54;
    }

    @Override
    public void onRun(BBSelectionData bbData) {
        this.man = bbData.getManager();
        this.open();
    }

    public void open() {
        boolean textSelection;
        this.engine = this.man.getDocument().getEngine();
        this.brailleDoc = this.man.getDocument();
        this.dfnPropertiesPath = BBIni.getUserProgramDataPath().resolve(Paths.get("settings", this.getTableType() + "-define.properties")).toString();
        this.corrPropertiesPath = BBIni.getUserProgramDataPath().resolve(Paths.get("settings", this.getTableType() + "-correct.properties")).toString();
        Shell parent = this.getParent();
        this.ctDialog = new Shell(parent, 67696);
        this.ctDialog.setText(CORRECT_TRANSLATION_SHELL);
        GridLayout grid = new GridLayout(1, false);
        this.ctDialog.setLayout((Layout)grid);
        Composite outerContainer = new Composite((Composite)this.ctDialog, 0);
        outerContainer.setLayout((Layout)new GridLayout(1, false));
        outerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc = new ScrolledComposite(outerContainer, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        Composite innerContainer = new Composite((Composite)sc, 0);
        innerContainer.setLayout((Layout)new GridLayout(1, false));
        innerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Label explain = new Label(innerContainer, 0);
        String blankline = "\n\n";
        explain.setText(this.addNewLines(INSTRUCTION_P1) + blankline + this.addNewLines(INSTRUCTION_P2) + blankline + this.addNewLines(INSTRUCTION_P3));
        Group radioPrint = new Group(innerContainer, 0);
        radioPrint.setLayout((Layout)new GridLayout(1, false));
        Label radioLabelPrint = new Label((Composite)radioPrint, 0);
        radioLabelPrint.setText(CHOOSE_OPERATION);
        Button define = new Button((Composite)radioPrint, 16);
        define.setText(DEFINE_NEW_CHARACTER);
        this.correctChar = new Button((Composite)radioPrint, 16);
        this.correctChar.setText(CORRECT_CHARACTER);
        this.correctWord = new Button((Composite)radioPrint, 16);
        this.correctWord.setText(CORRECT_WORD);
        this.correctWord.setSelection(true);
        Label printLabel = new Label(innerContainer, 0);
        this.printText = new Text(innerContainer, 2048);
        this.printText.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.printText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    CorrectTranslationDialog.this.printText.selectAll();
                }
            }
        });
        printLabel.setText(PRINT);
        TextView tv = this.man.getText();
        boolean bl = textSelection = tv.getView().getSelectionCount() > 0;
        if (textSelection) {
            this.printText.setText(tv.getView().getSelectionText());
        }
        Group radio = new Group(innerContainer, 0);
        radio.setLayout((Layout)new GridLayout(1, false));
        Label radioLabel = new Label((Composite)radio, 0);
        radioLabel.setText(CHOOSE_ENTRY_METHOD_FOR_BRAILLE);
        this.sixKey = new Button((Composite)radio, 16);
        this.sixKey.setText(SIX_KEY);
        this.sixKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CorrectTranslationDialog.this.sixKey.getSelection()) {
                    CorrectTranslationDialog.this.brailleText.setText("");
                    CorrectTranslationDialog.this.dots = "";
                    CorrectTranslationDialog.this.simBraille();
                }
            }
        });
        this.ascii = new Button((Composite)radio, 16);
        this.ascii.setText(ASCII);
        this.ascii.setSelection(true);
        this.ascii.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CorrectTranslationDialog.this.ascii.getSelection()) {
                    CorrectTranslationDialog.this.brailleText.setText("");
                    CorrectTranslationDialog.this.dots = "";
                    CorrectTranslationDialog.this.noSimBraille();
                }
            }
        });
        Label brailleLabel = new Label(innerContainer, 0);
        brailleLabel.setText(BRAILLE);
        this.brailleText = new Text(innerContainer, 2048);
        this.brailleText.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.brailleText.addVerifyListener(e -> {
            log.debug(e.toString());
            if (e.character > ' ' && e.character < '\u007f' && this.sixKey.getSelection()) {
                e.doit = false;
            }
        });
        this.brailleText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    CorrectTranslationDialog.this.brailleText.selectAll();
                }
            }
        });
        this.brailleText.addKeyListener((KeyListener)new KeyAdapter(){
            private byte downKeys = 0;
            private byte dotsByte = 0;
            private static final byte DOT_1 = 1;
            private static final byte DOT_2 = 2;
            private static final byte DOT_3 = 4;
            private static final byte DOT_4 = 8;
            private static final byte DOT_5 = 16;
            private static final byte DOT_6 = 32;

            public void keyPressed(KeyEvent e) {
                if (!CorrectTranslationDialog.this.sixKey.getSelection()) {
                    return;
                }
                char input = Character.toLowerCase(e.character);
                if (input == 'f') {
                    this.setDots((byte)1);
                } else if (input == 'd') {
                    this.setDots((byte)2);
                } else if (input == 's') {
                    this.setDots((byte)4);
                } else if (input == 'j') {
                    this.setDots((byte)8);
                } else if (input == 'k') {
                    this.setDots((byte)16);
                } else if (input == 'l') {
                    this.setDots((byte)32);
                } else if (e.keyCode == 8 || e.keyCode == 127) {
                    CorrectTranslationDialog.this.dots = "";
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!CorrectTranslationDialog.this.sixKey.getSelection()) {
                    return;
                }
                char input = Character.toLowerCase(e.character);
                if (input == 'f') {
                    this.showKey();
                } else if (input == 'd') {
                    this.showKey();
                } else if (input == 's') {
                    this.showKey();
                } else if (input == 'j') {
                    this.showKey();
                } else if (input == 'k') {
                    this.showKey();
                } else if (input == 'l') {
                    this.showKey();
                }
            }

            private void showKey() {
                if (this.downKeys == 0) {
                    String s = CorrectTranslationDialog.this.byteToDotsString(this.dotsByte);
                    CorrectTranslationDialog.this.addToDotString(s);
                    CorrectTranslationDialog.this.byteToAsciiString(this.dotsByte);
                    this.dotsByte = 0;
                }
            }

            private void setDots(byte dot) {
                this.downKeys = (byte)(this.downKeys & dot);
                this.dotsByte = (byte)(this.dotsByte | dot);
            }
        });
        Group saveOptions = new Group(innerContainer, 0);
        GridLayout gridSaveOptions = new GridLayout(3, false);
        saveOptions.setLayout((Layout)gridSaveOptions);
        Button saveLocal = new Button((Composite)saveOptions, 8);
        saveLocal.setText(SAVE_TRANSLATION_LOCALLY);
        saveLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StringUtils.isBlank((CharSequence)CorrectTranslationDialog.this.brailleText.getText()) || StringUtils.isBlank((CharSequence)CorrectTranslationDialog.this.printText.getText())) {
                    Notify.INSTANCE.notify(BOTH_BOXES_NEED_INPUT, Notify.ALERT_SHELL_NAME);
                } else if (CorrectTranslationDialog.this.printText.getText().contains(CorrectTranslationDialog.PRINT_BLANK)) {
                    Notify.INSTANCE.notify(ONE_WORD_CHARACTER_AT_ONCE, Notify.ALERT_SHELL_NAME);
                } else {
                    CorrectTranslationDialog.this.putInPropertiesFile();
                    if (CorrectTranslationDialog.this.saveLocally()) {
                        CorrectTranslationDialog.this.ctDialog.close();
                    }
                }
            }
        });
        Button cancel = new Button((Composite)saveOptions, 8);
        cancel.setText(CANCEL);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CorrectTranslationDialog.this.ctDialog.close();
            }
        });
        Button seeCorrections = new Button((Composite)saveOptions, 8);
        seeCorrections.setText(VIEW_CORRECTIONS);
        seeCorrections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CorrectTranslationDialog.this.makeViewDialog();
            }
        });
        FileUtils.INSTANCE.create(this.dfnPropertiesPath);
        this.dfnProps = new Properties();
        try {
            this.dfnProps.load(new FileInputStream(this.dfnPropertiesPath));
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to read file " + this.dfnPropertiesPath, e2);
        }
        FileUtils.INSTANCE.create(this.corrPropertiesPath);
        this.corrProps = new Properties();
        try {
            this.corrProps.load(new FileInputStream(this.corrPropertiesPath));
        }
        catch (IOException e3) {
            throw new RuntimeException("Unable to read file " + this.corrPropertiesPath, e3);
        }
        sc.setContent((Control)innerContainer);
        sc.setMinSize(innerContainer.computeSize(-1, -1));
        this.ctDialog.pack();
        this.ctDialog.layout(true);
        this.ctDialog.setSize(this.ctDialog.computeSize(-1, Display.getCurrent().getPrimaryMonitor().getClientArea().height / 2));
        this.ctDialog.open();
    }

    private String addNewLines(String s1) {
        String[] array;
        StringBuilder s2 = new StringBuilder();
        int cutPoint = 80;
        int curChars = 0;
        for (String s : array = s1.split(PRINT_BLANK)) {
            if (curChars > cutPoint) {
                s2.append("\n");
                curChars = 0;
            }
            s2.append(s).append(PRINT_BLANK);
            curChars += s.length();
        }
        return s2.toString();
    }

    public boolean saveLocally() {
        File file = TableExceptions.getCurrentExceptionFile(this.man);
        if (file == null || !file.exists()) {
            throw new RuntimeException("User exceptions table not found: " + (file != null ? file.getAbsolutePath() : null));
        }
        try (OutputStreamWriter f = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            String[] value;
            f.append(TableExceptions.UNIVERSAL_EXCEPTION_FILE_HEADING);
            f.append(System.lineSeparator());
            for (Map.Entry<Object, Object> e : this.dfnProps.entrySet()) {
                value = e.getValue().toString().split(",");
                f.append(PRINT_BLANK).append(value[0]).append(PRINT_BLANK);
                f.append(e.getKey().toString());
                f.append(PRINT_BLANK);
                f.append(value[1]);
                f.append(System.lineSeparator());
            }
            f.append(System.lineSeparator());
            for (Map.Entry<Object, Object> e : this.corrProps.entrySet()) {
                value = e.getValue().toString().split(",");
                f.append(PRINT_BLANK).append(value[0]).append(PRINT_BLANK);
                f.append(e.getKey().toString());
                f.append(PRINT_BLANK);
                f.append(value[1]);
                f.append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write exceptions to file " + file.getAbsolutePath(), e);
        }
        try {
            this.sanityCheck();
        }
        catch (RuntimeException | TranslationException e) {
            Notify.INSTANCE.notify(CORRECT_UNDEFINED_CHARACTER_WARNING, Notify.ALERT_SHELL_NAME);
            this.removeUndefinedCharacter(this.printText.getText().toLowerCase());
            return false;
        }
        this.refreshTranslation();
        this.savedCorrectly();
        return true;
    }

    public void savedCorrectly() {
        final Shell saved = new Shell(this.getParent(), 67680);
        saved.setText(SUCCESS);
        saved.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label((Composite)saved, 0);
        label.setText(TABLE_UPDATED_DOC_RETRANSLATED);
        Button button = new Button((Composite)saved, 8);
        button.setData((Object)new GridData(1, 1, true, true));
        button.setText(OK);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                saved.close();
            }
        });
        saved.open();
        saved.pack();
    }

    public void sanityCheck() throws TranslationException {
        this.engine.getBrailleTranslator().close();
        this.engine.getBrailleTranslator().translateString(TableExceptions.getCurrentExceptionTable(this.man), this.printText.getText().toLowerCase(), 0);
    }

    public void removeUndefinedCharacter(String stringToRemove) {
        this.dfnProps.remove(stringToRemove);
        this.corrProps.remove(stringToRemove);
        this.brailleText.setText("");
        this.dots = "";
        this.asciiBraille = "";
        this.unicode = "";
        try {
            this.dfnProps.store(new FileOutputStream(this.dfnPropertiesPath), null);
            this.corrProps.store(new FileOutputStream(this.corrPropertiesPath), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save file " + this.dfnPropertiesPath, e);
        }
        File file = this.brailleDoc.getSettingsManager().getExceptionsTableFile();
        if (file == null || !file.exists()) {
            throw new RuntimeException("User exceptions table not found: " + (file != null ? file.getAbsolutePath() : null));
        }
        try (OutputStreamWriter f = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            String[] s;
            f.append(TableExceptions.UNIVERSAL_EXCEPTION_FILE_HEADING);
            f.append(System.lineSeparator());
            for (Map.Entry<Object, Object> e : this.dfnProps.entrySet()) {
                s = e.getValue().toString().split(",");
                f.append(PRINT_BLANK);
                f.append(s[0]);
                f.append(PRINT_BLANK);
                f.append(e.getKey().toString());
                f.append(PRINT_BLANK);
                f.append(s[1]);
                f.append(System.lineSeparator());
            }
            for (Map.Entry<Object, Object> e : this.corrProps.entrySet()) {
                s = e.getValue().toString().split(",");
                f.append(PRINT_BLANK);
                f.append(s[0]);
                f.append(PRINT_BLANK);
                f.append(e.getKey().toString());
                f.append(PRINT_BLANK);
                f.append(s[1]);
                f.append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write exceptions to file " + file.getAbsolutePath(), e);
        }
    }

    public void refreshTranslation() {
        this.engine.getBrailleTranslator().close();
        this.man.refresh();
    }

    public void putInPropertiesFile() {
        this.asciiBraille = "";
        this.dots = "";
        this.unicode = "";
        this.parseWordsFromBrailleInputBox();
        if (this.correctWord.getSelection()) {
            this.corrProps.setProperty(this.printText.getText().toLowerCase(), "word," + this.dots + "," + this.asciiBraille + "," + this.unicode);
        } else if (this.correctChar.getSelection()) {
            this.corrProps.setProperty(this.printText.getText().toLowerCase(), "always," + this.dots + "," + this.asciiBraille + "," + this.unicode);
        } else {
            this.dfnProps.setProperty(this.printText.getText().toLowerCase(), "sign," + this.dots + "," + this.asciiBraille + "," + this.unicode);
            this.corrProps.setProperty(this.printText.getText().toLowerCase(), "always," + this.dots + "," + this.asciiBraille + "," + this.unicode);
        }
        try {
            if (this.corrProps != null) {
                this.corrProps.store(new FileOutputStream(this.corrPropertiesPath), null);
            }
            if (this.dfnProps != null) {
                this.dfnProps.store(new FileOutputStream(this.dfnPropertiesPath), null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save properties file.", e);
        }
    }

    public void processWord(String brailleString) {
        byte[] os;
        if (brailleString.isEmpty()) {
            return;
        }
        Louis translation = this.engine.getBrailleTranslator();
        Louis.WideChar input = new Louis.WideChar(brailleString);
        Louis.WideChar outputLouis = new Louis.WideChar(brailleString.length());
        translation.charToDots(TableExceptions.getCurrentExceptionTable(this.man), input, outputLouis, brailleString.length(), 0);
        String outputStr = outputLouis.getText(outputLouis.length());
        for (byte o : os = outputStr.getBytes(StandardCharsets.UTF_16LE)) {
            this.addToDotString(this.byteToDotsString(o));
            this.addByteToUnicodeString(o);
        }
    }

    private void parseWordsFromBrailleInputBox() {
        this.asciiBraille = this.brailleText.getText();
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < this.asciiBraille.length(); ++i) {
            if (this.asciiBraille.charAt(i) == ' ') {
                this.processWord(word.toString());
                this.addBlank();
                word = new StringBuilder();
                continue;
            }
            word.append(this.asciiBraille.charAt(i));
        }
        this.processWord(word.toString());
    }

    private void addBlank() {
        this.addToDotString("0");
        this.unicode = this.unicode + "\\u2800";
    }

    public String byteToDotsString(byte dots) {
        int mask = 1;
        StringBuilder result = new StringBuilder();
        for (int c = 1; c < 7; ++c) {
            if ((dots & mask) == mask) {
                result.append(c);
            }
            mask = (byte)(mask << 1);
        }
        return result.toString();
    }

    public void addToDotString(String braille) {
        if (braille.isEmpty()) {
            return;
        }
        this.dots = this.dots.isEmpty() ? this.dots + braille : this.dots + "-" + braille;
    }

    public void byteToAsciiString(byte b) {
        Louis translation = this.engine.getBrailleTranslator();
        byte[] bb = new byte[]{b, 40};
        String s = new String(bb, StandardCharsets.UTF_16LE);
        Louis.WideChar input = new Louis.WideChar(s);
        Louis.WideChar outputLouis = new Louis.WideChar(2);
        translation.dotsToChar(TableExceptions.getCurrentExceptionTable(this.man), input, outputLouis, s.length(), 1);
        String outputStr = outputLouis.getText(outputLouis.length());
        this.putInBrailleTextWidget(outputStr.substring(0, 1));
    }

    public void addByteToUnicodeString(byte bite) {
        if (bite >= 0) {
            byte[] bb = new byte[]{bite, 40};
            String s2 = new String(bb, StandardCharsets.UTF_16LE);
            this.unicode = this.unicode + "\\u" + Integer.toHexString(s2.charAt(0) | 0x10000).substring(1);
        }
    }

    public void putInBrailleTextWidget(String s) {
        if (s.isEmpty()) {
            return;
        }
        this.brailleText.insert(s);
    }

    public void simBraille() {
        this.ctDialog.getDisplay().loadFont(FONT_PATH);
        Font simBrailleFont = new Font((Device)WPManager.display, "SimBraille", 12, 0);
        this.brailleText.setFont(simBrailleFont);
    }

    public void noSimBraille() {
        Font courier = new Font((Device)WPManager.display, "Courier New", 12, 0);
        this.brailleText.setFont(courier);
    }

    public String getTableType() {
        return TableExceptions.getCurrentStandardName(this.man);
    }

    public void makeViewDialog() {
        Shell parent = this.getParent();
        this.vcDialog = new Shell(parent, 67680);
        this.vcDialog.setText(CORRECTED_TRANSLATIONS_SHELL);
        this.vcDialog.setLayout((Layout)new GridLayout(1, false));
        Composite container = new Composite((Composite)this.vcDialog, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData myGrid = new GridData(4, 4, true, true);
        Rectangle bounds = Display.getCurrent().getPrimaryMonitor().getClientArea();
        myGrid.widthHint = bounds.width / 3;
        myGrid.heightHint = bounds.height / 2;
        this.list = new List((Composite)this.vcDialog, 2562);
        this.list.setLayoutData((Object)myGrid);
        ArrayList<String> keys = new ArrayList<String>(this.corrProps.stringPropertyNames());
        Collections.sort(keys);
        for (int i = 0; i < this.corrProps.size(); ++i) {
            String b = this.corrProps.getProperty((String)keys.get(i));
            String[] keyValues = b.split(",");
            String mode = this.ascii.getSelection() ? keyValues[2] : StringEscapeUtils.unescapeJava((String)keyValues[3]);
            this.list.add((String)keys.get(i) + " \u2192 " + mode);
        }
        Group saveOptions = new Group((Composite)this.vcDialog, 0);
        GridLayout gridSaveOptions = new GridLayout(3, false);
        saveOptions.setLayout((Layout)gridSaveOptions);
        Button cancel = new Button((Composite)saveOptions, 8);
        cancel.setText(CANCEL);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CorrectTranslationDialog.this.vcDialog.close();
                CorrectTranslationDialog.this.ctDialog.setActive();
            }
        });
        Button edit = new Button((Composite)saveOptions, 8);
        edit.setText(EDIT_TRANSLATION);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (CorrectTranslationDialog.this.list.getSelectionIndex() == -1) {
                    Notify.INSTANCE.notify(SELECT_LIST_ITEM, Notify.ALERT_SHELL_NAME);
                    return;
                }
                String[] key = CorrectTranslationDialog.this.list.getItem(CorrectTranslationDialog.this.list.getSelectionIndex()).split("\u2192");
                String s = CorrectTranslationDialog.this.corrProps.getProperty(key[0].trim());
                String[] st = s.split(",");
                CorrectTranslationDialog.this.printText.setText(key[0].trim());
                CorrectTranslationDialog.this.brailleText.setText(st[2]);
                CorrectTranslationDialog.this.vcDialog.close();
                CorrectTranslationDialog.this.printText.setFocus();
            }
        });
        Button delete = new Button((Composite)saveOptions, 8);
        delete.setText(DELETE_ENTRY);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CorrectTranslationDialog.this.list.getSelectionIndex() == -1) {
                    Notify.INSTANCE.notify(SELECT_LIST_ITEM, Notify.ALERT_SHELL_NAME);
                    return;
                }
                String[] key = CorrectTranslationDialog.this.list.getItem(CorrectTranslationDialog.this.list.getSelectionIndex()).split("\u2192");
                CorrectTranslationDialog.this.removeUndefinedCharacter(key[0].trim());
                CorrectTranslationDialog.this.refreshTranslation();
                CorrectTranslationDialog.this.vcDialog.close();
                CorrectTranslationDialog.this.printText.setFocus();
            }
        });
        this.vcDialog.pack();
        this.vcDialog.layout(true);
        this.vcDialog.open();
    }
}

