/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.ui.contractionRelaxer;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.BBIni;
import org.brailleblaster.perspectives.braille.ui.contractionRelaxer.UnitList;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.settings.TableExceptions;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.utils.swt.ButtonBuilder;
import org.brailleblaster.utils.swt.ComboBuilder;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.LabelBuilder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.mwhapples.jlouis.Louis;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/brailleblaster/perspectives/braille/ui/contractionRelaxer/ContractionRelaxer;", "Lorg/eclipse/swt/widgets/Dialog;", "Lorg/brailleblaster/tools/MenuToolModule;", "parent", "Lorg/eclipse/swt/widgets/Shell;", "<init>", "(Lorg/eclipse/swt/widgets/Shell;)V", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "changeToContracted", "", "unitToggle", "", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "clearAndSave", "viewContractions", "shell", "makeContractionList", "makePrettyContractionList", "brailleAsciiToDots", "brailleAscii", "Unit", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nContractionRelaxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractionRelaxer.kt\norg/brailleblaster/perspectives/braille/ui/contractionRelaxer/ContractionRelaxer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1391#2:279\n1480#2,2:280\n1586#2:282\n1661#2,3:283\n1482#2,3:286\n*S KotlinDebug\n*F\n+ 1 ContractionRelaxer.kt\norg/brailleblaster/perspectives/braille/ui/contractionRelaxer/ContractionRelaxer\n*L\n215#1:279\n215#1:280,2\n215#1:282\n215#1:283,3\n215#1:286,3\n*E\n"})
public final class ContractionRelaxer
extends Dialog
implements MenuToolModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TopMenu topMenu;
    @NotNull
    private final String title;
    private boolean changeToContracted;
    private int unitToggle;
    @NotNull
    private static final String UNIT_TOGGLE_PROPERTY = "ContractionRelaxer.unitToggle";
    @NotNull
    private static final String RELAXER_HEADER = "#Begin UEB Contraction Relaxer";
    @NotNull
    private static final String RELAXER_FOOTER = "#End UEB Contraction Relaxer";

    public ContractionRelaxer(@NotNull Shell parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent, 0);
        this.topMenu = TopMenu.TOOLS;
        this.title = "Contraction Relaxer";
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return this.topMenu;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        String string = BBIni.getPropertyFileManager().getProperty(UNIT_TOGGLE_PROPERTY);
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.unitToggle = Integer.parseInt(it);
        }
        Shell shell = new Shell(this.getParent().getDisplay(), 16779376);
        shell.setText("Contraction Relaxer");
        shell.setLayout((Layout)new GridLayout(1, false));
        LabelBuilder shellText = EasySWT.INSTANCE.makeLabel((Composite)shell);
        shellText.text("Select a unit to toggle specific translation rules.\nThis will allow you to specify words and contractions up to and including the selected unit.");
        ComboBuilder unitSelector = EasySWT.makeComboDropdown((Composite)((Composite)shell));
        for (Unit unit : UnitList.INSTANCE.getAllUnits()) {
            unitSelector.add(unit.getUnitName());
        }
        unitSelector.select(this.unitToggle);
        unitSelector.onSelect(arg_0 -> ContractionRelaxer.onRun$lambda$1(this, unitSelector, arg_0));
        Composite buttonLayout = EasySWT.makeComposite((Composite)((Composite)shell), (int)3);
        ButtonBuilder saveBtn = EasySWT.INSTANCE.makeButton(buttonLayout, 8);
        saveBtn.text("OK");
        saveBtn.onSelection(arg_0 -> ContractionRelaxer.onRun$lambda$2(this, bbData, shell, arg_0));
        ButtonBuilder previewBtn = EasySWT.INSTANCE.makeButton(buttonLayout, 8);
        previewBtn.text("View Contractions");
        previewBtn.onSelection(arg_0 -> ContractionRelaxer.onRun$lambda$3(this, shell, arg_0));
        ButtonBuilder closeBtn = EasySWT.INSTANCE.makeButton(buttonLayout, 8);
        closeBtn.text("Cancel");
        closeBtn.onSelection(arg_0 -> ContractionRelaxer.onRun$lambda$4(shell, arg_0));
        EasySWT.INSTANCE.addEscapeCloseListener(shell);
        shell.pack();
        shell.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearAndSave(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        File file = TableExceptions.getCurrentExceptionFile(bbData.getManager());
        if (file == null) {
            throw new RuntimeException("Unable to save exceptions to translation correction file - no file found.");
        }
        File file2 = file;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        String fileContent = FilesKt.readText((File)file2, (Charset)charset);
        int headerIndex = StringsKt.indexOf$default((CharSequence)fileContent, (String)RELAXER_HEADER, (int)0, (boolean)false, (int)6, null);
        int footerIndex = StringsKt.lastIndexOf$default((CharSequence)fileContent, (String)RELAXER_FOOTER, (int)0, (boolean)false, (int)6, null);
        String contractionList = this.makeContractionList();
        if (headerIndex == -1 && footerIndex == -1) {
            Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                Writer writer = (OutputStreamWriter)closeable;
                boolean bl = false;
                writer.append(RELAXER_HEADER);
                writer.append(ConstantsKt.getLINE_BREAK());
                writer.append(contractionList);
                writer = writer.append(RELAXER_FOOTER);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (headerIndex < footerIndex) {
            String string = StringsKt.take((String)fileContent, (int)(headerIndex + 30));
            String string2 = ConstantsKt.getLINE_BREAK();
            String string3 = fileContent.substring(footerIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String newContent = string + string2 + contractionList + string3;
            Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8);
            Throwable writer = null;
            try {
                OutputStreamWriter writer2 = (OutputStreamWriter)closeable;
                boolean bl = false;
                writer2.write(newContent);
                writer2 = kotlin.Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                writer = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)writer);
            }
        }
        Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            writer.write("");
            writer.append(RELAXER_HEADER);
            writer.append(ConstantsKt.getLINE_BREAK());
            writer.append(contractionList);
            Writer writer3 = writer.append(RELAXER_FOOTER);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (this.changeToContracted) {
            bbData.getManager().getDocument().getSettingsManager().updateBrailleStandard(bbData.getManager().getDocument().doc, "UEB");
            this.changeToContracted = false;
        } else {
            bbData.getManager().getDocument().getSettingsManager().updateBrailleStandard(bbData.getManager().getDocument().doc, "UEB-UNCONTRACTED");
        }
        BBIni.getPropertyFileManager().saveAsInt(UNIT_TOGGLE_PROPERTY, this.unitToggle);
        bbData.getManager().getDocument().getEngine().getBrailleTranslator().close();
        bbData.getManager().refresh();
    }

    public final void viewContractions(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        String contractionList = this.makePrettyContractionList();
        Shell vc = new Shell(shell, 67680);
        vc.setText("Contraction List");
        vc.setLayout((Layout)new GridLayout(1, false));
        Composite comp = EasySWT.makeComposite((Composite)((Composite)vc), (int)0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData myGrid = new GridData(4, 4, true, true);
        Rectangle bounds = Display.getCurrent().getPrimaryMonitor().getClientArea();
        myGrid.widthHint = bounds.width / 4;
        myGrid.heightHint = bounds.height / 3;
        Text st = new Text(comp, 2826);
        st.setLayoutData((Object)myGrid);
        st.setText(contractionList);
        st.setEditable(false);
        vc.pack();
        vc.open();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeContractionList() {
        String string;
        int n = this.unitToggle;
        if (n == 0) {
            string = "";
        } else if (n == CollectionsKt.getLastIndex(UnitList.INSTANCE.getAllUnits())) {
            this.changeToContracted = true;
            string = "";
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)UnitList.INSTANCE.getAllUnits(), (int)1), (int)this.unitToggle);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Unit unit = (Unit)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = unit.getContractions();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add((String)it + System.lineSeparator());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    @NotNull
    public final String makePrettyContractionList() {
        StringBuilder f = new StringBuilder();
        int i = 0;
        int n = this.unitToggle;
        if (i <= n) {
            while (true) {
                List<String> unit = UnitList.INSTANCE.getAllPrettyUnits().get(i);
                for (String c : unit) {
                    f.append(c);
                    f.append(System.lineSeparator());
                }
                if (i == n) break;
                ++i;
            }
        }
        String string = f.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String brailleAsciiToDots(@NotNull String brailleAscii, @NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)brailleAscii, (String)"brailleAscii");
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        Louis translation = bbData.getManager().getDocument().getEngine().getBrailleTranslator();
        Louis.WideChar inputBuffer = new Louis.WideChar(brailleAscii);
        Louis.WideChar outputBuffer = new Louis.WideChar(brailleAscii.length());
        translation.charToDots(TableExceptions.getCurrentExceptionTable(bbData.getManager()), inputBuffer, outputBuffer, brailleAscii.length(), 0);
        String brailleDots = outputBuffer.getText(outputBuffer.length());
        Intrinsics.checkNotNull((Object)brailleDots);
        String string = brailleDots;
        Charset charset = StandardCharsets.UTF_16LE;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_16LE");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] brailleBytes = byArray;
        byte mask = 1;
        StringBuilder result = new StringBuilder();
        for (byte d : brailleBytes) {
            if (d >= 0) {
                for (int c = 1; c < 7; ++c) {
                    if ((byte)(d & mask) == mask) {
                        result.append(c);
                    }
                    mask = (byte)(mask << 1);
                }
                result.append("-");
            }
            mask = 1;
        }
        result.deleteCharAt(result.length() - 1);
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final void onRun$lambda$1(ContractionRelaxer this$0, ComboBuilder $unitSelector, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.unitToggle = ((Combo)$unitSelector.get()).getSelectionIndex();
    }

    private static final void onRun$lambda$2(ContractionRelaxer this$0, BBSelectionData $bbData, Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.unitToggle >= 0) {
            this$0.clearAndSave($bbData);
            $shell.close();
        }
    }

    private static final void onRun$lambda$3(ContractionRelaxer this$0, Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.viewContractions($shell);
    }

    private static final void onRun$lambda$4(Shell $shell, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $shell.close();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/contractionRelaxer/ContractionRelaxer$Companion;", "", "<init>", "()V", "UNIT_TOGGLE_PROPERTY", "", "RELAXER_HEADER", "RELAXER_FOOTER", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/perspectives/braille/ui/contractionRelaxer/ContractionRelaxer$Unit;", "", "unitName", "", "contractions", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getUnitName", "()Ljava/lang/String;", "getContractions", "()Ljava/util/List;", "brailleblaster-core"})
    public static final class Unit {
        @NotNull
        private final String unitName;
        @NotNull
        private final List<String> contractions;

        public Unit(@NotNull String unitName, @NotNull List<String> contractions) {
            Intrinsics.checkNotNullParameter((Object)unitName, (String)"unitName");
            Intrinsics.checkNotNullParameter(contractions, (String)"contractions");
            this.unitName = unitName;
            this.contractions = contractions;
        }

        @NotNull
        public final String getUnitName() {
            return this.unitName;
        }

        @NotNull
        public final List<String> getContractions() {
            return this.contractions;
        }
    }
}

