/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.perspectives.braille.viewInitializer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.mapping.elements.SectionElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/perspectives/braille/viewInitializer/SectionMapSearcher;", "", "sectionList", "Ljava/util/ArrayList;", "Lorg/brailleblaster/perspectives/braille/mapping/elements/SectionElement;", "Lkotlin/collections/ArrayList;", "<init>", "(Ljava/util/ArrayList;)V", "search", "Lkotlin/Pair;", "", "n", "Lnu/xom/Node;", "SearchCallable", "Companion", "brailleblaster-core"})
public final class SectionMapSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<SectionElement> sectionList;
    @NotNull
    private static final Logger log;

    public SectionMapSearcher(@NotNull ArrayList<SectionElement> sectionList) {
        Intrinsics.checkNotNullParameter(sectionList, (String)"sectionList");
        this.sectionList = sectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Pair<Integer, Integer> search(@Nullable Node n) {
        int processors = Runtime.getRuntime().availableProcessors();
        int sectionsPerProc = (int)Math.max((double)(this.sectionList.size() / processors), 1.0);
        Object[] objectArray = new Object[]{this.sectionList.size(), sectionsPerProc, processors};
        log.trace("Searching {} sections at {} sections / processor over {} procs", objectArray);
        ExecutorService executor = Executors.newFixedThreadPool(processors);
        CompletionService ecs = new ExecutorCompletionService(executor);
        List callables = new ArrayList();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.sectionList.size())), (int)sectionsPerProc);
        int i = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && i <= n2 || n3 < 0 && n2 <= i) {
            while (true) {
                boolean bl = i == this.sectionList.size() - 1 || i + sectionsPerProc > this.sectionList.size() ? callables.add(new SearchCallable(n, i, this.sectionList.size())) : callables.add(new SearchCallable(n, i, i + sectionsPerProc));
                if (i == n2) break;
                i += n3;
            }
        }
        List futures = new ArrayList();
        Pair result = null;
        try {
            int callableLength = callables.size();
            for (SearchCallable s : callables) {
                Future future = ecs.submit(s);
                Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
                futures.add(future);
            }
            for (int i2 = 0; i2 < callableLength; ++i2) {
                try {
                    Pair r = (Pair)ecs.take().get();
                    if (r == null) continue;
                    result = r;
                    break;
                }
                catch (ExecutionException r) {
                    continue;
                }
                catch (InterruptedException r) {
                    // empty catch block
                }
            }
        }
        finally {
            for (Future f : futures) {
                f.cancel(true);
            }
            executor.shutdownNow();
        }
        return result;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SectionMapSearcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/perspectives/braille/viewInitializer/SectionMapSearcher$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0001B!\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/perspectives/braille/viewInitializer/SectionMapSearcher$SearchCallable;", "Ljava/util/concurrent/Callable;", "Lkotlin/Pair;", "", "n", "Lnu/xom/Node;", "start", "end", "<init>", "(Lorg/brailleblaster/perspectives/braille/viewInitializer/SectionMapSearcher;Lnu/xom/Node;II)V", "getN", "()Lnu/xom/Node;", "getStart", "()I", "getEnd", "call", "brailleblaster-core"})
    private final class SearchCallable
    implements Callable<Pair<? extends Integer, ? extends Integer>> {
        @Nullable
        private final Node n;
        private final int start;
        private final int end;

        public SearchCallable(Node n, int start, int end) {
            this.n = n;
            this.start = start;
            this.end = end;
        }

        @Nullable
        public final Node getN() {
            return this.n;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @Override
        @Nullable
        public Pair<Integer, Integer> call() {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                int index;
                if (((SectionElement)SectionMapSearcher.this.sectionList.get(i)).isVisible() || (index = ((SectionElement)((SectionMapSearcher)SectionMapSearcher.this).sectionList.get((int)i)).list.findNodeIndex(this.n, 0)) == -1) continue;
                return TuplesKt.to((Object)i, (Object)index);
            }
            return null;
        }
    }
}

